/*
 * Created on 24-Apr-2003
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code Template
 */
package alma.archive.commands;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

import com.cosylab.CDB.DALChangeListener;
import com.cosylab.CDB.DALChangeListenerHelper;

import alma.acs.container.ContainerServices;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.EntityExistsException;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.Permissions;

/**
 * Used by DALImpl
 * @author simon
 */
public class ListenerManager
{
	private static ListenerManager _instance = null;
	private static int instanceCounter = 0;
	
	private String _nullns = "http://null";
	private URI nullns;
	
	public static ListenerManager instance(ContainerServices cs) throws DatabaseException, ModuleCriticalException
	{
		instanceCounter++;
		if (_instance == null)
		{
			_instance = new ListenerManager(cs);
		} 
		return _instance;
	}
	
	public void close() throws DatabaseException, ModuleCriticalException
	{
		instanceCounter--;
		 if (instanceCounter == 0)
		 {
		 	_instance = null;
		 	internal.close();
		 }
	}

	private ContainerServices containerServices;
	private Logger logger;
	
	private InternalIF internal = null;
	private String _listenermanager = "archive://listenermanager";
	private URI listenermanager;
	
	private HashMap<String, ArrayList<Integer>> listenedCurls;
	private HashMap<Integer, DALChangeListener> listeners;
	
	private Random rnd = new Random();

	private ListenerManager(ContainerServices cs) throws DatabaseException, ModuleCriticalException
	{
		this.containerServices = cs;
		logger = containerServices.getLogger();
		
		internal = InternalIFFactory.getInternalIF(logger);
		
		listenedCurls = new HashMap<String, ArrayList<Integer>>();
		listeners = new HashMap<Integer, DALChangeListener>();
		
		try
		{
			listenermanager = new URI(_listenermanager);
			nullns = new URI (_nullns);
			load();
		}
		catch (URISyntaxException e) {e.printStackTrace();} 
		catch (ModuleCriticalException e) {
			logger.severe("Critical exception in Database module.");
			throw new DatabaseException(e.getCause());
		}
		
	}
	
	private void load() throws ModuleCriticalException
	{
		SAXBuilder builder = new SAXBuilder();
		try
		{
			//String xmlString = internal.get(listenermanager);
			String xmlString = internal.get(listenermanager,"listenermanager");
			Document doc = builder.build(new StringReader(xmlString));
			readDocument(doc);
		}
		catch (JDOMException e) {logger.log(Level.SEVERE,"JDOM: Cannot parse Listeners string");}
		catch (IOException e) {logger.log(Level.SEVERE,"IO: Cannot parse Listeners string");}
		catch (ArchiveException e) {logger.log(Level.INFO,"ARCHIVE: Problem retriving the string");}
	}
	
	private void save() throws ModuleCriticalException
	{
		try
		{
			XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
			// XMLOutputter out = new XMLOutputter(" ",true, "UTF-8");
			String xml = out.outputString(createDocument());
			//internal.store(listenermanager,xml);
			try
			{
				internal.store(listenermanager,xml,nullns,"",
					"listenermanager",new Permissions(),"listenermanager",true);
			}
			catch (EntityExistsException e)
			{
				internal.update(listenermanager,new ArchiveTimeStamp(),xml,nullns,false,"listenermanager");
			}
		}
		catch (ArchiveException e){logger.log(Level.SEVERE,"ARCHIVE: Cannot save listenermanager");}
	}

	public int add(DALChangeListener listener) throws ModuleCriticalException
	{
		synchronized (listeners)
		{
			int link = rnd.nextInt(Integer.MAX_VALUE);
			while (listeners.containsKey(new Integer(link))) {link = rnd.nextInt(Integer.MAX_VALUE);}
			listeners.put(new Integer(link),listener);
			save();
			return link;
		}
	}
	
	public void attatch(int link, URI uri) throws ModuleCriticalException
	{
		synchronized (listenedCurls)
		{
			ArrayList<Integer> links = listenedCurls.get(uri.toString());
			if (links == null)
			{
				links = new ArrayList<Integer>();
				listenedCurls.put(uri.toString(), links);
			}
			links.add(new Integer(link));
			save();
		}
	}
	
	public void disconnect(int link) throws ModuleCriticalException
	{
		Integer lnk = new Integer(link);
		Iterator<ArrayList<Integer>> iter = listenedCurls.values().iterator();
		while (iter.hasNext())
		{
			ArrayList links = iter.next(); 
			if (links != null)
			{
				links.remove(lnk);
			}
		}
		save();
	}
	
	public void remove(int link) throws ModuleCriticalException
	{
		Integer lnk = new Integer(link);
		synchronized (listeners)
		{
			synchronized (listenedCurls)
			{
				if (listeners.containsKey(lnk)) {listeners.remove(lnk);}
				
				Iterator<String> iter = listenedCurls.keySet().iterator();
				while (iter.hasNext())
				{
					String curl = iter.next();
					ArrayList links = listenedCurls.get(curl);
					if (links != null)
					{
						links.remove(lnk);
					}
				}
			}
		}
		save();
	}
	
	public void updatedEntity(String curl)
	{
		synchronized (listenedCurls)
		{
			if (listenedCurls.containsKey(curl))
			{
				ArrayList links = listenedCurls.get(curl);
				if (links != null)
				{
					Iterator iter = links.iterator();
					while (iter.hasNext())
					{
						Integer lnk = (Integer)iter.next();
						DALChangeListener listener = listeners.get(lnk);
						listener.object_changed(curl);
					}
				}
			}
		}
	}
	
	private Document createDocument()
	{
		Element root = new Element ("listenermanager");
		Document doc = new Document(root);
		
		Element list = createListeners();
		root.addContent(list);
		Element curls = createCurls();
		root.addContent(curls);
		
		return doc;
	}
	
	private void readDocument(Document doc)
	{
		Element root = doc.getRootElement();

		Element list = root.getChild("listeners");
		extractListeners(list);
		Element curls = root.getChild("curls");
		extractCurls(curls);
	}
	
	private Element createListeners()
	{
		Iterator<Integer> iter = listeners.keySet().iterator();
		Element list = new Element("listeners");
		while (iter.hasNext())
		{
			Integer lnk = iter.next();
			Element listenerElement = new Element("listener");

			listenerElement.setAttribute("link",lnk.toString());
			
			String ior = toIOR(listeners.get(lnk));
			listenerElement.setAttribute("IOR",ior);
			
			list.addContent(listenerElement);
		}
		return list;
	}
	
	private void extractListeners(Element list)
	{
		List elements = list.getChildren();
		Iterator iter = elements.iterator();
		while (iter.hasNext())
		{
			Element listener = (Element)iter.next();
			String link = listener.getAttributeValue("link");
			String ior = listener.getAttributeValue("IOR");
			listeners.put(new Integer(link),fromIOR(ior)); 
		}
	}
	
	
	private Element createCurls()
	{
		Iterator<String> iter = listenedCurls.keySet().iterator();
		Element curls = new Element("curls");
		while (iter.hasNext())
		{
			String curl = iter.next();
			Element curlElement = createCurl(curl);
			curls.addContent(curlElement);
		}
		return curls;
	}
	
	private void extractCurls(Element curls)
	{
		List elements = curls.getChildren();
		Iterator iter = elements.iterator();
		while (iter.hasNext())
		{
			extractCurl((Element)iter.next());
		}
	}
	
	private Element createCurl(String curl)
	{
		Element curlElement = new Element("curl");
		curlElement.setAttribute("URI",curl);
	
		ArrayList<Integer> links = listenedCurls.get(curl);
		if (listeners != null)
		{
			Iterator<Integer> iter = links.iterator();
			while (iter.hasNext())
			{
				Integer link = iter.next();
				Element linkElement = new Element("link");
				linkElement.setAttribute("id",link.toString());
				curlElement.addContent(linkElement);
			}
		}
		else
		{
			return null;
		}
		return curlElement;
	}
	
	private void extractCurl(Element curl)
	{
		List elements = curl.getChildren();
		if (elements != null)
		{
			String uri = curl.getAttributeValue("URI");
			Iterator iter = elements.iterator();
			ArrayList<Integer> links = new ArrayList<Integer>();
			while (iter.hasNext())
			{
				Element link = (Element)iter.next();
				String linkStr = link.getAttributeValue("link");
				Integer lnk = Integer.valueOf(linkStr);
				links.add(lnk);
			}
			listenedCurls.put(uri,links);
		}
	}
	
	private String toIOR (DALChangeListener listener)
	{
		return containerServices.getAdvancedContainerServices().corbaObjectToString(listener);
	}

	private DALChangeListener fromIOR (String ior)
	{
		return DALChangeListenerHelper.narrow(containerServices.getAdvancedContainerServices().corbaObjectFromString(ior)); 
	}
}
