/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 * ========================================================================
 * == THIS IS GENERATED CODE!!! DO NOT MODIFY! ALL CHANGES WILL BE LOST! ==
 * ======================================================================== 
 *
 */
 
package alma.cdbErrType.wrappers;

import alma.ACSErr.Completion;
import alma.acs.exceptions.*;
import alma.cdbErrType.wrappers.AcsJWrongCDBDataTypeEx;

public class WrongCDBDataTypeAcsJCompletion extends AcsJCompletion
{
	/**
	 * Creates a new <code>WrongCDBDataTypeAcsJCompletion</code>
	 * with a corresponding exception (AcsJWrongCDBDataTypeEx) attached.
	 */
	public WrongCDBDataTypeAcsJCompletion () {
		super(new AcsJWrongCDBDataTypeEx()); 
	}

	/**
	 * Creates a new <code>WrongCDBDataTypeAcsJCompletion</code>
	 * with a corresponding exception (AcsJWrongCDBDataTypeEx) attached 
	 * that wraps an existing exception (<code>acsJEx</code>.)
	 */
	public WrongCDBDataTypeAcsJCompletion (AcsJException acsJEx) {
		super(new AcsJWrongCDBDataTypeEx(acsJEx));  
	}
	
	/**
	 * Creates a new <code>WrongCDBDataTypeAcsJCompletion</code>
	 * from another <code>AcsJCompletion</code> (<code>acsJComp</code>).
	 * <p>
	 * If present, the existing error trace is converted to Java exceptions
	 * and wrapped with an <code>AcsJWrongCDBDataTypeEx</code>.
	 */
	public WrongCDBDataTypeAcsJCompletion(AcsJCompletion acsJComp) {		
			init(new AcsJWrongCDBDataTypeEx(acsJComp.getAcsJException()));
	}
	
	/**
	 * Converts a Corba completion to an <code>WrongCDBDataTypeAcsJCompletion</code>
	 * such that a new <code>AcsJWrongCDBDataTypeEx</code> is created as the attached error.
	 * If <code>corbaComp</code> carries error information, these <code>ErrorTrace</code>
	 * objects are converted to Java exceptions, which are attached as the course of
	 * the new <code>AcsJWrongCDBDataTypeEx</code>.
	 * @param corbaComp
	 */
	public WrongCDBDataTypeAcsJCompletion(Completion corbaComp) {
		
		 this(AcsJCompletion.fromCorbaCompletion(corbaComp));
	}
	
       /**
        * Returns the short description of the error
        */
	public String getShortDescription() 
	{
	   return "Wrong CDB data type";
	}	

	/////////////////////////////////////////////////////////////
	// Getter/Setter for members
	/////////////////////////////////////////////////////////////	

		
        public void setValue(String value)
	{ 
		setProperty("Value", ""+value);
	}            				
	
	public String getValue()
	{ 
		return (getProperty("Value")); 
	}
  
		
        public void setDataType(String value)
	{ 
		setProperty("DataType", ""+value);
	}            				
	
	public String getDataType()
	{ 
		return (getProperty("DataType")); 
	}
  
	
}
