/*
*ALMA - Atacama Large Millimiter Array
* (c) Associated Universities Inc., 2007
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

/**
 * @author  nbarriga
 * @version $Id: LTS2Java.xslt,v 1.7 2007/12/20 18:43:45 hsommer Exp $
 * @since
 */

package alma.typeSafeLogs;

import java.util.logging.Logger;
import java.util.logging.Level;
import java.util.LinkedHashMap;
import java.util.Map;

import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.AcsLogRecord;


/**
 * Generated class that produces a type-safe log message, as configured in typeSafeLogs.xml.
 * <p>
 * The description for this log is: Successfully created a type-safe dummy message - full description <br>
 * The description for this group of logs is: Type-safe logs to be used in test-code that will look at the output to stdout, for the 3 implementation languages
 */
public class LOG_TEST_DummyMessage {
	public static final AcsLogLevel level = AcsLogLevel.INFO;
	private final Logger logger;
	private final Map<String, Object> nameValue;
	private final AcsLogRecord lr;	
	
	public LOG_TEST_DummyMessage(Logger logger) {
		this.logger=logger;
		if (logger instanceof AcsLogger) {
			((AcsLogger)logger).addLoggerClass(this.getClass());
		}
		nameValue = new LinkedHashMap<String, Object>();
		nameValue.put("logName","LOG_TEST_DummyMessage");
		lr = new AcsLogRecord(level, "Successfully created a type-safe dummy message", nameValue, logger.getName());
		lr.setAudience("Developer");
	}
	public LOG_TEST_DummyMessage(Logger logger, String array, String antenna) {
		this(logger);
		lr.setArray(array);
		lr.setAntenna(antenna);
	}	
	
	/**
	 * Convenience method for compact one-line logs.
	 * @since ACS 7.0.1
	 */
	public static void log(Logger logger, String MessageName, String Author) {
		if (logger.isLoggable(level)) {	
			LOG_TEST_DummyMessage instance = new LOG_TEST_DummyMessage(logger);
			instance.setMessageName(MessageName);
			instance.setAuthor(Author);
			instance.log();
		}
	}
	
	public void setArray(String array) {
		lr.setArray(array);
	}
	public void setAntenna(String antenna) {
		lr.setAntenna(antenna);
	}
	public String getArray(){
		return lr.getArray();
	}
	public String getAntenna(){
		return lr.getAntenna();
	}
	
	/**
	 * Logs the message through the Logger supplied in the constructor, with the configured log level.
	 */	
	public void log() {
		logger.log(lr);
	}
	

	/**
	 * Sets log parameter MessageName.
	 * @param MessageName
	 *			Name of the message created.
	 */
	public void setMessageName(String value) {
		nameValue.put("MessageName", value);
	}
	/**
	 * Sets log parameter Author.
	 * @param Author
	 *			Name of the author of this message.
	 */
	public void setAuthor(String value) {
		nameValue.put("Author", value);
	}
}

