/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File WeatherStationToPad.java
 */
package alma.TMCDB.generated;

import alma.TMCDB.types.ArrayTime;

import alma.TMCDB_GEN_IDL.WeatherStationToPadIDL;

/**

 * The WeatherStationToPad table gives the pad that a weather station is on at the indicated time.  If the Planned flag is 'y', then it indicates this is a planned weather station and not an actual one.  Planned entries are ignored when determining what is or was actually online.

   * Key: WeatherStationId, PadId, StartTime

 *
 */
public class WeatherStationToPad implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int WeatherStationId;

    private int PadId;

    private ArrayTime StartTime;

    private ArrayTime EndTime;

    // private boolean nullEndTime;

    private boolean Planned;

    /**
     * Default Constructor for WeatherStationToPad.  Setter methods must be used to insert data.
     */
    public WeatherStationToPad () {

        // nullEndTime = true;

    }

    /**
     * Create a WeatherStationToPad by specifiying all data values.
     */
    public WeatherStationToPad (

        int WeatherStationId,

        int PadId,

        ArrayTime StartTime,

        ArrayTime EndTime,

        boolean Planned

    ) {

		setWeatherStationId(WeatherStationId);

		setPadId(PadId);

		setStartTime(StartTime);

		setEndTime(EndTime);

		setPlanned(Planned);

    }

    /**
     * Create a WeatherStationToPad by specifiying data values as an array of strings.
     */
    public WeatherStationToPad (String[] data) {
    	if (data.length != 5)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 5)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.WeatherStationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.PadId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StartTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullEndTime = true;
			// this.EndTime = null;

		} else {

			// nullEndTime = false;

			this.EndTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Planned = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "WeatherStationToPad:" + newline;

        s += "\tWeatherStationId: " + WeatherStationId + newline;

        s += "\tPadId: " + PadId + newline;

        s += "\tStartTime: " + StartTime.toFITS() + newline;

    	// if (EndTime == null)
    	//	s += "\tEndTime: null" + newline;
    	// else

        s += "\tEndTime: " + EndTime.toFITS() + newline;

        s += "\tPlanned: " + Planned + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "WeatherStationToPad" + delimiter;  

        s += WeatherStationId + delimiter;

        s += PadId + delimiter;

		s += new String(StartTime.toFITS()) + delimiter;

        // if (nullEndTime)
        // 	s += delimiter;
        // else

		// s += new String(EndTime.toFITS()) + delimiter;

        s += Planned + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 5;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#WeatherStationToPad" + delimiter  

        	+ "WeatherStationId" + delimiter

        	+ "PadId" + delimiter

        	+ "StartTime" + delimiter

        	+ "EndTime" + delimiter

        	+ "Planned" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof WeatherStationToPad)) return false;
    	WeatherStationToPad arg = (WeatherStationToPad) obj;

		if (this.WeatherStationId != arg.WeatherStationId)
			return false;

		if (this.PadId != arg.PadId)
			return false;

		if (this.StartTime.get() != arg.StartTime.get())
			return false;

		if (this.EndTime.get() != arg.EndTime.get())
			return false;

		if (this.Planned != arg.Planned)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public WeatherStationToPadIDL toIDL() {
    	WeatherStationToPadIDL x = new WeatherStationToPadIDL ();

		x.WeatherStationId = this.WeatherStationId;

		x.PadId = this.PadId;

		x.StartTime = this.StartTime.toIDLArrayTime();

		x.EndTime = this.EndTime.toIDLArrayTime();

        // x.nullEndTime = this.nullEndTime;

		x.Planned = this.Planned;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(WeatherStationToPadIDL x) {

		this.WeatherStationId = x.WeatherStationId;

		this.PadId = x.PadId;

		this.StartTime = new ArrayTime(x.StartTime);

		this.EndTime = new ArrayTime(x.EndTime);

        // this.nullEndTime = x.nullEndTime;

		this.Planned = x.Planned;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for WeatherStationToPad.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for WeatherStationId.
     */
    public int getWeatherStationId () {
        return WeatherStationId;
    }

    /**
     * Set WeatherStationId to the specified value.
     */
    public void setWeatherStationId(int WeatherStationId) {

        this.WeatherStationId = WeatherStationId;

    }

    /**
     * Get the value for PadId.
     */
    public int getPadId () {
        return PadId;
    }

    /**
     * Set PadId to the specified value.
     */
    public void setPadId(int PadId) {

        this.PadId = PadId;

    }

    /**
     * Get the value for StartTime.
     */
    public ArrayTime getStartTime () {
        return StartTime;
    }

    /**
     * Set StartTime to the specified value.
     */
    public void setStartTime(ArrayTime StartTime) {

        this.StartTime = StartTime;

    }

    /**
     * Get the value for EndTime.
     */
    public ArrayTime getEndTime () {
        return EndTime;
    }

    /**
     * Set EndTime to the specified value.
     */
    public void setEndTime(ArrayTime EndTime) {

        // nullEndTime = false;

        this.EndTime = EndTime;

    }

    /*
     * Is the EndTime null?
     */
    // public boolean isEndTimeNull() {
    //	return nullEndTime;
    // }

    /*
     * Set the null indicator for EndTime
     */       
    // public void setEndTimeNull() {
    // 	nullEndTime = true;
    // }

    /**
     * Get the value for Planned.
     */
    public boolean getPlanned () {
        return Planned;
    }

    /**
     * Set Planned to the specified value.
     */
    public void setPlanned(boolean Planned) {

        this.Planned = Planned;

    }

}
