/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File WeatherStation.java
 */
package alma.TMCDB.generated;

import alma.TMCDB.types.ArrayTime;

import alma.TMCDB.types.Length;

import alma.TMCDB_GEN_IDL.WeatherStationIDL;

/**

 * It is assumed that weather stations are stationary.

 * Included is the name of the software component that executes the weather station.

   * Key: BaseElementId

 *
 */
public class WeatherStation implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int BaseElementId;

    private String SerialNumber;

    private String WeatherStationType;

    private ArrayTime CommissionDate;

    private Length XPosition;

    private Length YPosition;

    private Length ZPosition;

    private int ComponentId;

    /**
     * Default Constructor for WeatherStation.  Setter methods must be used to insert data.
     */
    public WeatherStation () {

    }

    /**
     * Create a WeatherStation by specifiying all data values.
     */
    public WeatherStation (

        int BaseElementId,

        String SerialNumber,

        String WeatherStationType,

        ArrayTime CommissionDate,

        Length XPosition,

        Length YPosition,

        Length ZPosition,

        int ComponentId

    ) {

		setBaseElementId(BaseElementId);

		setSerialNumber(SerialNumber);

		setWeatherStationType(WeatherStationType);

		setCommissionDate(CommissionDate);

		setXPosition(XPosition);

		setYPosition(YPosition);

		setZPosition(ZPosition);

		setComponentId(ComponentId);

    }

    /**
     * Create a WeatherStation by specifiying data values as an array of strings.
     */
    public WeatherStation (String[] data) {
    	if (data.length != 8)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 8)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.SerialNumber = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.WeatherStationType = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CommissionDate = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.XPosition = new Length(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.YPosition = new Length(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ZPosition = new Length(data[i]);

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComponentId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "WeatherStation:" + newline;

        s += "\tBaseElementId: " + BaseElementId + newline;

        s += "\tSerialNumber: " + SerialNumber + newline;

        s += "\tWeatherStationType: " + WeatherStationType + newline;

        s += "\tCommissionDate: " + CommissionDate.toFITS() + newline;

        s += "\tXPosition: " + XPosition + newline;

        s += "\tYPosition: " + YPosition + newline;

        s += "\tZPosition: " + ZPosition + newline;

        s += "\tComponentId: " + ComponentId + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "WeatherStation" + delimiter;  

        s += BaseElementId + delimiter;

        s += SerialNumber + delimiter;

        s += WeatherStationType + delimiter;

		s += new String(CommissionDate.toFITS()) + delimiter;

        s += XPosition + delimiter;

        s += YPosition + delimiter;

        s += ZPosition + delimiter;

        s += ComponentId + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 8;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#WeatherStation" + delimiter  

        	+ "BaseElementId" + delimiter

        	+ "SerialNumber" + delimiter

        	+ "WeatherStationType" + delimiter

        	+ "CommissionDate" + delimiter

        	+ "XPosition" + delimiter

        	+ "YPosition" + delimiter

        	+ "ZPosition" + delimiter

        	+ "ComponentId" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof WeatherStation)) return false;
    	WeatherStation arg = (WeatherStation) obj;

		if (this.BaseElementId != arg.BaseElementId)
			return false;

		if (this.SerialNumber == null) {	// Two null strings are equal
			if (arg.SerialNumber == null)
				return true;
			else
				return false;
		}
		if (!this.SerialNumber.equals(arg.SerialNumber))
			return false; 

		if (this.WeatherStationType == null) {	// Two null strings are equal
			if (arg.WeatherStationType == null)
				return true;
			else
				return false;
		}
		if (!this.WeatherStationType.equals(arg.WeatherStationType))
			return false; 

		if (this.CommissionDate.get() != arg.CommissionDate.get())
			return false;

		if (this.XPosition.get() != arg.XPosition.get())
			return false;

		if (this.YPosition.get() != arg.YPosition.get())
			return false;

		if (this.ZPosition.get() != arg.ZPosition.get())
			return false;

		if (this.ComponentId != arg.ComponentId)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public WeatherStationIDL toIDL() {
    	WeatherStationIDL x = new WeatherStationIDL ();

		x.BaseElementId = this.BaseElementId;

		x.SerialNumber = this.SerialNumber;

		x.WeatherStationType = this.WeatherStationType;

		x.CommissionDate = this.CommissionDate.toIDLArrayTime();

		x.XPosition = this.XPosition.toIDLLength();

		x.YPosition = this.YPosition.toIDLLength();

		x.ZPosition = this.ZPosition.toIDLLength();

		x.ComponentId = this.ComponentId;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(WeatherStationIDL x) {

		this.BaseElementId = x.BaseElementId;

		this.SerialNumber = x.SerialNumber;

		this.WeatherStationType = x.WeatherStationType;

		this.CommissionDate = new ArrayTime(x.CommissionDate);

		this.XPosition = new Length(x.XPosition);

		this.YPosition = new Length(x.YPosition);

		this.ZPosition = new Length(x.ZPosition);

		this.ComponentId = x.ComponentId;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for WeatherStation.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for BaseElementId.
     */
    public int getBaseElementId () {
        return BaseElementId;
    }

    /**
     * Set BaseElementId to the specified value.
     */
    public void setBaseElementId(int BaseElementId) {

        this.BaseElementId = BaseElementId;

    }

    /**
     * Get the value for SerialNumber.
     */
    public String getSerialNumber () {
        return SerialNumber;
    }

    /**
     * Set SerialNumber to the specified value.
     */
    public void setSerialNumber(String SerialNumber) {

        this.SerialNumber = SerialNumber;

    }

    /**
     * Get the value for WeatherStationType.
     */
    public String getWeatherStationType () {
        return WeatherStationType;
    }

    /**
     * Set WeatherStationType to the specified value.
     */
    public void setWeatherStationType(String WeatherStationType) {

        this.WeatherStationType = WeatherStationType;

    }

    /**
     * Get the value for CommissionDate.
     */
    public ArrayTime getCommissionDate () {
        return CommissionDate;
    }

    /**
     * Set CommissionDate to the specified value.
     */
    public void setCommissionDate(ArrayTime CommissionDate) {

        this.CommissionDate = CommissionDate;

    }

    /**
     * Get the value for XPosition.
     */
    public Length getXPosition () {
        return XPosition;
    }

    /**
     * Set XPosition to the specified value.
     */
    public void setXPosition(Length XPosition) {

        this.XPosition = XPosition;

    }

    /**
     * Get the value for YPosition.
     */
    public Length getYPosition () {
        return YPosition;
    }

    /**
     * Set YPosition to the specified value.
     */
    public void setYPosition(Length YPosition) {

        this.YPosition = YPosition;

    }

    /**
     * Get the value for ZPosition.
     */
    public Length getZPosition () {
        return ZPosition;
    }

    /**
     * Set ZPosition to the specified value.
     */
    public void setZPosition(Length ZPosition) {

        this.ZPosition = ZPosition;

    }

    /**
     * Get the value for ComponentId.
     */
    public int getComponentId () {
        return ComponentId;
    }

    /**
     * Set ComponentId to the specified value.
     */
    public void setComponentId(int ComponentId) {

        this.ComponentId = ComponentId;

    }

}
