/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File TMCDBVersion.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.TMCDBVersionIDL;

/**

 * The TMCDBVersion table records the database name, version and date from this file.

 * It is automatically filled by the generated CreateOracleTables.sql and CreateHsqldbTables.sql scripts.

 * There is only one row in this table.  It must be updated each time the structure of the database changes.

   * Key: DBName

 *
 */
public class TMCDBVersion implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private String DBName;

    private String DBVersion;

    private String DBDate;

    /**
     * Default Constructor for TMCDBVersion.  Setter methods must be used to insert data.
     */
    public TMCDBVersion () {

    }

    /**
     * Create a TMCDBVersion by specifiying all data values.
     */
    public TMCDBVersion (

        String DBName,

        String DBVersion,

        String DBDate

    ) {

		setDBName(DBName);

		setDBVersion(DBVersion);

		setDBDate(DBDate);

    }

    /**
     * Create a TMCDBVersion by specifiying data values as an array of strings.
     */
    public TMCDBVersion (String[] data) {
    	if (data.length != 3)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 3)");
    	int i = 0;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DBName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DBVersion = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DBDate = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "TMCDBVersion:" + newline;

        s += "\tDBName: " + DBName + newline;

        s += "\tDBVersion: " + DBVersion + newline;

        s += "\tDBDate: " + DBDate + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "TMCDBVersion" + delimiter;  

        s += DBName + delimiter;

        s += DBVersion + delimiter;

        s += DBDate + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 3;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#TMCDBVersion" + delimiter  

        	+ "DBName" + delimiter

        	+ "DBVersion" + delimiter

        	+ "DBDate" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof TMCDBVersion)) return false;
    	TMCDBVersion arg = (TMCDBVersion) obj;

		if (this.DBName == null) {	// Two null strings are equal
			if (arg.DBName == null)
				return true;
			else
				return false;
		}
		if (!this.DBName.equals(arg.DBName))
			return false; 

		if (this.DBVersion == null) {	// Two null strings are equal
			if (arg.DBVersion == null)
				return true;
			else
				return false;
		}
		if (!this.DBVersion.equals(arg.DBVersion))
			return false; 

		if (this.DBDate == null) {	// Two null strings are equal
			if (arg.DBDate == null)
				return true;
			else
				return false;
		}
		if (!this.DBDate.equals(arg.DBDate))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public TMCDBVersionIDL toIDL() {
    	TMCDBVersionIDL x = new TMCDBVersionIDL ();

		x.DBName = this.DBName;

		x.DBVersion = this.DBVersion;

		x.DBDate = this.DBDate;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(TMCDBVersionIDL x) {

		this.DBName = x.DBName;

		this.DBVersion = x.DBVersion;

		this.DBDate = x.DBDate;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for TMCDBVersion.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for DBName.
     */
    public String getDBName () {
        return DBName;
    }

    /**
     * Set DBName to the specified value.
     */
    public void setDBName(String DBName) {

        this.DBName = DBName;

    }

    /**
     * Get the value for DBVersion.
     */
    public String getDBVersion () {
        return DBVersion;
    }

    /**
     * Set DBVersion to the specified value.
     */
    public void setDBVersion(String DBVersion) {

        this.DBVersion = DBVersion;

    }

    /**
     * Get the value for DBDate.
     */
    public String getDBDate () {
        return DBDate;
    }

    /**
     * Set DBDate to the specified value.
     */
    public void setDBDate(String DBDate) {

        this.DBDate = DBDate;

    }

}
