/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File TMCDBBase.java
 */
package alma.TMCDB.generated;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.PreparedStatement;
import java.sql.Statement;
import javax.sql.rowset.serial.SerialBlob;
import java.util.ArrayList;

import alma.TMCDB.types.ArrayTime;
import alma.TMCDB.types.Length;

import alma.TmcdbErrType.wrappers.*;
import alma.TMCDB.TMCDBUtil;

abstract public class TMCDBBase extends TMCDBUtil {

    // Prepared statements for all tables.

    protected PreparedStatement getTMCDBVersionKey;

    protected PreparedStatement addTMCDBVersion;
    protected PreparedStatement updateTMCDBVersion;
    protected PreparedStatement deleteTMCDBVersionKey;

    protected PreparedStatement getComponentTypeKey;

    protected PreparedStatement getComponentTypeAlt;
    protected PreparedStatement maxComponentTypeKey;

    protected PreparedStatement addComponentType;
    protected PreparedStatement updateComponentType;
    protected PreparedStatement deleteComponentTypeKey;

    protected PreparedStatement deleteComponentTypeAlt;

    protected PreparedStatement getLRUTypeKey;

    protected PreparedStatement addLRUType;
    protected PreparedStatement updateLRUType;
    protected PreparedStatement deleteLRUTypeKey;

    protected PreparedStatement getAssemblyTypeKey;

    protected PreparedStatement addAssemblyType;
    protected PreparedStatement updateAssemblyType;
    protected PreparedStatement deleteAssemblyTypeKey;

    protected PreparedStatement getSchemasKey;

    protected PreparedStatement getSchemasAlt;
    protected PreparedStatement maxSchemasKey;

    protected PreparedStatement addSchemas;
    protected PreparedStatement updateSchemas;
    protected PreparedStatement deleteSchemasKey;

    protected PreparedStatement deleteSchemasAlt;

    protected PreparedStatement getDefaultComponentKey;

    protected PreparedStatement addDefaultComponent;
    protected PreparedStatement updateDefaultComponent;
    protected PreparedStatement deleteDefaultComponentKey;

    protected PreparedStatement getDefaultBaciPropertyKey;

    protected PreparedStatement addDefaultBaciProperty;
    protected PreparedStatement updateDefaultBaciProperty;
    protected PreparedStatement deleteDefaultBaciPropertyKey;

    protected PreparedStatement getDefaultMonitorPointKey;

    protected PreparedStatement addDefaultMonitorPoint;
    protected PreparedStatement updateDefaultMonitorPoint;
    protected PreparedStatement deleteDefaultMonitorPointKey;

    protected PreparedStatement getConfigurationKey;

    protected PreparedStatement getConfigurationAlt;
    protected PreparedStatement maxConfigurationKey;

    protected PreparedStatement addConfiguration;
    protected PreparedStatement updateConfiguration;
    protected PreparedStatement deleteConfigurationKey;

    protected PreparedStatement deleteConfigurationAlt;

    protected PreparedStatement getComputerKey;

    protected PreparedStatement getComputerAlt;
    protected PreparedStatement maxComputerKey;

    protected PreparedStatement addComputer;
    protected PreparedStatement updateComputer;
    protected PreparedStatement deleteComputerKey;

    protected PreparedStatement deleteComputerAlt;

    protected PreparedStatement getLoggingConfigKey;

    protected PreparedStatement getLoggingConfigAlt;
    protected PreparedStatement maxLoggingConfigKey;

    protected PreparedStatement addLoggingConfig;
    protected PreparedStatement updateLoggingConfig;
    protected PreparedStatement deleteLoggingConfigKey;

    protected PreparedStatement deleteLoggingConfigAlt;

    protected PreparedStatement getNamedLoggerConfigKey;

    protected PreparedStatement getNamedLoggerConfigAlt;
    protected PreparedStatement maxNamedLoggerConfigKey;

    protected PreparedStatement addNamedLoggerConfig;
    protected PreparedStatement updateNamedLoggerConfig;
    protected PreparedStatement deleteNamedLoggerConfigKey;

    protected PreparedStatement deleteNamedLoggerConfigAlt;

    protected PreparedStatement getManagerKey;

    protected PreparedStatement getManagerAlt;
    protected PreparedStatement maxManagerKey;

    protected PreparedStatement addManager;
    protected PreparedStatement updateManager;
    protected PreparedStatement deleteManagerKey;

    protected PreparedStatement deleteManagerAlt;

    protected PreparedStatement getContainerKey;

    protected PreparedStatement getContainerAlt;
    protected PreparedStatement maxContainerKey;

    protected PreparedStatement addContainer;
    protected PreparedStatement updateContainer;
    protected PreparedStatement deleteContainerKey;

    protected PreparedStatement deleteContainerAlt;

    protected PreparedStatement getComponentKey;

    protected PreparedStatement getComponentAlt;
    protected PreparedStatement maxComponentKey;

    protected PreparedStatement addComponent;
    protected PreparedStatement updateComponent;
    protected PreparedStatement deleteComponentKey;

    protected PreparedStatement deleteComponentAlt;

    protected PreparedStatement getAssemblyKey;

    protected PreparedStatement getAssemblyAlt;
    protected PreparedStatement maxAssemblyKey;

    protected PreparedStatement addAssembly;
    protected PreparedStatement updateAssembly;
    protected PreparedStatement deleteAssemblyKey;

    protected PreparedStatement deleteAssemblyAlt;

    protected PreparedStatement getDefaultCanAddressKey;

    protected PreparedStatement addDefaultCanAddress;
    protected PreparedStatement updateDefaultCanAddress;
    protected PreparedStatement deleteDefaultCanAddressKey;

    protected PreparedStatement getAssemblyRoleKey;

    protected PreparedStatement addAssemblyRole;
    protected PreparedStatement updateAssemblyRole;
    protected PreparedStatement deleteAssemblyRoleKey;

    protected PreparedStatement getBACIPropertyKey;

    protected PreparedStatement getBACIPropertyAlt;
    protected PreparedStatement maxBACIPropertyKey;

    protected PreparedStatement addBACIProperty;
    protected PreparedStatement updateBACIProperty;
    protected PreparedStatement deleteBACIPropertyKey;

    protected PreparedStatement deleteBACIPropertyAlt;

    protected PreparedStatement getMonitorPointKey;

    protected PreparedStatement addMonitorPoint;
    protected PreparedStatement updateMonitorPoint;
    protected PreparedStatement deleteMonitorPointKey;

    protected PreparedStatement getMonitorDataKey;

    protected PreparedStatement addMonitorData;
    protected PreparedStatement updateMonitorData;
    protected PreparedStatement deleteMonitorDataKey;

    protected PreparedStatement getBaseElementKey;

    protected PreparedStatement getBaseElementAlt;
    protected PreparedStatement maxBaseElementKey;

    protected PreparedStatement addBaseElement;
    protected PreparedStatement updateBaseElement;
    protected PreparedStatement deleteBaseElementKey;

    protected PreparedStatement deleteBaseElementAlt;

    protected PreparedStatement getBaseElementOnlineKey;

    protected PreparedStatement getBaseElementOnlineAlt;
    protected PreparedStatement maxBaseElementOnlineKey;

    protected PreparedStatement addBaseElementOnline;
    protected PreparedStatement updateBaseElementOnline;
    protected PreparedStatement deleteBaseElementOnlineKey;

    protected PreparedStatement deleteBaseElementOnlineAlt;

    protected PreparedStatement getAntennaKey;

    protected PreparedStatement addAntenna;
    protected PreparedStatement updateAntenna;
    protected PreparedStatement deleteAntennaKey;

    protected PreparedStatement getPadKey;

    protected PreparedStatement addPad;
    protected PreparedStatement updatePad;
    protected PreparedStatement deletePadKey;

    protected PreparedStatement getCorrHWConfigurationKey;

    protected PreparedStatement addCorrHWConfiguration;
    protected PreparedStatement updateCorrHWConfiguration;
    protected PreparedStatement deleteCorrHWConfigurationKey;

    protected PreparedStatement getCorrQuadrantKey;

    protected PreparedStatement getCorrQuadrantAlt;
    protected PreparedStatement maxCorrQuadrantKey;

    protected PreparedStatement addCorrQuadrant;
    protected PreparedStatement updateCorrQuadrant;
    protected PreparedStatement deleteCorrQuadrantKey;

    protected PreparedStatement deleteCorrQuadrantAlt;

    protected PreparedStatement getCorrQuadrantRackKey;

    protected PreparedStatement getCorrQuadrantRackAlt;
    protected PreparedStatement maxCorrQuadrantRackKey;

    protected PreparedStatement addCorrQuadrantRack;
    protected PreparedStatement updateCorrQuadrantRack;
    protected PreparedStatement deleteCorrQuadrantRackKey;

    protected PreparedStatement deleteCorrQuadrantRackAlt;

    protected PreparedStatement getCorrStationBinKey;

    protected PreparedStatement getCorrStationBinAlt;
    protected PreparedStatement maxCorrStationBinKey;

    protected PreparedStatement addCorrStationBin;
    protected PreparedStatement updateCorrStationBin;
    protected PreparedStatement deleteCorrStationBinKey;

    protected PreparedStatement deleteCorrStationBinAlt;

    protected PreparedStatement getCorrelatorBinKey;

    protected PreparedStatement getCorrelatorBinAlt;
    protected PreparedStatement maxCorrelatorBinKey;

    protected PreparedStatement addCorrelatorBin;
    protected PreparedStatement updateCorrelatorBin;
    protected PreparedStatement deleteCorrelatorBinKey;

    protected PreparedStatement deleteCorrelatorBinAlt;

    protected PreparedStatement getFrontEndKey;

    protected PreparedStatement addFrontEnd;
    protected PreparedStatement updateFrontEnd;
    protected PreparedStatement deleteFrontEndKey;

    protected PreparedStatement getWeatherStationKey;

    protected PreparedStatement addWeatherStation;
    protected PreparedStatement updateWeatherStation;
    protected PreparedStatement deleteWeatherStationKey;

    protected PreparedStatement getCentralRackKey;

    protected PreparedStatement addCentralRack;
    protected PreparedStatement updateCentralRack;
    protected PreparedStatement deleteCentralRackKey;

    protected PreparedStatement getMasterClockKey;

    protected PreparedStatement addMasterClock;
    protected PreparedStatement updateMasterClock;
    protected PreparedStatement deleteMasterClockKey;

    protected PreparedStatement getHolographyTowerKey;

    protected PreparedStatement addHolographyTower;
    protected PreparedStatement updateHolographyTower;
    protected PreparedStatement deleteHolographyTowerKey;

    protected PreparedStatement getArrayKey;

    protected PreparedStatement getArrayAlt;
    protected PreparedStatement maxArrayKey;

    protected PreparedStatement addArray;
    protected PreparedStatement updateArray;
    protected PreparedStatement deleteArrayKey;

    protected PreparedStatement deleteArrayAlt;

    protected PreparedStatement getAntennaToPadKey;

    protected PreparedStatement addAntennaToPad;
    protected PreparedStatement updateAntennaToPad;
    protected PreparedStatement deleteAntennaToPadKey;

    protected PreparedStatement getAntennaPointingModelKey;

    protected PreparedStatement getAntennaPointingModelAlt;
    protected PreparedStatement maxAntennaPointingModelKey;

    protected PreparedStatement addAntennaPointingModel;
    protected PreparedStatement updateAntennaPointingModel;
    protected PreparedStatement deleteAntennaPointingModelKey;

    protected PreparedStatement deleteAntennaPointingModelAlt;

    protected PreparedStatement getAntennaPointingModelTermKey;

    protected PreparedStatement addAntennaPointingModelTerm;
    protected PreparedStatement updateAntennaPointingModelTerm;
    protected PreparedStatement deleteAntennaPointingModelTermKey;

    protected PreparedStatement getAntennaFocusModelKey;

    protected PreparedStatement getAntennaFocusModelAlt;
    protected PreparedStatement maxAntennaFocusModelKey;

    protected PreparedStatement addAntennaFocusModel;
    protected PreparedStatement updateAntennaFocusModel;
    protected PreparedStatement deleteAntennaFocusModelKey;

    protected PreparedStatement deleteAntennaFocusModelAlt;

    protected PreparedStatement getAntennaFocusModelTermKey;

    protected PreparedStatement addAntennaFocusModelTerm;
    protected PreparedStatement updateAntennaFocusModelTerm;
    protected PreparedStatement deleteAntennaFocusModelTermKey;

    protected PreparedStatement getAntennaDelayModelKey;

    protected PreparedStatement getAntennaDelayModelAlt;
    protected PreparedStatement maxAntennaDelayModelKey;

    protected PreparedStatement addAntennaDelayModel;
    protected PreparedStatement updateAntennaDelayModel;
    protected PreparedStatement deleteAntennaDelayModelKey;

    protected PreparedStatement deleteAntennaDelayModelAlt;

    protected PreparedStatement getAntennaDelayModelTermKey;

    protected PreparedStatement addAntennaDelayModelTerm;
    protected PreparedStatement updateAntennaDelayModelTerm;
    protected PreparedStatement deleteAntennaDelayModelTermKey;

    protected PreparedStatement getAntennaToFrontEndKey;

    protected PreparedStatement addAntennaToFrontEnd;
    protected PreparedStatement updateAntennaToFrontEnd;
    protected PreparedStatement deleteAntennaToFrontEndKey;

    protected PreparedStatement getAntennaToArrayKey;

    protected PreparedStatement addAntennaToArray;
    protected PreparedStatement updateAntennaToArray;
    protected PreparedStatement deleteAntennaToArrayKey;

    protected PreparedStatement getSBExecutionKey;

    protected PreparedStatement addSBExecution;
    protected PreparedStatement updateSBExecution;
    protected PreparedStatement deleteSBExecutionKey;

    protected PreparedStatement getAntennaToCorrKey;

    protected PreparedStatement addAntennaToCorr;
    protected PreparedStatement updateAntennaToCorr;
    protected PreparedStatement deleteAntennaToCorrKey;

    protected PreparedStatement getWeatherStationToPadKey;

    protected PreparedStatement addWeatherStationToPad;
    protected PreparedStatement updateWeatherStationToPad;
    protected PreparedStatement deleteWeatherStationToPadKey;

    protected PreparedStatement getBaseElementAssemblyListKey;

    protected PreparedStatement addBaseElementAssemblyList;
    protected PreparedStatement updateBaseElementAssemblyList;
    protected PreparedStatement deleteBaseElementAssemblyListKey;

    protected PreparedStatement getMasterComponentKey;

    protected PreparedStatement getMasterComponentAlt;
    protected PreparedStatement maxMasterComponentKey;

    protected PreparedStatement addMasterComponent;
    protected PreparedStatement updateMasterComponent;
    protected PreparedStatement deleteMasterComponentKey;

    protected PreparedStatement deleteMasterComponentAlt;

    protected PreparedStatement getComputerExecutionKey;

    protected PreparedStatement getComputerExecutionAlt;
    protected PreparedStatement maxComputerExecutionKey;

    protected PreparedStatement addComputerExecution;
    protected PreparedStatement updateComputerExecution;
    protected PreparedStatement deleteComputerExecutionKey;

    protected PreparedStatement deleteComputerExecutionAlt;

    protected PreparedStatement getContainerExecutionKey;

    protected PreparedStatement getContainerExecutionAlt;
    protected PreparedStatement maxContainerExecutionKey;

    protected PreparedStatement addContainerExecution;
    protected PreparedStatement updateContainerExecution;
    protected PreparedStatement deleteContainerExecutionKey;

    protected PreparedStatement deleteContainerExecutionAlt;

    protected PreparedStatement getComponentExecutionKey;

    protected PreparedStatement getComponentExecutionAlt;
    protected PreparedStatement maxComponentExecutionKey;

    protected PreparedStatement addComponentExecution;
    protected PreparedStatement updateComponentExecution;
    protected PreparedStatement deleteComponentExecutionKey;

    protected PreparedStatement deleteComponentExecutionAlt;

    protected PreparedStatement getMasterComponentExecutionKey;

    protected PreparedStatement getMasterComponentExecutionAlt;
    protected PreparedStatement maxMasterComponentExecutionKey;

    protected PreparedStatement addMasterComponentExecution;
    protected PreparedStatement updateMasterComponentExecution;
    protected PreparedStatement deleteMasterComponentExecutionKey;

    protected PreparedStatement deleteMasterComponentExecutionAlt;

    protected PreparedStatement getACSKey;

    protected PreparedStatement getACSAlt;
    protected PreparedStatement maxACSKey;

    protected PreparedStatement addACS;
    protected PreparedStatement updateACS;
    protected PreparedStatement deleteACSKey;

    protected PreparedStatement deleteACSAlt;

    protected PreparedStatement getACSExecutionKey;

    protected PreparedStatement addACSExecution;
    protected PreparedStatement updateACSExecution;
    protected PreparedStatement deleteACSExecutionKey;

    protected PreparedStatement getNotificationChannelKey;

    protected PreparedStatement getNotificationChannelAlt;
    protected PreparedStatement maxNotificationChannelKey;

    protected PreparedStatement addNotificationChannel;
    protected PreparedStatement updateNotificationChannel;
    protected PreparedStatement deleteNotificationChannelKey;

    protected PreparedStatement deleteNotificationChannelAlt;

    protected PreparedStatement getNCExecutionKey;

    protected PreparedStatement addNCExecution;
    protected PreparedStatement updateNCExecution;
    protected PreparedStatement deleteNCExecutionKey;

    protected PreparedStatement getStartupKey;

    protected PreparedStatement getStartupAlt;
    protected PreparedStatement maxStartupKey;

    protected PreparedStatement addStartup;
    protected PreparedStatement updateStartup;
    protected PreparedStatement deleteStartupKey;

    protected PreparedStatement deleteStartupAlt;

    protected PreparedStatement getSystemExecutionKey;

    protected PreparedStatement addSystemExecution;
    protected PreparedStatement updateSystemExecution;
    protected PreparedStatement deleteSystemExecutionKey;

    protected PreparedStatement getDeploymentStartupKey;

    protected PreparedStatement addDeploymentStartup;
    protected PreparedStatement updateDeploymentStartup;
    protected PreparedStatement deleteDeploymentStartupKey;

    protected PreparedStatement getBaseElementStartupKey;

    protected PreparedStatement getBaseElementStartupAlt;
    protected PreparedStatement maxBaseElementStartupKey;

    protected PreparedStatement addBaseElementStartup;
    protected PreparedStatement updateBaseElementStartup;
    protected PreparedStatement deleteBaseElementStartupKey;

    protected PreparedStatement deleteBaseElementStartupAlt;

    protected PreparedStatement getAssociatedBaseElementKey;

    protected PreparedStatement addAssociatedBaseElement;
    protected PreparedStatement updateAssociatedBaseElement;
    protected PreparedStatement deleteAssociatedBaseElementKey;

    protected PreparedStatement getAssemblyStartupKey;

    protected PreparedStatement getAssemblyStartupAlt;
    protected PreparedStatement maxAssemblyStartupKey;

    protected PreparedStatement addAssemblyStartup;
    protected PreparedStatement updateAssemblyStartup;
    protected PreparedStatement deleteAssemblyStartupKey;

    protected PreparedStatement deleteAssemblyStartupAlt;

    protected PreparedStatement getSystemCountersKey;

    protected PreparedStatement addSystemCounters;
    protected PreparedStatement updateSystemCounters;
    protected PreparedStatement deleteSystemCountersKey;

    protected PreparedStatement getLocationKey;

    protected PreparedStatement getLocationAlt;
    protected PreparedStatement maxLocationKey;

    protected PreparedStatement addLocation;
    protected PreparedStatement updateLocation;
    protected PreparedStatement deleteLocationKey;

    protected PreparedStatement deleteLocationAlt;

    protected PreparedStatement getContactKey;

    protected PreparedStatement getContactAlt;
    protected PreparedStatement maxContactKey;

    protected PreparedStatement addContact;
    protected PreparedStatement updateContact;
    protected PreparedStatement deleteContactKey;

    protected PreparedStatement deleteContactAlt;

    protected PreparedStatement getAlarmCategoryKey;

    protected PreparedStatement addAlarmCategory;
    protected PreparedStatement updateAlarmCategory;
    protected PreparedStatement deleteAlarmCategoryKey;

    protected PreparedStatement getFaultFamilyKey;

    protected PreparedStatement getFaultFamilyAlt;
    protected PreparedStatement maxFaultFamilyKey;

    protected PreparedStatement addFaultFamily;
    protected PreparedStatement updateFaultFamily;
    protected PreparedStatement deleteFaultFamilyKey;

    protected PreparedStatement deleteFaultFamilyAlt;

    protected PreparedStatement getFaultMemberKey;

    protected PreparedStatement addFaultMember;
    protected PreparedStatement updateFaultMember;
    protected PreparedStatement deleteFaultMemberKey;

    protected PreparedStatement getDefaultMemberKey;

    protected PreparedStatement addDefaultMember;
    protected PreparedStatement updateDefaultMember;
    protected PreparedStatement deleteDefaultMemberKey;

    protected PreparedStatement getFaultCodeKey;

    protected PreparedStatement getFaultCodeAlt;
    protected PreparedStatement maxFaultCodeKey;

    protected PreparedStatement addFaultCode;
    protected PreparedStatement updateFaultCode;
    protected PreparedStatement deleteFaultCodeKey;

    protected PreparedStatement deleteFaultCodeAlt;

    /**
     * Constructor for TMCDBBase.
     */	
    public TMCDBBase () {
	}

    /**
     * Initializer for TMCDBBase.
     */	
    public void initialize () throws AcsJTmcdbSqlEx {
        try {
            // Construct the prepared statements.

		getTMCDBVersionKey = conn.prepareStatement("SELECT * FROM TMCDBVersion WHERE DBName = ?");
		addTMCDBVersion = conn.prepareStatement("INSERT INTO TMCDBVersion VALUES (?, ?, ?)");
		updateTMCDBVersion = conn.prepareStatement("UPDATE TMCDBVersion Set DBName = ?, DBVersion = ?, DBDate = ?  WHERE DBName = ?");
		deleteTMCDBVersionKey = conn.prepareStatement("DELETE FROM TMCDBVersion WHERE DBName = ?");

		getComponentTypeKey = conn.prepareStatement("SELECT * FROM ComponentType WHERE ComponentTypeId = ?");
		getComponentTypeAlt = conn.prepareStatement("SELECT * FROM ComponentType WHERE IDL = ?");
		maxComponentTypeKey = conn.prepareStatement("SELECT MAX(ComponentTypeId) FROM ComponentType");
		addComponentType = conn.prepareStatement("INSERT INTO ComponentType (IDL, URN) VALUES (?, ?)");
		updateComponentType = conn.prepareStatement("UPDATE ComponentType Set ComponentTypeId = ?, IDL = ?, URN = ?  WHERE ComponentTypeId = ?");
		deleteComponentTypeKey = conn.prepareStatement("DELETE FROM ComponentType WHERE ComponentTypeId = ?");
    	deleteComponentTypeAlt = conn.prepareStatement("DELETE FROM ComponentType WHERE IDL = ?");

		getLRUTypeKey = conn.prepareStatement("SELECT * FROM LRUType WHERE LRUName = ?");
		addLRUType = conn.prepareStatement("INSERT INTO LRUType VALUES (?, ?, ?, ?, ?, ?)");
		updateLRUType = conn.prepareStatement("UPDATE LRUType Set LRUName = ?, FullName = ?, ICD = ?, ICDDate = ?, Description = ?, Notes = ?  WHERE LRUName = ?");
		deleteLRUTypeKey = conn.prepareStatement("DELETE FROM LRUType WHERE LRUName = ?");

		getAssemblyTypeKey = conn.prepareStatement("SELECT * FROM AssemblyType WHERE AssemblyTypeName = ?");
		addAssemblyType = conn.prepareStatement("INSERT INTO AssemblyType VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
		updateAssemblyType = conn.prepareStatement("UPDATE AssemblyType Set AssemblyTypeName = ?, BaseElementType = ?, LRUName = ?, FullName = ?, Description = ?, Notes = ?, ComponentTypeId = ?, Data = ?  WHERE AssemblyTypeName = ?");
		deleteAssemblyTypeKey = conn.prepareStatement("DELETE FROM AssemblyType WHERE AssemblyTypeName = ?");

		getSchemasKey = conn.prepareStatement("SELECT * FROM Schemas WHERE SchemaId = ?");
		getSchemasAlt = conn.prepareStatement("SELECT * FROM Schemas WHERE URN = ? AND ConfigurationId = ?");
		maxSchemasKey = conn.prepareStatement("SELECT MAX(SchemaId) FROM Schemas");
		addSchemas = conn.prepareStatement("INSERT INTO Schemas (URN, ConfigurationId, Schema) VALUES (?, ?, ?)");
		updateSchemas = conn.prepareStatement("UPDATE Schemas Set SchemaId = ?, URN = ?, ConfigurationId = ?, Schema = ?  WHERE SchemaId = ?");
		deleteSchemasKey = conn.prepareStatement("DELETE FROM Schemas WHERE SchemaId = ?");
    	deleteSchemasAlt = conn.prepareStatement("DELETE FROM Schemas WHERE URN = ? AND ConfigurationId = ?");

		getDefaultComponentKey = conn.prepareStatement("SELECT * FROM DefaultComponent WHERE DefaultComponentId = ?");
		addDefaultComponent = conn.prepareStatement("INSERT INTO DefaultComponent VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		updateDefaultComponent = conn.prepareStatement("UPDATE DefaultComponent Set DefaultComponentId = ?, ComponentTypeId = ?, AssemblyTypeName = ?, ImplLang = ?, RealTime = ?, Code = ?, Path = ?, IsAutostart = ?, IsDefault = ?, IsStandaloneDefined = ?, KeepAliveTime = ?, MinLogLevel = ?, MinLogLevelLocal = ?, XMLDoc = ?  WHERE DefaultComponentId = ?");
		deleteDefaultComponentKey = conn.prepareStatement("DELETE FROM DefaultComponent WHERE DefaultComponentId = ?");

		getDefaultBaciPropertyKey = conn.prepareStatement("SELECT * FROM DefaultBaciProperty WHERE DefaultBaciPropId = ?");
		addDefaultBaciProperty = conn.prepareStatement("INSERT INTO DefaultBaciProperty VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		updateDefaultBaciProperty = conn.prepareStatement("UPDATE DefaultBaciProperty Set DefaultBaciPropId = ?, DefaultComponentId = ?, PropertyName = ?, description = ?, format = ?, units = ?, resolution = ?, archive_priority = ?, archive_min_int = ?, archive_max_int = ?, default_timer_trig = ?, min_timer_trig = ?, initialize_devio = ?, min_delta_trig = ?, default_value = ?, graph_min = ?, graph_max = ?, min_step = ?, archive_delta = ?, alarm_high_on = ?, alarm_low_on = ?, alarm_high_off = ?, alarm_low_off = ?, alarm_timer_trig = ?, min_value = ?, max_value = ?, bitDescription = ?, whenSet = ?, whenCleared = ?, statesDescription = ?, condition = ?, alarm_on = ?, alarm_off = ?, Data = ?  WHERE DefaultBaciPropId = ?");
		deleteDefaultBaciPropertyKey = conn.prepareStatement("DELETE FROM DefaultBaciProperty WHERE DefaultBaciPropId = ?");

		getDefaultMonitorPointKey = conn.prepareStatement("SELECT * FROM DefaultMonitorPoint WHERE DefaultMonitorPointId = ?");
		addDefaultMonitorPoint = conn.prepareStatement("INSERT INTO DefaultMonitorPoint VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		updateDefaultMonitorPoint = conn.prepareStatement("UPDATE DefaultMonitorPoint Set DefaultMonitorPointId = ?, DefaultBACIPropertyId = ?, MonitorPointName = ?, Indice = ?, DataType = ?, RCA = ?, TeRelated = ?, RawDataType = ?, WorldDataType = ?, Units = ?, Scale = ?, Offset = ?, MinRange = ?, MaxRange = ?, Description = ?  WHERE DefaultMonitorPointId = ?");
		deleteDefaultMonitorPointKey = conn.prepareStatement("DELETE FROM DefaultMonitorPoint WHERE DefaultMonitorPointId = ?");

		getConfigurationKey = conn.prepareStatement("SELECT * FROM Configuration WHERE ConfigurationId = ?");
		getConfigurationAlt = conn.prepareStatement("SELECT * FROM Configuration WHERE ConfigurationName = ?");
		maxConfigurationKey = conn.prepareStatement("SELECT MAX(ConfigurationId) FROM Configuration");
		addConfiguration = conn.prepareStatement("INSERT INTO Configuration (ConfigurationName, FullName, Active, CreationTime, Description) VALUES (?, ?, ?, ?, ?)");
		updateConfiguration = conn.prepareStatement("UPDATE Configuration Set ConfigurationId = ?, ConfigurationName = ?, FullName = ?, Active = ?, CreationTime = ?, Description = ?  WHERE ConfigurationId = ?");
		deleteConfigurationKey = conn.prepareStatement("DELETE FROM Configuration WHERE ConfigurationId = ?");
    	deleteConfigurationAlt = conn.prepareStatement("DELETE FROM Configuration WHERE ConfigurationName = ?");

		getComputerKey = conn.prepareStatement("SELECT * FROM Computer WHERE ComputerId = ?");
		getComputerAlt = conn.prepareStatement("SELECT * FROM Computer WHERE ComputerName = ? AND ConfigurationId = ?");
		maxComputerKey = conn.prepareStatement("SELECT MAX(ComputerId) FROM Computer");
		addComputer = conn.prepareStatement("INSERT INTO Computer (ComputerName, ConfigurationId, HostName, RealTime, ProcessorType, PhysicalLocation) VALUES (?, ?, ?, ?, ?, ?)");
		updateComputer = conn.prepareStatement("UPDATE Computer Set ComputerId = ?, ComputerName = ?, ConfigurationId = ?, HostName = ?, RealTime = ?, ProcessorType = ?, PhysicalLocation = ?  WHERE ComputerId = ?");
		deleteComputerKey = conn.prepareStatement("DELETE FROM Computer WHERE ComputerId = ?");
    	deleteComputerAlt = conn.prepareStatement("DELETE FROM Computer WHERE ComputerName = ? AND ConfigurationId = ?");

		getLoggingConfigKey = conn.prepareStatement("SELECT * FROM LoggingConfig WHERE LoggingConfigId = ?");

		maxLoggingConfigKey = conn.prepareStatement("SELECT MAX(LoggingConfigId) FROM LoggingConfig");
		addLoggingConfig = conn.prepareStatement("INSERT INTO LoggingConfig (ConfigurationId, MinLogLevelDefault, MinLogLevelLocalDefault, CentralizedLogger, DispatchPacketSize, ImmediateDispatchLevel, FlushPeriodSeconds, MaxLogQueueSize) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
		updateLoggingConfig = conn.prepareStatement("UPDATE LoggingConfig Set LoggingConfigId = ?, ConfigurationId = ?, MinLogLevelDefault = ?, MinLogLevelLocalDefault = ?, CentralizedLogger = ?, DispatchPacketSize = ?, ImmediateDispatchLevel = ?, FlushPeriodSeconds = ?, MaxLogQueueSize = ?  WHERE LoggingConfigId = ?");
		deleteLoggingConfigKey = conn.prepareStatement("DELETE FROM LoggingConfig WHERE LoggingConfigId = ?");

		getNamedLoggerConfigKey = conn.prepareStatement("SELECT * FROM NamedLoggerConfig WHERE NamedLoggerConfigId = ?");
		getNamedLoggerConfigAlt = conn.prepareStatement("SELECT * FROM NamedLoggerConfig WHERE LoggingConfigId = ? AND Name = ?");
		maxNamedLoggerConfigKey = conn.prepareStatement("SELECT MAX(NamedLoggerConfigId) FROM NamedLoggerConfig");
		addNamedLoggerConfig = conn.prepareStatement("INSERT INTO NamedLoggerConfig (LoggingConfigId, Name, MinLogLevel, MinLogLevelLocal) VALUES (?, ?, ?, ?)");
		updateNamedLoggerConfig = conn.prepareStatement("UPDATE NamedLoggerConfig Set NamedLoggerConfigId = ?, LoggingConfigId = ?, Name = ?, MinLogLevel = ?, MinLogLevelLocal = ?  WHERE NamedLoggerConfigId = ?");
		deleteNamedLoggerConfigKey = conn.prepareStatement("DELETE FROM NamedLoggerConfig WHERE NamedLoggerConfigId = ?");
    	deleteNamedLoggerConfigAlt = conn.prepareStatement("DELETE FROM NamedLoggerConfig WHERE LoggingConfigId = ? AND Name = ?");

		getManagerKey = conn.prepareStatement("SELECT * FROM Manager WHERE ManagerId = ?");
		getManagerAlt = conn.prepareStatement("SELECT * FROM Manager WHERE ConfigurationId = ? AND LoggingConfigId = ? AND Startup = ? AND ServiceComponents = ? AND Timeout = ? AND ClientPingInterval = ? AND AdministratorPingInterval = ? AND ContainerPingInterval = ? AND ServerThreads = ? AND DeadlockTimeout = ?");
		maxManagerKey = conn.prepareStatement("SELECT MAX(ManagerId) FROM Manager");
		addManager = conn.prepareStatement("INSERT INTO Manager (ConfigurationId, LoggingConfigId, Startup, ServiceComponents, Timeout, ClientPingInterval, AdministratorPingInterval, ContainerPingInterval, ServerThreads, DeadlockTimeout) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		updateManager = conn.prepareStatement("UPDATE Manager Set ManagerId = ?, ConfigurationId = ?, LoggingConfigId = ?, Startup = ?, ServiceComponents = ?, Timeout = ?, ClientPingInterval = ?, AdministratorPingInterval = ?, ContainerPingInterval = ?, ServerThreads = ?, DeadlockTimeout = ?  WHERE ManagerId = ?");
		deleteManagerKey = conn.prepareStatement("DELETE FROM Manager WHERE ManagerId = ?");
    	deleteManagerAlt = conn.prepareStatement("DELETE FROM Manager WHERE ConfigurationId = ? AND LoggingConfigId = ? AND Startup = ? AND ServiceComponents = ? AND Timeout = ? AND ClientPingInterval = ? AND AdministratorPingInterval = ? AND ContainerPingInterval = ? AND ServerThreads = ? AND DeadlockTimeout = ?");

		getContainerKey = conn.prepareStatement("SELECT * FROM Container WHERE ContainerId = ?");
		getContainerAlt = conn.prepareStatement("SELECT * FROM Container WHERE ContainerName = ? AND Path = ? AND ConfigurationId = ?");
		maxContainerKey = conn.prepareStatement("SELECT MAX(ContainerId) FROM Container");
		addContainer = conn.prepareStatement("INSERT INTO Container (ContainerName, Path, ConfigurationId, LoggingConfigId, ComputerId, ImplLang, TypeModifiers, RealTime, RealTimeType, KernelModuleLocation, KernelModule, AcsInstance, CmdLineArgs, KeepAliveTime, ServerThreads, ManagerRetry, CallTimeout, Recovery, AutoloadSharedLibs) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		updateContainer = conn.prepareStatement("UPDATE Container Set ContainerId = ?, ContainerName = ?, Path = ?, ConfigurationId = ?, LoggingConfigId = ?, ComputerId = ?, ImplLang = ?, TypeModifiers = ?, RealTime = ?, RealTimeType = ?, KernelModuleLocation = ?, KernelModule = ?, AcsInstance = ?, CmdLineArgs = ?, KeepAliveTime = ?, ServerThreads = ?, ManagerRetry = ?, CallTimeout = ?, Recovery = ?, AutoloadSharedLibs = ?  WHERE ContainerId = ?");
		deleteContainerKey = conn.prepareStatement("DELETE FROM Container WHERE ContainerId = ?");
    	deleteContainerAlt = conn.prepareStatement("DELETE FROM Container WHERE ContainerName = ? AND Path = ? AND ConfigurationId = ?");

		getComponentKey = conn.prepareStatement("SELECT * FROM Component WHERE ComponentId = ?");
		getComponentAlt = conn.prepareStatement("SELECT * FROM Component WHERE Path = ? AND ComponentName = ? AND ConfigurationId = ?");
		maxComponentKey = conn.prepareStatement("SELECT MAX(ComponentId) FROM Component");
		addComponent = conn.prepareStatement("INSERT INTO Component (ComponentTypeId, ComponentName, ConfigurationId, ContainerId, ImplLang, RealTime, Code, Path, IsAutostart, IsDefault, IsStandaloneDefined, KeepAliveTime, MinLogLevel, MinLogLevelLocal, XMLDoc) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		updateComponent = conn.prepareStatement("UPDATE Component Set ComponentId = ?, ComponentTypeId = ?, ComponentName = ?, ConfigurationId = ?, ContainerId = ?, ImplLang = ?, RealTime = ?, Code = ?, Path = ?, IsAutostart = ?, IsDefault = ?, IsStandaloneDefined = ?, KeepAliveTime = ?, MinLogLevel = ?, MinLogLevelLocal = ?, XMLDoc = ?  WHERE ComponentId = ?");
		deleteComponentKey = conn.prepareStatement("DELETE FROM Component WHERE ComponentId = ?");
    	deleteComponentAlt = conn.prepareStatement("DELETE FROM Component WHERE Path = ? AND ComponentName = ? AND ConfigurationId = ?");

		getAssemblyKey = conn.prepareStatement("SELECT * FROM Assembly WHERE AssemblyId = ?");
		getAssemblyAlt = conn.prepareStatement("SELECT * FROM Assembly WHERE SerialNumber = ? AND ConfigurationId = ?");
		maxAssemblyKey = conn.prepareStatement("SELECT MAX(AssemblyId) FROM Assembly");
		addAssembly = conn.prepareStatement("INSERT INTO Assembly (AssemblyTypeName, ConfigurationId, SerialNumber, Data) VALUES (?, ?, ?, ?)");
		updateAssembly = conn.prepareStatement("UPDATE Assembly Set AssemblyId = ?, AssemblyTypeName = ?, ConfigurationId = ?, SerialNumber = ?, Data = ?  WHERE AssemblyId = ?");
		deleteAssemblyKey = conn.prepareStatement("DELETE FROM Assembly WHERE AssemblyId = ?");
    	deleteAssemblyAlt = conn.prepareStatement("DELETE FROM Assembly WHERE SerialNumber = ? AND ConfigurationId = ?");

		getDefaultCanAddressKey = conn.prepareStatement("SELECT * FROM DefaultCanAddress WHERE ComponentId = ?");
		addDefaultCanAddress = conn.prepareStatement("INSERT INTO DefaultCanAddress VALUES (?, ?, ?, ?)");
		updateDefaultCanAddress = conn.prepareStatement("UPDATE DefaultCanAddress Set ComponentId = ?, NodeAddress = ?, ChannelNumber = ?, BaseAddress = ?  WHERE ComponentId = ?");
		deleteDefaultCanAddressKey = conn.prepareStatement("DELETE FROM DefaultCanAddress WHERE ComponentId = ?");

		getAssemblyRoleKey = conn.prepareStatement("SELECT * FROM AssemblyRole WHERE RoleName = ?");
		addAssemblyRole = conn.prepareStatement("INSERT INTO AssemblyRole VALUES (?, ?, ?, ?, ?)");
		updateAssemblyRole = conn.prepareStatement("UPDATE AssemblyRole Set RoleName = ?, NodeAddress = ?, ChannelNumber = ?, BaseAddress = ?, AssemblyTypeName = ?  WHERE RoleName = ?");
		deleteAssemblyRoleKey = conn.prepareStatement("DELETE FROM AssemblyRole WHERE RoleName = ?");

		getBACIPropertyKey = conn.prepareStatement("SELECT * FROM BACIProperty WHERE BACIPropertyId = ?");
		getBACIPropertyAlt = conn.prepareStatement("SELECT * FROM BACIProperty WHERE PropertyName = ? AND ComponentId = ?");
		maxBACIPropertyKey = conn.prepareStatement("SELECT MAX(BACIPropertyId) FROM BACIProperty");
		addBACIProperty = conn.prepareStatement("INSERT INTO BACIProperty (ComponentId, PropertyName, description, isSequence, format, units, resolution, archive_priority, archive_min_int, archive_max_int, default_timer_trig, min_timer_trig, initialize_devio, min_delta_trig, default_value, graph_min, graph_max, min_step, archive_delta, alarm_high_on, alarm_low_on, alarm_high_off, alarm_low_off, alarm_timer_trig, min_value, max_value, bitDescription, whenSet, whenCleared, statesDescription, condition, alarm_on, alarm_off, Data) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		updateBACIProperty = conn.prepareStatement("UPDATE BACIProperty Set BACIPropertyId = ?, ComponentId = ?, PropertyName = ?, description = ?, isSequence = ?, format = ?, units = ?, resolution = ?, archive_priority = ?, archive_min_int = ?, archive_max_int = ?, default_timer_trig = ?, min_timer_trig = ?, initialize_devio = ?, min_delta_trig = ?, default_value = ?, graph_min = ?, graph_max = ?, min_step = ?, archive_delta = ?, alarm_high_on = ?, alarm_low_on = ?, alarm_high_off = ?, alarm_low_off = ?, alarm_timer_trig = ?, min_value = ?, max_value = ?, bitDescription = ?, whenSet = ?, whenCleared = ?, statesDescription = ?, condition = ?, alarm_on = ?, alarm_off = ?, Data = ?  WHERE BACIPropertyId = ?");
		deleteBACIPropertyKey = conn.prepareStatement("DELETE FROM BACIProperty WHERE BACIPropertyId = ?");
    	deleteBACIPropertyAlt = conn.prepareStatement("DELETE FROM BACIProperty WHERE PropertyName = ? AND ComponentId = ?");

		getMonitorPointKey = conn.prepareStatement("SELECT * FROM MonitorPoint WHERE MonitorPointId = ?");
		addMonitorPoint = conn.prepareStatement("INSERT INTO MonitorPoint VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		updateMonitorPoint = conn.prepareStatement("UPDATE MonitorPoint Set MonitorPointId = ?, BACIPropertyId = ?, MonitorPointName = ?, AssemblyId = ?, Indice = ?, DataType = ?, RCA = ?, TeRelated = ?, RawDataType = ?, WorldDataType = ?, Units = ?, Scale = ?, Offset = ?, MinRange = ?, MaxRange = ?, Description = ?  WHERE MonitorPointId = ?");
		deleteMonitorPointKey = conn.prepareStatement("DELETE FROM MonitorPoint WHERE MonitorPointId = ?");

		getMonitorDataKey = conn.prepareStatement("SELECT * FROM MonitorData WHERE MonitorPointId = ? AND MonitorTS = ?");
		addMonitorData = conn.prepareStatement("INSERT INTO MonitorData VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		updateMonitorData = conn.prepareStatement("UPDATE MonitorData Set MonitorPointId = ?, StartTime = ?, EndTime = ?, MonitorTS = ?, SampleSize = ?, MonitorClob = ?, MinStat = ?, MaxStat = ?, MeanStat = ?, StdDevStat = ?  WHERE MonitorPointId = ? AND MonitorTS = ?");
		deleteMonitorDataKey = conn.prepareStatement("DELETE FROM MonitorData WHERE MonitorPointId = ? AND MonitorTS = ?");

		getBaseElementKey = conn.prepareStatement("SELECT * FROM BaseElement WHERE BaseElementId = ?");
		getBaseElementAlt = conn.prepareStatement("SELECT * FROM BaseElement WHERE BaseElementName = ? AND ConfigurationId = ?");
		maxBaseElementKey = conn.prepareStatement("SELECT MAX(BaseElementId) FROM BaseElement");
		addBaseElement = conn.prepareStatement("INSERT INTO BaseElement (BaseType, BaseElementName, ConfigurationId) VALUES (?, ?, ?)");
		updateBaseElement = conn.prepareStatement("UPDATE BaseElement Set BaseElementId = ?, BaseType = ?, BaseElementName = ?, ConfigurationId = ?  WHERE BaseElementId = ?");
		deleteBaseElementKey = conn.prepareStatement("DELETE FROM BaseElement WHERE BaseElementId = ?");
    	deleteBaseElementAlt = conn.prepareStatement("DELETE FROM BaseElement WHERE BaseElementName = ? AND ConfigurationId = ?");

		getBaseElementOnlineKey = conn.prepareStatement("SELECT * FROM BaseElementOnline WHERE BaseElementOnlineId = ?");
		getBaseElementOnlineAlt = conn.prepareStatement("SELECT * FROM BaseElementOnline WHERE BaseElementId = ? AND ConfigurationId = ? AND StartTime = ?");
		maxBaseElementOnlineKey = conn.prepareStatement("SELECT MAX(BaseElementOnlineId) FROM BaseElementOnline");
		addBaseElementOnline = conn.prepareStatement("INSERT INTO BaseElementOnline (BaseElementId, ConfigurationId, StartTime, EndTime, NormalTermination) VALUES (?, ?, ?, ?, ?)");
		updateBaseElementOnline = conn.prepareStatement("UPDATE BaseElementOnline Set BaseElementOnlineId = ?, BaseElementId = ?, ConfigurationId = ?, StartTime = ?, EndTime = ?, NormalTermination = ?  WHERE BaseElementOnlineId = ?");
		deleteBaseElementOnlineKey = conn.prepareStatement("DELETE FROM BaseElementOnline WHERE BaseElementOnlineId = ?");
    	deleteBaseElementOnlineAlt = conn.prepareStatement("DELETE FROM BaseElementOnline WHERE BaseElementId = ? AND ConfigurationId = ? AND StartTime = ?");

		getAntennaKey = conn.prepareStatement("SELECT * FROM Antenna WHERE BaseElementId = ?");
		addAntenna = conn.prepareStatement("INSERT INTO Antenna VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		updateAntenna = conn.prepareStatement("UPDATE Antenna Set BaseElementId = ?, AntennaName = ?, AntennaType = ?, DishDiameter = ?, CommissionDate = ?, XPosition = ?, YPosition = ?, ZPosition = ?, XOffset = ?, YOffset = ?, ZOffset = ?, ComponentId = ?  WHERE BaseElementId = ?");
		deleteAntennaKey = conn.prepareStatement("DELETE FROM Antenna WHERE BaseElementId = ?");

		getPadKey = conn.prepareStatement("SELECT * FROM Pad WHERE BaseElementId = ?");
		addPad = conn.prepareStatement("INSERT INTO Pad VALUES (?, ?, ?, ?, ?, ?)");
		updatePad = conn.prepareStatement("UPDATE Pad Set BaseElementId = ?, PadName = ?, CommissionDate = ?, XPosition = ?, YPosition = ?, ZPosition = ?  WHERE BaseElementId = ?");
		deletePadKey = conn.prepareStatement("DELETE FROM Pad WHERE BaseElementId = ?");

		getCorrHWConfigurationKey = conn.prepareStatement("SELECT * FROM CorrHWConfiguration WHERE BaseElementId = ?");
		addCorrHWConfiguration = conn.prepareStatement("INSERT INTO CorrHWConfiguration VALUES (?, ?, ?)");
		updateCorrHWConfiguration = conn.prepareStatement("UPDATE CorrHWConfiguration Set BaseElementId = ?, CorrHWName = ?, CorrHWType = ?  WHERE BaseElementId = ?");
		deleteCorrHWConfigurationKey = conn.prepareStatement("DELETE FROM CorrHWConfiguration WHERE BaseElementId = ?");

		getCorrQuadrantKey = conn.prepareStatement("SELECT * FROM CorrQuadrant WHERE CorrQuadrantId = ?");
		getCorrQuadrantAlt = conn.prepareStatement("SELECT * FROM CorrQuadrant WHERE CorrName = ? AND Quadrant = ? AND BaseElementId = ?");
		maxCorrQuadrantKey = conn.prepareStatement("SELECT MAX(CorrQuadrantId) FROM CorrQuadrant");
		addCorrQuadrant = conn.prepareStatement("INSERT INTO CorrQuadrant (CorrHWConfigId, BaseElementId, CorrName, Quadrant, ChannelNumber, NumberOfAntennas, CommissionDate, ComponentId, NumberOfRacks, NumberOfBins, Active) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		updateCorrQuadrant = conn.prepareStatement("UPDATE CorrQuadrant Set CorrQuadrantId = ?, CorrHWConfigId = ?, BaseElementId = ?, CorrName = ?, Quadrant = ?, ChannelNumber = ?, NumberOfAntennas = ?, CommissionDate = ?, ComponentId = ?, NumberOfRacks = ?, NumberOfBins = ?, Active = ?  WHERE CorrQuadrantId = ?");
		deleteCorrQuadrantKey = conn.prepareStatement("DELETE FROM CorrQuadrant WHERE CorrQuadrantId = ?");
    	deleteCorrQuadrantAlt = conn.prepareStatement("DELETE FROM CorrQuadrant WHERE CorrName = ? AND Quadrant = ? AND BaseElementId = ?");

		getCorrQuadrantRackKey = conn.prepareStatement("SELECT * FROM CorrQuadrantRack WHERE CorrQuadrantRackId = ?");
		getCorrQuadrantRackAlt = conn.prepareStatement("SELECT * FROM CorrQuadrantRack WHERE RackName = ? AND CorrQuadrantId = ?");
		maxCorrQuadrantRackKey = conn.prepareStatement("SELECT MAX(CorrQuadrantRackId) FROM CorrQuadrantRack");
		addCorrQuadrantRack = conn.prepareStatement("INSERT INTO CorrQuadrantRack (CorrQuadrantId, RackName, RackType, NumberOfBins, Active) VALUES (?, ?, ?, ?, ?)");
		updateCorrQuadrantRack = conn.prepareStatement("UPDATE CorrQuadrantRack Set CorrQuadrantRackId = ?, CorrQuadrantId = ?, RackName = ?, RackType = ?, NumberOfBins = ?, Active = ?  WHERE CorrQuadrantRackId = ?");
		deleteCorrQuadrantRackKey = conn.prepareStatement("DELETE FROM CorrQuadrantRack WHERE CorrQuadrantRackId = ?");
    	deleteCorrQuadrantRackAlt = conn.prepareStatement("DELETE FROM CorrQuadrantRack WHERE RackName = ? AND CorrQuadrantId = ?");

		getCorrStationBinKey = conn.prepareStatement("SELECT * FROM CorrStationBin WHERE CorrStationBinId = ?");
		getCorrStationBinAlt = conn.prepareStatement("SELECT * FROM CorrStationBin WHERE StationBinName = ? AND CorrQuadrantRackId = ?");
		maxCorrStationBinKey = conn.prepareStatement("SELECT MAX(CorrStationBinId) FROM CorrStationBin");
		addCorrStationBin = conn.prepareStatement("INSERT INTO CorrStationBin (CorrQuadrantRackId, StationBinName, StationNodeAddr, NumberOfStationCards, NumberOfTFBCards, NumberOfDRXCards, NumberOfInterfaceCards, NumberOfPSCards, Active) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
		updateCorrStationBin = conn.prepareStatement("UPDATE CorrStationBin Set CorrStationBinId = ?, CorrQuadrantRackId = ?, StationBinName = ?, StationNodeAddr = ?, NumberOfStationCards = ?, NumberOfTFBCards = ?, NumberOfDRXCards = ?, NumberOfInterfaceCards = ?, NumberOfPSCards = ?, Active = ?  WHERE CorrStationBinId = ?");
		deleteCorrStationBinKey = conn.prepareStatement("DELETE FROM CorrStationBin WHERE CorrStationBinId = ?");
    	deleteCorrStationBinAlt = conn.prepareStatement("DELETE FROM CorrStationBin WHERE StationBinName = ? AND CorrQuadrantRackId = ?");

		getCorrelatorBinKey = conn.prepareStatement("SELECT * FROM CorrelatorBin WHERE CorrelatorBinId = ?");
		getCorrelatorBinAlt = conn.prepareStatement("SELECT * FROM CorrelatorBin WHERE CorrelatorBinName = ? AND CorrQuadrantRackId = ?");
		maxCorrelatorBinKey = conn.prepareStatement("SELECT MAX(CorrelatorBinId) FROM CorrelatorBin");
		addCorrelatorBin = conn.prepareStatement("INSERT INTO CorrelatorBin (CorrQuadrantRackId, CorrelatorBinName, LTANodeAddr, NumberOfCorrelatorCards, NumberOfInterfaceCards, NumberOfPSCards, Active) VALUES (?, ?, ?, ?, ?, ?, ?)");
		updateCorrelatorBin = conn.prepareStatement("UPDATE CorrelatorBin Set CorrelatorBinId = ?, CorrQuadrantRackId = ?, CorrelatorBinName = ?, LTANodeAddr = ?, NumberOfCorrelatorCards = ?, NumberOfInterfaceCards = ?, NumberOfPSCards = ?, Active = ?  WHERE CorrelatorBinId = ?");
		deleteCorrelatorBinKey = conn.prepareStatement("DELETE FROM CorrelatorBin WHERE CorrelatorBinId = ?");
    	deleteCorrelatorBinAlt = conn.prepareStatement("DELETE FROM CorrelatorBin WHERE CorrelatorBinName = ? AND CorrQuadrantRackId = ?");

		getFrontEndKey = conn.prepareStatement("SELECT * FROM FrontEnd WHERE BaseElementId = ?");
		addFrontEnd = conn.prepareStatement("INSERT INTO FrontEnd VALUES (?, ?, ?)");
		updateFrontEnd = conn.prepareStatement("UPDATE FrontEnd Set BaseElementId = ?, CommissionDate = ?, ComponentId = ?  WHERE BaseElementId = ?");
		deleteFrontEndKey = conn.prepareStatement("DELETE FROM FrontEnd WHERE BaseElementId = ?");

		getWeatherStationKey = conn.prepareStatement("SELECT * FROM WeatherStation WHERE BaseElementId = ?");
		addWeatherStation = conn.prepareStatement("INSERT INTO WeatherStation VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
		updateWeatherStation = conn.prepareStatement("UPDATE WeatherStation Set BaseElementId = ?, SerialNumber = ?, WeatherStationType = ?, CommissionDate = ?, XPosition = ?, YPosition = ?, ZPosition = ?, ComponentId = ?  WHERE BaseElementId = ?");
		deleteWeatherStationKey = conn.prepareStatement("DELETE FROM WeatherStation WHERE BaseElementId = ?");

		getCentralRackKey = conn.prepareStatement("SELECT * FROM CentralRack WHERE BaseElementId = ?");
		addCentralRack = conn.prepareStatement("INSERT INTO CentralRack VALUES (?, ?, ?)");
		updateCentralRack = conn.prepareStatement("UPDATE CentralRack Set BaseElementId = ?, CommissionDate = ?, ComponentId = ?  WHERE BaseElementId = ?");
		deleteCentralRackKey = conn.prepareStatement("DELETE FROM CentralRack WHERE BaseElementId = ?");

		getMasterClockKey = conn.prepareStatement("SELECT * FROM MasterClock WHERE BaseElementId = ?");
		addMasterClock = conn.prepareStatement("INSERT INTO MasterClock VALUES (?, ?, ?)");
		updateMasterClock = conn.prepareStatement("UPDATE MasterClock Set BaseElementId = ?, CommissionDate = ?, ComponentId = ?  WHERE BaseElementId = ?");
		deleteMasterClockKey = conn.prepareStatement("DELETE FROM MasterClock WHERE BaseElementId = ?");

		getHolographyTowerKey = conn.prepareStatement("SELECT * FROM HolographyTower WHERE BaseElementId = ?");
		addHolographyTower = conn.prepareStatement("INSERT INTO HolographyTower VALUES (?, ?, ?, ?, ?)");
		updateHolographyTower = conn.prepareStatement("UPDATE HolographyTower Set BaseElementId = ?, CommissionDate = ?, XPosition = ?, YPosition = ?, ZPosition = ?  WHERE BaseElementId = ?");
		deleteHolographyTowerKey = conn.prepareStatement("DELETE FROM HolographyTower WHERE BaseElementId = ?");

		getArrayKey = conn.prepareStatement("SELECT * FROM Array WHERE ArrayId = ?");
		getArrayAlt = conn.prepareStatement("SELECT * FROM Array WHERE StartTime = ? AND BaseElementId = ?");
		maxArrayKey = conn.prepareStatement("SELECT MAX(ArrayId) FROM Array");
		addArray = conn.prepareStatement("INSERT INTO Array (BaseElementId, Type, UserId, StartTime, EndTime, NormalTermination, ComponentId) VALUES (?, ?, ?, ?, ?, ?, ?)");
		updateArray = conn.prepareStatement("UPDATE Array Set ArrayId = ?, BaseElementId = ?, Type = ?, UserId = ?, StartTime = ?, EndTime = ?, NormalTermination = ?, ComponentId = ?  WHERE ArrayId = ?");
		deleteArrayKey = conn.prepareStatement("DELETE FROM Array WHERE ArrayId = ?");
    	deleteArrayAlt = conn.prepareStatement("DELETE FROM Array WHERE StartTime = ? AND BaseElementId = ?");

		getAntennaToPadKey = conn.prepareStatement("SELECT * FROM AntennaToPad WHERE AntennaId = ? AND PadId = ? AND StartTime = ?");
		addAntennaToPad = conn.prepareStatement("INSERT INTO AntennaToPad VALUES (?, ?, ?, ?, ?)");
		updateAntennaToPad = conn.prepareStatement("UPDATE AntennaToPad Set AntennaId = ?, PadId = ?, StartTime = ?, EndTime = ?, Planned = ?  WHERE AntennaId = ? AND PadId = ? AND StartTime = ?");
		deleteAntennaToPadKey = conn.prepareStatement("DELETE FROM AntennaToPad WHERE AntennaId = ? AND PadId = ? AND StartTime = ?");

		getAntennaPointingModelKey = conn.prepareStatement("SELECT * FROM AntennaPointingModel WHERE PointingModelId = ?");
		getAntennaPointingModelAlt = conn.prepareStatement("SELECT * FROM AntennaPointingModel WHERE AntennaId = ? AND PadId = ? AND ReceiverBand = ? AND StartValidTime = ?");
		maxAntennaPointingModelKey = conn.prepareStatement("SELECT MAX(PointingModelId) FROM AntennaPointingModel");
		addAntennaPointingModel = conn.prepareStatement("INSERT INTO AntennaPointingModel (AntennaId, PadId, ReceiverBand, StartTime, StartValidTime, EndValidTime, AsdmUID) VALUES (?, ?, ?, ?, ?, ?, ?)");
		updateAntennaPointingModel = conn.prepareStatement("UPDATE AntennaPointingModel Set PointingModelId = ?, AntennaId = ?, PadId = ?, ReceiverBand = ?, StartTime = ?, StartValidTime = ?, EndValidTime = ?, AsdmUID = ?  WHERE PointingModelId = ?");
		deleteAntennaPointingModelKey = conn.prepareStatement("DELETE FROM AntennaPointingModel WHERE PointingModelId = ?");
    	deleteAntennaPointingModelAlt = conn.prepareStatement("DELETE FROM AntennaPointingModel WHERE AntennaId = ? AND PadId = ? AND ReceiverBand = ? AND StartValidTime = ?");

		getAntennaPointingModelTermKey = conn.prepareStatement("SELECT * FROM AntennaPointingModelTerm WHERE PointingModelId = ? AND CoeffName = ?");
		addAntennaPointingModelTerm = conn.prepareStatement("INSERT INTO AntennaPointingModelTerm VALUES (?, ?, ?, ?)");
		updateAntennaPointingModelTerm = conn.prepareStatement("UPDATE AntennaPointingModelTerm Set PointingModelId = ?, CoeffName = ?, CoeffValue = ?, CoeffError = ?  WHERE PointingModelId = ? AND CoeffName = ?");
		deleteAntennaPointingModelTermKey = conn.prepareStatement("DELETE FROM AntennaPointingModelTerm WHERE PointingModelId = ? AND CoeffName = ?");

		getAntennaFocusModelKey = conn.prepareStatement("SELECT * FROM AntennaFocusModel WHERE FocusModelId = ?");
		getAntennaFocusModelAlt = conn.prepareStatement("SELECT * FROM AntennaFocusModel WHERE AntennaId = ? AND ReceiverBand = ? AND StartValidTime = ?");
		maxAntennaFocusModelKey = conn.prepareStatement("SELECT MAX(FocusModelId) FROM AntennaFocusModel");
		addAntennaFocusModel = conn.prepareStatement("INSERT INTO AntennaFocusModel (AntennaId, ReceiverBand, StartValidTime, EndValidTime, AsdmUID) VALUES (?, ?, ?, ?, ?)");
		updateAntennaFocusModel = conn.prepareStatement("UPDATE AntennaFocusModel Set FocusModelId = ?, AntennaId = ?, ReceiverBand = ?, StartValidTime = ?, EndValidTime = ?, AsdmUID = ?  WHERE FocusModelId = ?");
		deleteAntennaFocusModelKey = conn.prepareStatement("DELETE FROM AntennaFocusModel WHERE FocusModelId = ?");
    	deleteAntennaFocusModelAlt = conn.prepareStatement("DELETE FROM AntennaFocusModel WHERE AntennaId = ? AND ReceiverBand = ? AND StartValidTime = ?");

		getAntennaFocusModelTermKey = conn.prepareStatement("SELECT * FROM AntennaFocusModelTerm WHERE FocusModelId = ? AND CoeffName = ?");
		addAntennaFocusModelTerm = conn.prepareStatement("INSERT INTO AntennaFocusModelTerm VALUES (?, ?, ?, ?)");
		updateAntennaFocusModelTerm = conn.prepareStatement("UPDATE AntennaFocusModelTerm Set FocusModelId = ?, CoeffName = ?, CoeffValue = ?, CoeffError = ?  WHERE FocusModelId = ? AND CoeffName = ?");
		deleteAntennaFocusModelTermKey = conn.prepareStatement("DELETE FROM AntennaFocusModelTerm WHERE FocusModelId = ? AND CoeffName = ?");

		getAntennaDelayModelKey = conn.prepareStatement("SELECT * FROM AntennaDelayModel WHERE DelayModelId = ?");
		getAntennaDelayModelAlt = conn.prepareStatement("SELECT * FROM AntennaDelayModel WHERE AntennaId = ? AND PadId = ? AND ReceiverBand = ? AND StartValidTime = ?");
		maxAntennaDelayModelKey = conn.prepareStatement("SELECT MAX(DelayModelId) FROM AntennaDelayModel");
		addAntennaDelayModel = conn.prepareStatement("INSERT INTO AntennaDelayModel (AntennaId, PadId, ReceiverBand, StartTime, StartValidTime, EndValidTime, AsdmUID) VALUES (?, ?, ?, ?, ?, ?, ?)");
		updateAntennaDelayModel = conn.prepareStatement("UPDATE AntennaDelayModel Set DelayModelId = ?, AntennaId = ?, PadId = ?, ReceiverBand = ?, StartTime = ?, StartValidTime = ?, EndValidTime = ?, AsdmUID = ?  WHERE DelayModelId = ?");
		deleteAntennaDelayModelKey = conn.prepareStatement("DELETE FROM AntennaDelayModel WHERE DelayModelId = ?");
    	deleteAntennaDelayModelAlt = conn.prepareStatement("DELETE FROM AntennaDelayModel WHERE AntennaId = ? AND PadId = ? AND ReceiverBand = ? AND StartValidTime = ?");

		getAntennaDelayModelTermKey = conn.prepareStatement("SELECT * FROM AntennaDelayModelTerm WHERE DelayModelId = ? AND CoeffName = ?");
		addAntennaDelayModelTerm = conn.prepareStatement("INSERT INTO AntennaDelayModelTerm VALUES (?, ?, ?, ?)");
		updateAntennaDelayModelTerm = conn.prepareStatement("UPDATE AntennaDelayModelTerm Set DelayModelId = ?, CoeffName = ?, CoeffValue = ?, CoeffError = ?  WHERE DelayModelId = ? AND CoeffName = ?");
		deleteAntennaDelayModelTermKey = conn.prepareStatement("DELETE FROM AntennaDelayModelTerm WHERE DelayModelId = ? AND CoeffName = ?");

		getAntennaToFrontEndKey = conn.prepareStatement("SELECT * FROM AntennaToFrontEnd WHERE AntennaId = ? AND FrontEndId = ? AND StartTime = ?");
		addAntennaToFrontEnd = conn.prepareStatement("INSERT INTO AntennaToFrontEnd VALUES (?, ?, ?, ?)");
		updateAntennaToFrontEnd = conn.prepareStatement("UPDATE AntennaToFrontEnd Set AntennaId = ?, FrontEndId = ?, StartTime = ?, EndTime = ?  WHERE AntennaId = ? AND FrontEndId = ? AND StartTime = ?");
		deleteAntennaToFrontEndKey = conn.prepareStatement("DELETE FROM AntennaToFrontEnd WHERE AntennaId = ? AND FrontEndId = ? AND StartTime = ?");

		getAntennaToArrayKey = conn.prepareStatement("SELECT * FROM AntennaToArray WHERE AntennaId = ? AND ArrayId = ?");
		addAntennaToArray = conn.prepareStatement("INSERT INTO AntennaToArray VALUES (?, ?)");
		updateAntennaToArray = conn.prepareStatement("UPDATE AntennaToArray Set AntennaId = ?, ArrayId = ?  WHERE AntennaId = ? AND ArrayId = ?");
		deleteAntennaToArrayKey = conn.prepareStatement("DELETE FROM AntennaToArray WHERE AntennaId = ? AND ArrayId = ?");

		getSBExecutionKey = conn.prepareStatement("SELECT * FROM SBExecution WHERE ArrayId = ? AND SbUID = ? AND StartTime = ?");
		addSBExecution = conn.prepareStatement("INSERT INTO SBExecution VALUES (?, ?, ?, ?, ?)");
		updateSBExecution = conn.prepareStatement("UPDATE SBExecution Set ArrayId = ?, SbUID = ?, StartTime = ?, EndTime = ?, NormalTermination = ?  WHERE ArrayId = ? AND SbUID = ? AND StartTime = ?");
		deleteSBExecutionKey = conn.prepareStatement("DELETE FROM SBExecution WHERE ArrayId = ? AND SbUID = ? AND StartTime = ?");

		getAntennaToCorrKey = conn.prepareStatement("SELECT * FROM AntennaToCorr WHERE AntennaId = ? AND CorrId = ? AND StartTime = ?");
		addAntennaToCorr = conn.prepareStatement("INSERT INTO AntennaToCorr VALUES (?, ?, ?, ?, ?)");
		updateAntennaToCorr = conn.prepareStatement("UPDATE AntennaToCorr Set AntennaId = ?, CorrId = ?, AntennaNumber = ?, StartTime = ?, EndTime = ?  WHERE AntennaId = ? AND CorrId = ? AND StartTime = ?");
		deleteAntennaToCorrKey = conn.prepareStatement("DELETE FROM AntennaToCorr WHERE AntennaId = ? AND CorrId = ? AND StartTime = ?");

		getWeatherStationToPadKey = conn.prepareStatement("SELECT * FROM WeatherStationToPad WHERE WeatherStationId = ? AND PadId = ? AND StartTime = ?");
		addWeatherStationToPad = conn.prepareStatement("INSERT INTO WeatherStationToPad VALUES (?, ?, ?, ?, ?)");
		updateWeatherStationToPad = conn.prepareStatement("UPDATE WeatherStationToPad Set WeatherStationId = ?, PadId = ?, StartTime = ?, EndTime = ?, Planned = ?  WHERE WeatherStationId = ? AND PadId = ? AND StartTime = ?");
		deleteWeatherStationToPadKey = conn.prepareStatement("DELETE FROM WeatherStationToPad WHERE WeatherStationId = ? AND PadId = ? AND StartTime = ?");

		getBaseElementAssemblyListKey = conn.prepareStatement("SELECT * FROM BaseElementAssemblyList WHERE AssemblyId = ? AND BaseElementOnlineId = ?");
		addBaseElementAssemblyList = conn.prepareStatement("INSERT INTO BaseElementAssemblyList VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
		updateBaseElementAssemblyList = conn.prepareStatement("UPDATE BaseElementAssemblyList Set AssemblyId = ?, BaseElementOnlineId = ?, GroupName = ?, OrderTag = ?, ComponentId = ?, RoleName = ?, ChannelNumber = ?, NodeAddress = ?, BaseAddress = ?  WHERE AssemblyId = ? AND BaseElementOnlineId = ?");
		deleteBaseElementAssemblyListKey = conn.prepareStatement("DELETE FROM BaseElementAssemblyList WHERE AssemblyId = ? AND BaseElementOnlineId = ?");

		getMasterComponentKey = conn.prepareStatement("SELECT * FROM MasterComponent WHERE MasterComponentId = ?");
		getMasterComponentAlt = conn.prepareStatement("SELECT * FROM MasterComponent WHERE ComponentId = ? AND ConfigurationId = ?");
		maxMasterComponentKey = conn.prepareStatement("SELECT MAX(MasterComponentId) FROM MasterComponent");
		addMasterComponent = conn.prepareStatement("INSERT INTO MasterComponent (ComponentId, ConfigurationId, SubsystemName) VALUES (?, ?, ?)");
		updateMasterComponent = conn.prepareStatement("UPDATE MasterComponent Set MasterComponentId = ?, ComponentId = ?, ConfigurationId = ?, SubsystemName = ?  WHERE MasterComponentId = ?");
		deleteMasterComponentKey = conn.prepareStatement("DELETE FROM MasterComponent WHERE MasterComponentId = ?");
    	deleteMasterComponentAlt = conn.prepareStatement("DELETE FROM MasterComponent WHERE ComponentId = ? AND ConfigurationId = ?");

		getComputerExecutionKey = conn.prepareStatement("SELECT * FROM ComputerExecution WHERE ComputerExecutionId = ?");
		getComputerExecutionAlt = conn.prepareStatement("SELECT * FROM ComputerExecution WHERE ComputerId = ? AND ConfigurationId = ? AND StartTime = ?");
		maxComputerExecutionKey = conn.prepareStatement("SELECT MAX(ComputerExecutionId) FROM ComputerExecution");
		addComputerExecution = conn.prepareStatement("INSERT INTO ComputerExecution (ComputerId, ConfigurationId, StartTime, EndTime, NormalStart, NormalTermination) VALUES (?, ?, ?, ?, ?, ?)");
		updateComputerExecution = conn.prepareStatement("UPDATE ComputerExecution Set ComputerExecutionId = ?, ComputerId = ?, ConfigurationId = ?, StartTime = ?, EndTime = ?, NormalStart = ?, NormalTermination = ?  WHERE ComputerExecutionId = ?");
		deleteComputerExecutionKey = conn.prepareStatement("DELETE FROM ComputerExecution WHERE ComputerExecutionId = ?");
    	deleteComputerExecutionAlt = conn.prepareStatement("DELETE FROM ComputerExecution WHERE ComputerId = ? AND ConfigurationId = ? AND StartTime = ?");

		getContainerExecutionKey = conn.prepareStatement("SELECT * FROM ContainerExecution WHERE ContainerExecutionId = ?");
		getContainerExecutionAlt = conn.prepareStatement("SELECT * FROM ContainerExecution WHERE ContainerId = ? AND ComputerId = ? AND StartTime = ? AND ConfigurationId = ?");
		maxContainerExecutionKey = conn.prepareStatement("SELECT MAX(ContainerExecutionId) FROM ContainerExecution");
		addContainerExecution = conn.prepareStatement("INSERT INTO ContainerExecution (ContainerId, ConfigurationId, ComputerId, StartTime, EndTime, NormalStart, NormalTermination) VALUES (?, ?, ?, ?, ?, ?, ?)");
		updateContainerExecution = conn.prepareStatement("UPDATE ContainerExecution Set ContainerExecutionId = ?, ContainerId = ?, ConfigurationId = ?, ComputerId = ?, StartTime = ?, EndTime = ?, NormalStart = ?, NormalTermination = ?  WHERE ContainerExecutionId = ?");
		deleteContainerExecutionKey = conn.prepareStatement("DELETE FROM ContainerExecution WHERE ContainerExecutionId = ?");
    	deleteContainerExecutionAlt = conn.prepareStatement("DELETE FROM ContainerExecution WHERE ContainerId = ? AND ComputerId = ? AND StartTime = ? AND ConfigurationId = ?");

		getComponentExecutionKey = conn.prepareStatement("SELECT * FROM ComponentExecution WHERE ComponentExecutionId = ?");
		getComponentExecutionAlt = conn.prepareStatement("SELECT * FROM ComponentExecution WHERE ComponentId = ? AND StartTime = ? AND ConfigurationId = ?");
		maxComponentExecutionKey = conn.prepareStatement("SELECT MAX(ComponentExecutionId) FROM ComponentExecution");
		addComponentExecution = conn.prepareStatement("INSERT INTO ComponentExecution (ComponentExecutionAcsId, ComponentId, ConfigurationId, ContainerId, StartTime, EndTime, NormalStart, NormalTermination, BaseElementOnlineId, AssemblyId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		updateComponentExecution = conn.prepareStatement("UPDATE ComponentExecution Set ComponentExecutionId = ?, ComponentExecutionAcsId = ?, ComponentId = ?, ConfigurationId = ?, ContainerId = ?, StartTime = ?, EndTime = ?, NormalStart = ?, NormalTermination = ?, BaseElementOnlineId = ?, AssemblyId = ?  WHERE ComponentExecutionId = ?");
		deleteComponentExecutionKey = conn.prepareStatement("DELETE FROM ComponentExecution WHERE ComponentExecutionId = ?");
    	deleteComponentExecutionAlt = conn.prepareStatement("DELETE FROM ComponentExecution WHERE ComponentId = ? AND StartTime = ? AND ConfigurationId = ?");

		getMasterComponentExecutionKey = conn.prepareStatement("SELECT * FROM MasterComponentExecution WHERE MasterComponentExecId = ?");
		getMasterComponentExecutionAlt = conn.prepareStatement("SELECT * FROM MasterComponentExecution WHERE MasterComponentId = ? AND ContainerId = ? AND StartTime = ? AND ConfigurationId = ?");
		maxMasterComponentExecutionKey = conn.prepareStatement("SELECT MAX(MasterComponentExecId) FROM MasterComponentExecution");
		addMasterComponentExecution = conn.prepareStatement("INSERT INTO MasterComponentExecution (MasterComponentId, ConfigurationId, ContainerId, StartTime, EndTime, NormalStart, NormalTermination) VALUES (?, ?, ?, ?, ?, ?, ?)");
		updateMasterComponentExecution = conn.prepareStatement("UPDATE MasterComponentExecution Set MasterComponentExecId = ?, MasterComponentId = ?, ConfigurationId = ?, ContainerId = ?, StartTime = ?, EndTime = ?, NormalStart = ?, NormalTermination = ?  WHERE MasterComponentExecId = ?");
		deleteMasterComponentExecutionKey = conn.prepareStatement("DELETE FROM MasterComponentExecution WHERE MasterComponentExecId = ?");
    	deleteMasterComponentExecutionAlt = conn.prepareStatement("DELETE FROM MasterComponentExecution WHERE MasterComponentId = ? AND ContainerId = ? AND StartTime = ? AND ConfigurationId = ?");

		getACSKey = conn.prepareStatement("SELECT * FROM ACS WHERE ACSId = ?");
		getACSAlt = conn.prepareStatement("SELECT * FROM ACS WHERE ACSVersion = ? AND ConfigurationId = ? AND ComputerId = ?");
		maxACSKey = conn.prepareStatement("SELECT MAX(ACSId) FROM ACS");
		addACS = conn.prepareStatement("INSERT INTO ACS (ACSVersion, ConfigurationId, ComputerId, Var1, Var2, Var3) VALUES (?, ?, ?, ?, ?, ?)");
		updateACS = conn.prepareStatement("UPDATE ACS Set ACSId = ?, ACSVersion = ?, ConfigurationId = ?, ComputerId = ?, Var1 = ?, Var2 = ?, Var3 = ?  WHERE ACSId = ?");
		deleteACSKey = conn.prepareStatement("DELETE FROM ACS WHERE ACSId = ?");
    	deleteACSAlt = conn.prepareStatement("DELETE FROM ACS WHERE ACSVersion = ? AND ConfigurationId = ? AND ComputerId = ?");

		getACSExecutionKey = conn.prepareStatement("SELECT * FROM ACSExecution WHERE ACSId = ? AND ConfigurationId = ? AND StartTime = ?");
		addACSExecution = conn.prepareStatement("INSERT INTO ACSExecution VALUES (?, ?, ?, ?, ?, ?)");
		updateACSExecution = conn.prepareStatement("UPDATE ACSExecution Set ACSId = ?, ConfigurationId = ?, StartTime = ?, EndTime = ?, NormalStart = ?, NormalTermination = ?  WHERE ACSId = ? AND ConfigurationId = ? AND StartTime = ?");
		deleteACSExecutionKey = conn.prepareStatement("DELETE FROM ACSExecution WHERE ACSId = ? AND ConfigurationId = ? AND StartTime = ?");

		getNotificationChannelKey = conn.prepareStatement("SELECT * FROM NotificationChannel WHERE NCId = ?");
		getNotificationChannelAlt = conn.prepareStatement("SELECT * FROM NotificationChannel WHERE NCName = ? AND ConfigurationId = ?");
		maxNotificationChannelKey = conn.prepareStatement("SELECT MAX(NCId) FROM NotificationChannel");
		addNotificationChannel = conn.prepareStatement("INSERT INTO NotificationChannel (NCName, SubsystemName, ConfigurationId, QOS1, QOS2, QOS3) VALUES (?, ?, ?, ?, ?, ?)");
		updateNotificationChannel = conn.prepareStatement("UPDATE NotificationChannel Set NCId = ?, NCName = ?, SubsystemName = ?, ConfigurationId = ?, QOS1 = ?, QOS2 = ?, QOS3 = ?  WHERE NCId = ?");
		deleteNotificationChannelKey = conn.prepareStatement("DELETE FROM NotificationChannel WHERE NCId = ?");
    	deleteNotificationChannelAlt = conn.prepareStatement("DELETE FROM NotificationChannel WHERE NCName = ? AND ConfigurationId = ?");

		getNCExecutionKey = conn.prepareStatement("SELECT * FROM NCExecution WHERE NCId = ? AND ConfigurationId = ? AND StartTime = ?");
		addNCExecution = conn.prepareStatement("INSERT INTO NCExecution VALUES (?, ?, ?, ?, ?, ?, ?)");
		updateNCExecution = conn.prepareStatement("UPDATE NCExecution Set NCId = ?, ACSId = ?, ConfigurationId = ?, StartTime = ?, EndTime = ?, NormalStart = ?, NormalTermination = ?  WHERE NCId = ? AND ConfigurationId = ? AND StartTime = ?");
		deleteNCExecutionKey = conn.prepareStatement("DELETE FROM NCExecution WHERE NCId = ? AND ConfigurationId = ? AND StartTime = ?");

		getStartupKey = conn.prepareStatement("SELECT * FROM Startup WHERE StartupId = ?");
		getStartupAlt = conn.prepareStatement("SELECT * FROM Startup WHERE StartupName = ? AND ConfigurationId = ?");
		maxStartupKey = conn.prepareStatement("SELECT MAX(StartupId) FROM Startup");
		addStartup = conn.prepareStatement("INSERT INTO Startup (ConfigurationId, StartupName) VALUES (?, ?)");
		updateStartup = conn.prepareStatement("UPDATE Startup Set StartupId = ?, ConfigurationId = ?, StartupName = ?  WHERE StartupId = ?");
		deleteStartupKey = conn.prepareStatement("DELETE FROM Startup WHERE StartupId = ?");
    	deleteStartupAlt = conn.prepareStatement("DELETE FROM Startup WHERE StartupName = ? AND ConfigurationId = ?");

		getSystemExecutionKey = conn.prepareStatement("SELECT * FROM SystemExecution WHERE StartupId = ? AND ConfigurationId = ? AND StartTime = ?");
		addSystemExecution = conn.prepareStatement("INSERT INTO SystemExecution VALUES (?, ?, ?, ?, ?, ?)");
		updateSystemExecution = conn.prepareStatement("UPDATE SystemExecution Set StartupId = ?, ConfigurationId = ?, StartTime = ?, EndTime = ?, NormalStart = ?, NormalTermination = ?  WHERE StartupId = ? AND ConfigurationId = ? AND StartTime = ?");
		deleteSystemExecutionKey = conn.prepareStatement("DELETE FROM SystemExecution WHERE StartupId = ? AND ConfigurationId = ? AND StartTime = ?");

		getDeploymentStartupKey = conn.prepareStatement("SELECT * FROM DeploymentStartup WHERE Name = ? AND Path = ? AND StartupType = ? AND StartupId = ?");
		addDeploymentStartup = conn.prepareStatement("INSERT INTO DeploymentStartup VALUES (?, ?, ?, ?, ?, ?, ?)");
		updateDeploymentStartup = conn.prepareStatement("UPDATE DeploymentStartup Set Name = ?, Path = ?, StartupType = ?, StartupId = ?, DependsOnName = ?, DependsOnPath = ?, DependsOnType = ?  WHERE Name = ? AND Path = ? AND StartupType = ? AND StartupId = ?");
		deleteDeploymentStartupKey = conn.prepareStatement("DELETE FROM DeploymentStartup WHERE Name = ? AND Path = ? AND StartupType = ? AND StartupId = ?");

		getBaseElementStartupKey = conn.prepareStatement("SELECT * FROM BaseElementStartup WHERE BaseElementStartupId = ?");
		getBaseElementStartupAlt = conn.prepareStatement("SELECT * FROM BaseElementStartup WHERE StartupId = ? AND BaseElementId = ? AND Parent = ? AND BaseElementType = ?");
		maxBaseElementStartupKey = conn.prepareStatement("SELECT MAX(BaseElementStartupId) FROM BaseElementStartup");
		addBaseElementStartup = conn.prepareStatement("INSERT INTO BaseElementStartup (BaseElementId, StartupId, BaseElementType, Parent, IsGeneric) VALUES (?, ?, ?, ?, ?)");
		updateBaseElementStartup = conn.prepareStatement("UPDATE BaseElementStartup Set BaseElementStartupId = ?, BaseElementId = ?, StartupId = ?, BaseElementType = ?, Parent = ?, IsGeneric = ?  WHERE BaseElementStartupId = ?");
		deleteBaseElementStartupKey = conn.prepareStatement("DELETE FROM BaseElementStartup WHERE BaseElementStartupId = ?");
    	deleteBaseElementStartupAlt = conn.prepareStatement("DELETE FROM BaseElementStartup WHERE StartupId = ? AND BaseElementId = ? AND Parent = ? AND BaseElementType = ?");

		getAssociatedBaseElementKey = conn.prepareStatement("SELECT * FROM AssociatedBaseElement WHERE BaseElementId = ? AND StartupId = ? AND AssociatedId = ?");
		addAssociatedBaseElement = conn.prepareStatement("INSERT INTO AssociatedBaseElement VALUES (?, ?, ?, ?)");
		updateAssociatedBaseElement = conn.prepareStatement("UPDATE AssociatedBaseElement Set BaseElementId = ?, StartupId = ?, AssociatedId = ?, AssociationType = ?  WHERE BaseElementId = ? AND StartupId = ? AND AssociatedId = ?");
		deleteAssociatedBaseElementKey = conn.prepareStatement("DELETE FROM AssociatedBaseElement WHERE BaseElementId = ? AND StartupId = ? AND AssociatedId = ?");

		getAssemblyStartupKey = conn.prepareStatement("SELECT * FROM AssemblyStartup WHERE AssemblyStartupId = ?");
		getAssemblyStartupAlt = conn.prepareStatement("SELECT * FROM AssemblyStartup WHERE BaseElementStartupId = ? AND RoleName = ?");
		maxAssemblyStartupKey = conn.prepareStatement("SELECT MAX(AssemblyStartupId) FROM AssemblyStartup");
		addAssemblyStartup = conn.prepareStatement("INSERT INTO AssemblyStartup (RoleName, ComponentId, BaseElementStartupId) VALUES (?, ?, ?)");
		updateAssemblyStartup = conn.prepareStatement("UPDATE AssemblyStartup Set AssemblyStartupId = ?, RoleName = ?, ComponentId = ?, BaseElementStartupId = ?  WHERE AssemblyStartupId = ?");
		deleteAssemblyStartupKey = conn.prepareStatement("DELETE FROM AssemblyStartup WHERE AssemblyStartupId = ?");
    	deleteAssemblyStartupAlt = conn.prepareStatement("DELETE FROM AssemblyStartup WHERE BaseElementStartupId = ? AND RoleName = ?");

		getSystemCountersKey = conn.prepareStatement("SELECT * FROM SystemCounters WHERE ConfigurationId = ?");
		addSystemCounters = conn.prepareStatement("INSERT INTO SystemCounters VALUES (?, ?, ?, ?, ?)");
		updateSystemCounters = conn.prepareStatement("UPDATE SystemCounters Set ConfigurationId = ?, UpdateTime = ?, AutoArrayCount = ?, ManArrayCount = ?, DataCaptureCount = ?  WHERE ConfigurationId = ?");
		deleteSystemCountersKey = conn.prepareStatement("DELETE FROM SystemCounters WHERE ConfigurationId = ?");

		getLocationKey = conn.prepareStatement("SELECT * FROM Location WHERE LocationId = ?");
		getLocationAlt = conn.prepareStatement("SELECT * FROM Location WHERE Building = ? AND Floor = ? AND Room = ? AND Mnemonic = ? AND LocationPosition = ?");
		maxLocationKey = conn.prepareStatement("SELECT MAX(LocationId) FROM Location");
		addLocation = conn.prepareStatement("INSERT INTO Location (Building, Floor, Room, Mnemonic, LocationPosition) VALUES (?, ?, ?, ?, ?)");
		updateLocation = conn.prepareStatement("UPDATE Location Set LocationId = ?, Building = ?, Floor = ?, Room = ?, Mnemonic = ?, LocationPosition = ?  WHERE LocationId = ?");
		deleteLocationKey = conn.prepareStatement("DELETE FROM Location WHERE LocationId = ?");
    	deleteLocationAlt = conn.prepareStatement("DELETE FROM Location WHERE Building = ? AND Floor = ? AND Room = ? AND Mnemonic = ? AND LocationPosition = ?");

		getContactKey = conn.prepareStatement("SELECT * FROM Contact WHERE ContactId = ?");
		getContactAlt = conn.prepareStatement("SELECT * FROM Contact WHERE ContactName = ?");
		maxContactKey = conn.prepareStatement("SELECT MAX(ContactId) FROM Contact");
		addContact = conn.prepareStatement("INSERT INTO Contact (ContactName, Email, Gsm) VALUES (?, ?, ?)");
		updateContact = conn.prepareStatement("UPDATE Contact Set ContactId = ?, ContactName = ?, Email = ?, Gsm = ?  WHERE ContactId = ?");
		deleteContactKey = conn.prepareStatement("DELETE FROM Contact WHERE ContactId = ?");
    	deleteContactAlt = conn.prepareStatement("DELETE FROM Contact WHERE ContactName = ?");

		getAlarmCategoryKey = conn.prepareStatement("SELECT * FROM AlarmCategory WHERE AlarmCategoryName = ?");
		addAlarmCategory = conn.prepareStatement("INSERT INTO AlarmCategory VALUES (?, ?, ?, ?)");
		updateAlarmCategory = conn.prepareStatement("UPDATE AlarmCategory Set AlarmCategoryName = ?, Description = ?, Path = ?, IsDefault = ?  WHERE AlarmCategoryName = ?");
		deleteAlarmCategoryKey = conn.prepareStatement("DELETE FROM AlarmCategory WHERE AlarmCategoryName = ?");

		getFaultFamilyKey = conn.prepareStatement("SELECT * FROM FaultFamily WHERE FaultFamilyId = ?");
		getFaultFamilyAlt = conn.prepareStatement("SELECT * FROM FaultFamily WHERE FamilyName = ?");
		maxFaultFamilyKey = conn.prepareStatement("SELECT MAX(FaultFamilyId) FROM FaultFamily");
		addFaultFamily = conn.prepareStatement("INSERT INTO FaultFamily (FamilyName, AlarmCategoryName, AlarmSource, HelpURL, ContactId) VALUES (?, ?, ?, ?, ?)");
		updateFaultFamily = conn.prepareStatement("UPDATE FaultFamily Set FaultFamilyId = ?, FamilyName = ?, AlarmCategoryName = ?, AlarmSource = ?, HelpURL = ?, ContactId = ?  WHERE FaultFamilyId = ?");
		deleteFaultFamilyKey = conn.prepareStatement("DELETE FROM FaultFamily WHERE FaultFamilyId = ?");
    	deleteFaultFamilyAlt = conn.prepareStatement("DELETE FROM FaultFamily WHERE FamilyName = ?");

		getFaultMemberKey = conn.prepareStatement("SELECT * FROM FaultMember WHERE MemberName = ?");
		addFaultMember = conn.prepareStatement("INSERT INTO FaultMember VALUES (?, ?, ?)");
		updateFaultMember = conn.prepareStatement("UPDATE FaultMember Set MemberName = ?, FaultFamilyId = ?, LocationId = ?  WHERE MemberName = ?");
		deleteFaultMemberKey = conn.prepareStatement("DELETE FROM FaultMember WHERE MemberName = ?");

		getDefaultMemberKey = conn.prepareStatement("SELECT * FROM DefaultMember WHERE DefaultMemberId = ?");
		addDefaultMember = conn.prepareStatement("INSERT INTO DefaultMember VALUES (?, ?, ?)");
		updateDefaultMember = conn.prepareStatement("UPDATE DefaultMember Set DefaultMemberId = ?, FaultFamilyId = ?, LocationID = ?  WHERE DefaultMemberId = ?");
		deleteDefaultMemberKey = conn.prepareStatement("DELETE FROM DefaultMember WHERE DefaultMemberId = ?");

		getFaultCodeKey = conn.prepareStatement("SELECT * FROM FaultCode WHERE FaultCodeId = ?");
		getFaultCodeAlt = conn.prepareStatement("SELECT * FROM FaultCode WHERE FaultFamilyId = ? AND CodeValue = ?");
		maxFaultCodeKey = conn.prepareStatement("SELECT MAX(FaultCodeId) FROM FaultCode");
		addFaultCode = conn.prepareStatement("INSERT INTO FaultCode (FaultFamilyId, CodeValue, Priority, Cause, Action, Consequence, ProblemDescription, IsInstant) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
		updateFaultCode = conn.prepareStatement("UPDATE FaultCode Set FaultCodeId = ?, FaultFamilyId = ?, CodeValue = ?, Priority = ?, Cause = ?, Action = ?, Consequence = ?, ProblemDescription = ?, IsInstant = ?  WHERE FaultCodeId = ?");
		deleteFaultCodeKey = conn.prepareStatement("DELETE FROM FaultCode WHERE FaultCodeId = ?");
    	deleteFaultCodeAlt = conn.prepareStatement("DELETE FROM FaultCode WHERE FaultFamilyId = ? AND CodeValue = ?");

        } catch (SQLException err) {
        	AcsJTmcdbSqlEx ex = new AcsJTmcdbSqlEx (err);
            throw ex;
        }
    }

    /////////////////////////////////////////////////////////////////
    // For each table we have get, add, delete, and update methods //
    /////////////////////////////////////////////////////////////////

    /////////////////////////////////////////
    // TMCDBVersion
    /////////////////////////////////////////

    public void assignTMCDBVersion(TMCDBVersion x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setDBName(result.getString(1));

        x.setDBVersion(result.getString(2));

        x.setDBDate(result.getString(3));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public TMCDBVersion getTMCDBVersion (String DBName) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getTMCDBVersionKey.setString(1, DBName);

            ResultSet result = getTMCDBVersionKey.executeQuery();
            TMCDBVersion x = new TMCDBVersion ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in TMCDBVersion tables with key " + 
                    DBName);
            assignTMCDBVersion(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for TMCDBVersion table (key " + 
                    DBName + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public TMCDBVersion[] getTMCDBVersionWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<TMCDBVersion> list = new ArrayList<TMCDBVersion> ();
	    	TMCDBVersion item = null;
	    	String s = "SELECT * FROM TMCDBVersion";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new TMCDBVersion ();
	    		assignTMCDBVersion(item,result);
	    		list.add(item);
	    	}
	    	TMCDBVersion[] tmp = new TMCDBVersion [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addTMCDBVersion(TMCDBVersion data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    TMCDBVersion x = getTMCDBVersion(data.getDBName());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addTMCDBVersion.setString(1,data.getDBName());

            addTMCDBVersion.setString(2,data.getDBVersion());

            addTMCDBVersion.setString(3,data.getDBDate());

			addTMCDBVersion.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addTMCDBVersion(TMCDBVersion data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				TMCDBVersion x = getTMCDBVersion(data.getDBName());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addTMCDBVersion(data);

    }

    public void deleteTMCDBVersion (String DBName) throws AcsJTmcdbSqlEx {
        try {

          	deleteTMCDBVersionKey.setString(1, DBName);

			deleteTMCDBVersionKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateTMCDBVersion(TMCDBVersion data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        TMCDBVersion x = null;
        try {
            x = getTMCDBVersion(data.getDBName());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (!x.getDBName().equals(data.getDBName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateTMCDBVersion.setString(1,data.getDBName());

            updateTMCDBVersion.setString(2,data.getDBVersion());

            updateTMCDBVersion.setString(3,data.getDBDate());

          	updateTMCDBVersion.setString(3 + 1, data.getDBName());

			updateTMCDBVersion.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // ComponentType
    /////////////////////////////////////////

    public void assignComponentType(ComponentType x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setComponentTypeId(result.getInt(1));

        x.setIDL(result.getString(2));

        x.setURN(result.getString(3));

        // if (result.wasNull())
        // 	x.setURNNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public ComponentType getComponentType (int ComponentTypeId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getComponentTypeKey.setInt(1, ComponentTypeId);
            ResultSet result = getComponentTypeKey.executeQuery();
            ComponentType x = new ComponentType ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in ComponentType tables with key " + 
                    ComponentTypeId);

            assignComponentType(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for ComponentType table (key " + 
                    ComponentTypeId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public ComponentType getComponentType (String IDL) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getComponentTypeAlt.setString(1, IDL);

            ResultSet result = getComponentTypeAlt.executeQuery();
            ComponentType x = new ComponentType ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in ComponentType tables with key " + 
                    IDL);

            assignComponentType(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for ComponentType table (key " + 
                    IDL + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public ComponentType[] getComponentTypeWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<ComponentType> list = new ArrayList<ComponentType> ();
	    	ComponentType item = null;
	    	String s = "SELECT * FROM ComponentType";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new ComponentType ();
	    		assignComponentType(item,result);
	    		list.add(item);
	    	}
	    	ComponentType[] tmp = new ComponentType [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addComponentType(ComponentType data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addComponentType.setString(1,data.getIDL());

            addComponentType.setString(2,data.getURN());

		    addComponentType.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			ComponentType addedRow = getComponentType (data.getIDL() );        
            return addedRow.getComponentTypeId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table ComponentType!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addComponentType(ComponentType data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			ComponentType x = getComponentType(data.getIDL() );
	    		return x.getComponentTypeId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addComponentType(data);

    }

    public void deleteComponentType (int ComponentTypeId) throws AcsJTmcdbSqlEx {
        try {
            deleteComponentTypeKey.setInt(1, ComponentTypeId);
			deleteComponentTypeKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteComponentType (String IDL) throws AcsJTmcdbSqlEx {
        try {

            deleteComponentTypeAlt.setString(1, IDL);

			deleteComponentTypeAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateComponentType(ComponentType data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        ComponentType x = null;

        x = getComponentType(data.getComponentTypeId());

        // You can't change the keys.
		if (x.getComponentTypeId() != data.getComponentTypeId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getIDL().equals(data.getIDL()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateComponentType.setInt(1,data.getComponentTypeId());

            updateComponentType.setString(2,data.getIDL());

            updateComponentType.setString(3,data.getURN());

      		updateComponentType.setInt(4, data.getComponentTypeId()); 
			updateComponentType.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // LRUType
    /////////////////////////////////////////

    public void assignLRUType(LRUType x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setLRUName(result.getString(1));

        x.setFullName(result.getString(2));

        x.setICD(result.getString(3));

	    x.setICDDate(new ArrayTime(result.getLong(4)));

        x.setDescription(result.getString(5));

        x.setNotes(result.getString(6));

        // if (result.wasNull())
        // 	x.setNotesNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public LRUType getLRUType (String LRUName) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getLRUTypeKey.setString(1, LRUName);

            ResultSet result = getLRUTypeKey.executeQuery();
            LRUType x = new LRUType ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in LRUType tables with key " + 
                    LRUName);
            assignLRUType(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for LRUType table (key " + 
                    LRUName + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public LRUType[] getLRUTypeWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<LRUType> list = new ArrayList<LRUType> ();
	    	LRUType item = null;
	    	String s = "SELECT * FROM LRUType";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new LRUType ();
	    		assignLRUType(item,result);
	    		list.add(item);
	    	}
	    	LRUType[] tmp = new LRUType [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addLRUType(LRUType data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    LRUType x = getLRUType(data.getLRUName());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addLRUType.setString(1,data.getLRUName());

            addLRUType.setString(2,data.getFullName());

            addLRUType.setString(3,data.getICD());

	        addLRUType.setLong(4,data.getICDDate().get());

            addLRUType.setString(5,data.getDescription());

            addLRUType.setString(6,data.getNotes());

			addLRUType.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addLRUType(LRUType data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				LRUType x = getLRUType(data.getLRUName());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addLRUType(data);

    }

    public void deleteLRUType (String LRUName) throws AcsJTmcdbSqlEx {
        try {

          	deleteLRUTypeKey.setString(1, LRUName);

			deleteLRUTypeKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateLRUType(LRUType data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        LRUType x = null;
        try {
            x = getLRUType(data.getLRUName());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (!x.getLRUName().equals(data.getLRUName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateLRUType.setString(1,data.getLRUName());

            updateLRUType.setString(2,data.getFullName());

            updateLRUType.setString(3,data.getICD());

	        updateLRUType.setLong(4,data.getICDDate().get());

            updateLRUType.setString(5,data.getDescription());

            updateLRUType.setString(6,data.getNotes());

          	updateLRUType.setString(6 + 1, data.getLRUName());

			updateLRUType.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // AssemblyType
    /////////////////////////////////////////

    public void assignAssemblyType(AssemblyType x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setAssemblyTypeName(result.getString(1));

        x.setBaseElementType(result.getString(2));

        x.setLRUName(result.getString(3));

        x.setFullName(result.getString(4));

        x.setDescription(result.getString(5));

        x.setNotes(result.getString(6));

        // if (result.wasNull())
        // 	x.setNotesNull();

        x.setComponentTypeId(result.getInt(7));

        // if (result.wasNull())
        // 	x.setComponentTypeIdNull();

        x.setData(result.getString(8));

        // if (result.wasNull())
        // 	x.setDataNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public AssemblyType getAssemblyType (String AssemblyTypeName) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getAssemblyTypeKey.setString(1, AssemblyTypeName);

            ResultSet result = getAssemblyTypeKey.executeQuery();
            AssemblyType x = new AssemblyType ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AssemblyType tables with key " + 
                    AssemblyTypeName);
            assignAssemblyType(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for AssemblyType table (key " + 
                    AssemblyTypeName + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public AssemblyType[] getAssemblyTypeWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<AssemblyType> list = new ArrayList<AssemblyType> ();
	    	AssemblyType item = null;
	    	String s = "SELECT * FROM AssemblyType";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new AssemblyType ();
	    		assignAssemblyType(item,result);
	    		list.add(item);
	    	}
	    	AssemblyType[] tmp = new AssemblyType [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAssemblyType(AssemblyType data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    AssemblyType x = getAssemblyType(data.getAssemblyTypeName());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addAssemblyType.setString(1,data.getAssemblyTypeName());

            addAssemblyType.setString(2,data.getBaseElementType());

            addAssemblyType.setString(3,data.getLRUName());

            addAssemblyType.setString(4,data.getFullName());

            addAssemblyType.setString(5,data.getDescription());

            addAssemblyType.setString(6,data.getNotes());

            addAssemblyType.setInt(7,data.getComponentTypeId());

            addAssemblyType.setString(8,data.getData());

			addAssemblyType.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addAssemblyType(AssemblyType data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				AssemblyType x = getAssemblyType(data.getAssemblyTypeName());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addAssemblyType(data);

    }

    public void deleteAssemblyType (String AssemblyTypeName) throws AcsJTmcdbSqlEx {
        try {

          	deleteAssemblyTypeKey.setString(1, AssemblyTypeName);

			deleteAssemblyTypeKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAssemblyType(AssemblyType data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        AssemblyType x = null;
        try {
            x = getAssemblyType(data.getAssemblyTypeName());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (!x.getAssemblyTypeName().equals(data.getAssemblyTypeName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAssemblyType.setString(1,data.getAssemblyTypeName());

            updateAssemblyType.setString(2,data.getBaseElementType());

            updateAssemblyType.setString(3,data.getLRUName());

            updateAssemblyType.setString(4,data.getFullName());

            updateAssemblyType.setString(5,data.getDescription());

            updateAssemblyType.setString(6,data.getNotes());

            updateAssemblyType.setInt(7,data.getComponentTypeId());

            updateAssemblyType.setString(8,data.getData());

          	updateAssemblyType.setString(8 + 1, data.getAssemblyTypeName());

			updateAssemblyType.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // Schemas
    /////////////////////////////////////////

    public void assignSchemas(Schemas x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setSchemaId(result.getInt(1));

        x.setURN(result.getString(2));

        x.setConfigurationId(result.getInt(3));

        x.setSchema(result.getString(4));

        // if (result.wasNull())
        // 	x.setSchemaNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public Schemas getSchemas (int SchemaId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getSchemasKey.setInt(1, SchemaId);
            ResultSet result = getSchemasKey.executeQuery();
            Schemas x = new Schemas ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Schemas tables with key " + 
                    SchemaId);

            assignSchemas(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Schemas table (key " + 
                    SchemaId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public Schemas getSchemas (String URN, int ConfigurationId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getSchemasAlt.setString(1, URN);

            getSchemasAlt.setInt(2, ConfigurationId);

            ResultSet result = getSchemasAlt.executeQuery();
            Schemas x = new Schemas ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Schemas tables with key " + 
                    URN + ", " + ConfigurationId);

            assignSchemas(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Schemas table (key " + 
                    URN + ", " + ConfigurationId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public Schemas[] getSchemasWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<Schemas> list = new ArrayList<Schemas> ();
	    	Schemas item = null;
	    	String s = "SELECT * FROM Schemas";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new Schemas ();
	    		assignSchemas(item,result);
	    		list.add(item);
	    	}
	    	Schemas[] tmp = new Schemas [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addSchemas(Schemas data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addSchemas.setString(1,data.getURN());

            addSchemas.setInt(2,data.getConfigurationId());

            addSchemas.setString(3,data.getSchema());

		    addSchemas.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			Schemas addedRow = getSchemas (data.getURN(), data.getConfigurationId() );        
            return addedRow.getSchemaId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table Schemas!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addSchemas(Schemas data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			Schemas x = getSchemas(data.getURN(), data.getConfigurationId() );
	    		return x.getSchemaId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addSchemas(data);

    }

    public void deleteSchemas (int SchemaId) throws AcsJTmcdbSqlEx {
        try {
            deleteSchemasKey.setInt(1, SchemaId);
			deleteSchemasKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteSchemas (String URN, int ConfigurationId) throws AcsJTmcdbSqlEx {
        try {

            deleteSchemasAlt.setString(1, URN);

            deleteSchemasAlt.setInt(2, ConfigurationId);

			deleteSchemasAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateSchemas(Schemas data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        Schemas x = null;

        x = getSchemas(data.getSchemaId());

        // You can't change the keys.
		if (x.getSchemaId() != data.getSchemaId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getURN().equals(data.getURN()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateSchemas.setInt(1,data.getSchemaId());

            updateSchemas.setString(2,data.getURN());

            updateSchemas.setInt(3,data.getConfigurationId());

            updateSchemas.setString(4,data.getSchema());

      		updateSchemas.setInt(5, data.getSchemaId()); 
			updateSchemas.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // DefaultComponent
    /////////////////////////////////////////

    public void assignDefaultComponent(DefaultComponent x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setDefaultComponentId(result.getInt(1));

        x.setComponentTypeId(result.getInt(2));

        x.setAssemblyTypeName(result.getString(3));

        x.setImplLang(result.getString(4));

	    x.setRealTime(result.getBoolean(5));

        x.setCode(result.getString(6));

        x.setPath(result.getString(7));

	    x.setIsAutostart(result.getBoolean(8));

	    x.setIsDefault(result.getBoolean(9));

	    x.setIsStandaloneDefined(result.getBoolean(10));

        // if (result.wasNull())
        // 	x.setIsStandaloneDefinedNull();

        x.setKeepAliveTime(result.getInt(11));

        x.setMinLogLevel(result.getInt(12));

        x.setMinLogLevelLocal(result.getInt(13));

        x.setXMLDoc(result.getString(14));

        // if (result.wasNull())
        // 	x.setXMLDocNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public DefaultComponent getDefaultComponent (int DefaultComponentId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getDefaultComponentKey.setInt(1, DefaultComponentId);

            ResultSet result = getDefaultComponentKey.executeQuery();
            DefaultComponent x = new DefaultComponent ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in DefaultComponent tables with key " + 
                    DefaultComponentId);
            assignDefaultComponent(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for DefaultComponent table (key " + 
                    DefaultComponentId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public DefaultComponent[] getDefaultComponentWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<DefaultComponent> list = new ArrayList<DefaultComponent> ();
	    	DefaultComponent item = null;
	    	String s = "SELECT * FROM DefaultComponent";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new DefaultComponent ();
	    		assignDefaultComponent(item,result);
	    		list.add(item);
	    	}
	    	DefaultComponent[] tmp = new DefaultComponent [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addDefaultComponent(DefaultComponent data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    DefaultComponent x = getDefaultComponent(data.getDefaultComponentId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addDefaultComponent.setInt(1,data.getDefaultComponentId());

            addDefaultComponent.setInt(2,data.getComponentTypeId());

            addDefaultComponent.setString(3,data.getAssemblyTypeName());

            addDefaultComponent.setString(4,data.getImplLang());

	        addDefaultComponent.setBoolean(5,data.getRealTime());

            addDefaultComponent.setString(6,data.getCode());

            addDefaultComponent.setString(7,data.getPath());

	        addDefaultComponent.setBoolean(8,data.getIsAutostart());

	        addDefaultComponent.setBoolean(9,data.getIsDefault());

	        addDefaultComponent.setBoolean(10,data.getIsStandaloneDefined());

            addDefaultComponent.setInt(11,data.getKeepAliveTime());

            addDefaultComponent.setInt(12,data.getMinLogLevel());

            addDefaultComponent.setInt(13,data.getMinLogLevelLocal());

            addDefaultComponent.setString(14,data.getXMLDoc());

			addDefaultComponent.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addDefaultComponent(DefaultComponent data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				DefaultComponent x = getDefaultComponent(data.getDefaultComponentId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addDefaultComponent(data);

    }

    public void deleteDefaultComponent (int DefaultComponentId) throws AcsJTmcdbSqlEx {
        try {

          	deleteDefaultComponentKey.setInt(1, DefaultComponentId);

			deleteDefaultComponentKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateDefaultComponent(DefaultComponent data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        DefaultComponent x = null;
        try {
            x = getDefaultComponent(data.getDefaultComponentId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getDefaultComponentId() != data.getDefaultComponentId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateDefaultComponent.setInt(1,data.getDefaultComponentId());

            updateDefaultComponent.setInt(2,data.getComponentTypeId());

            updateDefaultComponent.setString(3,data.getAssemblyTypeName());

            updateDefaultComponent.setString(4,data.getImplLang());

	        updateDefaultComponent.setBoolean(5,data.getRealTime());

            updateDefaultComponent.setString(6,data.getCode());

            updateDefaultComponent.setString(7,data.getPath());

	        updateDefaultComponent.setBoolean(8,data.getIsAutostart());

	        updateDefaultComponent.setBoolean(9,data.getIsDefault());

	        updateDefaultComponent.setBoolean(10,data.getIsStandaloneDefined());

            updateDefaultComponent.setInt(11,data.getKeepAliveTime());

            updateDefaultComponent.setInt(12,data.getMinLogLevel());

            updateDefaultComponent.setInt(13,data.getMinLogLevelLocal());

            updateDefaultComponent.setString(14,data.getXMLDoc());

          	updateDefaultComponent.setInt(14 + 1, data.getDefaultComponentId());

			updateDefaultComponent.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // DefaultBaciProperty
    /////////////////////////////////////////

    public void assignDefaultBaciProperty(DefaultBaciProperty x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setDefaultBaciPropId(result.getInt(1));

        x.setDefaultComponentId(result.getInt(2));

        x.setPropertyName(result.getString(3));

        x.setdescription(result.getString(4));

        x.setformat(result.getString(5));

        x.setunits(result.getString(6));

        x.setresolution(result.getString(7));

        x.setarchive_priority(result.getInt(8));

        x.setarchive_min_int(result.getDouble(9));

        x.setarchive_max_int(result.getDouble(10));

        x.setdefault_timer_trig(result.getDouble(11));

        x.setmin_timer_trig(result.getDouble(12));

	    x.setinitialize_devio(result.getBoolean(13));

        x.setmin_delta_trig(result.getDouble(14));

        // if (result.wasNull())
        // 	x.setmin_delta_trigNull();

        x.setdefault_value(result.getString(15));

        x.setgraph_min(result.getDouble(16));

        // if (result.wasNull())
        // 	x.setgraph_minNull();

        x.setgraph_max(result.getDouble(17));

        // if (result.wasNull())
        // 	x.setgraph_maxNull();

        x.setmin_step(result.getDouble(18));

        // if (result.wasNull())
        // 	x.setmin_stepNull();

        x.setarchive_delta(result.getDouble(19));

        x.setalarm_high_on(result.getDouble(20));

        // if (result.wasNull())
        // 	x.setalarm_high_onNull();

        x.setalarm_low_on(result.getDouble(21));

        // if (result.wasNull())
        // 	x.setalarm_low_onNull();

        x.setalarm_high_off(result.getDouble(22));

        // if (result.wasNull())
        // 	x.setalarm_high_offNull();

        x.setalarm_low_off(result.getDouble(23));

        // if (result.wasNull())
        // 	x.setalarm_low_offNull();

        x.setalarm_timer_trig(result.getDouble(24));

        // if (result.wasNull())
        // 	x.setalarm_timer_trigNull();

        x.setmin_value(result.getDouble(25));

        // if (result.wasNull())
        // 	x.setmin_valueNull();

        x.setmax_value(result.getDouble(26));

        // if (result.wasNull())
        // 	x.setmax_valueNull();

        x.setbitDescription(result.getString(27));

        // if (result.wasNull())
        // 	x.setbitDescriptionNull();

        x.setwhenSet(result.getString(28));

        // if (result.wasNull())
        // 	x.setwhenSetNull();

        x.setwhenCleared(result.getString(29));

        // if (result.wasNull())
        // 	x.setwhenClearedNull();

        x.setstatesDescription(result.getString(30));

        // if (result.wasNull())
        // 	x.setstatesDescriptionNull();

        x.setcondition(result.getString(31));

        // if (result.wasNull())
        // 	x.setconditionNull();

        x.setalarm_on(result.getString(32));

        // if (result.wasNull())
        // 	x.setalarm_onNull();

        x.setalarm_off(result.getString(33));

        // if (result.wasNull())
        // 	x.setalarm_offNull();

        x.setData(result.getString(34));

        // if (result.wasNull())
        // 	x.setDataNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public DefaultBaciProperty getDefaultBaciProperty (int DefaultBaciPropId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getDefaultBaciPropertyKey.setInt(1, DefaultBaciPropId);

            ResultSet result = getDefaultBaciPropertyKey.executeQuery();
            DefaultBaciProperty x = new DefaultBaciProperty ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in DefaultBaciProperty tables with key " + 
                    DefaultBaciPropId);
            assignDefaultBaciProperty(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for DefaultBaciProperty table (key " + 
                    DefaultBaciPropId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public DefaultBaciProperty[] getDefaultBaciPropertyWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<DefaultBaciProperty> list = new ArrayList<DefaultBaciProperty> ();
	    	DefaultBaciProperty item = null;
	    	String s = "SELECT * FROM DefaultBaciProperty";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new DefaultBaciProperty ();
	    		assignDefaultBaciProperty(item,result);
	    		list.add(item);
	    	}
	    	DefaultBaciProperty[] tmp = new DefaultBaciProperty [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addDefaultBaciProperty(DefaultBaciProperty data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    DefaultBaciProperty x = getDefaultBaciProperty(data.getDefaultBaciPropId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addDefaultBaciProperty.setInt(1,data.getDefaultBaciPropId());

            addDefaultBaciProperty.setInt(2,data.getDefaultComponentId());

            addDefaultBaciProperty.setString(3,data.getPropertyName());

            addDefaultBaciProperty.setString(4,data.getdescription());

            addDefaultBaciProperty.setString(5,data.getformat());

            addDefaultBaciProperty.setString(6,data.getunits());

            addDefaultBaciProperty.setString(7,data.getresolution());

            addDefaultBaciProperty.setInt(8,data.getarchive_priority());

            addDefaultBaciProperty.setDouble(9,data.getarchive_min_int());

            addDefaultBaciProperty.setDouble(10,data.getarchive_max_int());

            addDefaultBaciProperty.setDouble(11,data.getdefault_timer_trig());

            addDefaultBaciProperty.setDouble(12,data.getmin_timer_trig());

	        addDefaultBaciProperty.setBoolean(13,data.getinitialize_devio());

            addDefaultBaciProperty.setDouble(14,data.getmin_delta_trig());

            addDefaultBaciProperty.setString(15,data.getdefault_value());

            addDefaultBaciProperty.setDouble(16,data.getgraph_min());

            addDefaultBaciProperty.setDouble(17,data.getgraph_max());

            addDefaultBaciProperty.setDouble(18,data.getmin_step());

            addDefaultBaciProperty.setDouble(19,data.getarchive_delta());

            addDefaultBaciProperty.setDouble(20,data.getalarm_high_on());

            addDefaultBaciProperty.setDouble(21,data.getalarm_low_on());

            addDefaultBaciProperty.setDouble(22,data.getalarm_high_off());

            addDefaultBaciProperty.setDouble(23,data.getalarm_low_off());

            addDefaultBaciProperty.setDouble(24,data.getalarm_timer_trig());

            addDefaultBaciProperty.setDouble(25,data.getmin_value());

            addDefaultBaciProperty.setDouble(26,data.getmax_value());

            addDefaultBaciProperty.setString(27,data.getbitDescription());

            addDefaultBaciProperty.setString(28,data.getwhenSet());

            addDefaultBaciProperty.setString(29,data.getwhenCleared());

            addDefaultBaciProperty.setString(30,data.getstatesDescription());

            addDefaultBaciProperty.setString(31,data.getcondition());

            addDefaultBaciProperty.setString(32,data.getalarm_on());

            addDefaultBaciProperty.setString(33,data.getalarm_off());

            addDefaultBaciProperty.setString(34,data.getData());

			addDefaultBaciProperty.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addDefaultBaciProperty(DefaultBaciProperty data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				DefaultBaciProperty x = getDefaultBaciProperty(data.getDefaultBaciPropId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addDefaultBaciProperty(data);

    }

    public void deleteDefaultBaciProperty (int DefaultBaciPropId) throws AcsJTmcdbSqlEx {
        try {

          	deleteDefaultBaciPropertyKey.setInt(1, DefaultBaciPropId);

			deleteDefaultBaciPropertyKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateDefaultBaciProperty(DefaultBaciProperty data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        DefaultBaciProperty x = null;
        try {
            x = getDefaultBaciProperty(data.getDefaultBaciPropId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getDefaultBaciPropId() != data.getDefaultBaciPropId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateDefaultBaciProperty.setInt(1,data.getDefaultBaciPropId());

            updateDefaultBaciProperty.setInt(2,data.getDefaultComponentId());

            updateDefaultBaciProperty.setString(3,data.getPropertyName());

            updateDefaultBaciProperty.setString(4,data.getdescription());

            updateDefaultBaciProperty.setString(5,data.getformat());

            updateDefaultBaciProperty.setString(6,data.getunits());

            updateDefaultBaciProperty.setString(7,data.getresolution());

            updateDefaultBaciProperty.setInt(8,data.getarchive_priority());

            updateDefaultBaciProperty.setDouble(9,data.getarchive_min_int());

            updateDefaultBaciProperty.setDouble(10,data.getarchive_max_int());

            updateDefaultBaciProperty.setDouble(11,data.getdefault_timer_trig());

            updateDefaultBaciProperty.setDouble(12,data.getmin_timer_trig());

	        updateDefaultBaciProperty.setBoolean(13,data.getinitialize_devio());

            updateDefaultBaciProperty.setDouble(14,data.getmin_delta_trig());

            updateDefaultBaciProperty.setString(15,data.getdefault_value());

            updateDefaultBaciProperty.setDouble(16,data.getgraph_min());

            updateDefaultBaciProperty.setDouble(17,data.getgraph_max());

            updateDefaultBaciProperty.setDouble(18,data.getmin_step());

            updateDefaultBaciProperty.setDouble(19,data.getarchive_delta());

            updateDefaultBaciProperty.setDouble(20,data.getalarm_high_on());

            updateDefaultBaciProperty.setDouble(21,data.getalarm_low_on());

            updateDefaultBaciProperty.setDouble(22,data.getalarm_high_off());

            updateDefaultBaciProperty.setDouble(23,data.getalarm_low_off());

            updateDefaultBaciProperty.setDouble(24,data.getalarm_timer_trig());

            updateDefaultBaciProperty.setDouble(25,data.getmin_value());

            updateDefaultBaciProperty.setDouble(26,data.getmax_value());

            updateDefaultBaciProperty.setString(27,data.getbitDescription());

            updateDefaultBaciProperty.setString(28,data.getwhenSet());

            updateDefaultBaciProperty.setString(29,data.getwhenCleared());

            updateDefaultBaciProperty.setString(30,data.getstatesDescription());

            updateDefaultBaciProperty.setString(31,data.getcondition());

            updateDefaultBaciProperty.setString(32,data.getalarm_on());

            updateDefaultBaciProperty.setString(33,data.getalarm_off());

            updateDefaultBaciProperty.setString(34,data.getData());

          	updateDefaultBaciProperty.setInt(34 + 1, data.getDefaultBaciPropId());

			updateDefaultBaciProperty.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // DefaultMonitorPoint
    /////////////////////////////////////////

    public void assignDefaultMonitorPoint(DefaultMonitorPoint x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setDefaultMonitorPointId(result.getInt(1));

        x.setDefaultBACIPropertyId(result.getInt(2));

        x.setMonitorPointName(result.getString(3));

        x.setIndice(result.getInt(4));

        x.setDataType(result.getString(5));

        x.setRCA(result.getString(6));

	    x.setTeRelated(result.getBoolean(7));

        x.setRawDataType(result.getString(8));

        x.setWorldDataType(result.getString(9));

        x.setUnits(result.getString(10));

        // if (result.wasNull())
        // 	x.setUnitsNull();

        x.setScale(result.getDouble(11));

        // if (result.wasNull())
        // 	x.setScaleNull();

	    x.setOffset(new Length(result.getDouble(12)));

        // if (result.wasNull())
        // 	x.setOffsetNull();

        x.setMinRange(result.getString(13));

        // if (result.wasNull())
        // 	x.setMinRangeNull();

        x.setMaxRange(result.getString(14));

        // if (result.wasNull())
        // 	x.setMaxRangeNull();

        x.setDescription(result.getString(15));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public DefaultMonitorPoint getDefaultMonitorPoint (int DefaultMonitorPointId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getDefaultMonitorPointKey.setInt(1, DefaultMonitorPointId);

            ResultSet result = getDefaultMonitorPointKey.executeQuery();
            DefaultMonitorPoint x = new DefaultMonitorPoint ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in DefaultMonitorPoint tables with key " + 
                    DefaultMonitorPointId);
            assignDefaultMonitorPoint(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for DefaultMonitorPoint table (key " + 
                    DefaultMonitorPointId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public DefaultMonitorPoint[] getDefaultMonitorPointWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<DefaultMonitorPoint> list = new ArrayList<DefaultMonitorPoint> ();
	    	DefaultMonitorPoint item = null;
	    	String s = "SELECT * FROM DefaultMonitorPoint";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new DefaultMonitorPoint ();
	    		assignDefaultMonitorPoint(item,result);
	    		list.add(item);
	    	}
	    	DefaultMonitorPoint[] tmp = new DefaultMonitorPoint [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addDefaultMonitorPoint(DefaultMonitorPoint data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    DefaultMonitorPoint x = getDefaultMonitorPoint(data.getDefaultMonitorPointId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addDefaultMonitorPoint.setInt(1,data.getDefaultMonitorPointId());

            addDefaultMonitorPoint.setInt(2,data.getDefaultBACIPropertyId());

            addDefaultMonitorPoint.setString(3,data.getMonitorPointName());

            addDefaultMonitorPoint.setInt(4,data.getIndice());

            addDefaultMonitorPoint.setString(5,data.getDataType());

            addDefaultMonitorPoint.setString(6,data.getRCA());

	        addDefaultMonitorPoint.setBoolean(7,data.getTeRelated());

            addDefaultMonitorPoint.setString(8,data.getRawDataType());

            addDefaultMonitorPoint.setString(9,data.getWorldDataType());

            addDefaultMonitorPoint.setString(10,data.getUnits());

            addDefaultMonitorPoint.setDouble(11,data.getScale());

	        addDefaultMonitorPoint.setDouble(12,data.getOffset().get());

            addDefaultMonitorPoint.setString(13,data.getMinRange());

            addDefaultMonitorPoint.setString(14,data.getMaxRange());

            addDefaultMonitorPoint.setString(15,data.getDescription());

			addDefaultMonitorPoint.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addDefaultMonitorPoint(DefaultMonitorPoint data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				DefaultMonitorPoint x = getDefaultMonitorPoint(data.getDefaultMonitorPointId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addDefaultMonitorPoint(data);

    }

    public void deleteDefaultMonitorPoint (int DefaultMonitorPointId) throws AcsJTmcdbSqlEx {
        try {

          	deleteDefaultMonitorPointKey.setInt(1, DefaultMonitorPointId);

			deleteDefaultMonitorPointKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateDefaultMonitorPoint(DefaultMonitorPoint data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        DefaultMonitorPoint x = null;
        try {
            x = getDefaultMonitorPoint(data.getDefaultMonitorPointId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getDefaultMonitorPointId() != data.getDefaultMonitorPointId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateDefaultMonitorPoint.setInt(1,data.getDefaultMonitorPointId());

            updateDefaultMonitorPoint.setInt(2,data.getDefaultBACIPropertyId());

            updateDefaultMonitorPoint.setString(3,data.getMonitorPointName());

            updateDefaultMonitorPoint.setInt(4,data.getIndice());

            updateDefaultMonitorPoint.setString(5,data.getDataType());

            updateDefaultMonitorPoint.setString(6,data.getRCA());

	        updateDefaultMonitorPoint.setBoolean(7,data.getTeRelated());

            updateDefaultMonitorPoint.setString(8,data.getRawDataType());

            updateDefaultMonitorPoint.setString(9,data.getWorldDataType());

            updateDefaultMonitorPoint.setString(10,data.getUnits());

            updateDefaultMonitorPoint.setDouble(11,data.getScale());

	        updateDefaultMonitorPoint.setDouble(12,data.getOffset().get());

            updateDefaultMonitorPoint.setString(13,data.getMinRange());

            updateDefaultMonitorPoint.setString(14,data.getMaxRange());

            updateDefaultMonitorPoint.setString(15,data.getDescription());

          	updateDefaultMonitorPoint.setInt(15 + 1, data.getDefaultMonitorPointId());

			updateDefaultMonitorPoint.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // Configuration
    /////////////////////////////////////////

    public void assignConfiguration(Configuration x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setConfigurationId(result.getInt(1));

        x.setConfigurationName(result.getString(2));

        x.setFullName(result.getString(3));

	    x.setActive(result.getBoolean(4));

        x.setCreationTime(result.getString(5));

        x.setDescription(result.getString(6));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public Configuration getConfiguration (int ConfigurationId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getConfigurationKey.setInt(1, ConfigurationId);
            ResultSet result = getConfigurationKey.executeQuery();
            Configuration x = new Configuration ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Configuration tables with key " + 
                    ConfigurationId);

            assignConfiguration(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Configuration table (key " + 
                    ConfigurationId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public Configuration getConfiguration (String ConfigurationName) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getConfigurationAlt.setString(1, ConfigurationName);

            ResultSet result = getConfigurationAlt.executeQuery();
            Configuration x = new Configuration ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Configuration tables with key " + 
                    ConfigurationName);

            assignConfiguration(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Configuration table (key " + 
                    ConfigurationName + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public Configuration[] getConfigurationWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<Configuration> list = new ArrayList<Configuration> ();
	    	Configuration item = null;
	    	String s = "SELECT * FROM Configuration";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new Configuration ();
	    		assignConfiguration(item,result);
	    		list.add(item);
	    	}
	    	Configuration[] tmp = new Configuration [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addConfiguration(Configuration data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addConfiguration.setString(1,data.getConfigurationName());

            addConfiguration.setString(2,data.getFullName());

	        addConfiguration.setBoolean(3,data.getActive());

            addConfiguration.setString(4,data.getCreationTime());

            addConfiguration.setString(5,data.getDescription());

		    addConfiguration.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			Configuration addedRow = getConfiguration (data.getConfigurationName() );        
            return addedRow.getConfigurationId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table Configuration!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addConfiguration(Configuration data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			Configuration x = getConfiguration(data.getConfigurationName() );
	    		return x.getConfigurationId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addConfiguration(data);

    }

    public void deleteConfiguration (int ConfigurationId) throws AcsJTmcdbSqlEx {
        try {
            deleteConfigurationKey.setInt(1, ConfigurationId);
			deleteConfigurationKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteConfiguration (String ConfigurationName) throws AcsJTmcdbSqlEx {
        try {

            deleteConfigurationAlt.setString(1, ConfigurationName);

			deleteConfigurationAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateConfiguration(Configuration data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        Configuration x = null;

        x = getConfiguration(data.getConfigurationId());

        // You can't change the keys.
		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getConfigurationName().equals(data.getConfigurationName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateConfiguration.setInt(1,data.getConfigurationId());

            updateConfiguration.setString(2,data.getConfigurationName());

            updateConfiguration.setString(3,data.getFullName());

	        updateConfiguration.setBoolean(4,data.getActive());

            updateConfiguration.setString(5,data.getCreationTime());

            updateConfiguration.setString(6,data.getDescription());

      		updateConfiguration.setInt(7, data.getConfigurationId()); 
			updateConfiguration.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // Computer
    /////////////////////////////////////////

    public void assignComputer(Computer x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setComputerId(result.getInt(1));

        x.setComputerName(result.getString(2));

        x.setConfigurationId(result.getInt(3));

        x.setHostName(result.getString(4));

	    x.setRealTime(result.getBoolean(5));

        x.setProcessorType(result.getString(6));

        x.setPhysicalLocation(result.getString(7));

        // if (result.wasNull())
        // 	x.setPhysicalLocationNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public Computer getComputer (int ComputerId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getComputerKey.setInt(1, ComputerId);
            ResultSet result = getComputerKey.executeQuery();
            Computer x = new Computer ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Computer tables with key " + 
                    ComputerId);

            assignComputer(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Computer table (key " + 
                    ComputerId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public Computer getComputer (String ComputerName, int ConfigurationId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getComputerAlt.setString(1, ComputerName);

            getComputerAlt.setInt(2, ConfigurationId);

            ResultSet result = getComputerAlt.executeQuery();
            Computer x = new Computer ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Computer tables with key " + 
                    ComputerName + ", " + ConfigurationId);

            assignComputer(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Computer table (key " + 
                    ComputerName + ", " + ConfigurationId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public Computer[] getComputerWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<Computer> list = new ArrayList<Computer> ();
	    	Computer item = null;
	    	String s = "SELECT * FROM Computer";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new Computer ();
	    		assignComputer(item,result);
	    		list.add(item);
	    	}
	    	Computer[] tmp = new Computer [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addComputer(Computer data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addComputer.setString(1,data.getComputerName());

            addComputer.setInt(2,data.getConfigurationId());

            addComputer.setString(3,data.getHostName());

	        addComputer.setBoolean(4,data.getRealTime());

            addComputer.setString(5,data.getProcessorType());

            addComputer.setString(6,data.getPhysicalLocation());

		    addComputer.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			Computer addedRow = getComputer (data.getComputerName(), data.getConfigurationId() );        
            return addedRow.getComputerId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table Computer!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addComputer(Computer data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			Computer x = getComputer(data.getComputerName(), data.getConfigurationId() );
	    		return x.getComputerId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addComputer(data);

    }

    public void deleteComputer (int ComputerId) throws AcsJTmcdbSqlEx {
        try {
            deleteComputerKey.setInt(1, ComputerId);
			deleteComputerKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteComputer (String ComputerName, int ConfigurationId) throws AcsJTmcdbSqlEx {
        try {

            deleteComputerAlt.setString(1, ComputerName);

            deleteComputerAlt.setInt(2, ConfigurationId);

			deleteComputerAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateComputer(Computer data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        Computer x = null;

        x = getComputer(data.getComputerId());

        // You can't change the keys.
		if (x.getComputerId() != data.getComputerId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getComputerName().equals(data.getComputerName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateComputer.setInt(1,data.getComputerId());

            updateComputer.setString(2,data.getComputerName());

            updateComputer.setInt(3,data.getConfigurationId());

            updateComputer.setString(4,data.getHostName());

	        updateComputer.setBoolean(5,data.getRealTime());

            updateComputer.setString(6,data.getProcessorType());

            updateComputer.setString(7,data.getPhysicalLocation());

      		updateComputer.setInt(8, data.getComputerId()); 
			updateComputer.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // LoggingConfig
    /////////////////////////////////////////

    public void assignLoggingConfig(LoggingConfig x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setLoggingConfigId(result.getInt(1));

        x.setConfigurationId(result.getInt(2));

        x.setMinLogLevelDefault(result.getInt(3));

        x.setMinLogLevelLocalDefault(result.getInt(4));

        x.setCentralizedLogger(result.getString(5));

        x.setDispatchPacketSize(result.getInt(6));

        x.setImmediateDispatchLevel(result.getInt(7));

        x.setFlushPeriodSeconds(result.getInt(8));

        x.setMaxLogQueueSize(result.getInt(9));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public LoggingConfig getLoggingConfig (int LoggingConfigId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getLoggingConfigKey.setInt(1, LoggingConfigId);
            ResultSet result = getLoggingConfigKey.executeQuery();
            LoggingConfig x = new LoggingConfig ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in LoggingConfig tables with this key.");

            assignLoggingConfig(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for LoggingConfig table");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public LoggingConfig[] getLoggingConfigWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<LoggingConfig> list = new ArrayList<LoggingConfig> ();
	    	LoggingConfig item = null;
	    	String s = "SELECT * FROM LoggingConfig";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new LoggingConfig ();
	    		assignLoggingConfig(item,result);
	    		list.add(item);
	    	}
	    	LoggingConfig[] tmp = new LoggingConfig [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addLoggingConfig(LoggingConfig data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addLoggingConfig.setInt(1,data.getConfigurationId());

            addLoggingConfig.setInt(2,data.getMinLogLevelDefault());

            addLoggingConfig.setInt(3,data.getMinLogLevelLocalDefault());

            addLoggingConfig.setString(4,data.getCentralizedLogger());

            addLoggingConfig.setInt(5,data.getDispatchPacketSize());

            addLoggingConfig.setInt(6,data.getImmediateDispatchLevel());

            addLoggingConfig.setInt(7,data.getFlushPeriodSeconds());

            addLoggingConfig.setInt(8,data.getMaxLogQueueSize());

			conn.setAutoCommit(false);
			addLoggingConfig.executeUpdate();	// INSERT doesn't return a result set
            // Get the maximum key id.
            ResultSet result = maxLoggingConfigKey.executeQuery();
            if (result.next() == true) {
            	int maxKey = result.getInt(1);
            	conn.commit();
            	conn.setAutoCommit(true);
            	result.close();
            	return maxKey;
            }
            throw new AcsJTmcdbNoSuchRowEx();			

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table LoggingConfig!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addLoggingConfig(LoggingConfig data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

    	return addLoggingConfig(data);

    }

    public void deleteLoggingConfig (int LoggingConfigId) throws AcsJTmcdbSqlEx {
        try {
            deleteLoggingConfigKey.setInt(1, LoggingConfigId);
			deleteLoggingConfigKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateLoggingConfig(LoggingConfig data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        LoggingConfig x = null;

        x = getLoggingConfig(data.getLoggingConfigId());

        // You can't change the keys.
		if (x.getLoggingConfigId() != data.getLoggingConfigId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateLoggingConfig.setInt(1,data.getLoggingConfigId());

            updateLoggingConfig.setInt(2,data.getConfigurationId());

            updateLoggingConfig.setInt(3,data.getMinLogLevelDefault());

            updateLoggingConfig.setInt(4,data.getMinLogLevelLocalDefault());

            updateLoggingConfig.setString(5,data.getCentralizedLogger());

            updateLoggingConfig.setInt(6,data.getDispatchPacketSize());

            updateLoggingConfig.setInt(7,data.getImmediateDispatchLevel());

            updateLoggingConfig.setInt(8,data.getFlushPeriodSeconds());

            updateLoggingConfig.setInt(9,data.getMaxLogQueueSize());

      		updateLoggingConfig.setInt(10, data.getLoggingConfigId()); 
			updateLoggingConfig.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // NamedLoggerConfig
    /////////////////////////////////////////

    public void assignNamedLoggerConfig(NamedLoggerConfig x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setNamedLoggerConfigId(result.getInt(1));

        x.setLoggingConfigId(result.getInt(2));

        x.setName(result.getString(3));

        x.setMinLogLevel(result.getInt(4));

        x.setMinLogLevelLocal(result.getInt(5));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public NamedLoggerConfig getNamedLoggerConfig (int NamedLoggerConfigId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getNamedLoggerConfigKey.setInt(1, NamedLoggerConfigId);
            ResultSet result = getNamedLoggerConfigKey.executeQuery();
            NamedLoggerConfig x = new NamedLoggerConfig ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in NamedLoggerConfig tables with key " + 
                    NamedLoggerConfigId);

            assignNamedLoggerConfig(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for NamedLoggerConfig table (key " + 
                    NamedLoggerConfigId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public NamedLoggerConfig getNamedLoggerConfig (int LoggingConfigId, String Name) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getNamedLoggerConfigAlt.setInt(1, LoggingConfigId);

            getNamedLoggerConfigAlt.setString(2, Name);

            ResultSet result = getNamedLoggerConfigAlt.executeQuery();
            NamedLoggerConfig x = new NamedLoggerConfig ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in NamedLoggerConfig tables with key " + 
                    LoggingConfigId + ", " + Name);

            assignNamedLoggerConfig(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for NamedLoggerConfig table (key " + 
                    LoggingConfigId + ", " + Name + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public NamedLoggerConfig[] getNamedLoggerConfigWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<NamedLoggerConfig> list = new ArrayList<NamedLoggerConfig> ();
	    	NamedLoggerConfig item = null;
	    	String s = "SELECT * FROM NamedLoggerConfig";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new NamedLoggerConfig ();
	    		assignNamedLoggerConfig(item,result);
	    		list.add(item);
	    	}
	    	NamedLoggerConfig[] tmp = new NamedLoggerConfig [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addNamedLoggerConfig(NamedLoggerConfig data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addNamedLoggerConfig.setInt(1,data.getLoggingConfigId());

            addNamedLoggerConfig.setString(2,data.getName());

            addNamedLoggerConfig.setInt(3,data.getMinLogLevel());

            addNamedLoggerConfig.setInt(4,data.getMinLogLevelLocal());

		    addNamedLoggerConfig.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			NamedLoggerConfig addedRow = getNamedLoggerConfig (data.getLoggingConfigId(), data.getName() );        
            return addedRow.getNamedLoggerConfigId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table NamedLoggerConfig!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addNamedLoggerConfig(NamedLoggerConfig data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			NamedLoggerConfig x = getNamedLoggerConfig(data.getLoggingConfigId(), data.getName() );
	    		return x.getNamedLoggerConfigId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addNamedLoggerConfig(data);

    }

    public void deleteNamedLoggerConfig (int NamedLoggerConfigId) throws AcsJTmcdbSqlEx {
        try {
            deleteNamedLoggerConfigKey.setInt(1, NamedLoggerConfigId);
			deleteNamedLoggerConfigKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteNamedLoggerConfig (int LoggingConfigId, String Name) throws AcsJTmcdbSqlEx {
        try {

            deleteNamedLoggerConfigAlt.setInt(1, LoggingConfigId);

            deleteNamedLoggerConfigAlt.setString(2, Name);

			deleteNamedLoggerConfigAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateNamedLoggerConfig(NamedLoggerConfig data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        NamedLoggerConfig x = null;

        x = getNamedLoggerConfig(data.getNamedLoggerConfigId());

        // You can't change the keys.
		if (x.getNamedLoggerConfigId() != data.getNamedLoggerConfigId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getLoggingConfigId() != data.getLoggingConfigId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getName().equals(data.getName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateNamedLoggerConfig.setInt(1,data.getNamedLoggerConfigId());

            updateNamedLoggerConfig.setInt(2,data.getLoggingConfigId());

            updateNamedLoggerConfig.setString(3,data.getName());

            updateNamedLoggerConfig.setInt(4,data.getMinLogLevel());

            updateNamedLoggerConfig.setInt(5,data.getMinLogLevelLocal());

      		updateNamedLoggerConfig.setInt(6, data.getNamedLoggerConfigId()); 
			updateNamedLoggerConfig.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // Manager
    /////////////////////////////////////////

    public void assignManager(Manager x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setManagerId(result.getInt(1));

        x.setConfigurationId(result.getInt(2));

        x.setLoggingConfigId(result.getInt(3));

        x.setStartup(result.getString(4));

        // if (result.wasNull())
        // 	x.setStartupNull();

        x.setServiceComponents(result.getString(5));

        // if (result.wasNull())
        // 	x.setServiceComponentsNull();

        x.setTimeout(result.getInt(6));

        x.setClientPingInterval(result.getInt(7));

        x.setAdministratorPingInterval(result.getInt(8));

        x.setContainerPingInterval(result.getInt(9));

        x.setServerThreads(result.getInt(10));

        x.setDeadlockTimeout(result.getInt(11));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public Manager getManager (int ManagerId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getManagerKey.setInt(1, ManagerId);
            ResultSet result = getManagerKey.executeQuery();
            Manager x = new Manager ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Manager tables with key " + 
                    ManagerId);

            assignManager(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Manager table (key " + 
                    ManagerId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public Manager getManager (int ConfigurationId, int LoggingConfigId, String Startup, String ServiceComponents, int Timeout, int ClientPingInterval, int AdministratorPingInterval, int ContainerPingInterval, int ServerThreads, int DeadlockTimeout) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getManagerAlt.setInt(1, ConfigurationId);

            getManagerAlt.setInt(2, LoggingConfigId);

            getManagerAlt.setString(3, Startup);

            getManagerAlt.setString(4, ServiceComponents);

            getManagerAlt.setInt(5, Timeout);

            getManagerAlt.setInt(6, ClientPingInterval);

            getManagerAlt.setInt(7, AdministratorPingInterval);

            getManagerAlt.setInt(8, ContainerPingInterval);

            getManagerAlt.setInt(9, ServerThreads);

            getManagerAlt.setInt(10, DeadlockTimeout);

            ResultSet result = getManagerAlt.executeQuery();
            Manager x = new Manager ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Manager tables with key " + 
                    ConfigurationId + ", " + LoggingConfigId + ", " + Startup + ", " + ServiceComponents + ", " + Timeout + ", " + ClientPingInterval + ", " + AdministratorPingInterval + ", " + ContainerPingInterval + ", " + ServerThreads + ", " + DeadlockTimeout);

            assignManager(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Manager table (key " + 
                    ConfigurationId + ", " + LoggingConfigId + ", " + Startup + ", " + ServiceComponents + ", " + Timeout + ", " + ClientPingInterval + ", " + AdministratorPingInterval + ", " + ContainerPingInterval + ", " + ServerThreads + ", " + DeadlockTimeout + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public Manager[] getManagerWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<Manager> list = new ArrayList<Manager> ();
	    	Manager item = null;
	    	String s = "SELECT * FROM Manager";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new Manager ();
	    		assignManager(item,result);
	    		list.add(item);
	    	}
	    	Manager[] tmp = new Manager [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addManager(Manager data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addManager.setInt(1,data.getConfigurationId());

            addManager.setInt(2,data.getLoggingConfigId());

            addManager.setString(3,data.getStartup());

            addManager.setString(4,data.getServiceComponents());

            addManager.setInt(5,data.getTimeout());

            addManager.setInt(6,data.getClientPingInterval());

            addManager.setInt(7,data.getAdministratorPingInterval());

            addManager.setInt(8,data.getContainerPingInterval());

            addManager.setInt(9,data.getServerThreads());

            addManager.setInt(10,data.getDeadlockTimeout());

		    addManager.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			Manager addedRow = getManager (data.getConfigurationId(), data.getLoggingConfigId(), data.getStartup(), data.getServiceComponents(), data.getTimeout(), data.getClientPingInterval(), data.getAdministratorPingInterval(), data.getContainerPingInterval(), data.getServerThreads(), data.getDeadlockTimeout() );        
            return addedRow.getManagerId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table Manager!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addManager(Manager data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			Manager x = getManager(data.getConfigurationId(), data.getLoggingConfigId(), data.getStartup(), data.getServiceComponents(), data.getTimeout(), data.getClientPingInterval(), data.getAdministratorPingInterval(), data.getContainerPingInterval(), data.getServerThreads(), data.getDeadlockTimeout() );
	    		return x.getManagerId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addManager(data);

    }

    public void deleteManager (int ManagerId) throws AcsJTmcdbSqlEx {
        try {
            deleteManagerKey.setInt(1, ManagerId);
			deleteManagerKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteManager (int ConfigurationId, int LoggingConfigId, String Startup, String ServiceComponents, int Timeout, int ClientPingInterval, int AdministratorPingInterval, int ContainerPingInterval, int ServerThreads, int DeadlockTimeout) throws AcsJTmcdbSqlEx {
        try {

            deleteManagerAlt.setInt(1, ConfigurationId);

            deleteManagerAlt.setInt(2, LoggingConfigId);

            deleteManagerAlt.setString(3, Startup);

            deleteManagerAlt.setString(4, ServiceComponents);

            deleteManagerAlt.setInt(5, Timeout);

            deleteManagerAlt.setInt(6, ClientPingInterval);

            deleteManagerAlt.setInt(7, AdministratorPingInterval);

            deleteManagerAlt.setInt(8, ContainerPingInterval);

            deleteManagerAlt.setInt(9, ServerThreads);

            deleteManagerAlt.setInt(10, DeadlockTimeout);

			deleteManagerAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateManager(Manager data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        Manager x = null;

        x = getManager(data.getManagerId());

        // You can't change the keys.
		if (x.getManagerId() != data.getManagerId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getLoggingConfigId() != data.getLoggingConfigId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getStartup().equals(data.getStartup()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getServiceComponents().equals(data.getServiceComponents()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getTimeout() != data.getTimeout())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getClientPingInterval() != data.getClientPingInterval())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getAdministratorPingInterval() != data.getAdministratorPingInterval())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getContainerPingInterval() != data.getContainerPingInterval())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getServerThreads() != data.getServerThreads())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getDeadlockTimeout() != data.getDeadlockTimeout())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateManager.setInt(1,data.getManagerId());

            updateManager.setInt(2,data.getConfigurationId());

            updateManager.setInt(3,data.getLoggingConfigId());

            updateManager.setString(4,data.getStartup());

            updateManager.setString(5,data.getServiceComponents());

            updateManager.setInt(6,data.getTimeout());

            updateManager.setInt(7,data.getClientPingInterval());

            updateManager.setInt(8,data.getAdministratorPingInterval());

            updateManager.setInt(9,data.getContainerPingInterval());

            updateManager.setInt(10,data.getServerThreads());

            updateManager.setInt(11,data.getDeadlockTimeout());

      		updateManager.setInt(12, data.getManagerId()); 
			updateManager.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // Container
    /////////////////////////////////////////

    public void assignContainer(Container x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setContainerId(result.getInt(1));

        x.setContainerName(result.getString(2));

        x.setPath(result.getString(3));

        x.setConfigurationId(result.getInt(4));

        x.setLoggingConfigId(result.getInt(5));

        x.setComputerId(result.getInt(6));

        // if (result.wasNull())
        // 	x.setComputerIdNull();

        x.setImplLang(result.getString(7));

        x.setTypeModifiers(result.getString(8));

        // if (result.wasNull())
        // 	x.setTypeModifiersNull();

	    x.setRealTime(result.getBoolean(9));

        x.setRealTimeType(result.getString(10));

        x.setKernelModuleLocation(result.getString(11));

        // if (result.wasNull())
        // 	x.setKernelModuleLocationNull();

        x.setKernelModule(result.getString(12));

        // if (result.wasNull())
        // 	x.setKernelModuleNull();

        x.setAcsInstance(result.getInt(13));

        x.setCmdLineArgs(result.getString(14));

        // if (result.wasNull())
        // 	x.setCmdLineArgsNull();

        x.setKeepAliveTime(result.getInt(15));

        x.setServerThreads(result.getInt(16));

        x.setManagerRetry(result.getInt(17));

        x.setCallTimeout(result.getInt(18));

	    x.setRecovery(result.getBoolean(19));

        x.setAutoloadSharedLibs(result.getString(20));

        // if (result.wasNull())
        // 	x.setAutoloadSharedLibsNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public Container getContainer (int ContainerId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getContainerKey.setInt(1, ContainerId);
            ResultSet result = getContainerKey.executeQuery();
            Container x = new Container ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Container tables with key " + 
                    ContainerId);

            assignContainer(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Container table (key " + 
                    ContainerId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public Container getContainer (String ContainerName, String Path, int ConfigurationId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getContainerAlt.setString(1, ContainerName);

            getContainerAlt.setString(2, Path);

            getContainerAlt.setInt(3, ConfigurationId);

            ResultSet result = getContainerAlt.executeQuery();
            Container x = new Container ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Container tables with key " + 
                    ContainerName + ", " + Path + ", " + ConfigurationId);

            assignContainer(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Container table (key " + 
                    ContainerName + ", " + Path + ", " + ConfigurationId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public Container[] getContainerWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<Container> list = new ArrayList<Container> ();
	    	Container item = null;
	    	String s = "SELECT * FROM Container";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new Container ();
	    		assignContainer(item,result);
	    		list.add(item);
	    	}
	    	Container[] tmp = new Container [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addContainer(Container data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addContainer.setString(1,data.getContainerName());

            addContainer.setString(2,data.getPath());

            addContainer.setInt(3,data.getConfigurationId());

            addContainer.setInt(4,data.getLoggingConfigId());

            addContainer.setInt(5,data.getComputerId());

            addContainer.setString(6,data.getImplLang());

            addContainer.setString(7,data.getTypeModifiers());

	        addContainer.setBoolean(8,data.getRealTime());

            addContainer.setString(9,data.getRealTimeType());

            addContainer.setString(10,data.getKernelModuleLocation());

            addContainer.setString(11,data.getKernelModule());

            addContainer.setInt(12,data.getAcsInstance());

            addContainer.setString(13,data.getCmdLineArgs());

            addContainer.setInt(14,data.getKeepAliveTime());

            addContainer.setInt(15,data.getServerThreads());

            addContainer.setInt(16,data.getManagerRetry());

            addContainer.setInt(17,data.getCallTimeout());

	        addContainer.setBoolean(18,data.getRecovery());

            addContainer.setString(19,data.getAutoloadSharedLibs());

		    addContainer.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			Container addedRow = getContainer (data.getContainerName(), data.getPath(), data.getConfigurationId() );        
            return addedRow.getContainerId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table Container!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addContainer(Container data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			Container x = getContainer(data.getContainerName(), data.getPath(), data.getConfigurationId() );
	    		return x.getContainerId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addContainer(data);

    }

    public void deleteContainer (int ContainerId) throws AcsJTmcdbSqlEx {
        try {
            deleteContainerKey.setInt(1, ContainerId);
			deleteContainerKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteContainer (String ContainerName, String Path, int ConfigurationId) throws AcsJTmcdbSqlEx {
        try {

            deleteContainerAlt.setString(1, ContainerName);

            deleteContainerAlt.setString(2, Path);

            deleteContainerAlt.setInt(3, ConfigurationId);

			deleteContainerAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateContainer(Container data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        Container x = null;

        x = getContainer(data.getContainerId());

        // You can't change the keys.
		if (x.getContainerId() != data.getContainerId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getContainerName().equals(data.getContainerName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getPath().equals(data.getPath()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateContainer.setInt(1,data.getContainerId());

            updateContainer.setString(2,data.getContainerName());

            updateContainer.setString(3,data.getPath());

            updateContainer.setInt(4,data.getConfigurationId());

            updateContainer.setInt(5,data.getLoggingConfigId());

            updateContainer.setInt(6,data.getComputerId());

            updateContainer.setString(7,data.getImplLang());

            updateContainer.setString(8,data.getTypeModifiers());

	        updateContainer.setBoolean(9,data.getRealTime());

            updateContainer.setString(10,data.getRealTimeType());

            updateContainer.setString(11,data.getKernelModuleLocation());

            updateContainer.setString(12,data.getKernelModule());

            updateContainer.setInt(13,data.getAcsInstance());

            updateContainer.setString(14,data.getCmdLineArgs());

            updateContainer.setInt(15,data.getKeepAliveTime());

            updateContainer.setInt(16,data.getServerThreads());

            updateContainer.setInt(17,data.getManagerRetry());

            updateContainer.setInt(18,data.getCallTimeout());

	        updateContainer.setBoolean(19,data.getRecovery());

            updateContainer.setString(20,data.getAutoloadSharedLibs());

      		updateContainer.setInt(21, data.getContainerId()); 
			updateContainer.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // Component
    /////////////////////////////////////////

    public void assignComponent(Component x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setComponentId(result.getInt(1));

        x.setComponentTypeId(result.getInt(2));

        x.setComponentName(result.getString(3));

        x.setConfigurationId(result.getInt(4));

        x.setContainerId(result.getInt(5));

        x.setImplLang(result.getString(6));

	    x.setRealTime(result.getBoolean(7));

        x.setCode(result.getString(8));

        x.setPath(result.getString(9));

	    x.setIsAutostart(result.getBoolean(10));

	    x.setIsDefault(result.getBoolean(11));

	    x.setIsStandaloneDefined(result.getBoolean(12));

        // if (result.wasNull())
        // 	x.setIsStandaloneDefinedNull();

        x.setKeepAliveTime(result.getInt(13));

        x.setMinLogLevel(result.getInt(14));

        x.setMinLogLevelLocal(result.getInt(15));

        x.setXMLDoc(result.getString(16));

        // if (result.wasNull())
        // 	x.setXMLDocNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public Component getComponent (int ComponentId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getComponentKey.setInt(1, ComponentId);
            ResultSet result = getComponentKey.executeQuery();
            Component x = new Component ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Component tables with key " + 
                    ComponentId);

            assignComponent(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Component table (key " + 
                    ComponentId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public Component getComponent (String Path, String ComponentName, int ConfigurationId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getComponentAlt.setString(1, Path);

            getComponentAlt.setString(2, ComponentName);

            getComponentAlt.setInt(3, ConfigurationId);

            ResultSet result = getComponentAlt.executeQuery();
            Component x = new Component ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Component tables with key " + 
                    Path + ", " + ComponentName + ", " + ConfigurationId);

            assignComponent(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Component table (key " + 
                    Path + ", " + ComponentName + ", " + ConfigurationId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public Component[] getComponentWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<Component> list = new ArrayList<Component> ();
	    	Component item = null;
	    	String s = "SELECT * FROM Component";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new Component ();
	    		assignComponent(item,result);
	    		list.add(item);
	    	}
	    	Component[] tmp = new Component [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addComponent(Component data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addComponent.setInt(1,data.getComponentTypeId());

            addComponent.setString(2,data.getComponentName());

            addComponent.setInt(3,data.getConfigurationId());

            addComponent.setInt(4,data.getContainerId());

            addComponent.setString(5,data.getImplLang());

	        addComponent.setBoolean(6,data.getRealTime());

            addComponent.setString(7,data.getCode());

            addComponent.setString(8,data.getPath());

	        addComponent.setBoolean(9,data.getIsAutostart());

	        addComponent.setBoolean(10,data.getIsDefault());

	        addComponent.setBoolean(11,data.getIsStandaloneDefined());

            addComponent.setInt(12,data.getKeepAliveTime());

            addComponent.setInt(13,data.getMinLogLevel());

            addComponent.setInt(14,data.getMinLogLevelLocal());

            addComponent.setString(15,data.getXMLDoc());

		    addComponent.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			Component addedRow = getComponent (data.getPath(), data.getComponentName(), data.getConfigurationId() );        
            return addedRow.getComponentId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table Component!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addComponent(Component data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			Component x = getComponent(data.getPath(), data.getComponentName(), data.getConfigurationId() );
	    		return x.getComponentId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addComponent(data);

    }

    public void deleteComponent (int ComponentId) throws AcsJTmcdbSqlEx {
        try {
            deleteComponentKey.setInt(1, ComponentId);
			deleteComponentKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteComponent (String Path, String ComponentName, int ConfigurationId) throws AcsJTmcdbSqlEx {
        try {

            deleteComponentAlt.setString(1, Path);

            deleteComponentAlt.setString(2, ComponentName);

            deleteComponentAlt.setInt(3, ConfigurationId);

			deleteComponentAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateComponent(Component data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        Component x = null;

        x = getComponent(data.getComponentId());

        // You can't change the keys.
		if (x.getComponentId() != data.getComponentId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getPath().equals(data.getPath()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getComponentName().equals(data.getComponentName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateComponent.setInt(1,data.getComponentId());

            updateComponent.setInt(2,data.getComponentTypeId());

            updateComponent.setString(3,data.getComponentName());

            updateComponent.setInt(4,data.getConfigurationId());

            updateComponent.setInt(5,data.getContainerId());

            updateComponent.setString(6,data.getImplLang());

	        updateComponent.setBoolean(7,data.getRealTime());

            updateComponent.setString(8,data.getCode());

            updateComponent.setString(9,data.getPath());

	        updateComponent.setBoolean(10,data.getIsAutostart());

	        updateComponent.setBoolean(11,data.getIsDefault());

	        updateComponent.setBoolean(12,data.getIsStandaloneDefined());

            updateComponent.setInt(13,data.getKeepAliveTime());

            updateComponent.setInt(14,data.getMinLogLevel());

            updateComponent.setInt(15,data.getMinLogLevelLocal());

            updateComponent.setString(16,data.getXMLDoc());

      		updateComponent.setInt(17, data.getComponentId()); 
			updateComponent.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // Assembly
    /////////////////////////////////////////

    public void assignAssembly(Assembly x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setAssemblyId(result.getInt(1));

        x.setAssemblyTypeName(result.getString(2));

        x.setConfigurationId(result.getInt(3));

        x.setSerialNumber(result.getString(4));

        x.setData(result.getString(5));

        // if (result.wasNull())
        // 	x.setDataNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public Assembly getAssembly (int AssemblyId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getAssemblyKey.setInt(1, AssemblyId);
            ResultSet result = getAssemblyKey.executeQuery();
            Assembly x = new Assembly ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Assembly tables with key " + 
                    AssemblyId);

            assignAssembly(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Assembly table (key " + 
                    AssemblyId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public Assembly getAssembly (String SerialNumber, int ConfigurationId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getAssemblyAlt.setString(1, SerialNumber);

            getAssemblyAlt.setInt(2, ConfigurationId);

            ResultSet result = getAssemblyAlt.executeQuery();
            Assembly x = new Assembly ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Assembly tables with key " + 
                    SerialNumber + ", " + ConfigurationId);

            assignAssembly(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Assembly table (key " + 
                    SerialNumber + ", " + ConfigurationId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public Assembly[] getAssemblyWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<Assembly> list = new ArrayList<Assembly> ();
	    	Assembly item = null;
	    	String s = "SELECT * FROM Assembly";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new Assembly ();
	    		assignAssembly(item,result);
	    		list.add(item);
	    	}
	    	Assembly[] tmp = new Assembly [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAssembly(Assembly data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addAssembly.setString(1,data.getAssemblyTypeName());

            addAssembly.setInt(2,data.getConfigurationId());

            addAssembly.setString(3,data.getSerialNumber());

            addAssembly.setString(4,data.getData());

		    addAssembly.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			Assembly addedRow = getAssembly (data.getSerialNumber(), data.getConfigurationId() );        
            return addedRow.getAssemblyId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table Assembly!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addAssembly(Assembly data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			Assembly x = getAssembly(data.getSerialNumber(), data.getConfigurationId() );
	    		return x.getAssemblyId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addAssembly(data);

    }

    public void deleteAssembly (int AssemblyId) throws AcsJTmcdbSqlEx {
        try {
            deleteAssemblyKey.setInt(1, AssemblyId);
			deleteAssemblyKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteAssembly (String SerialNumber, int ConfigurationId) throws AcsJTmcdbSqlEx {
        try {

            deleteAssemblyAlt.setString(1, SerialNumber);

            deleteAssemblyAlt.setInt(2, ConfigurationId);

			deleteAssemblyAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAssembly(Assembly data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        Assembly x = null;

        x = getAssembly(data.getAssemblyId());

        // You can't change the keys.
		if (x.getAssemblyId() != data.getAssemblyId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getSerialNumber().equals(data.getSerialNumber()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAssembly.setInt(1,data.getAssemblyId());

            updateAssembly.setString(2,data.getAssemblyTypeName());

            updateAssembly.setInt(3,data.getConfigurationId());

            updateAssembly.setString(4,data.getSerialNumber());

            updateAssembly.setString(5,data.getData());

      		updateAssembly.setInt(6, data.getAssemblyId()); 
			updateAssembly.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // DefaultCanAddress
    /////////////////////////////////////////

    public void assignDefaultCanAddress(DefaultCanAddress x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setComponentId(result.getInt(1));

        x.setNodeAddress(result.getString(2));

        x.setChannelNumber(result.getInt(3));

        x.setBaseAddress(result.getString(4));

        // if (result.wasNull())
        // 	x.setBaseAddressNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public DefaultCanAddress getDefaultCanAddress (int ComponentId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getDefaultCanAddressKey.setInt(1, ComponentId);

            ResultSet result = getDefaultCanAddressKey.executeQuery();
            DefaultCanAddress x = new DefaultCanAddress ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in DefaultCanAddress tables with key " + 
                    ComponentId);
            assignDefaultCanAddress(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for DefaultCanAddress table (key " + 
                    ComponentId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public DefaultCanAddress[] getDefaultCanAddressWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<DefaultCanAddress> list = new ArrayList<DefaultCanAddress> ();
	    	DefaultCanAddress item = null;
	    	String s = "SELECT * FROM DefaultCanAddress";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new DefaultCanAddress ();
	    		assignDefaultCanAddress(item,result);
	    		list.add(item);
	    	}
	    	DefaultCanAddress[] tmp = new DefaultCanAddress [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addDefaultCanAddress(DefaultCanAddress data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    DefaultCanAddress x = getDefaultCanAddress(data.getComponentId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addDefaultCanAddress.setInt(1,data.getComponentId());

            addDefaultCanAddress.setString(2,data.getNodeAddress());

            addDefaultCanAddress.setInt(3,data.getChannelNumber());

            addDefaultCanAddress.setString(4,data.getBaseAddress());

			addDefaultCanAddress.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addDefaultCanAddress(DefaultCanAddress data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				DefaultCanAddress x = getDefaultCanAddress(data.getComponentId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addDefaultCanAddress(data);

    }

    public void deleteDefaultCanAddress (int ComponentId) throws AcsJTmcdbSqlEx {
        try {

          	deleteDefaultCanAddressKey.setInt(1, ComponentId);

			deleteDefaultCanAddressKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateDefaultCanAddress(DefaultCanAddress data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        DefaultCanAddress x = null;
        try {
            x = getDefaultCanAddress(data.getComponentId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getComponentId() != data.getComponentId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateDefaultCanAddress.setInt(1,data.getComponentId());

            updateDefaultCanAddress.setString(2,data.getNodeAddress());

            updateDefaultCanAddress.setInt(3,data.getChannelNumber());

            updateDefaultCanAddress.setString(4,data.getBaseAddress());

          	updateDefaultCanAddress.setInt(4 + 1, data.getComponentId());

			updateDefaultCanAddress.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // AssemblyRole
    /////////////////////////////////////////

    public void assignAssemblyRole(AssemblyRole x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setRoleName(result.getString(1));

        x.setNodeAddress(result.getString(2));

        x.setChannelNumber(result.getInt(3));

        x.setBaseAddress(result.getString(4));

        // if (result.wasNull())
        // 	x.setBaseAddressNull();

        x.setAssemblyTypeName(result.getString(5));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public AssemblyRole getAssemblyRole (String RoleName) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getAssemblyRoleKey.setString(1, RoleName);

            ResultSet result = getAssemblyRoleKey.executeQuery();
            AssemblyRole x = new AssemblyRole ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AssemblyRole tables with key " + 
                    RoleName);
            assignAssemblyRole(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for AssemblyRole table (key " + 
                    RoleName + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public AssemblyRole[] getAssemblyRoleWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<AssemblyRole> list = new ArrayList<AssemblyRole> ();
	    	AssemblyRole item = null;
	    	String s = "SELECT * FROM AssemblyRole";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new AssemblyRole ();
	    		assignAssemblyRole(item,result);
	    		list.add(item);
	    	}
	    	AssemblyRole[] tmp = new AssemblyRole [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAssemblyRole(AssemblyRole data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    AssemblyRole x = getAssemblyRole(data.getRoleName());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addAssemblyRole.setString(1,data.getRoleName());

            addAssemblyRole.setString(2,data.getNodeAddress());

            addAssemblyRole.setInt(3,data.getChannelNumber());

            addAssemblyRole.setString(4,data.getBaseAddress());

            addAssemblyRole.setString(5,data.getAssemblyTypeName());

			addAssemblyRole.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addAssemblyRole(AssemblyRole data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				AssemblyRole x = getAssemblyRole(data.getRoleName());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addAssemblyRole(data);

    }

    public void deleteAssemblyRole (String RoleName) throws AcsJTmcdbSqlEx {
        try {

          	deleteAssemblyRoleKey.setString(1, RoleName);

			deleteAssemblyRoleKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAssemblyRole(AssemblyRole data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        AssemblyRole x = null;
        try {
            x = getAssemblyRole(data.getRoleName());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (!x.getRoleName().equals(data.getRoleName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAssemblyRole.setString(1,data.getRoleName());

            updateAssemblyRole.setString(2,data.getNodeAddress());

            updateAssemblyRole.setInt(3,data.getChannelNumber());

            updateAssemblyRole.setString(4,data.getBaseAddress());

            updateAssemblyRole.setString(5,data.getAssemblyTypeName());

          	updateAssemblyRole.setString(5 + 1, data.getRoleName());

			updateAssemblyRole.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // BACIProperty
    /////////////////////////////////////////

    public void assignBACIProperty(BACIProperty x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setBACIPropertyId(result.getInt(1));

        x.setComponentId(result.getInt(2));

        x.setPropertyName(result.getString(3));

        x.setdescription(result.getString(4));

	    x.setisSequence(result.getBoolean(5));

        x.setformat(result.getString(6));

        x.setunits(result.getString(7));

        x.setresolution(result.getString(8));

        x.setarchive_priority(result.getInt(9));

        x.setarchive_min_int(result.getDouble(10));

        x.setarchive_max_int(result.getDouble(11));

        x.setdefault_timer_trig(result.getDouble(12));

        x.setmin_timer_trig(result.getDouble(13));

	    x.setinitialize_devio(result.getBoolean(14));

        x.setmin_delta_trig(result.getDouble(15));

        // if (result.wasNull())
        // 	x.setmin_delta_trigNull();

        x.setdefault_value(result.getString(16));

        x.setgraph_min(result.getDouble(17));

        // if (result.wasNull())
        // 	x.setgraph_minNull();

        x.setgraph_max(result.getDouble(18));

        // if (result.wasNull())
        // 	x.setgraph_maxNull();

        x.setmin_step(result.getDouble(19));

        // if (result.wasNull())
        // 	x.setmin_stepNull();

        x.setarchive_delta(result.getDouble(20));

        x.setalarm_high_on(result.getDouble(21));

        // if (result.wasNull())
        // 	x.setalarm_high_onNull();

        x.setalarm_low_on(result.getDouble(22));

        // if (result.wasNull())
        // 	x.setalarm_low_onNull();

        x.setalarm_high_off(result.getDouble(23));

        // if (result.wasNull())
        // 	x.setalarm_high_offNull();

        x.setalarm_low_off(result.getDouble(24));

        // if (result.wasNull())
        // 	x.setalarm_low_offNull();

        x.setalarm_timer_trig(result.getDouble(25));

        // if (result.wasNull())
        // 	x.setalarm_timer_trigNull();

        x.setmin_value(result.getDouble(26));

        // if (result.wasNull())
        // 	x.setmin_valueNull();

        x.setmax_value(result.getDouble(27));

        // if (result.wasNull())
        // 	x.setmax_valueNull();

        x.setbitDescription(result.getString(28));

        // if (result.wasNull())
        // 	x.setbitDescriptionNull();

        x.setwhenSet(result.getString(29));

        // if (result.wasNull())
        // 	x.setwhenSetNull();

        x.setwhenCleared(result.getString(30));

        // if (result.wasNull())
        // 	x.setwhenClearedNull();

        x.setstatesDescription(result.getString(31));

        // if (result.wasNull())
        // 	x.setstatesDescriptionNull();

        x.setcondition(result.getString(32));

        // if (result.wasNull())
        // 	x.setconditionNull();

        x.setalarm_on(result.getString(33));

        // if (result.wasNull())
        // 	x.setalarm_onNull();

        x.setalarm_off(result.getString(34));

        // if (result.wasNull())
        // 	x.setalarm_offNull();

        x.setData(result.getString(35));

        // if (result.wasNull())
        // 	x.setDataNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public BACIProperty getBACIProperty (int BACIPropertyId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getBACIPropertyKey.setInt(1, BACIPropertyId);
            ResultSet result = getBACIPropertyKey.executeQuery();
            BACIProperty x = new BACIProperty ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in BACIProperty tables with key " + 
                    BACIPropertyId);

            assignBACIProperty(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for BACIProperty table (key " + 
                    BACIPropertyId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public BACIProperty getBACIProperty (String PropertyName, int ComponentId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getBACIPropertyAlt.setString(1, PropertyName);

            getBACIPropertyAlt.setInt(2, ComponentId);

            ResultSet result = getBACIPropertyAlt.executeQuery();
            BACIProperty x = new BACIProperty ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in BACIProperty tables with key " + 
                    PropertyName + ", " + ComponentId);

            assignBACIProperty(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for BACIProperty table (key " + 
                    PropertyName + ", " + ComponentId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public BACIProperty[] getBACIPropertyWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<BACIProperty> list = new ArrayList<BACIProperty> ();
	    	BACIProperty item = null;
	    	String s = "SELECT * FROM BACIProperty";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new BACIProperty ();
	    		assignBACIProperty(item,result);
	    		list.add(item);
	    	}
	    	BACIProperty[] tmp = new BACIProperty [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addBACIProperty(BACIProperty data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addBACIProperty.setInt(1,data.getComponentId());

            addBACIProperty.setString(2,data.getPropertyName());

            addBACIProperty.setString(3,data.getdescription());

	        addBACIProperty.setBoolean(4,data.getisSequence());

            addBACIProperty.setString(5,data.getformat());

            addBACIProperty.setString(6,data.getunits());

            addBACIProperty.setString(7,data.getresolution());

            addBACIProperty.setInt(8,data.getarchive_priority());

            addBACIProperty.setDouble(9,data.getarchive_min_int());

            addBACIProperty.setDouble(10,data.getarchive_max_int());

            addBACIProperty.setDouble(11,data.getdefault_timer_trig());

            addBACIProperty.setDouble(12,data.getmin_timer_trig());

	        addBACIProperty.setBoolean(13,data.getinitialize_devio());

            addBACIProperty.setDouble(14,data.getmin_delta_trig());

            addBACIProperty.setString(15,data.getdefault_value());

            addBACIProperty.setDouble(16,data.getgraph_min());

            addBACIProperty.setDouble(17,data.getgraph_max());

            addBACIProperty.setDouble(18,data.getmin_step());

            addBACIProperty.setDouble(19,data.getarchive_delta());

            addBACIProperty.setDouble(20,data.getalarm_high_on());

            addBACIProperty.setDouble(21,data.getalarm_low_on());

            addBACIProperty.setDouble(22,data.getalarm_high_off());

            addBACIProperty.setDouble(23,data.getalarm_low_off());

            addBACIProperty.setDouble(24,data.getalarm_timer_trig());

            addBACIProperty.setDouble(25,data.getmin_value());

            addBACIProperty.setDouble(26,data.getmax_value());

            addBACIProperty.setString(27,data.getbitDescription());

            addBACIProperty.setString(28,data.getwhenSet());

            addBACIProperty.setString(29,data.getwhenCleared());

            addBACIProperty.setString(30,data.getstatesDescription());

            addBACIProperty.setString(31,data.getcondition());

            addBACIProperty.setString(32,data.getalarm_on());

            addBACIProperty.setString(33,data.getalarm_off());

            addBACIProperty.setString(34,data.getData());

		    addBACIProperty.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			BACIProperty addedRow = getBACIProperty (data.getPropertyName(), data.getComponentId() );        
            return addedRow.getBACIPropertyId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table BACIProperty!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addBACIProperty(BACIProperty data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			BACIProperty x = getBACIProperty(data.getPropertyName(), data.getComponentId() );
	    		return x.getBACIPropertyId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addBACIProperty(data);

    }

    public void deleteBACIProperty (int BACIPropertyId) throws AcsJTmcdbSqlEx {
        try {
            deleteBACIPropertyKey.setInt(1, BACIPropertyId);
			deleteBACIPropertyKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteBACIProperty (String PropertyName, int ComponentId) throws AcsJTmcdbSqlEx {
        try {

            deleteBACIPropertyAlt.setString(1, PropertyName);

            deleteBACIPropertyAlt.setInt(2, ComponentId);

			deleteBACIPropertyAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateBACIProperty(BACIProperty data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        BACIProperty x = null;

        x = getBACIProperty(data.getBACIPropertyId());

        // You can't change the keys.
		if (x.getBACIPropertyId() != data.getBACIPropertyId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getPropertyName().equals(data.getPropertyName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getComponentId() != data.getComponentId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateBACIProperty.setInt(1,data.getBACIPropertyId());

            updateBACIProperty.setInt(2,data.getComponentId());

            updateBACIProperty.setString(3,data.getPropertyName());

            updateBACIProperty.setString(4,data.getdescription());

	        updateBACIProperty.setBoolean(5,data.getisSequence());

            updateBACIProperty.setString(6,data.getformat());

            updateBACIProperty.setString(7,data.getunits());

            updateBACIProperty.setString(8,data.getresolution());

            updateBACIProperty.setInt(9,data.getarchive_priority());

            updateBACIProperty.setDouble(10,data.getarchive_min_int());

            updateBACIProperty.setDouble(11,data.getarchive_max_int());

            updateBACIProperty.setDouble(12,data.getdefault_timer_trig());

            updateBACIProperty.setDouble(13,data.getmin_timer_trig());

	        updateBACIProperty.setBoolean(14,data.getinitialize_devio());

            updateBACIProperty.setDouble(15,data.getmin_delta_trig());

            updateBACIProperty.setString(16,data.getdefault_value());

            updateBACIProperty.setDouble(17,data.getgraph_min());

            updateBACIProperty.setDouble(18,data.getgraph_max());

            updateBACIProperty.setDouble(19,data.getmin_step());

            updateBACIProperty.setDouble(20,data.getarchive_delta());

            updateBACIProperty.setDouble(21,data.getalarm_high_on());

            updateBACIProperty.setDouble(22,data.getalarm_low_on());

            updateBACIProperty.setDouble(23,data.getalarm_high_off());

            updateBACIProperty.setDouble(24,data.getalarm_low_off());

            updateBACIProperty.setDouble(25,data.getalarm_timer_trig());

            updateBACIProperty.setDouble(26,data.getmin_value());

            updateBACIProperty.setDouble(27,data.getmax_value());

            updateBACIProperty.setString(28,data.getbitDescription());

            updateBACIProperty.setString(29,data.getwhenSet());

            updateBACIProperty.setString(30,data.getwhenCleared());

            updateBACIProperty.setString(31,data.getstatesDescription());

            updateBACIProperty.setString(32,data.getcondition());

            updateBACIProperty.setString(33,data.getalarm_on());

            updateBACIProperty.setString(34,data.getalarm_off());

            updateBACIProperty.setString(35,data.getData());

      		updateBACIProperty.setInt(36, data.getBACIPropertyId()); 
			updateBACIProperty.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // MonitorPoint
    /////////////////////////////////////////

    public void assignMonitorPoint(MonitorPoint x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setMonitorPointId(result.getInt(1));

        x.setBACIPropertyId(result.getInt(2));

        x.setMonitorPointName(result.getString(3));

        x.setAssemblyId(result.getInt(4));

        x.setIndice(result.getInt(5));

        x.setDataType(result.getString(6));

        x.setRCA(result.getString(7));

	    x.setTeRelated(result.getBoolean(8));

        x.setRawDataType(result.getString(9));

        x.setWorldDataType(result.getString(10));

        x.setUnits(result.getString(11));

        // if (result.wasNull())
        // 	x.setUnitsNull();

        x.setScale(result.getDouble(12));

        // if (result.wasNull())
        // 	x.setScaleNull();

	    x.setOffset(new Length(result.getDouble(13)));

        // if (result.wasNull())
        // 	x.setOffsetNull();

        x.setMinRange(result.getString(14));

        // if (result.wasNull())
        // 	x.setMinRangeNull();

        x.setMaxRange(result.getString(15));

        // if (result.wasNull())
        // 	x.setMaxRangeNull();

        x.setDescription(result.getString(16));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public MonitorPoint getMonitorPoint (int MonitorPointId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getMonitorPointKey.setInt(1, MonitorPointId);

            ResultSet result = getMonitorPointKey.executeQuery();
            MonitorPoint x = new MonitorPoint ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in MonitorPoint tables with key " + 
                    MonitorPointId);
            assignMonitorPoint(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for MonitorPoint table (key " + 
                    MonitorPointId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public MonitorPoint[] getMonitorPointWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<MonitorPoint> list = new ArrayList<MonitorPoint> ();
	    	MonitorPoint item = null;
	    	String s = "SELECT * FROM MonitorPoint";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new MonitorPoint ();
	    		assignMonitorPoint(item,result);
	    		list.add(item);
	    	}
	    	MonitorPoint[] tmp = new MonitorPoint [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addMonitorPoint(MonitorPoint data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    MonitorPoint x = getMonitorPoint(data.getMonitorPointId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addMonitorPoint.setInt(1,data.getMonitorPointId());

            addMonitorPoint.setInt(2,data.getBACIPropertyId());

            addMonitorPoint.setString(3,data.getMonitorPointName());

            addMonitorPoint.setInt(4,data.getAssemblyId());

            addMonitorPoint.setInt(5,data.getIndice());

            addMonitorPoint.setString(6,data.getDataType());

            addMonitorPoint.setString(7,data.getRCA());

	        addMonitorPoint.setBoolean(8,data.getTeRelated());

            addMonitorPoint.setString(9,data.getRawDataType());

            addMonitorPoint.setString(10,data.getWorldDataType());

            addMonitorPoint.setString(11,data.getUnits());

            addMonitorPoint.setDouble(12,data.getScale());

	        addMonitorPoint.setDouble(13,data.getOffset().get());

            addMonitorPoint.setString(14,data.getMinRange());

            addMonitorPoint.setString(15,data.getMaxRange());

            addMonitorPoint.setString(16,data.getDescription());

			addMonitorPoint.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addMonitorPoint(MonitorPoint data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				MonitorPoint x = getMonitorPoint(data.getMonitorPointId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addMonitorPoint(data);

    }

    public void deleteMonitorPoint (int MonitorPointId) throws AcsJTmcdbSqlEx {
        try {

          	deleteMonitorPointKey.setInt(1, MonitorPointId);

			deleteMonitorPointKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateMonitorPoint(MonitorPoint data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        MonitorPoint x = null;
        try {
            x = getMonitorPoint(data.getMonitorPointId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getMonitorPointId() != data.getMonitorPointId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateMonitorPoint.setInt(1,data.getMonitorPointId());

            updateMonitorPoint.setInt(2,data.getBACIPropertyId());

            updateMonitorPoint.setString(3,data.getMonitorPointName());

            updateMonitorPoint.setInt(4,data.getAssemblyId());

            updateMonitorPoint.setInt(5,data.getIndice());

            updateMonitorPoint.setString(6,data.getDataType());

            updateMonitorPoint.setString(7,data.getRCA());

	        updateMonitorPoint.setBoolean(8,data.getTeRelated());

            updateMonitorPoint.setString(9,data.getRawDataType());

            updateMonitorPoint.setString(10,data.getWorldDataType());

            updateMonitorPoint.setString(11,data.getUnits());

            updateMonitorPoint.setDouble(12,data.getScale());

	        updateMonitorPoint.setDouble(13,data.getOffset().get());

            updateMonitorPoint.setString(14,data.getMinRange());

            updateMonitorPoint.setString(15,data.getMaxRange());

            updateMonitorPoint.setString(16,data.getDescription());

          	updateMonitorPoint.setInt(16 + 1, data.getMonitorPointId());

			updateMonitorPoint.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // MonitorData
    /////////////////////////////////////////

    public void assignMonitorData(MonitorData x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setMonitorPointId(result.getInt(1));

	    x.setStartTime(new ArrayTime(result.getLong(2)));

	    x.setEndTime(new ArrayTime(result.getLong(3)));

        x.setMonitorTS(result.getString(4));

        x.setSampleSize(result.getInt(5));

        x.setMonitorClob(result.getString(6));

        x.setMinStat(result.getDouble(7));

        // if (result.wasNull())
        // 	x.setMinStatNull();

        x.setMaxStat(result.getDouble(8));

        // if (result.wasNull())
        // 	x.setMaxStatNull();

        x.setMeanStat(result.getDouble(9));

        // if (result.wasNull())
        // 	x.setMeanStatNull();

        x.setStdDevStat(result.getDouble(10));

        // if (result.wasNull())
        // 	x.setStdDevStatNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public MonitorData getMonitorData (int MonitorPointId, String MonitorTS) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getMonitorDataKey.setInt(1, MonitorPointId);

          	getMonitorDataKey.setString(2, MonitorTS);

            ResultSet result = getMonitorDataKey.executeQuery();
            MonitorData x = new MonitorData ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in MonitorData tables with key " + 
                    MonitorPointId + ", " + MonitorTS);
            assignMonitorData(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for MonitorData table (key " + 
                    MonitorPointId + ", " + MonitorTS + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public MonitorData[] getMonitorDataWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<MonitorData> list = new ArrayList<MonitorData> ();
	    	MonitorData item = null;
	    	String s = "SELECT * FROM MonitorData";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new MonitorData ();
	    		assignMonitorData(item,result);
	    		list.add(item);
	    	}
	    	MonitorData[] tmp = new MonitorData [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addMonitorData(MonitorData data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    MonitorData x = getMonitorData(data.getMonitorPointId(), data.getMonitorTS());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addMonitorData.setInt(1,data.getMonitorPointId());

	        addMonitorData.setLong(2,data.getStartTime().get());

	        addMonitorData.setLong(3,data.getEndTime().get());

            addMonitorData.setString(4,data.getMonitorTS());

            addMonitorData.setInt(5,data.getSampleSize());

            addMonitorData.setString(6,data.getMonitorClob());

            addMonitorData.setDouble(7,data.getMinStat());

            addMonitorData.setDouble(8,data.getMaxStat());

            addMonitorData.setDouble(9,data.getMeanStat());

            addMonitorData.setDouble(10,data.getStdDevStat());

			addMonitorData.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addMonitorData(MonitorData data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				MonitorData x = getMonitorData(data.getMonitorPointId(), data.getMonitorTS());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addMonitorData(data);

    }

    public void deleteMonitorData (int MonitorPointId, String MonitorTS) throws AcsJTmcdbSqlEx {
        try {

          	deleteMonitorDataKey.setInt(1, MonitorPointId);

          	deleteMonitorDataKey.setString(2, MonitorTS);

			deleteMonitorDataKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateMonitorData(MonitorData data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        MonitorData x = null;
        try {
            x = getMonitorData(data.getMonitorPointId(), data.getMonitorTS());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getMonitorPointId() != data.getMonitorPointId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getMonitorTS().equals(data.getMonitorTS()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateMonitorData.setInt(1,data.getMonitorPointId());

	        updateMonitorData.setLong(2,data.getStartTime().get());

	        updateMonitorData.setLong(3,data.getEndTime().get());

            updateMonitorData.setString(4,data.getMonitorTS());

            updateMonitorData.setInt(5,data.getSampleSize());

            updateMonitorData.setString(6,data.getMonitorClob());

            updateMonitorData.setDouble(7,data.getMinStat());

            updateMonitorData.setDouble(8,data.getMaxStat());

            updateMonitorData.setDouble(9,data.getMeanStat());

            updateMonitorData.setDouble(10,data.getStdDevStat());

          	updateMonitorData.setInt(10 + 1, data.getMonitorPointId());

          	updateMonitorData.setString(10 + 2, data.getMonitorTS());

			updateMonitorData.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // BaseElement
    /////////////////////////////////////////

    public void assignBaseElement(BaseElement x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setBaseElementId(result.getInt(1));

        x.setBaseType(result.getString(2));

        x.setBaseElementName(result.getString(3));

        x.setConfigurationId(result.getInt(4));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public BaseElement getBaseElement (int BaseElementId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getBaseElementKey.setInt(1, BaseElementId);
            ResultSet result = getBaseElementKey.executeQuery();
            BaseElement x = new BaseElement ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in BaseElement tables with key " + 
                    BaseElementId);

            assignBaseElement(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for BaseElement table (key " + 
                    BaseElementId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public BaseElement getBaseElement (String BaseElementName, int ConfigurationId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getBaseElementAlt.setString(1, BaseElementName);

            getBaseElementAlt.setInt(2, ConfigurationId);

            ResultSet result = getBaseElementAlt.executeQuery();
            BaseElement x = new BaseElement ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in BaseElement tables with key " + 
                    BaseElementName + ", " + ConfigurationId);

            assignBaseElement(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for BaseElement table (key " + 
                    BaseElementName + ", " + ConfigurationId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public BaseElement[] getBaseElementWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<BaseElement> list = new ArrayList<BaseElement> ();
	    	BaseElement item = null;
	    	String s = "SELECT * FROM BaseElement";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new BaseElement ();
	    		assignBaseElement(item,result);
	    		list.add(item);
	    	}
	    	BaseElement[] tmp = new BaseElement [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addBaseElement(BaseElement data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addBaseElement.setString(1,data.getBaseType());

            addBaseElement.setString(2,data.getBaseElementName());

            addBaseElement.setInt(3,data.getConfigurationId());

		    addBaseElement.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			BaseElement addedRow = getBaseElement (data.getBaseElementName(), data.getConfigurationId() );        
            return addedRow.getBaseElementId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table BaseElement!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addBaseElement(BaseElement data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			BaseElement x = getBaseElement(data.getBaseElementName(), data.getConfigurationId() );
	    		return x.getBaseElementId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addBaseElement(data);

    }

    public void deleteBaseElement (int BaseElementId) throws AcsJTmcdbSqlEx {
        try {
            deleteBaseElementKey.setInt(1, BaseElementId);
			deleteBaseElementKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteBaseElement (String BaseElementName, int ConfigurationId) throws AcsJTmcdbSqlEx {
        try {

            deleteBaseElementAlt.setString(1, BaseElementName);

            deleteBaseElementAlt.setInt(2, ConfigurationId);

			deleteBaseElementAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateBaseElement(BaseElement data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        BaseElement x = null;

        x = getBaseElement(data.getBaseElementId());

        // You can't change the keys.
		if (x.getBaseElementId() != data.getBaseElementId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getBaseElementName().equals(data.getBaseElementName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateBaseElement.setInt(1,data.getBaseElementId());

            updateBaseElement.setString(2,data.getBaseType());

            updateBaseElement.setString(3,data.getBaseElementName());

            updateBaseElement.setInt(4,data.getConfigurationId());

      		updateBaseElement.setInt(5, data.getBaseElementId()); 
			updateBaseElement.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // BaseElementOnline
    /////////////////////////////////////////

    public void assignBaseElementOnline(BaseElementOnline x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setBaseElementOnlineId(result.getInt(1));

        x.setBaseElementId(result.getInt(2));

        x.setConfigurationId(result.getInt(3));

	    x.setStartTime(new ArrayTime(result.getLong(4)));

	    x.setEndTime(new ArrayTime(result.getLong(5)));

        // if (result.wasNull())
        // 	x.setEndTimeNull();

	    x.setNormalTermination(result.getBoolean(6));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public BaseElementOnline getBaseElementOnline (int BaseElementOnlineId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getBaseElementOnlineKey.setInt(1, BaseElementOnlineId);
            ResultSet result = getBaseElementOnlineKey.executeQuery();
            BaseElementOnline x = new BaseElementOnline ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in BaseElementOnline tables with key " + 
                    BaseElementOnlineId);

            assignBaseElementOnline(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for BaseElementOnline table (key " + 
                    BaseElementOnlineId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public BaseElementOnline getBaseElementOnline (int BaseElementId, int ConfigurationId, ArrayTime StartTime) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getBaseElementOnlineAlt.setInt(1, BaseElementId);

            getBaseElementOnlineAlt.setInt(2, ConfigurationId);

	      	getBaseElementOnlineAlt.setLong(3, StartTime.get());

            ResultSet result = getBaseElementOnlineAlt.executeQuery();
            BaseElementOnline x = new BaseElementOnline ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in BaseElementOnline tables with key " + 
                    BaseElementId + ", " + ConfigurationId + ", " + StartTime);

            assignBaseElementOnline(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for BaseElementOnline table (key " + 
                    BaseElementId + ", " + ConfigurationId + ", " + StartTime + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public BaseElementOnline[] getBaseElementOnlineWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<BaseElementOnline> list = new ArrayList<BaseElementOnline> ();
	    	BaseElementOnline item = null;
	    	String s = "SELECT * FROM BaseElementOnline";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new BaseElementOnline ();
	    		assignBaseElementOnline(item,result);
	    		list.add(item);
	    	}
	    	BaseElementOnline[] tmp = new BaseElementOnline [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addBaseElementOnline(BaseElementOnline data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addBaseElementOnline.setInt(1,data.getBaseElementId());

            addBaseElementOnline.setInt(2,data.getConfigurationId());

	        addBaseElementOnline.setLong(3,data.getStartTime().get());

	        addBaseElementOnline.setLong(4,data.getEndTime().get());

	        addBaseElementOnline.setBoolean(5,data.getNormalTermination());

		    addBaseElementOnline.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			BaseElementOnline addedRow = getBaseElementOnline (data.getBaseElementId(), data.getConfigurationId(), data.getStartTime() );        
            return addedRow.getBaseElementOnlineId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table BaseElementOnline!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addBaseElementOnline(BaseElementOnline data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			BaseElementOnline x = getBaseElementOnline(data.getBaseElementId(), data.getConfigurationId(), data.getStartTime() );
	    		return x.getBaseElementOnlineId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addBaseElementOnline(data);

    }

    public void deleteBaseElementOnline (int BaseElementOnlineId) throws AcsJTmcdbSqlEx {
        try {
            deleteBaseElementOnlineKey.setInt(1, BaseElementOnlineId);
			deleteBaseElementOnlineKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteBaseElementOnline (int BaseElementId, int ConfigurationId, ArrayTime StartTime) throws AcsJTmcdbSqlEx {
        try {

            deleteBaseElementOnlineAlt.setInt(1, BaseElementId);

            deleteBaseElementOnlineAlt.setInt(2, ConfigurationId);

	      	deleteBaseElementOnlineAlt.setLong(3, StartTime.get());

			deleteBaseElementOnlineAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateBaseElementOnline(BaseElementOnline data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        BaseElementOnline x = null;

        x = getBaseElementOnline(data.getBaseElementOnlineId());

        // You can't change the keys.
		if (x.getBaseElementOnlineId() != data.getBaseElementOnlineId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getBaseElementId() != data.getBaseElementId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartTime().get() != data.getStartTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateBaseElementOnline.setInt(1,data.getBaseElementOnlineId());

            updateBaseElementOnline.setInt(2,data.getBaseElementId());

            updateBaseElementOnline.setInt(3,data.getConfigurationId());

	        updateBaseElementOnline.setLong(4,data.getStartTime().get());

	        updateBaseElementOnline.setLong(5,data.getEndTime().get());

	        updateBaseElementOnline.setBoolean(6,data.getNormalTermination());

      		updateBaseElementOnline.setInt(7, data.getBaseElementOnlineId()); 
			updateBaseElementOnline.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // Antenna
    /////////////////////////////////////////

    public void assignAntenna(Antenna x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setBaseElementId(result.getInt(1));

        x.setAntennaName(result.getString(2));

        // if (result.wasNull())
        // 	x.setAntennaNameNull();

        x.setAntennaType(result.getString(3));

	    x.setDishDiameter(new Length(result.getDouble(4)));

	    x.setCommissionDate(new ArrayTime(result.getLong(5)));

	    x.setXPosition(new Length(result.getDouble(6)));

	    x.setYPosition(new Length(result.getDouble(7)));

	    x.setZPosition(new Length(result.getDouble(8)));

	    x.setXOffset(new Length(result.getDouble(9)));

	    x.setYOffset(new Length(result.getDouble(10)));

	    x.setZOffset(new Length(result.getDouble(11)));

        x.setComponentId(result.getInt(12));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public Antenna getAntenna (int BaseElementId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getAntennaKey.setInt(1, BaseElementId);

            ResultSet result = getAntennaKey.executeQuery();
            Antenna x = new Antenna ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Antenna tables with key " + 
                    BaseElementId);
            assignAntenna(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for Antenna table (key " + 
                    BaseElementId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public Antenna[] getAntennaWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<Antenna> list = new ArrayList<Antenna> ();
	    	Antenna item = null;
	    	String s = "SELECT * FROM Antenna";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new Antenna ();
	    		assignAntenna(item,result);
	    		list.add(item);
	    	}
	    	Antenna[] tmp = new Antenna [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAntenna(Antenna data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    Antenna x = getAntenna(data.getBaseElementId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addAntenna.setInt(1,data.getBaseElementId());

            addAntenna.setString(2,data.getAntennaName());

            addAntenna.setString(3,data.getAntennaType());

	        addAntenna.setDouble(4,data.getDishDiameter().get());

	        addAntenna.setLong(5,data.getCommissionDate().get());

	        addAntenna.setDouble(6,data.getXPosition().get());

	        addAntenna.setDouble(7,data.getYPosition().get());

	        addAntenna.setDouble(8,data.getZPosition().get());

	        addAntenna.setDouble(9,data.getXOffset().get());

	        addAntenna.setDouble(10,data.getYOffset().get());

	        addAntenna.setDouble(11,data.getZOffset().get());

            addAntenna.setInt(12,data.getComponentId());

			addAntenna.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addAntenna(Antenna data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				Antenna x = getAntenna(data.getBaseElementId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addAntenna(data);

    }

    public void deleteAntenna (int BaseElementId) throws AcsJTmcdbSqlEx {
        try {

          	deleteAntennaKey.setInt(1, BaseElementId);

			deleteAntennaKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAntenna(Antenna data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        Antenna x = null;
        try {
            x = getAntenna(data.getBaseElementId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getBaseElementId() != data.getBaseElementId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAntenna.setInt(1,data.getBaseElementId());

            updateAntenna.setString(2,data.getAntennaName());

            updateAntenna.setString(3,data.getAntennaType());

	        updateAntenna.setDouble(4,data.getDishDiameter().get());

	        updateAntenna.setLong(5,data.getCommissionDate().get());

	        updateAntenna.setDouble(6,data.getXPosition().get());

	        updateAntenna.setDouble(7,data.getYPosition().get());

	        updateAntenna.setDouble(8,data.getZPosition().get());

	        updateAntenna.setDouble(9,data.getXOffset().get());

	        updateAntenna.setDouble(10,data.getYOffset().get());

	        updateAntenna.setDouble(11,data.getZOffset().get());

            updateAntenna.setInt(12,data.getComponentId());

          	updateAntenna.setInt(12 + 1, data.getBaseElementId());

			updateAntenna.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // Pad
    /////////////////////////////////////////

    public void assignPad(Pad x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setBaseElementId(result.getInt(1));

        x.setPadName(result.getString(2));

        // if (result.wasNull())
        // 	x.setPadNameNull();

	    x.setCommissionDate(new ArrayTime(result.getLong(3)));

	    x.setXPosition(new Length(result.getDouble(4)));

	    x.setYPosition(new Length(result.getDouble(5)));

	    x.setZPosition(new Length(result.getDouble(6)));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public Pad getPad (int BaseElementId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getPadKey.setInt(1, BaseElementId);

            ResultSet result = getPadKey.executeQuery();
            Pad x = new Pad ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Pad tables with key " + 
                    BaseElementId);
            assignPad(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for Pad table (key " + 
                    BaseElementId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public Pad[] getPadWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<Pad> list = new ArrayList<Pad> ();
	    	Pad item = null;
	    	String s = "SELECT * FROM Pad";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new Pad ();
	    		assignPad(item,result);
	    		list.add(item);
	    	}
	    	Pad[] tmp = new Pad [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addPad(Pad data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    Pad x = getPad(data.getBaseElementId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addPad.setInt(1,data.getBaseElementId());

            addPad.setString(2,data.getPadName());

	        addPad.setLong(3,data.getCommissionDate().get());

	        addPad.setDouble(4,data.getXPosition().get());

	        addPad.setDouble(5,data.getYPosition().get());

	        addPad.setDouble(6,data.getZPosition().get());

			addPad.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addPad(Pad data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				Pad x = getPad(data.getBaseElementId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addPad(data);

    }

    public void deletePad (int BaseElementId) throws AcsJTmcdbSqlEx {
        try {

          	deletePadKey.setInt(1, BaseElementId);

			deletePadKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updatePad(Pad data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        Pad x = null;
        try {
            x = getPad(data.getBaseElementId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getBaseElementId() != data.getBaseElementId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updatePad.setInt(1,data.getBaseElementId());

            updatePad.setString(2,data.getPadName());

	        updatePad.setLong(3,data.getCommissionDate().get());

	        updatePad.setDouble(4,data.getXPosition().get());

	        updatePad.setDouble(5,data.getYPosition().get());

	        updatePad.setDouble(6,data.getZPosition().get());

          	updatePad.setInt(6 + 1, data.getBaseElementId());

			updatePad.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // CorrHWConfiguration
    /////////////////////////////////////////

    public void assignCorrHWConfiguration(CorrHWConfiguration x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setBaseElementId(result.getInt(1));

        x.setCorrHWName(result.getString(2));

        x.setCorrHWType(result.getString(3));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public CorrHWConfiguration getCorrHWConfiguration (int BaseElementId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getCorrHWConfigurationKey.setInt(1, BaseElementId);

            ResultSet result = getCorrHWConfigurationKey.executeQuery();
            CorrHWConfiguration x = new CorrHWConfiguration ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in CorrHWConfiguration tables with key " + 
                    BaseElementId);
            assignCorrHWConfiguration(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for CorrHWConfiguration table (key " + 
                    BaseElementId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public CorrHWConfiguration[] getCorrHWConfigurationWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<CorrHWConfiguration> list = new ArrayList<CorrHWConfiguration> ();
	    	CorrHWConfiguration item = null;
	    	String s = "SELECT * FROM CorrHWConfiguration";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new CorrHWConfiguration ();
	    		assignCorrHWConfiguration(item,result);
	    		list.add(item);
	    	}
	    	CorrHWConfiguration[] tmp = new CorrHWConfiguration [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addCorrHWConfiguration(CorrHWConfiguration data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    CorrHWConfiguration x = getCorrHWConfiguration(data.getBaseElementId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addCorrHWConfiguration.setInt(1,data.getBaseElementId());

            addCorrHWConfiguration.setString(2,data.getCorrHWName());

            addCorrHWConfiguration.setString(3,data.getCorrHWType());

			addCorrHWConfiguration.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addCorrHWConfiguration(CorrHWConfiguration data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				CorrHWConfiguration x = getCorrHWConfiguration(data.getBaseElementId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addCorrHWConfiguration(data);

    }

    public void deleteCorrHWConfiguration (int BaseElementId) throws AcsJTmcdbSqlEx {
        try {

          	deleteCorrHWConfigurationKey.setInt(1, BaseElementId);

			deleteCorrHWConfigurationKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateCorrHWConfiguration(CorrHWConfiguration data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        CorrHWConfiguration x = null;
        try {
            x = getCorrHWConfiguration(data.getBaseElementId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getBaseElementId() != data.getBaseElementId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateCorrHWConfiguration.setInt(1,data.getBaseElementId());

            updateCorrHWConfiguration.setString(2,data.getCorrHWName());

            updateCorrHWConfiguration.setString(3,data.getCorrHWType());

          	updateCorrHWConfiguration.setInt(3 + 1, data.getBaseElementId());

			updateCorrHWConfiguration.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // CorrQuadrant
    /////////////////////////////////////////

    public void assignCorrQuadrant(CorrQuadrant x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setCorrQuadrantId(result.getInt(1));

        x.setCorrHWConfigId(result.getInt(2));

        x.setBaseElementId(result.getInt(3));

        x.setCorrName(result.getString(4));

        x.setQuadrant(result.getInt(5));

        x.setChannelNumber(result.getInt(6));

        x.setNumberOfAntennas(result.getInt(7));

	    x.setCommissionDate(new ArrayTime(result.getLong(8)));

        x.setComponentId(result.getInt(9));

        x.setNumberOfRacks(result.getInt(10));

        x.setNumberOfBins(result.getInt(11));

	    x.setActive(result.getBoolean(12));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public CorrQuadrant getCorrQuadrant (int CorrQuadrantId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getCorrQuadrantKey.setInt(1, CorrQuadrantId);
            ResultSet result = getCorrQuadrantKey.executeQuery();
            CorrQuadrant x = new CorrQuadrant ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in CorrQuadrant tables with key " + 
                    CorrQuadrantId);

            assignCorrQuadrant(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for CorrQuadrant table (key " + 
                    CorrQuadrantId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public CorrQuadrant getCorrQuadrant (String CorrName, int Quadrant, int BaseElementId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getCorrQuadrantAlt.setString(1, CorrName);

            getCorrQuadrantAlt.setInt(2, Quadrant);

            getCorrQuadrantAlt.setInt(3, BaseElementId);

            ResultSet result = getCorrQuadrantAlt.executeQuery();
            CorrQuadrant x = new CorrQuadrant ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in CorrQuadrant tables with key " + 
                    CorrName + ", " + Quadrant + ", " + BaseElementId);

            assignCorrQuadrant(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for CorrQuadrant table (key " + 
                    CorrName + ", " + Quadrant + ", " + BaseElementId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public CorrQuadrant[] getCorrQuadrantWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<CorrQuadrant> list = new ArrayList<CorrQuadrant> ();
	    	CorrQuadrant item = null;
	    	String s = "SELECT * FROM CorrQuadrant";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new CorrQuadrant ();
	    		assignCorrQuadrant(item,result);
	    		list.add(item);
	    	}
	    	CorrQuadrant[] tmp = new CorrQuadrant [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addCorrQuadrant(CorrQuadrant data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addCorrQuadrant.setInt(1,data.getCorrHWConfigId());

            addCorrQuadrant.setInt(2,data.getBaseElementId());

            addCorrQuadrant.setString(3,data.getCorrName());

            addCorrQuadrant.setInt(4,data.getQuadrant());

            addCorrQuadrant.setInt(5,data.getChannelNumber());

            addCorrQuadrant.setInt(6,data.getNumberOfAntennas());

	        addCorrQuadrant.setLong(7,data.getCommissionDate().get());

            addCorrQuadrant.setInt(8,data.getComponentId());

            addCorrQuadrant.setInt(9,data.getNumberOfRacks());

            addCorrQuadrant.setInt(10,data.getNumberOfBins());

	        addCorrQuadrant.setBoolean(11,data.getActive());

		    addCorrQuadrant.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			CorrQuadrant addedRow = getCorrQuadrant (data.getCorrName(), data.getQuadrant(), data.getBaseElementId() );        
            return addedRow.getCorrQuadrantId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table CorrQuadrant!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addCorrQuadrant(CorrQuadrant data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			CorrQuadrant x = getCorrQuadrant(data.getCorrName(), data.getQuadrant(), data.getBaseElementId() );
	    		return x.getCorrQuadrantId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addCorrQuadrant(data);

    }

    public void deleteCorrQuadrant (int CorrQuadrantId) throws AcsJTmcdbSqlEx {
        try {
            deleteCorrQuadrantKey.setInt(1, CorrQuadrantId);
			deleteCorrQuadrantKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteCorrQuadrant (String CorrName, int Quadrant, int BaseElementId) throws AcsJTmcdbSqlEx {
        try {

            deleteCorrQuadrantAlt.setString(1, CorrName);

            deleteCorrQuadrantAlt.setInt(2, Quadrant);

            deleteCorrQuadrantAlt.setInt(3, BaseElementId);

			deleteCorrQuadrantAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateCorrQuadrant(CorrQuadrant data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        CorrQuadrant x = null;

        x = getCorrQuadrant(data.getCorrQuadrantId());

        // You can't change the keys.
		if (x.getCorrQuadrantId() != data.getCorrQuadrantId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getCorrName().equals(data.getCorrName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getQuadrant() != data.getQuadrant())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getBaseElementId() != data.getBaseElementId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateCorrQuadrant.setInt(1,data.getCorrQuadrantId());

            updateCorrQuadrant.setInt(2,data.getCorrHWConfigId());

            updateCorrQuadrant.setInt(3,data.getBaseElementId());

            updateCorrQuadrant.setString(4,data.getCorrName());

            updateCorrQuadrant.setInt(5,data.getQuadrant());

            updateCorrQuadrant.setInt(6,data.getChannelNumber());

            updateCorrQuadrant.setInt(7,data.getNumberOfAntennas());

	        updateCorrQuadrant.setLong(8,data.getCommissionDate().get());

            updateCorrQuadrant.setInt(9,data.getComponentId());

            updateCorrQuadrant.setInt(10,data.getNumberOfRacks());

            updateCorrQuadrant.setInt(11,data.getNumberOfBins());

	        updateCorrQuadrant.setBoolean(12,data.getActive());

      		updateCorrQuadrant.setInt(13, data.getCorrQuadrantId()); 
			updateCorrQuadrant.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // CorrQuadrantRack
    /////////////////////////////////////////

    public void assignCorrQuadrantRack(CorrQuadrantRack x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setCorrQuadrantRackId(result.getInt(1));

        x.setCorrQuadrantId(result.getInt(2));

        x.setRackName(result.getString(3));

        x.setRackType(result.getString(4));

        x.setNumberOfBins(result.getInt(5));

	    x.setActive(result.getBoolean(6));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public CorrQuadrantRack getCorrQuadrantRack (int CorrQuadrantRackId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getCorrQuadrantRackKey.setInt(1, CorrQuadrantRackId);
            ResultSet result = getCorrQuadrantRackKey.executeQuery();
            CorrQuadrantRack x = new CorrQuadrantRack ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in CorrQuadrantRack tables with key " + 
                    CorrQuadrantRackId);

            assignCorrQuadrantRack(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for CorrQuadrantRack table (key " + 
                    CorrQuadrantRackId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public CorrQuadrantRack getCorrQuadrantRack (String RackName, int CorrQuadrantId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getCorrQuadrantRackAlt.setString(1, RackName);

            getCorrQuadrantRackAlt.setInt(2, CorrQuadrantId);

            ResultSet result = getCorrQuadrantRackAlt.executeQuery();
            CorrQuadrantRack x = new CorrQuadrantRack ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in CorrQuadrantRack tables with key " + 
                    RackName + ", " + CorrQuadrantId);

            assignCorrQuadrantRack(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for CorrQuadrantRack table (key " + 
                    RackName + ", " + CorrQuadrantId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public CorrQuadrantRack[] getCorrQuadrantRackWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<CorrQuadrantRack> list = new ArrayList<CorrQuadrantRack> ();
	    	CorrQuadrantRack item = null;
	    	String s = "SELECT * FROM CorrQuadrantRack";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new CorrQuadrantRack ();
	    		assignCorrQuadrantRack(item,result);
	    		list.add(item);
	    	}
	    	CorrQuadrantRack[] tmp = new CorrQuadrantRack [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addCorrQuadrantRack(CorrQuadrantRack data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addCorrQuadrantRack.setInt(1,data.getCorrQuadrantId());

            addCorrQuadrantRack.setString(2,data.getRackName());

            addCorrQuadrantRack.setString(3,data.getRackType());

            addCorrQuadrantRack.setInt(4,data.getNumberOfBins());

	        addCorrQuadrantRack.setBoolean(5,data.getActive());

		    addCorrQuadrantRack.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			CorrQuadrantRack addedRow = getCorrQuadrantRack (data.getRackName(), data.getCorrQuadrantId() );        
            return addedRow.getCorrQuadrantRackId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table CorrQuadrantRack!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addCorrQuadrantRack(CorrQuadrantRack data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			CorrQuadrantRack x = getCorrQuadrantRack(data.getRackName(), data.getCorrQuadrantId() );
	    		return x.getCorrQuadrantRackId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addCorrQuadrantRack(data);

    }

    public void deleteCorrQuadrantRack (int CorrQuadrantRackId) throws AcsJTmcdbSqlEx {
        try {
            deleteCorrQuadrantRackKey.setInt(1, CorrQuadrantRackId);
			deleteCorrQuadrantRackKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteCorrQuadrantRack (String RackName, int CorrQuadrantId) throws AcsJTmcdbSqlEx {
        try {

            deleteCorrQuadrantRackAlt.setString(1, RackName);

            deleteCorrQuadrantRackAlt.setInt(2, CorrQuadrantId);

			deleteCorrQuadrantRackAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateCorrQuadrantRack(CorrQuadrantRack data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        CorrQuadrantRack x = null;

        x = getCorrQuadrantRack(data.getCorrQuadrantRackId());

        // You can't change the keys.
		if (x.getCorrQuadrantRackId() != data.getCorrQuadrantRackId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getRackName().equals(data.getRackName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getCorrQuadrantId() != data.getCorrQuadrantId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateCorrQuadrantRack.setInt(1,data.getCorrQuadrantRackId());

            updateCorrQuadrantRack.setInt(2,data.getCorrQuadrantId());

            updateCorrQuadrantRack.setString(3,data.getRackName());

            updateCorrQuadrantRack.setString(4,data.getRackType());

            updateCorrQuadrantRack.setInt(5,data.getNumberOfBins());

	        updateCorrQuadrantRack.setBoolean(6,data.getActive());

      		updateCorrQuadrantRack.setInt(7, data.getCorrQuadrantRackId()); 
			updateCorrQuadrantRack.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // CorrStationBin
    /////////////////////////////////////////

    public void assignCorrStationBin(CorrStationBin x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setCorrStationBinId(result.getInt(1));

        x.setCorrQuadrantRackId(result.getInt(2));

        x.setStationBinName(result.getString(3));

        x.setStationNodeAddr(result.getInt(4));

        x.setNumberOfStationCards(result.getInt(5));

        x.setNumberOfTFBCards(result.getInt(6));

        x.setNumberOfDRXCards(result.getInt(7));

        x.setNumberOfInterfaceCards(result.getInt(8));

        x.setNumberOfPSCards(result.getInt(9));

	    x.setActive(result.getBoolean(10));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public CorrStationBin getCorrStationBin (int CorrStationBinId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getCorrStationBinKey.setInt(1, CorrStationBinId);
            ResultSet result = getCorrStationBinKey.executeQuery();
            CorrStationBin x = new CorrStationBin ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in CorrStationBin tables with key " + 
                    CorrStationBinId);

            assignCorrStationBin(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for CorrStationBin table (key " + 
                    CorrStationBinId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public CorrStationBin getCorrStationBin (String StationBinName, int CorrQuadrantRackId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getCorrStationBinAlt.setString(1, StationBinName);

            getCorrStationBinAlt.setInt(2, CorrQuadrantRackId);

            ResultSet result = getCorrStationBinAlt.executeQuery();
            CorrStationBin x = new CorrStationBin ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in CorrStationBin tables with key " + 
                    StationBinName + ", " + CorrQuadrantRackId);

            assignCorrStationBin(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for CorrStationBin table (key " + 
                    StationBinName + ", " + CorrQuadrantRackId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public CorrStationBin[] getCorrStationBinWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<CorrStationBin> list = new ArrayList<CorrStationBin> ();
	    	CorrStationBin item = null;
	    	String s = "SELECT * FROM CorrStationBin";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new CorrStationBin ();
	    		assignCorrStationBin(item,result);
	    		list.add(item);
	    	}
	    	CorrStationBin[] tmp = new CorrStationBin [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addCorrStationBin(CorrStationBin data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addCorrStationBin.setInt(1,data.getCorrQuadrantRackId());

            addCorrStationBin.setString(2,data.getStationBinName());

            addCorrStationBin.setInt(3,data.getStationNodeAddr());

            addCorrStationBin.setInt(4,data.getNumberOfStationCards());

            addCorrStationBin.setInt(5,data.getNumberOfTFBCards());

            addCorrStationBin.setInt(6,data.getNumberOfDRXCards());

            addCorrStationBin.setInt(7,data.getNumberOfInterfaceCards());

            addCorrStationBin.setInt(8,data.getNumberOfPSCards());

	        addCorrStationBin.setBoolean(9,data.getActive());

		    addCorrStationBin.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			CorrStationBin addedRow = getCorrStationBin (data.getStationBinName(), data.getCorrQuadrantRackId() );        
            return addedRow.getCorrStationBinId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table CorrStationBin!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addCorrStationBin(CorrStationBin data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			CorrStationBin x = getCorrStationBin(data.getStationBinName(), data.getCorrQuadrantRackId() );
	    		return x.getCorrStationBinId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addCorrStationBin(data);

    }

    public void deleteCorrStationBin (int CorrStationBinId) throws AcsJTmcdbSqlEx {
        try {
            deleteCorrStationBinKey.setInt(1, CorrStationBinId);
			deleteCorrStationBinKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteCorrStationBin (String StationBinName, int CorrQuadrantRackId) throws AcsJTmcdbSqlEx {
        try {

            deleteCorrStationBinAlt.setString(1, StationBinName);

            deleteCorrStationBinAlt.setInt(2, CorrQuadrantRackId);

			deleteCorrStationBinAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateCorrStationBin(CorrStationBin data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        CorrStationBin x = null;

        x = getCorrStationBin(data.getCorrStationBinId());

        // You can't change the keys.
		if (x.getCorrStationBinId() != data.getCorrStationBinId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getStationBinName().equals(data.getStationBinName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getCorrQuadrantRackId() != data.getCorrQuadrantRackId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateCorrStationBin.setInt(1,data.getCorrStationBinId());

            updateCorrStationBin.setInt(2,data.getCorrQuadrantRackId());

            updateCorrStationBin.setString(3,data.getStationBinName());

            updateCorrStationBin.setInt(4,data.getStationNodeAddr());

            updateCorrStationBin.setInt(5,data.getNumberOfStationCards());

            updateCorrStationBin.setInt(6,data.getNumberOfTFBCards());

            updateCorrStationBin.setInt(7,data.getNumberOfDRXCards());

            updateCorrStationBin.setInt(8,data.getNumberOfInterfaceCards());

            updateCorrStationBin.setInt(9,data.getNumberOfPSCards());

	        updateCorrStationBin.setBoolean(10,data.getActive());

      		updateCorrStationBin.setInt(11, data.getCorrStationBinId()); 
			updateCorrStationBin.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // CorrelatorBin
    /////////////////////////////////////////

    public void assignCorrelatorBin(CorrelatorBin x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setCorrelatorBinId(result.getInt(1));

        x.setCorrQuadrantRackId(result.getInt(2));

        x.setCorrelatorBinName(result.getString(3));

        x.setLTANodeAddr(result.getInt(4));

        x.setNumberOfCorrelatorCards(result.getInt(5));

        x.setNumberOfInterfaceCards(result.getInt(6));

        x.setNumberOfPSCards(result.getInt(7));

	    x.setActive(result.getBoolean(8));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public CorrelatorBin getCorrelatorBin (int CorrelatorBinId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getCorrelatorBinKey.setInt(1, CorrelatorBinId);
            ResultSet result = getCorrelatorBinKey.executeQuery();
            CorrelatorBin x = new CorrelatorBin ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in CorrelatorBin tables with key " + 
                    CorrelatorBinId);

            assignCorrelatorBin(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for CorrelatorBin table (key " + 
                    CorrelatorBinId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public CorrelatorBin getCorrelatorBin (String CorrelatorBinName, int CorrQuadrantRackId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getCorrelatorBinAlt.setString(1, CorrelatorBinName);

            getCorrelatorBinAlt.setInt(2, CorrQuadrantRackId);

            ResultSet result = getCorrelatorBinAlt.executeQuery();
            CorrelatorBin x = new CorrelatorBin ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in CorrelatorBin tables with key " + 
                    CorrelatorBinName + ", " + CorrQuadrantRackId);

            assignCorrelatorBin(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for CorrelatorBin table (key " + 
                    CorrelatorBinName + ", " + CorrQuadrantRackId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public CorrelatorBin[] getCorrelatorBinWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<CorrelatorBin> list = new ArrayList<CorrelatorBin> ();
	    	CorrelatorBin item = null;
	    	String s = "SELECT * FROM CorrelatorBin";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new CorrelatorBin ();
	    		assignCorrelatorBin(item,result);
	    		list.add(item);
	    	}
	    	CorrelatorBin[] tmp = new CorrelatorBin [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addCorrelatorBin(CorrelatorBin data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addCorrelatorBin.setInt(1,data.getCorrQuadrantRackId());

            addCorrelatorBin.setString(2,data.getCorrelatorBinName());

            addCorrelatorBin.setInt(3,data.getLTANodeAddr());

            addCorrelatorBin.setInt(4,data.getNumberOfCorrelatorCards());

            addCorrelatorBin.setInt(5,data.getNumberOfInterfaceCards());

            addCorrelatorBin.setInt(6,data.getNumberOfPSCards());

	        addCorrelatorBin.setBoolean(7,data.getActive());

		    addCorrelatorBin.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			CorrelatorBin addedRow = getCorrelatorBin (data.getCorrelatorBinName(), data.getCorrQuadrantRackId() );        
            return addedRow.getCorrelatorBinId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table CorrelatorBin!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addCorrelatorBin(CorrelatorBin data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			CorrelatorBin x = getCorrelatorBin(data.getCorrelatorBinName(), data.getCorrQuadrantRackId() );
	    		return x.getCorrelatorBinId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addCorrelatorBin(data);

    }

    public void deleteCorrelatorBin (int CorrelatorBinId) throws AcsJTmcdbSqlEx {
        try {
            deleteCorrelatorBinKey.setInt(1, CorrelatorBinId);
			deleteCorrelatorBinKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteCorrelatorBin (String CorrelatorBinName, int CorrQuadrantRackId) throws AcsJTmcdbSqlEx {
        try {

            deleteCorrelatorBinAlt.setString(1, CorrelatorBinName);

            deleteCorrelatorBinAlt.setInt(2, CorrQuadrantRackId);

			deleteCorrelatorBinAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateCorrelatorBin(CorrelatorBin data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        CorrelatorBin x = null;

        x = getCorrelatorBin(data.getCorrelatorBinId());

        // You can't change the keys.
		if (x.getCorrelatorBinId() != data.getCorrelatorBinId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getCorrelatorBinName().equals(data.getCorrelatorBinName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getCorrQuadrantRackId() != data.getCorrQuadrantRackId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateCorrelatorBin.setInt(1,data.getCorrelatorBinId());

            updateCorrelatorBin.setInt(2,data.getCorrQuadrantRackId());

            updateCorrelatorBin.setString(3,data.getCorrelatorBinName());

            updateCorrelatorBin.setInt(4,data.getLTANodeAddr());

            updateCorrelatorBin.setInt(5,data.getNumberOfCorrelatorCards());

            updateCorrelatorBin.setInt(6,data.getNumberOfInterfaceCards());

            updateCorrelatorBin.setInt(7,data.getNumberOfPSCards());

	        updateCorrelatorBin.setBoolean(8,data.getActive());

      		updateCorrelatorBin.setInt(9, data.getCorrelatorBinId()); 
			updateCorrelatorBin.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // FrontEnd
    /////////////////////////////////////////

    public void assignFrontEnd(FrontEnd x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setBaseElementId(result.getInt(1));

	    x.setCommissionDate(new ArrayTime(result.getLong(2)));

        x.setComponentId(result.getInt(3));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public FrontEnd getFrontEnd (int BaseElementId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getFrontEndKey.setInt(1, BaseElementId);

            ResultSet result = getFrontEndKey.executeQuery();
            FrontEnd x = new FrontEnd ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in FrontEnd tables with key " + 
                    BaseElementId);
            assignFrontEnd(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for FrontEnd table (key " + 
                    BaseElementId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public FrontEnd[] getFrontEndWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<FrontEnd> list = new ArrayList<FrontEnd> ();
	    	FrontEnd item = null;
	    	String s = "SELECT * FROM FrontEnd";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new FrontEnd ();
	    		assignFrontEnd(item,result);
	    		list.add(item);
	    	}
	    	FrontEnd[] tmp = new FrontEnd [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addFrontEnd(FrontEnd data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    FrontEnd x = getFrontEnd(data.getBaseElementId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addFrontEnd.setInt(1,data.getBaseElementId());

	        addFrontEnd.setLong(2,data.getCommissionDate().get());

            addFrontEnd.setInt(3,data.getComponentId());

			addFrontEnd.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addFrontEnd(FrontEnd data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				FrontEnd x = getFrontEnd(data.getBaseElementId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addFrontEnd(data);

    }

    public void deleteFrontEnd (int BaseElementId) throws AcsJTmcdbSqlEx {
        try {

          	deleteFrontEndKey.setInt(1, BaseElementId);

			deleteFrontEndKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateFrontEnd(FrontEnd data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        FrontEnd x = null;
        try {
            x = getFrontEnd(data.getBaseElementId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getBaseElementId() != data.getBaseElementId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateFrontEnd.setInt(1,data.getBaseElementId());

	        updateFrontEnd.setLong(2,data.getCommissionDate().get());

            updateFrontEnd.setInt(3,data.getComponentId());

          	updateFrontEnd.setInt(3 + 1, data.getBaseElementId());

			updateFrontEnd.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // WeatherStation
    /////////////////////////////////////////

    public void assignWeatherStation(WeatherStation x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setBaseElementId(result.getInt(1));

        x.setSerialNumber(result.getString(2));

        x.setWeatherStationType(result.getString(3));

	    x.setCommissionDate(new ArrayTime(result.getLong(4)));

	    x.setXPosition(new Length(result.getDouble(5)));

	    x.setYPosition(new Length(result.getDouble(6)));

	    x.setZPosition(new Length(result.getDouble(7)));

        x.setComponentId(result.getInt(8));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public WeatherStation getWeatherStation (int BaseElementId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getWeatherStationKey.setInt(1, BaseElementId);

            ResultSet result = getWeatherStationKey.executeQuery();
            WeatherStation x = new WeatherStation ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in WeatherStation tables with key " + 
                    BaseElementId);
            assignWeatherStation(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for WeatherStation table (key " + 
                    BaseElementId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public WeatherStation[] getWeatherStationWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<WeatherStation> list = new ArrayList<WeatherStation> ();
	    	WeatherStation item = null;
	    	String s = "SELECT * FROM WeatherStation";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new WeatherStation ();
	    		assignWeatherStation(item,result);
	    		list.add(item);
	    	}
	    	WeatherStation[] tmp = new WeatherStation [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addWeatherStation(WeatherStation data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    WeatherStation x = getWeatherStation(data.getBaseElementId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addWeatherStation.setInt(1,data.getBaseElementId());

            addWeatherStation.setString(2,data.getSerialNumber());

            addWeatherStation.setString(3,data.getWeatherStationType());

	        addWeatherStation.setLong(4,data.getCommissionDate().get());

	        addWeatherStation.setDouble(5,data.getXPosition().get());

	        addWeatherStation.setDouble(6,data.getYPosition().get());

	        addWeatherStation.setDouble(7,data.getZPosition().get());

            addWeatherStation.setInt(8,data.getComponentId());

			addWeatherStation.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addWeatherStation(WeatherStation data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				WeatherStation x = getWeatherStation(data.getBaseElementId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addWeatherStation(data);

    }

    public void deleteWeatherStation (int BaseElementId) throws AcsJTmcdbSqlEx {
        try {

          	deleteWeatherStationKey.setInt(1, BaseElementId);

			deleteWeatherStationKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateWeatherStation(WeatherStation data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        WeatherStation x = null;
        try {
            x = getWeatherStation(data.getBaseElementId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getBaseElementId() != data.getBaseElementId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateWeatherStation.setInt(1,data.getBaseElementId());

            updateWeatherStation.setString(2,data.getSerialNumber());

            updateWeatherStation.setString(3,data.getWeatherStationType());

	        updateWeatherStation.setLong(4,data.getCommissionDate().get());

	        updateWeatherStation.setDouble(5,data.getXPosition().get());

	        updateWeatherStation.setDouble(6,data.getYPosition().get());

	        updateWeatherStation.setDouble(7,data.getZPosition().get());

            updateWeatherStation.setInt(8,data.getComponentId());

          	updateWeatherStation.setInt(8 + 1, data.getBaseElementId());

			updateWeatherStation.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // CentralRack
    /////////////////////////////////////////

    public void assignCentralRack(CentralRack x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setBaseElementId(result.getInt(1));

	    x.setCommissionDate(new ArrayTime(result.getLong(2)));

        x.setComponentId(result.getInt(3));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public CentralRack getCentralRack (int BaseElementId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getCentralRackKey.setInt(1, BaseElementId);

            ResultSet result = getCentralRackKey.executeQuery();
            CentralRack x = new CentralRack ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in CentralRack tables with key " + 
                    BaseElementId);
            assignCentralRack(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for CentralRack table (key " + 
                    BaseElementId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public CentralRack[] getCentralRackWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<CentralRack> list = new ArrayList<CentralRack> ();
	    	CentralRack item = null;
	    	String s = "SELECT * FROM CentralRack";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new CentralRack ();
	    		assignCentralRack(item,result);
	    		list.add(item);
	    	}
	    	CentralRack[] tmp = new CentralRack [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addCentralRack(CentralRack data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    CentralRack x = getCentralRack(data.getBaseElementId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addCentralRack.setInt(1,data.getBaseElementId());

	        addCentralRack.setLong(2,data.getCommissionDate().get());

            addCentralRack.setInt(3,data.getComponentId());

			addCentralRack.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addCentralRack(CentralRack data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				CentralRack x = getCentralRack(data.getBaseElementId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addCentralRack(data);

    }

    public void deleteCentralRack (int BaseElementId) throws AcsJTmcdbSqlEx {
        try {

          	deleteCentralRackKey.setInt(1, BaseElementId);

			deleteCentralRackKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateCentralRack(CentralRack data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        CentralRack x = null;
        try {
            x = getCentralRack(data.getBaseElementId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getBaseElementId() != data.getBaseElementId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateCentralRack.setInt(1,data.getBaseElementId());

	        updateCentralRack.setLong(2,data.getCommissionDate().get());

            updateCentralRack.setInt(3,data.getComponentId());

          	updateCentralRack.setInt(3 + 1, data.getBaseElementId());

			updateCentralRack.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // MasterClock
    /////////////////////////////////////////

    public void assignMasterClock(MasterClock x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setBaseElementId(result.getInt(1));

	    x.setCommissionDate(new ArrayTime(result.getLong(2)));

        x.setComponentId(result.getInt(3));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public MasterClock getMasterClock (int BaseElementId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getMasterClockKey.setInt(1, BaseElementId);

            ResultSet result = getMasterClockKey.executeQuery();
            MasterClock x = new MasterClock ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in MasterClock tables with key " + 
                    BaseElementId);
            assignMasterClock(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for MasterClock table (key " + 
                    BaseElementId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public MasterClock[] getMasterClockWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<MasterClock> list = new ArrayList<MasterClock> ();
	    	MasterClock item = null;
	    	String s = "SELECT * FROM MasterClock";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new MasterClock ();
	    		assignMasterClock(item,result);
	    		list.add(item);
	    	}
	    	MasterClock[] tmp = new MasterClock [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addMasterClock(MasterClock data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    MasterClock x = getMasterClock(data.getBaseElementId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addMasterClock.setInt(1,data.getBaseElementId());

	        addMasterClock.setLong(2,data.getCommissionDate().get());

            addMasterClock.setInt(3,data.getComponentId());

			addMasterClock.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addMasterClock(MasterClock data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				MasterClock x = getMasterClock(data.getBaseElementId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addMasterClock(data);

    }

    public void deleteMasterClock (int BaseElementId) throws AcsJTmcdbSqlEx {
        try {

          	deleteMasterClockKey.setInt(1, BaseElementId);

			deleteMasterClockKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateMasterClock(MasterClock data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        MasterClock x = null;
        try {
            x = getMasterClock(data.getBaseElementId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getBaseElementId() != data.getBaseElementId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateMasterClock.setInt(1,data.getBaseElementId());

	        updateMasterClock.setLong(2,data.getCommissionDate().get());

            updateMasterClock.setInt(3,data.getComponentId());

          	updateMasterClock.setInt(3 + 1, data.getBaseElementId());

			updateMasterClock.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // HolographyTower
    /////////////////////////////////////////

    public void assignHolographyTower(HolographyTower x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setBaseElementId(result.getInt(1));

	    x.setCommissionDate(new ArrayTime(result.getLong(2)));

	    x.setXPosition(new Length(result.getDouble(3)));

	    x.setYPosition(new Length(result.getDouble(4)));

	    x.setZPosition(new Length(result.getDouble(5)));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public HolographyTower getHolographyTower (int BaseElementId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getHolographyTowerKey.setInt(1, BaseElementId);

            ResultSet result = getHolographyTowerKey.executeQuery();
            HolographyTower x = new HolographyTower ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in HolographyTower tables with key " + 
                    BaseElementId);
            assignHolographyTower(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for HolographyTower table (key " + 
                    BaseElementId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public HolographyTower[] getHolographyTowerWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<HolographyTower> list = new ArrayList<HolographyTower> ();
	    	HolographyTower item = null;
	    	String s = "SELECT * FROM HolographyTower";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new HolographyTower ();
	    		assignHolographyTower(item,result);
	    		list.add(item);
	    	}
	    	HolographyTower[] tmp = new HolographyTower [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addHolographyTower(HolographyTower data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    HolographyTower x = getHolographyTower(data.getBaseElementId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addHolographyTower.setInt(1,data.getBaseElementId());

	        addHolographyTower.setLong(2,data.getCommissionDate().get());

	        addHolographyTower.setDouble(3,data.getXPosition().get());

	        addHolographyTower.setDouble(4,data.getYPosition().get());

	        addHolographyTower.setDouble(5,data.getZPosition().get());

			addHolographyTower.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addHolographyTower(HolographyTower data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				HolographyTower x = getHolographyTower(data.getBaseElementId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addHolographyTower(data);

    }

    public void deleteHolographyTower (int BaseElementId) throws AcsJTmcdbSqlEx {
        try {

          	deleteHolographyTowerKey.setInt(1, BaseElementId);

			deleteHolographyTowerKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateHolographyTower(HolographyTower data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        HolographyTower x = null;
        try {
            x = getHolographyTower(data.getBaseElementId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getBaseElementId() != data.getBaseElementId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateHolographyTower.setInt(1,data.getBaseElementId());

	        updateHolographyTower.setLong(2,data.getCommissionDate().get());

	        updateHolographyTower.setDouble(3,data.getXPosition().get());

	        updateHolographyTower.setDouble(4,data.getYPosition().get());

	        updateHolographyTower.setDouble(5,data.getZPosition().get());

          	updateHolographyTower.setInt(5 + 1, data.getBaseElementId());

			updateHolographyTower.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // Array
    /////////////////////////////////////////

    public void assignArray(Array x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setArrayId(result.getInt(1));

        x.setBaseElementId(result.getInt(2));

        x.setType(result.getString(3));

        x.setUserId(result.getString(4));

        // if (result.wasNull())
        // 	x.setUserIdNull();

	    x.setStartTime(new ArrayTime(result.getLong(5)));

	    x.setEndTime(new ArrayTime(result.getLong(6)));

        // if (result.wasNull())
        // 	x.setEndTimeNull();

	    x.setNormalTermination(result.getBoolean(7));

        x.setComponentId(result.getInt(8));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public Array getArray (int ArrayId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getArrayKey.setInt(1, ArrayId);
            ResultSet result = getArrayKey.executeQuery();
            Array x = new Array ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Array tables with key " + 
                    ArrayId);

            assignArray(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Array table (key " + 
                    ArrayId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public Array getArray (ArrayTime StartTime, int BaseElementId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

	      	getArrayAlt.setLong(1, StartTime.get());

            getArrayAlt.setInt(2, BaseElementId);

            ResultSet result = getArrayAlt.executeQuery();
            Array x = new Array ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Array tables with key " + 
                    StartTime + ", " + BaseElementId);

            assignArray(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Array table (key " + 
                    StartTime + ", " + BaseElementId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public Array[] getArrayWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<Array> list = new ArrayList<Array> ();
	    	Array item = null;
	    	String s = "SELECT * FROM Array";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new Array ();
	    		assignArray(item,result);
	    		list.add(item);
	    	}
	    	Array[] tmp = new Array [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addArray(Array data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addArray.setInt(1,data.getBaseElementId());

            addArray.setString(2,data.getType());

            addArray.setString(3,data.getUserId());

	        addArray.setLong(4,data.getStartTime().get());

	        addArray.setLong(5,data.getEndTime().get());

	        addArray.setBoolean(6,data.getNormalTermination());

            addArray.setInt(7,data.getComponentId());

		    addArray.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			Array addedRow = getArray (data.getStartTime(), data.getBaseElementId() );        
            return addedRow.getArrayId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table Array!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addArray(Array data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			Array x = getArray(data.getStartTime(), data.getBaseElementId() );
	    		return x.getArrayId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addArray(data);

    }

    public void deleteArray (int ArrayId) throws AcsJTmcdbSqlEx {
        try {
            deleteArrayKey.setInt(1, ArrayId);
			deleteArrayKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteArray (ArrayTime StartTime, int BaseElementId) throws AcsJTmcdbSqlEx {
        try {

	      	deleteArrayAlt.setLong(1, StartTime.get());

            deleteArrayAlt.setInt(2, BaseElementId);

			deleteArrayAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateArray(Array data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        Array x = null;

        x = getArray(data.getArrayId());

        // You can't change the keys.
		if (x.getArrayId() != data.getArrayId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartTime().get() != data.getStartTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getBaseElementId() != data.getBaseElementId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateArray.setInt(1,data.getArrayId());

            updateArray.setInt(2,data.getBaseElementId());

            updateArray.setString(3,data.getType());

            updateArray.setString(4,data.getUserId());

	        updateArray.setLong(5,data.getStartTime().get());

	        updateArray.setLong(6,data.getEndTime().get());

	        updateArray.setBoolean(7,data.getNormalTermination());

            updateArray.setInt(8,data.getComponentId());

      		updateArray.setInt(9, data.getArrayId()); 
			updateArray.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // AntennaToPad
    /////////////////////////////////////////

    public void assignAntennaToPad(AntennaToPad x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setAntennaId(result.getInt(1));

        x.setPadId(result.getInt(2));

	    x.setStartTime(new ArrayTime(result.getLong(3)));

	    x.setEndTime(new ArrayTime(result.getLong(4)));

        // if (result.wasNull())
        // 	x.setEndTimeNull();

	    x.setPlanned(result.getBoolean(5));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public AntennaToPad getAntennaToPad (int AntennaId, int PadId, ArrayTime StartTime) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getAntennaToPadKey.setInt(1, AntennaId);

          	getAntennaToPadKey.setInt(2, PadId);

	      	getAntennaToPadKey.setLong(3, StartTime.get());

            ResultSet result = getAntennaToPadKey.executeQuery();
            AntennaToPad x = new AntennaToPad ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AntennaToPad tables with key " + 
                    AntennaId + ", " + PadId + ", " + StartTime);
            assignAntennaToPad(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for AntennaToPad table (key " + 
                    AntennaId + ", " + PadId + ", " + StartTime + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public AntennaToPad[] getAntennaToPadWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<AntennaToPad> list = new ArrayList<AntennaToPad> ();
	    	AntennaToPad item = null;
	    	String s = "SELECT * FROM AntennaToPad";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new AntennaToPad ();
	    		assignAntennaToPad(item,result);
	    		list.add(item);
	    	}
	    	AntennaToPad[] tmp = new AntennaToPad [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAntennaToPad(AntennaToPad data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    AntennaToPad x = getAntennaToPad(data.getAntennaId(), data.getPadId(), data.getStartTime());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addAntennaToPad.setInt(1,data.getAntennaId());

            addAntennaToPad.setInt(2,data.getPadId());

	        addAntennaToPad.setLong(3,data.getStartTime().get());

	        addAntennaToPad.setLong(4,data.getEndTime().get());

	        addAntennaToPad.setBoolean(5,data.getPlanned());

			addAntennaToPad.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addAntennaToPad(AntennaToPad data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				AntennaToPad x = getAntennaToPad(data.getAntennaId(), data.getPadId(), data.getStartTime());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addAntennaToPad(data);

    }

    public void deleteAntennaToPad (int AntennaId, int PadId, ArrayTime StartTime) throws AcsJTmcdbSqlEx {
        try {

          	deleteAntennaToPadKey.setInt(1, AntennaId);

          	deleteAntennaToPadKey.setInt(2, PadId);

	      	deleteAntennaToPadKey.setLong(3, StartTime.get());

			deleteAntennaToPadKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAntennaToPad(AntennaToPad data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        AntennaToPad x = null;
        try {
            x = getAntennaToPad(data.getAntennaId(), data.getPadId(), data.getStartTime());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getAntennaId() != data.getAntennaId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getPadId() != data.getPadId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartTime().get() != data.getStartTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAntennaToPad.setInt(1,data.getAntennaId());

            updateAntennaToPad.setInt(2,data.getPadId());

	        updateAntennaToPad.setLong(3,data.getStartTime().get());

	        updateAntennaToPad.setLong(4,data.getEndTime().get());

	        updateAntennaToPad.setBoolean(5,data.getPlanned());

          	updateAntennaToPad.setInt(5 + 1, data.getAntennaId());

          	updateAntennaToPad.setInt(5 + 2, data.getPadId());

	      	updateAntennaToPad.setLong(5 + 3, data.getStartTime().get());

			updateAntennaToPad.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // AntennaPointingModel
    /////////////////////////////////////////

    public void assignAntennaPointingModel(AntennaPointingModel x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setPointingModelId(result.getInt(1));

        x.setAntennaId(result.getInt(2));

        x.setPadId(result.getInt(3));

        x.setReceiverBand(result.getString(4));

	    x.setStartTime(new ArrayTime(result.getLong(5)));

	    x.setStartValidTime(new ArrayTime(result.getLong(6)));

	    x.setEndValidTime(new ArrayTime(result.getLong(7)));

        // if (result.wasNull())
        // 	x.setEndValidTimeNull();

        x.setAsdmUID(result.getString(8));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public AntennaPointingModel getAntennaPointingModel (int PointingModelId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getAntennaPointingModelKey.setInt(1, PointingModelId);
            ResultSet result = getAntennaPointingModelKey.executeQuery();
            AntennaPointingModel x = new AntennaPointingModel ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AntennaPointingModel tables with key " + 
                    PointingModelId);

            assignAntennaPointingModel(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for AntennaPointingModel table (key " + 
                    PointingModelId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public AntennaPointingModel getAntennaPointingModel (int AntennaId, int PadId, String ReceiverBand, ArrayTime StartValidTime) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getAntennaPointingModelAlt.setInt(1, AntennaId);

            getAntennaPointingModelAlt.setInt(2, PadId);

            getAntennaPointingModelAlt.setString(3, ReceiverBand);

	      	getAntennaPointingModelAlt.setLong(4, StartValidTime.get());

            ResultSet result = getAntennaPointingModelAlt.executeQuery();
            AntennaPointingModel x = new AntennaPointingModel ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AntennaPointingModel tables with key " + 
                    AntennaId + ", " + PadId + ", " + ReceiverBand + ", " + StartValidTime);

            assignAntennaPointingModel(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for AntennaPointingModel table (key " + 
                    AntennaId + ", " + PadId + ", " + ReceiverBand + ", " + StartValidTime + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public AntennaPointingModel[] getAntennaPointingModelWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<AntennaPointingModel> list = new ArrayList<AntennaPointingModel> ();
	    	AntennaPointingModel item = null;
	    	String s = "SELECT * FROM AntennaPointingModel";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new AntennaPointingModel ();
	    		assignAntennaPointingModel(item,result);
	    		list.add(item);
	    	}
	    	AntennaPointingModel[] tmp = new AntennaPointingModel [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAntennaPointingModel(AntennaPointingModel data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addAntennaPointingModel.setInt(1,data.getAntennaId());

            addAntennaPointingModel.setInt(2,data.getPadId());

            addAntennaPointingModel.setString(3,data.getReceiverBand());

	        addAntennaPointingModel.setLong(4,data.getStartTime().get());

	        addAntennaPointingModel.setLong(5,data.getStartValidTime().get());

	        addAntennaPointingModel.setLong(6,data.getEndValidTime().get());

            addAntennaPointingModel.setString(7,data.getAsdmUID());

		    addAntennaPointingModel.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			AntennaPointingModel addedRow = getAntennaPointingModel (data.getAntennaId(), data.getPadId(), data.getReceiverBand(), data.getStartValidTime() );        
            return addedRow.getPointingModelId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table AntennaPointingModel!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addAntennaPointingModel(AntennaPointingModel data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			AntennaPointingModel x = getAntennaPointingModel(data.getAntennaId(), data.getPadId(), data.getReceiverBand(), data.getStartValidTime() );
	    		return x.getPointingModelId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addAntennaPointingModel(data);

    }

    public void deleteAntennaPointingModel (int PointingModelId) throws AcsJTmcdbSqlEx {
        try {
            deleteAntennaPointingModelKey.setInt(1, PointingModelId);
			deleteAntennaPointingModelKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteAntennaPointingModel (int AntennaId, int PadId, String ReceiverBand, ArrayTime StartValidTime) throws AcsJTmcdbSqlEx {
        try {

            deleteAntennaPointingModelAlt.setInt(1, AntennaId);

            deleteAntennaPointingModelAlt.setInt(2, PadId);

            deleteAntennaPointingModelAlt.setString(3, ReceiverBand);

	      	deleteAntennaPointingModelAlt.setLong(4, StartValidTime.get());

			deleteAntennaPointingModelAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAntennaPointingModel(AntennaPointingModel data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        AntennaPointingModel x = null;

        x = getAntennaPointingModel(data.getPointingModelId());

        // You can't change the keys.
		if (x.getPointingModelId() != data.getPointingModelId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getAntennaId() != data.getAntennaId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getPadId() != data.getPadId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getReceiverBand().equals(data.getReceiverBand()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartValidTime().get() != data.getStartValidTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAntennaPointingModel.setInt(1,data.getPointingModelId());

            updateAntennaPointingModel.setInt(2,data.getAntennaId());

            updateAntennaPointingModel.setInt(3,data.getPadId());

            updateAntennaPointingModel.setString(4,data.getReceiverBand());

	        updateAntennaPointingModel.setLong(5,data.getStartTime().get());

	        updateAntennaPointingModel.setLong(6,data.getStartValidTime().get());

	        updateAntennaPointingModel.setLong(7,data.getEndValidTime().get());

            updateAntennaPointingModel.setString(8,data.getAsdmUID());

      		updateAntennaPointingModel.setInt(9, data.getPointingModelId()); 
			updateAntennaPointingModel.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // AntennaPointingModelTerm
    /////////////////////////////////////////

    public void assignAntennaPointingModelTerm(AntennaPointingModelTerm x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setPointingModelId(result.getInt(1));

        x.setCoeffName(result.getString(2));

        x.setCoeffValue(result.getFloat(3));

        x.setCoeffError(result.getFloat(4));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public AntennaPointingModelTerm getAntennaPointingModelTerm (int PointingModelId, String CoeffName) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getAntennaPointingModelTermKey.setInt(1, PointingModelId);

          	getAntennaPointingModelTermKey.setString(2, CoeffName);

            ResultSet result = getAntennaPointingModelTermKey.executeQuery();
            AntennaPointingModelTerm x = new AntennaPointingModelTerm ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AntennaPointingModelTerm tables with key " + 
                    PointingModelId + ", " + CoeffName);
            assignAntennaPointingModelTerm(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for AntennaPointingModelTerm table (key " + 
                    PointingModelId + ", " + CoeffName + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public AntennaPointingModelTerm[] getAntennaPointingModelTermWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<AntennaPointingModelTerm> list = new ArrayList<AntennaPointingModelTerm> ();
	    	AntennaPointingModelTerm item = null;
	    	String s = "SELECT * FROM AntennaPointingModelTerm";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new AntennaPointingModelTerm ();
	    		assignAntennaPointingModelTerm(item,result);
	    		list.add(item);
	    	}
	    	AntennaPointingModelTerm[] tmp = new AntennaPointingModelTerm [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAntennaPointingModelTerm(AntennaPointingModelTerm data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    AntennaPointingModelTerm x = getAntennaPointingModelTerm(data.getPointingModelId(), data.getCoeffName());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addAntennaPointingModelTerm.setInt(1,data.getPointingModelId());

            addAntennaPointingModelTerm.setString(2,data.getCoeffName());

            addAntennaPointingModelTerm.setFloat(3,data.getCoeffValue());

            addAntennaPointingModelTerm.setFloat(4,data.getCoeffError());

			addAntennaPointingModelTerm.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addAntennaPointingModelTerm(AntennaPointingModelTerm data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				AntennaPointingModelTerm x = getAntennaPointingModelTerm(data.getPointingModelId(), data.getCoeffName());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addAntennaPointingModelTerm(data);

    }

    public void deleteAntennaPointingModelTerm (int PointingModelId, String CoeffName) throws AcsJTmcdbSqlEx {
        try {

          	deleteAntennaPointingModelTermKey.setInt(1, PointingModelId);

          	deleteAntennaPointingModelTermKey.setString(2, CoeffName);

			deleteAntennaPointingModelTermKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAntennaPointingModelTerm(AntennaPointingModelTerm data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        AntennaPointingModelTerm x = null;
        try {
            x = getAntennaPointingModelTerm(data.getPointingModelId(), data.getCoeffName());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getPointingModelId() != data.getPointingModelId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getCoeffName().equals(data.getCoeffName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAntennaPointingModelTerm.setInt(1,data.getPointingModelId());

            updateAntennaPointingModelTerm.setString(2,data.getCoeffName());

            updateAntennaPointingModelTerm.setFloat(3,data.getCoeffValue());

            updateAntennaPointingModelTerm.setFloat(4,data.getCoeffError());

          	updateAntennaPointingModelTerm.setInt(4 + 1, data.getPointingModelId());

          	updateAntennaPointingModelTerm.setString(4 + 2, data.getCoeffName());

			updateAntennaPointingModelTerm.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // AntennaFocusModel
    /////////////////////////////////////////

    public void assignAntennaFocusModel(AntennaFocusModel x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setFocusModelId(result.getInt(1));

        x.setAntennaId(result.getInt(2));

        x.setReceiverBand(result.getString(3));

	    x.setStartValidTime(new ArrayTime(result.getLong(4)));

	    x.setEndValidTime(new ArrayTime(result.getLong(5)));

        // if (result.wasNull())
        // 	x.setEndValidTimeNull();

        x.setAsdmUID(result.getString(6));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public AntennaFocusModel getAntennaFocusModel (int FocusModelId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getAntennaFocusModelKey.setInt(1, FocusModelId);
            ResultSet result = getAntennaFocusModelKey.executeQuery();
            AntennaFocusModel x = new AntennaFocusModel ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AntennaFocusModel tables with key " + 
                    FocusModelId);

            assignAntennaFocusModel(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for AntennaFocusModel table (key " + 
                    FocusModelId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public AntennaFocusModel getAntennaFocusModel (int AntennaId, String ReceiverBand, ArrayTime StartValidTime) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getAntennaFocusModelAlt.setInt(1, AntennaId);

            getAntennaFocusModelAlt.setString(2, ReceiverBand);

	      	getAntennaFocusModelAlt.setLong(3, StartValidTime.get());

            ResultSet result = getAntennaFocusModelAlt.executeQuery();
            AntennaFocusModel x = new AntennaFocusModel ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AntennaFocusModel tables with key " + 
                    AntennaId + ", " + ReceiverBand + ", " + StartValidTime);

            assignAntennaFocusModel(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for AntennaFocusModel table (key " + 
                    AntennaId + ", " + ReceiverBand + ", " + StartValidTime + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public AntennaFocusModel[] getAntennaFocusModelWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<AntennaFocusModel> list = new ArrayList<AntennaFocusModel> ();
	    	AntennaFocusModel item = null;
	    	String s = "SELECT * FROM AntennaFocusModel";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new AntennaFocusModel ();
	    		assignAntennaFocusModel(item,result);
	    		list.add(item);
	    	}
	    	AntennaFocusModel[] tmp = new AntennaFocusModel [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAntennaFocusModel(AntennaFocusModel data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addAntennaFocusModel.setInt(1,data.getAntennaId());

            addAntennaFocusModel.setString(2,data.getReceiverBand());

	        addAntennaFocusModel.setLong(3,data.getStartValidTime().get());

	        addAntennaFocusModel.setLong(4,data.getEndValidTime().get());

            addAntennaFocusModel.setString(5,data.getAsdmUID());

		    addAntennaFocusModel.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			AntennaFocusModel addedRow = getAntennaFocusModel (data.getAntennaId(), data.getReceiverBand(), data.getStartValidTime() );        
            return addedRow.getFocusModelId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table AntennaFocusModel!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addAntennaFocusModel(AntennaFocusModel data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			AntennaFocusModel x = getAntennaFocusModel(data.getAntennaId(), data.getReceiverBand(), data.getStartValidTime() );
	    		return x.getFocusModelId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addAntennaFocusModel(data);

    }

    public void deleteAntennaFocusModel (int FocusModelId) throws AcsJTmcdbSqlEx {
        try {
            deleteAntennaFocusModelKey.setInt(1, FocusModelId);
			deleteAntennaFocusModelKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteAntennaFocusModel (int AntennaId, String ReceiverBand, ArrayTime StartValidTime) throws AcsJTmcdbSqlEx {
        try {

            deleteAntennaFocusModelAlt.setInt(1, AntennaId);

            deleteAntennaFocusModelAlt.setString(2, ReceiverBand);

	      	deleteAntennaFocusModelAlt.setLong(3, StartValidTime.get());

			deleteAntennaFocusModelAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAntennaFocusModel(AntennaFocusModel data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        AntennaFocusModel x = null;

        x = getAntennaFocusModel(data.getFocusModelId());

        // You can't change the keys.
		if (x.getFocusModelId() != data.getFocusModelId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getAntennaId() != data.getAntennaId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getReceiverBand().equals(data.getReceiverBand()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartValidTime().get() != data.getStartValidTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAntennaFocusModel.setInt(1,data.getFocusModelId());

            updateAntennaFocusModel.setInt(2,data.getAntennaId());

            updateAntennaFocusModel.setString(3,data.getReceiverBand());

	        updateAntennaFocusModel.setLong(4,data.getStartValidTime().get());

	        updateAntennaFocusModel.setLong(5,data.getEndValidTime().get());

            updateAntennaFocusModel.setString(6,data.getAsdmUID());

      		updateAntennaFocusModel.setInt(7, data.getFocusModelId()); 
			updateAntennaFocusModel.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // AntennaFocusModelTerm
    /////////////////////////////////////////

    public void assignAntennaFocusModelTerm(AntennaFocusModelTerm x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setFocusModelId(result.getInt(1));

        x.setCoeffName(result.getString(2));

        x.setCoeffValue(result.getFloat(3));

        x.setCoeffError(result.getFloat(4));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public AntennaFocusModelTerm getAntennaFocusModelTerm (int FocusModelId, String CoeffName) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getAntennaFocusModelTermKey.setInt(1, FocusModelId);

          	getAntennaFocusModelTermKey.setString(2, CoeffName);

            ResultSet result = getAntennaFocusModelTermKey.executeQuery();
            AntennaFocusModelTerm x = new AntennaFocusModelTerm ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AntennaFocusModelTerm tables with key " + 
                    FocusModelId + ", " + CoeffName);
            assignAntennaFocusModelTerm(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for AntennaFocusModelTerm table (key " + 
                    FocusModelId + ", " + CoeffName + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public AntennaFocusModelTerm[] getAntennaFocusModelTermWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<AntennaFocusModelTerm> list = new ArrayList<AntennaFocusModelTerm> ();
	    	AntennaFocusModelTerm item = null;
	    	String s = "SELECT * FROM AntennaFocusModelTerm";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new AntennaFocusModelTerm ();
	    		assignAntennaFocusModelTerm(item,result);
	    		list.add(item);
	    	}
	    	AntennaFocusModelTerm[] tmp = new AntennaFocusModelTerm [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAntennaFocusModelTerm(AntennaFocusModelTerm data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    AntennaFocusModelTerm x = getAntennaFocusModelTerm(data.getFocusModelId(), data.getCoeffName());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addAntennaFocusModelTerm.setInt(1,data.getFocusModelId());

            addAntennaFocusModelTerm.setString(2,data.getCoeffName());

            addAntennaFocusModelTerm.setFloat(3,data.getCoeffValue());

            addAntennaFocusModelTerm.setFloat(4,data.getCoeffError());

			addAntennaFocusModelTerm.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addAntennaFocusModelTerm(AntennaFocusModelTerm data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				AntennaFocusModelTerm x = getAntennaFocusModelTerm(data.getFocusModelId(), data.getCoeffName());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addAntennaFocusModelTerm(data);

    }

    public void deleteAntennaFocusModelTerm (int FocusModelId, String CoeffName) throws AcsJTmcdbSqlEx {
        try {

          	deleteAntennaFocusModelTermKey.setInt(1, FocusModelId);

          	deleteAntennaFocusModelTermKey.setString(2, CoeffName);

			deleteAntennaFocusModelTermKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAntennaFocusModelTerm(AntennaFocusModelTerm data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        AntennaFocusModelTerm x = null;
        try {
            x = getAntennaFocusModelTerm(data.getFocusModelId(), data.getCoeffName());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getFocusModelId() != data.getFocusModelId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getCoeffName().equals(data.getCoeffName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAntennaFocusModelTerm.setInt(1,data.getFocusModelId());

            updateAntennaFocusModelTerm.setString(2,data.getCoeffName());

            updateAntennaFocusModelTerm.setFloat(3,data.getCoeffValue());

            updateAntennaFocusModelTerm.setFloat(4,data.getCoeffError());

          	updateAntennaFocusModelTerm.setInt(4 + 1, data.getFocusModelId());

          	updateAntennaFocusModelTerm.setString(4 + 2, data.getCoeffName());

			updateAntennaFocusModelTerm.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // AntennaDelayModel
    /////////////////////////////////////////

    public void assignAntennaDelayModel(AntennaDelayModel x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setDelayModelId(result.getInt(1));

        x.setAntennaId(result.getInt(2));

        x.setPadId(result.getInt(3));

        x.setReceiverBand(result.getString(4));

	    x.setStartTime(new ArrayTime(result.getLong(5)));

	    x.setStartValidTime(new ArrayTime(result.getLong(6)));

	    x.setEndValidTime(new ArrayTime(result.getLong(7)));

        // if (result.wasNull())
        // 	x.setEndValidTimeNull();

        x.setAsdmUID(result.getString(8));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public AntennaDelayModel getAntennaDelayModel (int DelayModelId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getAntennaDelayModelKey.setInt(1, DelayModelId);
            ResultSet result = getAntennaDelayModelKey.executeQuery();
            AntennaDelayModel x = new AntennaDelayModel ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AntennaDelayModel tables with key " + 
                    DelayModelId);

            assignAntennaDelayModel(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for AntennaDelayModel table (key " + 
                    DelayModelId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public AntennaDelayModel getAntennaDelayModel (int AntennaId, int PadId, String ReceiverBand, ArrayTime StartValidTime) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getAntennaDelayModelAlt.setInt(1, AntennaId);

            getAntennaDelayModelAlt.setInt(2, PadId);

            getAntennaDelayModelAlt.setString(3, ReceiverBand);

	      	getAntennaDelayModelAlt.setLong(4, StartValidTime.get());

            ResultSet result = getAntennaDelayModelAlt.executeQuery();
            AntennaDelayModel x = new AntennaDelayModel ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AntennaDelayModel tables with key " + 
                    AntennaId + ", " + PadId + ", " + ReceiverBand + ", " + StartValidTime);

            assignAntennaDelayModel(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for AntennaDelayModel table (key " + 
                    AntennaId + ", " + PadId + ", " + ReceiverBand + ", " + StartValidTime + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public AntennaDelayModel[] getAntennaDelayModelWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<AntennaDelayModel> list = new ArrayList<AntennaDelayModel> ();
	    	AntennaDelayModel item = null;
	    	String s = "SELECT * FROM AntennaDelayModel";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new AntennaDelayModel ();
	    		assignAntennaDelayModel(item,result);
	    		list.add(item);
	    	}
	    	AntennaDelayModel[] tmp = new AntennaDelayModel [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAntennaDelayModel(AntennaDelayModel data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addAntennaDelayModel.setInt(1,data.getAntennaId());

            addAntennaDelayModel.setInt(2,data.getPadId());

            addAntennaDelayModel.setString(3,data.getReceiverBand());

	        addAntennaDelayModel.setLong(4,data.getStartTime().get());

	        addAntennaDelayModel.setLong(5,data.getStartValidTime().get());

	        addAntennaDelayModel.setLong(6,data.getEndValidTime().get());

            addAntennaDelayModel.setString(7,data.getAsdmUID());

		    addAntennaDelayModel.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			AntennaDelayModel addedRow = getAntennaDelayModel (data.getAntennaId(), data.getPadId(), data.getReceiverBand(), data.getStartValidTime() );        
            return addedRow.getDelayModelId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table AntennaDelayModel!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addAntennaDelayModel(AntennaDelayModel data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			AntennaDelayModel x = getAntennaDelayModel(data.getAntennaId(), data.getPadId(), data.getReceiverBand(), data.getStartValidTime() );
	    		return x.getDelayModelId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addAntennaDelayModel(data);

    }

    public void deleteAntennaDelayModel (int DelayModelId) throws AcsJTmcdbSqlEx {
        try {
            deleteAntennaDelayModelKey.setInt(1, DelayModelId);
			deleteAntennaDelayModelKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteAntennaDelayModel (int AntennaId, int PadId, String ReceiverBand, ArrayTime StartValidTime) throws AcsJTmcdbSqlEx {
        try {

            deleteAntennaDelayModelAlt.setInt(1, AntennaId);

            deleteAntennaDelayModelAlt.setInt(2, PadId);

            deleteAntennaDelayModelAlt.setString(3, ReceiverBand);

	      	deleteAntennaDelayModelAlt.setLong(4, StartValidTime.get());

			deleteAntennaDelayModelAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAntennaDelayModel(AntennaDelayModel data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        AntennaDelayModel x = null;

        x = getAntennaDelayModel(data.getDelayModelId());

        // You can't change the keys.
		if (x.getDelayModelId() != data.getDelayModelId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getAntennaId() != data.getAntennaId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getPadId() != data.getPadId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getReceiverBand().equals(data.getReceiverBand()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartValidTime().get() != data.getStartValidTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAntennaDelayModel.setInt(1,data.getDelayModelId());

            updateAntennaDelayModel.setInt(2,data.getAntennaId());

            updateAntennaDelayModel.setInt(3,data.getPadId());

            updateAntennaDelayModel.setString(4,data.getReceiverBand());

	        updateAntennaDelayModel.setLong(5,data.getStartTime().get());

	        updateAntennaDelayModel.setLong(6,data.getStartValidTime().get());

	        updateAntennaDelayModel.setLong(7,data.getEndValidTime().get());

            updateAntennaDelayModel.setString(8,data.getAsdmUID());

      		updateAntennaDelayModel.setInt(9, data.getDelayModelId()); 
			updateAntennaDelayModel.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // AntennaDelayModelTerm
    /////////////////////////////////////////

    public void assignAntennaDelayModelTerm(AntennaDelayModelTerm x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setDelayModelId(result.getInt(1));

        x.setCoeffName(result.getString(2));

        x.setCoeffValue(result.getDouble(3));

        x.setCoeffError(result.getDouble(4));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public AntennaDelayModelTerm getAntennaDelayModelTerm (int DelayModelId, String CoeffName) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getAntennaDelayModelTermKey.setInt(1, DelayModelId);

          	getAntennaDelayModelTermKey.setString(2, CoeffName);

            ResultSet result = getAntennaDelayModelTermKey.executeQuery();
            AntennaDelayModelTerm x = new AntennaDelayModelTerm ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AntennaDelayModelTerm tables with key " + 
                    DelayModelId + ", " + CoeffName);
            assignAntennaDelayModelTerm(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for AntennaDelayModelTerm table (key " + 
                    DelayModelId + ", " + CoeffName + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public AntennaDelayModelTerm[] getAntennaDelayModelTermWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<AntennaDelayModelTerm> list = new ArrayList<AntennaDelayModelTerm> ();
	    	AntennaDelayModelTerm item = null;
	    	String s = "SELECT * FROM AntennaDelayModelTerm";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new AntennaDelayModelTerm ();
	    		assignAntennaDelayModelTerm(item,result);
	    		list.add(item);
	    	}
	    	AntennaDelayModelTerm[] tmp = new AntennaDelayModelTerm [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAntennaDelayModelTerm(AntennaDelayModelTerm data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    AntennaDelayModelTerm x = getAntennaDelayModelTerm(data.getDelayModelId(), data.getCoeffName());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addAntennaDelayModelTerm.setInt(1,data.getDelayModelId());

            addAntennaDelayModelTerm.setString(2,data.getCoeffName());

            addAntennaDelayModelTerm.setDouble(3,data.getCoeffValue());

            addAntennaDelayModelTerm.setDouble(4,data.getCoeffError());

			addAntennaDelayModelTerm.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addAntennaDelayModelTerm(AntennaDelayModelTerm data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				AntennaDelayModelTerm x = getAntennaDelayModelTerm(data.getDelayModelId(), data.getCoeffName());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addAntennaDelayModelTerm(data);

    }

    public void deleteAntennaDelayModelTerm (int DelayModelId, String CoeffName) throws AcsJTmcdbSqlEx {
        try {

          	deleteAntennaDelayModelTermKey.setInt(1, DelayModelId);

          	deleteAntennaDelayModelTermKey.setString(2, CoeffName);

			deleteAntennaDelayModelTermKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAntennaDelayModelTerm(AntennaDelayModelTerm data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        AntennaDelayModelTerm x = null;
        try {
            x = getAntennaDelayModelTerm(data.getDelayModelId(), data.getCoeffName());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getDelayModelId() != data.getDelayModelId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getCoeffName().equals(data.getCoeffName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAntennaDelayModelTerm.setInt(1,data.getDelayModelId());

            updateAntennaDelayModelTerm.setString(2,data.getCoeffName());

            updateAntennaDelayModelTerm.setDouble(3,data.getCoeffValue());

            updateAntennaDelayModelTerm.setDouble(4,data.getCoeffError());

          	updateAntennaDelayModelTerm.setInt(4 + 1, data.getDelayModelId());

          	updateAntennaDelayModelTerm.setString(4 + 2, data.getCoeffName());

			updateAntennaDelayModelTerm.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // AntennaToFrontEnd
    /////////////////////////////////////////

    public void assignAntennaToFrontEnd(AntennaToFrontEnd x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setAntennaId(result.getInt(1));

        x.setFrontEndId(result.getInt(2));

	    x.setStartTime(new ArrayTime(result.getLong(3)));

	    x.setEndTime(new ArrayTime(result.getLong(4)));

        // if (result.wasNull())
        // 	x.setEndTimeNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public AntennaToFrontEnd getAntennaToFrontEnd (int AntennaId, int FrontEndId, ArrayTime StartTime) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getAntennaToFrontEndKey.setInt(1, AntennaId);

          	getAntennaToFrontEndKey.setInt(2, FrontEndId);

	      	getAntennaToFrontEndKey.setLong(3, StartTime.get());

            ResultSet result = getAntennaToFrontEndKey.executeQuery();
            AntennaToFrontEnd x = new AntennaToFrontEnd ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AntennaToFrontEnd tables with key " + 
                    AntennaId + ", " + FrontEndId + ", " + StartTime);
            assignAntennaToFrontEnd(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for AntennaToFrontEnd table (key " + 
                    AntennaId + ", " + FrontEndId + ", " + StartTime + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public AntennaToFrontEnd[] getAntennaToFrontEndWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<AntennaToFrontEnd> list = new ArrayList<AntennaToFrontEnd> ();
	    	AntennaToFrontEnd item = null;
	    	String s = "SELECT * FROM AntennaToFrontEnd";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new AntennaToFrontEnd ();
	    		assignAntennaToFrontEnd(item,result);
	    		list.add(item);
	    	}
	    	AntennaToFrontEnd[] tmp = new AntennaToFrontEnd [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAntennaToFrontEnd(AntennaToFrontEnd data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    AntennaToFrontEnd x = getAntennaToFrontEnd(data.getAntennaId(), data.getFrontEndId(), data.getStartTime());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addAntennaToFrontEnd.setInt(1,data.getAntennaId());

            addAntennaToFrontEnd.setInt(2,data.getFrontEndId());

	        addAntennaToFrontEnd.setLong(3,data.getStartTime().get());

	        addAntennaToFrontEnd.setLong(4,data.getEndTime().get());

			addAntennaToFrontEnd.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addAntennaToFrontEnd(AntennaToFrontEnd data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				AntennaToFrontEnd x = getAntennaToFrontEnd(data.getAntennaId(), data.getFrontEndId(), data.getStartTime());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addAntennaToFrontEnd(data);

    }

    public void deleteAntennaToFrontEnd (int AntennaId, int FrontEndId, ArrayTime StartTime) throws AcsJTmcdbSqlEx {
        try {

          	deleteAntennaToFrontEndKey.setInt(1, AntennaId);

          	deleteAntennaToFrontEndKey.setInt(2, FrontEndId);

	      	deleteAntennaToFrontEndKey.setLong(3, StartTime.get());

			deleteAntennaToFrontEndKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAntennaToFrontEnd(AntennaToFrontEnd data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        AntennaToFrontEnd x = null;
        try {
            x = getAntennaToFrontEnd(data.getAntennaId(), data.getFrontEndId(), data.getStartTime());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getAntennaId() != data.getAntennaId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getFrontEndId() != data.getFrontEndId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartTime().get() != data.getStartTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAntennaToFrontEnd.setInt(1,data.getAntennaId());

            updateAntennaToFrontEnd.setInt(2,data.getFrontEndId());

	        updateAntennaToFrontEnd.setLong(3,data.getStartTime().get());

	        updateAntennaToFrontEnd.setLong(4,data.getEndTime().get());

          	updateAntennaToFrontEnd.setInt(4 + 1, data.getAntennaId());

          	updateAntennaToFrontEnd.setInt(4 + 2, data.getFrontEndId());

	      	updateAntennaToFrontEnd.setLong(4 + 3, data.getStartTime().get());

			updateAntennaToFrontEnd.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // AntennaToArray
    /////////////////////////////////////////

    public void assignAntennaToArray(AntennaToArray x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setAntennaId(result.getInt(1));

        x.setArrayId(result.getInt(2));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public AntennaToArray getAntennaToArray (int AntennaId, int ArrayId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getAntennaToArrayKey.setInt(1, AntennaId);

          	getAntennaToArrayKey.setInt(2, ArrayId);

            ResultSet result = getAntennaToArrayKey.executeQuery();
            AntennaToArray x = new AntennaToArray ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AntennaToArray tables with key " + 
                    AntennaId + ", " + ArrayId);
            assignAntennaToArray(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for AntennaToArray table (key " + 
                    AntennaId + ", " + ArrayId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public AntennaToArray[] getAntennaToArrayWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<AntennaToArray> list = new ArrayList<AntennaToArray> ();
	    	AntennaToArray item = null;
	    	String s = "SELECT * FROM AntennaToArray";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new AntennaToArray ();
	    		assignAntennaToArray(item,result);
	    		list.add(item);
	    	}
	    	AntennaToArray[] tmp = new AntennaToArray [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAntennaToArray(AntennaToArray data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    AntennaToArray x = getAntennaToArray(data.getAntennaId(), data.getArrayId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addAntennaToArray.setInt(1,data.getAntennaId());

            addAntennaToArray.setInt(2,data.getArrayId());

			addAntennaToArray.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addAntennaToArray(AntennaToArray data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				AntennaToArray x = getAntennaToArray(data.getAntennaId(), data.getArrayId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addAntennaToArray(data);

    }

    public void deleteAntennaToArray (int AntennaId, int ArrayId) throws AcsJTmcdbSqlEx {
        try {

          	deleteAntennaToArrayKey.setInt(1, AntennaId);

          	deleteAntennaToArrayKey.setInt(2, ArrayId);

			deleteAntennaToArrayKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAntennaToArray(AntennaToArray data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        AntennaToArray x = null;
        try {
            x = getAntennaToArray(data.getAntennaId(), data.getArrayId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getAntennaId() != data.getAntennaId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getArrayId() != data.getArrayId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAntennaToArray.setInt(1,data.getAntennaId());

            updateAntennaToArray.setInt(2,data.getArrayId());

          	updateAntennaToArray.setInt(2 + 1, data.getAntennaId());

          	updateAntennaToArray.setInt(2 + 2, data.getArrayId());

			updateAntennaToArray.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // SBExecution
    /////////////////////////////////////////

    public void assignSBExecution(SBExecution x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setArrayId(result.getInt(1));

        x.setSbUID(result.getString(2));

	    x.setStartTime(new ArrayTime(result.getLong(3)));

	    x.setEndTime(new ArrayTime(result.getLong(4)));

        // if (result.wasNull())
        // 	x.setEndTimeNull();

	    x.setNormalTermination(result.getBoolean(5));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public SBExecution getSBExecution (int ArrayId, String SbUID, ArrayTime StartTime) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getSBExecutionKey.setInt(1, ArrayId);

          	getSBExecutionKey.setString(2, SbUID);

	      	getSBExecutionKey.setLong(3, StartTime.get());

            ResultSet result = getSBExecutionKey.executeQuery();
            SBExecution x = new SBExecution ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in SBExecution tables with key " + 
                    ArrayId + ", " + SbUID + ", " + StartTime);
            assignSBExecution(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for SBExecution table (key " + 
                    ArrayId + ", " + SbUID + ", " + StartTime + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public SBExecution[] getSBExecutionWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<SBExecution> list = new ArrayList<SBExecution> ();
	    	SBExecution item = null;
	    	String s = "SELECT * FROM SBExecution";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new SBExecution ();
	    		assignSBExecution(item,result);
	    		list.add(item);
	    	}
	    	SBExecution[] tmp = new SBExecution [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addSBExecution(SBExecution data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    SBExecution x = getSBExecution(data.getArrayId(), data.getSbUID(), data.getStartTime());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addSBExecution.setInt(1,data.getArrayId());

            addSBExecution.setString(2,data.getSbUID());

	        addSBExecution.setLong(3,data.getStartTime().get());

	        addSBExecution.setLong(4,data.getEndTime().get());

	        addSBExecution.setBoolean(5,data.getNormalTermination());

			addSBExecution.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addSBExecution(SBExecution data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				SBExecution x = getSBExecution(data.getArrayId(), data.getSbUID(), data.getStartTime());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addSBExecution(data);

    }

    public void deleteSBExecution (int ArrayId, String SbUID, ArrayTime StartTime) throws AcsJTmcdbSqlEx {
        try {

          	deleteSBExecutionKey.setInt(1, ArrayId);

          	deleteSBExecutionKey.setString(2, SbUID);

	      	deleteSBExecutionKey.setLong(3, StartTime.get());

			deleteSBExecutionKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateSBExecution(SBExecution data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        SBExecution x = null;
        try {
            x = getSBExecution(data.getArrayId(), data.getSbUID(), data.getStartTime());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getArrayId() != data.getArrayId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getSbUID().equals(data.getSbUID()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartTime().get() != data.getStartTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateSBExecution.setInt(1,data.getArrayId());

            updateSBExecution.setString(2,data.getSbUID());

	        updateSBExecution.setLong(3,data.getStartTime().get());

	        updateSBExecution.setLong(4,data.getEndTime().get());

	        updateSBExecution.setBoolean(5,data.getNormalTermination());

          	updateSBExecution.setInt(5 + 1, data.getArrayId());

          	updateSBExecution.setString(5 + 2, data.getSbUID());

	      	updateSBExecution.setLong(5 + 3, data.getStartTime().get());

			updateSBExecution.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // AntennaToCorr
    /////////////////////////////////////////

    public void assignAntennaToCorr(AntennaToCorr x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setAntennaId(result.getInt(1));

        x.setCorrId(result.getInt(2));

        x.setAntennaNumber(result.getInt(3));

	    x.setStartTime(new ArrayTime(result.getLong(4)));

	    x.setEndTime(new ArrayTime(result.getLong(5)));

        // if (result.wasNull())
        // 	x.setEndTimeNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public AntennaToCorr getAntennaToCorr (int AntennaId, int CorrId, ArrayTime StartTime) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getAntennaToCorrKey.setInt(1, AntennaId);

          	getAntennaToCorrKey.setInt(2, CorrId);

	      	getAntennaToCorrKey.setLong(3, StartTime.get());

            ResultSet result = getAntennaToCorrKey.executeQuery();
            AntennaToCorr x = new AntennaToCorr ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AntennaToCorr tables with key " + 
                    AntennaId + ", " + CorrId + ", " + StartTime);
            assignAntennaToCorr(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for AntennaToCorr table (key " + 
                    AntennaId + ", " + CorrId + ", " + StartTime + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public AntennaToCorr[] getAntennaToCorrWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<AntennaToCorr> list = new ArrayList<AntennaToCorr> ();
	    	AntennaToCorr item = null;
	    	String s = "SELECT * FROM AntennaToCorr";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new AntennaToCorr ();
	    		assignAntennaToCorr(item,result);
	    		list.add(item);
	    	}
	    	AntennaToCorr[] tmp = new AntennaToCorr [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAntennaToCorr(AntennaToCorr data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    AntennaToCorr x = getAntennaToCorr(data.getAntennaId(), data.getCorrId(), data.getStartTime());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addAntennaToCorr.setInt(1,data.getAntennaId());

            addAntennaToCorr.setInt(2,data.getCorrId());

            addAntennaToCorr.setInt(3,data.getAntennaNumber());

	        addAntennaToCorr.setLong(4,data.getStartTime().get());

	        addAntennaToCorr.setLong(5,data.getEndTime().get());

			addAntennaToCorr.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addAntennaToCorr(AntennaToCorr data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				AntennaToCorr x = getAntennaToCorr(data.getAntennaId(), data.getCorrId(), data.getStartTime());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addAntennaToCorr(data);

    }

    public void deleteAntennaToCorr (int AntennaId, int CorrId, ArrayTime StartTime) throws AcsJTmcdbSqlEx {
        try {

          	deleteAntennaToCorrKey.setInt(1, AntennaId);

          	deleteAntennaToCorrKey.setInt(2, CorrId);

	      	deleteAntennaToCorrKey.setLong(3, StartTime.get());

			deleteAntennaToCorrKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAntennaToCorr(AntennaToCorr data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        AntennaToCorr x = null;
        try {
            x = getAntennaToCorr(data.getAntennaId(), data.getCorrId(), data.getStartTime());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getAntennaId() != data.getAntennaId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getCorrId() != data.getCorrId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartTime().get() != data.getStartTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAntennaToCorr.setInt(1,data.getAntennaId());

            updateAntennaToCorr.setInt(2,data.getCorrId());

            updateAntennaToCorr.setInt(3,data.getAntennaNumber());

	        updateAntennaToCorr.setLong(4,data.getStartTime().get());

	        updateAntennaToCorr.setLong(5,data.getEndTime().get());

          	updateAntennaToCorr.setInt(5 + 1, data.getAntennaId());

          	updateAntennaToCorr.setInt(5 + 2, data.getCorrId());

	      	updateAntennaToCorr.setLong(5 + 3, data.getStartTime().get());

			updateAntennaToCorr.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // WeatherStationToPad
    /////////////////////////////////////////

    public void assignWeatherStationToPad(WeatherStationToPad x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setWeatherStationId(result.getInt(1));

        x.setPadId(result.getInt(2));

	    x.setStartTime(new ArrayTime(result.getLong(3)));

	    x.setEndTime(new ArrayTime(result.getLong(4)));

        // if (result.wasNull())
        // 	x.setEndTimeNull();

	    x.setPlanned(result.getBoolean(5));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public WeatherStationToPad getWeatherStationToPad (int WeatherStationId, int PadId, ArrayTime StartTime) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getWeatherStationToPadKey.setInt(1, WeatherStationId);

          	getWeatherStationToPadKey.setInt(2, PadId);

	      	getWeatherStationToPadKey.setLong(3, StartTime.get());

            ResultSet result = getWeatherStationToPadKey.executeQuery();
            WeatherStationToPad x = new WeatherStationToPad ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in WeatherStationToPad tables with key " + 
                    WeatherStationId + ", " + PadId + ", " + StartTime);
            assignWeatherStationToPad(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for WeatherStationToPad table (key " + 
                    WeatherStationId + ", " + PadId + ", " + StartTime + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public WeatherStationToPad[] getWeatherStationToPadWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<WeatherStationToPad> list = new ArrayList<WeatherStationToPad> ();
	    	WeatherStationToPad item = null;
	    	String s = "SELECT * FROM WeatherStationToPad";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new WeatherStationToPad ();
	    		assignWeatherStationToPad(item,result);
	    		list.add(item);
	    	}
	    	WeatherStationToPad[] tmp = new WeatherStationToPad [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addWeatherStationToPad(WeatherStationToPad data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    WeatherStationToPad x = getWeatherStationToPad(data.getWeatherStationId(), data.getPadId(), data.getStartTime());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addWeatherStationToPad.setInt(1,data.getWeatherStationId());

            addWeatherStationToPad.setInt(2,data.getPadId());

	        addWeatherStationToPad.setLong(3,data.getStartTime().get());

	        addWeatherStationToPad.setLong(4,data.getEndTime().get());

	        addWeatherStationToPad.setBoolean(5,data.getPlanned());

			addWeatherStationToPad.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addWeatherStationToPad(WeatherStationToPad data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				WeatherStationToPad x = getWeatherStationToPad(data.getWeatherStationId(), data.getPadId(), data.getStartTime());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addWeatherStationToPad(data);

    }

    public void deleteWeatherStationToPad (int WeatherStationId, int PadId, ArrayTime StartTime) throws AcsJTmcdbSqlEx {
        try {

          	deleteWeatherStationToPadKey.setInt(1, WeatherStationId);

          	deleteWeatherStationToPadKey.setInt(2, PadId);

	      	deleteWeatherStationToPadKey.setLong(3, StartTime.get());

			deleteWeatherStationToPadKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateWeatherStationToPad(WeatherStationToPad data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        WeatherStationToPad x = null;
        try {
            x = getWeatherStationToPad(data.getWeatherStationId(), data.getPadId(), data.getStartTime());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getWeatherStationId() != data.getWeatherStationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getPadId() != data.getPadId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartTime().get() != data.getStartTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateWeatherStationToPad.setInt(1,data.getWeatherStationId());

            updateWeatherStationToPad.setInt(2,data.getPadId());

	        updateWeatherStationToPad.setLong(3,data.getStartTime().get());

	        updateWeatherStationToPad.setLong(4,data.getEndTime().get());

	        updateWeatherStationToPad.setBoolean(5,data.getPlanned());

          	updateWeatherStationToPad.setInt(5 + 1, data.getWeatherStationId());

          	updateWeatherStationToPad.setInt(5 + 2, data.getPadId());

	      	updateWeatherStationToPad.setLong(5 + 3, data.getStartTime().get());

			updateWeatherStationToPad.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // BaseElementAssemblyList
    /////////////////////////////////////////

    public void assignBaseElementAssemblyList(BaseElementAssemblyList x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setAssemblyId(result.getInt(1));

        x.setBaseElementOnlineId(result.getInt(2));

        x.setGroupName(result.getString(3));

        // if (result.wasNull())
        // 	x.setGroupNameNull();

        x.setOrderTag(result.getInt(4));

        // if (result.wasNull())
        // 	x.setOrderTagNull();

        x.setComponentId(result.getInt(5));

        x.setRoleName(result.getString(6));

        // if (result.wasNull())
        // 	x.setRoleNameNull();

        x.setChannelNumber(result.getInt(7));

        // if (result.wasNull())
        // 	x.setChannelNumberNull();

        x.setNodeAddress(result.getString(8));

        // if (result.wasNull())
        // 	x.setNodeAddressNull();

        x.setBaseAddress(result.getString(9));

        // if (result.wasNull())
        // 	x.setBaseAddressNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public BaseElementAssemblyList getBaseElementAssemblyList (int AssemblyId, int BaseElementOnlineId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getBaseElementAssemblyListKey.setInt(1, AssemblyId);

          	getBaseElementAssemblyListKey.setInt(2, BaseElementOnlineId);

            ResultSet result = getBaseElementAssemblyListKey.executeQuery();
            BaseElementAssemblyList x = new BaseElementAssemblyList ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in BaseElementAssemblyList tables with key " + 
                    AssemblyId + ", " + BaseElementOnlineId);
            assignBaseElementAssemblyList(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for BaseElementAssemblyList table (key " + 
                    AssemblyId + ", " + BaseElementOnlineId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public BaseElementAssemblyList[] getBaseElementAssemblyListWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<BaseElementAssemblyList> list = new ArrayList<BaseElementAssemblyList> ();
	    	BaseElementAssemblyList item = null;
	    	String s = "SELECT * FROM BaseElementAssemblyList";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new BaseElementAssemblyList ();
	    		assignBaseElementAssemblyList(item,result);
	    		list.add(item);
	    	}
	    	BaseElementAssemblyList[] tmp = new BaseElementAssemblyList [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addBaseElementAssemblyList(BaseElementAssemblyList data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    BaseElementAssemblyList x = getBaseElementAssemblyList(data.getAssemblyId(), data.getBaseElementOnlineId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addBaseElementAssemblyList.setInt(1,data.getAssemblyId());

            addBaseElementAssemblyList.setInt(2,data.getBaseElementOnlineId());

            addBaseElementAssemblyList.setString(3,data.getGroupName());

            addBaseElementAssemblyList.setInt(4,data.getOrderTag());

            addBaseElementAssemblyList.setInt(5,data.getComponentId());

            addBaseElementAssemblyList.setString(6,data.getRoleName());

            addBaseElementAssemblyList.setInt(7,data.getChannelNumber());

            addBaseElementAssemblyList.setString(8,data.getNodeAddress());

            addBaseElementAssemblyList.setString(9,data.getBaseAddress());

			addBaseElementAssemblyList.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addBaseElementAssemblyList(BaseElementAssemblyList data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				BaseElementAssemblyList x = getBaseElementAssemblyList(data.getAssemblyId(), data.getBaseElementOnlineId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addBaseElementAssemblyList(data);

    }

    public void deleteBaseElementAssemblyList (int AssemblyId, int BaseElementOnlineId) throws AcsJTmcdbSqlEx {
        try {

          	deleteBaseElementAssemblyListKey.setInt(1, AssemblyId);

          	deleteBaseElementAssemblyListKey.setInt(2, BaseElementOnlineId);

			deleteBaseElementAssemblyListKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateBaseElementAssemblyList(BaseElementAssemblyList data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        BaseElementAssemblyList x = null;
        try {
            x = getBaseElementAssemblyList(data.getAssemblyId(), data.getBaseElementOnlineId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getAssemblyId() != data.getAssemblyId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getBaseElementOnlineId() != data.getBaseElementOnlineId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateBaseElementAssemblyList.setInt(1,data.getAssemblyId());

            updateBaseElementAssemblyList.setInt(2,data.getBaseElementOnlineId());

            updateBaseElementAssemblyList.setString(3,data.getGroupName());

            updateBaseElementAssemblyList.setInt(4,data.getOrderTag());

            updateBaseElementAssemblyList.setInt(5,data.getComponentId());

            updateBaseElementAssemblyList.setString(6,data.getRoleName());

            updateBaseElementAssemblyList.setInt(7,data.getChannelNumber());

            updateBaseElementAssemblyList.setString(8,data.getNodeAddress());

            updateBaseElementAssemblyList.setString(9,data.getBaseAddress());

          	updateBaseElementAssemblyList.setInt(9 + 1, data.getAssemblyId());

          	updateBaseElementAssemblyList.setInt(9 + 2, data.getBaseElementOnlineId());

			updateBaseElementAssemblyList.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // MasterComponent
    /////////////////////////////////////////

    public void assignMasterComponent(MasterComponent x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setMasterComponentId(result.getInt(1));

        x.setComponentId(result.getInt(2));

        x.setConfigurationId(result.getInt(3));

        x.setSubsystemName(result.getString(4));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public MasterComponent getMasterComponent (int MasterComponentId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getMasterComponentKey.setInt(1, MasterComponentId);
            ResultSet result = getMasterComponentKey.executeQuery();
            MasterComponent x = new MasterComponent ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in MasterComponent tables with key " + 
                    MasterComponentId);

            assignMasterComponent(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for MasterComponent table (key " + 
                    MasterComponentId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public MasterComponent getMasterComponent (int ComponentId, int ConfigurationId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getMasterComponentAlt.setInt(1, ComponentId);

            getMasterComponentAlt.setInt(2, ConfigurationId);

            ResultSet result = getMasterComponentAlt.executeQuery();
            MasterComponent x = new MasterComponent ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in MasterComponent tables with key " + 
                    ComponentId + ", " + ConfigurationId);

            assignMasterComponent(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for MasterComponent table (key " + 
                    ComponentId + ", " + ConfigurationId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public MasterComponent[] getMasterComponentWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<MasterComponent> list = new ArrayList<MasterComponent> ();
	    	MasterComponent item = null;
	    	String s = "SELECT * FROM MasterComponent";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new MasterComponent ();
	    		assignMasterComponent(item,result);
	    		list.add(item);
	    	}
	    	MasterComponent[] tmp = new MasterComponent [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addMasterComponent(MasterComponent data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addMasterComponent.setInt(1,data.getComponentId());

            addMasterComponent.setInt(2,data.getConfigurationId());

            addMasterComponent.setString(3,data.getSubsystemName());

		    addMasterComponent.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			MasterComponent addedRow = getMasterComponent (data.getComponentId(), data.getConfigurationId() );        
            return addedRow.getMasterComponentId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table MasterComponent!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addMasterComponent(MasterComponent data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			MasterComponent x = getMasterComponent(data.getComponentId(), data.getConfigurationId() );
	    		return x.getMasterComponentId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addMasterComponent(data);

    }

    public void deleteMasterComponent (int MasterComponentId) throws AcsJTmcdbSqlEx {
        try {
            deleteMasterComponentKey.setInt(1, MasterComponentId);
			deleteMasterComponentKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteMasterComponent (int ComponentId, int ConfigurationId) throws AcsJTmcdbSqlEx {
        try {

            deleteMasterComponentAlt.setInt(1, ComponentId);

            deleteMasterComponentAlt.setInt(2, ConfigurationId);

			deleteMasterComponentAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateMasterComponent(MasterComponent data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        MasterComponent x = null;

        x = getMasterComponent(data.getMasterComponentId());

        // You can't change the keys.
		if (x.getMasterComponentId() != data.getMasterComponentId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getComponentId() != data.getComponentId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateMasterComponent.setInt(1,data.getMasterComponentId());

            updateMasterComponent.setInt(2,data.getComponentId());

            updateMasterComponent.setInt(3,data.getConfigurationId());

            updateMasterComponent.setString(4,data.getSubsystemName());

      		updateMasterComponent.setInt(5, data.getMasterComponentId()); 
			updateMasterComponent.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // ComputerExecution
    /////////////////////////////////////////

    public void assignComputerExecution(ComputerExecution x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setComputerExecutionId(result.getInt(1));

        x.setComputerId(result.getInt(2));

        x.setConfigurationId(result.getInt(3));

	    x.setStartTime(new ArrayTime(result.getLong(4)));

	    x.setEndTime(new ArrayTime(result.getLong(5)));

        // if (result.wasNull())
        // 	x.setEndTimeNull();

	    x.setNormalStart(result.getBoolean(6));

	    x.setNormalTermination(result.getBoolean(7));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public ComputerExecution getComputerExecution (int ComputerExecutionId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getComputerExecutionKey.setInt(1, ComputerExecutionId);
            ResultSet result = getComputerExecutionKey.executeQuery();
            ComputerExecution x = new ComputerExecution ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in ComputerExecution tables with key " + 
                    ComputerExecutionId);

            assignComputerExecution(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for ComputerExecution table (key " + 
                    ComputerExecutionId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public ComputerExecution getComputerExecution (int ComputerId, int ConfigurationId, ArrayTime StartTime) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getComputerExecutionAlt.setInt(1, ComputerId);

            getComputerExecutionAlt.setInt(2, ConfigurationId);

	      	getComputerExecutionAlt.setLong(3, StartTime.get());

            ResultSet result = getComputerExecutionAlt.executeQuery();
            ComputerExecution x = new ComputerExecution ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in ComputerExecution tables with key " + 
                    ComputerId + ", " + ConfigurationId + ", " + StartTime);

            assignComputerExecution(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for ComputerExecution table (key " + 
                    ComputerId + ", " + ConfigurationId + ", " + StartTime + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public ComputerExecution[] getComputerExecutionWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<ComputerExecution> list = new ArrayList<ComputerExecution> ();
	    	ComputerExecution item = null;
	    	String s = "SELECT * FROM ComputerExecution";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new ComputerExecution ();
	    		assignComputerExecution(item,result);
	    		list.add(item);
	    	}
	    	ComputerExecution[] tmp = new ComputerExecution [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addComputerExecution(ComputerExecution data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addComputerExecution.setInt(1,data.getComputerId());

            addComputerExecution.setInt(2,data.getConfigurationId());

	        addComputerExecution.setLong(3,data.getStartTime().get());

	        addComputerExecution.setLong(4,data.getEndTime().get());

	        addComputerExecution.setBoolean(5,data.getNormalStart());

	        addComputerExecution.setBoolean(6,data.getNormalTermination());

		    addComputerExecution.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			ComputerExecution addedRow = getComputerExecution (data.getComputerId(), data.getConfigurationId(), data.getStartTime() );        
            return addedRow.getComputerExecutionId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table ComputerExecution!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addComputerExecution(ComputerExecution data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			ComputerExecution x = getComputerExecution(data.getComputerId(), data.getConfigurationId(), data.getStartTime() );
	    		return x.getComputerExecutionId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addComputerExecution(data);

    }

    public void deleteComputerExecution (int ComputerExecutionId) throws AcsJTmcdbSqlEx {
        try {
            deleteComputerExecutionKey.setInt(1, ComputerExecutionId);
			deleteComputerExecutionKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteComputerExecution (int ComputerId, int ConfigurationId, ArrayTime StartTime) throws AcsJTmcdbSqlEx {
        try {

            deleteComputerExecutionAlt.setInt(1, ComputerId);

            deleteComputerExecutionAlt.setInt(2, ConfigurationId);

	      	deleteComputerExecutionAlt.setLong(3, StartTime.get());

			deleteComputerExecutionAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateComputerExecution(ComputerExecution data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        ComputerExecution x = null;

        x = getComputerExecution(data.getComputerExecutionId());

        // You can't change the keys.
		if (x.getComputerExecutionId() != data.getComputerExecutionId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getComputerId() != data.getComputerId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartTime().get() != data.getStartTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateComputerExecution.setInt(1,data.getComputerExecutionId());

            updateComputerExecution.setInt(2,data.getComputerId());

            updateComputerExecution.setInt(3,data.getConfigurationId());

	        updateComputerExecution.setLong(4,data.getStartTime().get());

	        updateComputerExecution.setLong(5,data.getEndTime().get());

	        updateComputerExecution.setBoolean(6,data.getNormalStart());

	        updateComputerExecution.setBoolean(7,data.getNormalTermination());

      		updateComputerExecution.setInt(8, data.getComputerExecutionId()); 
			updateComputerExecution.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // ContainerExecution
    /////////////////////////////////////////

    public void assignContainerExecution(ContainerExecution x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setContainerExecutionId(result.getInt(1));

        x.setContainerId(result.getInt(2));

        x.setConfigurationId(result.getInt(3));

        x.setComputerId(result.getInt(4));

	    x.setStartTime(new ArrayTime(result.getLong(5)));

	    x.setEndTime(new ArrayTime(result.getLong(6)));

        // if (result.wasNull())
        // 	x.setEndTimeNull();

	    x.setNormalStart(result.getBoolean(7));

	    x.setNormalTermination(result.getBoolean(8));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public ContainerExecution getContainerExecution (int ContainerExecutionId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getContainerExecutionKey.setInt(1, ContainerExecutionId);
            ResultSet result = getContainerExecutionKey.executeQuery();
            ContainerExecution x = new ContainerExecution ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in ContainerExecution tables with key " + 
                    ContainerExecutionId);

            assignContainerExecution(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for ContainerExecution table (key " + 
                    ContainerExecutionId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public ContainerExecution getContainerExecution (int ContainerId, int ComputerId, ArrayTime StartTime, int ConfigurationId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getContainerExecutionAlt.setInt(1, ContainerId);

            getContainerExecutionAlt.setInt(2, ComputerId);

	      	getContainerExecutionAlt.setLong(3, StartTime.get());

            getContainerExecutionAlt.setInt(4, ConfigurationId);

            ResultSet result = getContainerExecutionAlt.executeQuery();
            ContainerExecution x = new ContainerExecution ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in ContainerExecution tables with key " + 
                    ContainerId + ", " + ComputerId + ", " + StartTime + ", " + ConfigurationId);

            assignContainerExecution(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for ContainerExecution table (key " + 
                    ContainerId + ", " + ComputerId + ", " + StartTime + ", " + ConfigurationId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public ContainerExecution[] getContainerExecutionWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<ContainerExecution> list = new ArrayList<ContainerExecution> ();
	    	ContainerExecution item = null;
	    	String s = "SELECT * FROM ContainerExecution";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new ContainerExecution ();
	    		assignContainerExecution(item,result);
	    		list.add(item);
	    	}
	    	ContainerExecution[] tmp = new ContainerExecution [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addContainerExecution(ContainerExecution data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addContainerExecution.setInt(1,data.getContainerId());

            addContainerExecution.setInt(2,data.getConfigurationId());

            addContainerExecution.setInt(3,data.getComputerId());

	        addContainerExecution.setLong(4,data.getStartTime().get());

	        addContainerExecution.setLong(5,data.getEndTime().get());

	        addContainerExecution.setBoolean(6,data.getNormalStart());

	        addContainerExecution.setBoolean(7,data.getNormalTermination());

		    addContainerExecution.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			ContainerExecution addedRow = getContainerExecution (data.getContainerId(), data.getComputerId(), data.getStartTime(), data.getConfigurationId() );        
            return addedRow.getContainerExecutionId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table ContainerExecution!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addContainerExecution(ContainerExecution data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			ContainerExecution x = getContainerExecution(data.getContainerId(), data.getComputerId(), data.getStartTime(), data.getConfigurationId() );
	    		return x.getContainerExecutionId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addContainerExecution(data);

    }

    public void deleteContainerExecution (int ContainerExecutionId) throws AcsJTmcdbSqlEx {
        try {
            deleteContainerExecutionKey.setInt(1, ContainerExecutionId);
			deleteContainerExecutionKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteContainerExecution (int ContainerId, int ComputerId, ArrayTime StartTime, int ConfigurationId) throws AcsJTmcdbSqlEx {
        try {

            deleteContainerExecutionAlt.setInt(1, ContainerId);

            deleteContainerExecutionAlt.setInt(2, ComputerId);

	      	deleteContainerExecutionAlt.setLong(3, StartTime.get());

            deleteContainerExecutionAlt.setInt(4, ConfigurationId);

			deleteContainerExecutionAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateContainerExecution(ContainerExecution data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        ContainerExecution x = null;

        x = getContainerExecution(data.getContainerExecutionId());

        // You can't change the keys.
		if (x.getContainerExecutionId() != data.getContainerExecutionId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getContainerId() != data.getContainerId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getComputerId() != data.getComputerId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartTime().get() != data.getStartTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateContainerExecution.setInt(1,data.getContainerExecutionId());

            updateContainerExecution.setInt(2,data.getContainerId());

            updateContainerExecution.setInt(3,data.getConfigurationId());

            updateContainerExecution.setInt(4,data.getComputerId());

	        updateContainerExecution.setLong(5,data.getStartTime().get());

	        updateContainerExecution.setLong(6,data.getEndTime().get());

	        updateContainerExecution.setBoolean(7,data.getNormalStart());

	        updateContainerExecution.setBoolean(8,data.getNormalTermination());

      		updateContainerExecution.setInt(9, data.getContainerExecutionId()); 
			updateContainerExecution.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // ComponentExecution
    /////////////////////////////////////////

    public void assignComponentExecution(ComponentExecution x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setComponentExecutionId(result.getInt(1));

        x.setComponentExecutionAcsId(result.getLong(2));

        x.setComponentId(result.getInt(3));

        x.setConfigurationId(result.getInt(4));

        x.setContainerId(result.getInt(5));

	    x.setStartTime(new ArrayTime(result.getLong(6)));

	    x.setEndTime(new ArrayTime(result.getLong(7)));

        // if (result.wasNull())
        // 	x.setEndTimeNull();

	    x.setNormalStart(result.getBoolean(8));

	    x.setNormalTermination(result.getBoolean(9));

        x.setBaseElementOnlineId(result.getInt(10));

        // if (result.wasNull())
        // 	x.setBaseElementOnlineIdNull();

        x.setAssemblyId(result.getInt(11));

        // if (result.wasNull())
        // 	x.setAssemblyIdNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public ComponentExecution getComponentExecution (int ComponentExecutionId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getComponentExecutionKey.setInt(1, ComponentExecutionId);
            ResultSet result = getComponentExecutionKey.executeQuery();
            ComponentExecution x = new ComponentExecution ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in ComponentExecution tables with key " + 
                    ComponentExecutionId);

            assignComponentExecution(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for ComponentExecution table (key " + 
                    ComponentExecutionId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public ComponentExecution getComponentExecution (int ComponentId, ArrayTime StartTime, int ConfigurationId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getComponentExecutionAlt.setInt(1, ComponentId);

	      	getComponentExecutionAlt.setLong(2, StartTime.get());

            getComponentExecutionAlt.setInt(3, ConfigurationId);

            ResultSet result = getComponentExecutionAlt.executeQuery();
            ComponentExecution x = new ComponentExecution ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in ComponentExecution tables with key " + 
                    ComponentId + ", " + StartTime + ", " + ConfigurationId);

            assignComponentExecution(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for ComponentExecution table (key " + 
                    ComponentId + ", " + StartTime + ", " + ConfigurationId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public ComponentExecution[] getComponentExecutionWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<ComponentExecution> list = new ArrayList<ComponentExecution> ();
	    	ComponentExecution item = null;
	    	String s = "SELECT * FROM ComponentExecution";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new ComponentExecution ();
	    		assignComponentExecution(item,result);
	    		list.add(item);
	    	}
	    	ComponentExecution[] tmp = new ComponentExecution [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addComponentExecution(ComponentExecution data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addComponentExecution.setLong(1,data.getComponentExecutionAcsId());

            addComponentExecution.setInt(2,data.getComponentId());

            addComponentExecution.setInt(3,data.getConfigurationId());

            addComponentExecution.setInt(4,data.getContainerId());

	        addComponentExecution.setLong(5,data.getStartTime().get());

	        addComponentExecution.setLong(6,data.getEndTime().get());

	        addComponentExecution.setBoolean(7,data.getNormalStart());

	        addComponentExecution.setBoolean(8,data.getNormalTermination());

            addComponentExecution.setInt(9,data.getBaseElementOnlineId());

            addComponentExecution.setInt(10,data.getAssemblyId());

		    addComponentExecution.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			ComponentExecution addedRow = getComponentExecution (data.getComponentId(), data.getStartTime(), data.getConfigurationId() );        
            return addedRow.getComponentExecutionId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table ComponentExecution!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addComponentExecution(ComponentExecution data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			ComponentExecution x = getComponentExecution(data.getComponentId(), data.getStartTime(), data.getConfigurationId() );
	    		return x.getComponentExecutionId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addComponentExecution(data);

    }

    public void deleteComponentExecution (int ComponentExecutionId) throws AcsJTmcdbSqlEx {
        try {
            deleteComponentExecutionKey.setInt(1, ComponentExecutionId);
			deleteComponentExecutionKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteComponentExecution (int ComponentId, ArrayTime StartTime, int ConfigurationId) throws AcsJTmcdbSqlEx {
        try {

            deleteComponentExecutionAlt.setInt(1, ComponentId);

	      	deleteComponentExecutionAlt.setLong(2, StartTime.get());

            deleteComponentExecutionAlt.setInt(3, ConfigurationId);

			deleteComponentExecutionAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateComponentExecution(ComponentExecution data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        ComponentExecution x = null;

        x = getComponentExecution(data.getComponentExecutionId());

        // You can't change the keys.
		if (x.getComponentExecutionId() != data.getComponentExecutionId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getComponentId() != data.getComponentId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartTime().get() != data.getStartTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateComponentExecution.setInt(1,data.getComponentExecutionId());

            updateComponentExecution.setLong(2,data.getComponentExecutionAcsId());

            updateComponentExecution.setInt(3,data.getComponentId());

            updateComponentExecution.setInt(4,data.getConfigurationId());

            updateComponentExecution.setInt(5,data.getContainerId());

	        updateComponentExecution.setLong(6,data.getStartTime().get());

	        updateComponentExecution.setLong(7,data.getEndTime().get());

	        updateComponentExecution.setBoolean(8,data.getNormalStart());

	        updateComponentExecution.setBoolean(9,data.getNormalTermination());

            updateComponentExecution.setInt(10,data.getBaseElementOnlineId());

            updateComponentExecution.setInt(11,data.getAssemblyId());

      		updateComponentExecution.setInt(12, data.getComponentExecutionId()); 
			updateComponentExecution.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // MasterComponentExecution
    /////////////////////////////////////////

    public void assignMasterComponentExecution(MasterComponentExecution x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setMasterComponentExecId(result.getInt(1));

        x.setMasterComponentId(result.getInt(2));

        x.setConfigurationId(result.getInt(3));

        x.setContainerId(result.getInt(4));

	    x.setStartTime(new ArrayTime(result.getLong(5)));

	    x.setEndTime(new ArrayTime(result.getLong(6)));

        // if (result.wasNull())
        // 	x.setEndTimeNull();

	    x.setNormalStart(result.getBoolean(7));

	    x.setNormalTermination(result.getBoolean(8));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public MasterComponentExecution getMasterComponentExecution (int MasterComponentExecId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getMasterComponentExecutionKey.setInt(1, MasterComponentExecId);
            ResultSet result = getMasterComponentExecutionKey.executeQuery();
            MasterComponentExecution x = new MasterComponentExecution ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in MasterComponentExecution tables with key " + 
                    MasterComponentExecId);

            assignMasterComponentExecution(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for MasterComponentExecution table (key " + 
                    MasterComponentExecId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public MasterComponentExecution getMasterComponentExecution (int MasterComponentId, int ContainerId, ArrayTime StartTime, int ConfigurationId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getMasterComponentExecutionAlt.setInt(1, MasterComponentId);

            getMasterComponentExecutionAlt.setInt(2, ContainerId);

	      	getMasterComponentExecutionAlt.setLong(3, StartTime.get());

            getMasterComponentExecutionAlt.setInt(4, ConfigurationId);

            ResultSet result = getMasterComponentExecutionAlt.executeQuery();
            MasterComponentExecution x = new MasterComponentExecution ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in MasterComponentExecution tables with key " + 
                    MasterComponentId + ", " + ContainerId + ", " + StartTime + ", " + ConfigurationId);

            assignMasterComponentExecution(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for MasterComponentExecution table (key " + 
                    MasterComponentId + ", " + ContainerId + ", " + StartTime + ", " + ConfigurationId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public MasterComponentExecution[] getMasterComponentExecutionWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<MasterComponentExecution> list = new ArrayList<MasterComponentExecution> ();
	    	MasterComponentExecution item = null;
	    	String s = "SELECT * FROM MasterComponentExecution";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new MasterComponentExecution ();
	    		assignMasterComponentExecution(item,result);
	    		list.add(item);
	    	}
	    	MasterComponentExecution[] tmp = new MasterComponentExecution [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addMasterComponentExecution(MasterComponentExecution data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addMasterComponentExecution.setInt(1,data.getMasterComponentId());

            addMasterComponentExecution.setInt(2,data.getConfigurationId());

            addMasterComponentExecution.setInt(3,data.getContainerId());

	        addMasterComponentExecution.setLong(4,data.getStartTime().get());

	        addMasterComponentExecution.setLong(5,data.getEndTime().get());

	        addMasterComponentExecution.setBoolean(6,data.getNormalStart());

	        addMasterComponentExecution.setBoolean(7,data.getNormalTermination());

		    addMasterComponentExecution.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			MasterComponentExecution addedRow = getMasterComponentExecution (data.getMasterComponentId(), data.getContainerId(), data.getStartTime(), data.getConfigurationId() );        
            return addedRow.getMasterComponentExecId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table MasterComponentExecution!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addMasterComponentExecution(MasterComponentExecution data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			MasterComponentExecution x = getMasterComponentExecution(data.getMasterComponentId(), data.getContainerId(), data.getStartTime(), data.getConfigurationId() );
	    		return x.getMasterComponentExecId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addMasterComponentExecution(data);

    }

    public void deleteMasterComponentExecution (int MasterComponentExecId) throws AcsJTmcdbSqlEx {
        try {
            deleteMasterComponentExecutionKey.setInt(1, MasterComponentExecId);
			deleteMasterComponentExecutionKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteMasterComponentExecution (int MasterComponentId, int ContainerId, ArrayTime StartTime, int ConfigurationId) throws AcsJTmcdbSqlEx {
        try {

            deleteMasterComponentExecutionAlt.setInt(1, MasterComponentId);

            deleteMasterComponentExecutionAlt.setInt(2, ContainerId);

	      	deleteMasterComponentExecutionAlt.setLong(3, StartTime.get());

            deleteMasterComponentExecutionAlt.setInt(4, ConfigurationId);

			deleteMasterComponentExecutionAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateMasterComponentExecution(MasterComponentExecution data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        MasterComponentExecution x = null;

        x = getMasterComponentExecution(data.getMasterComponentExecId());

        // You can't change the keys.
		if (x.getMasterComponentExecId() != data.getMasterComponentExecId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getMasterComponentId() != data.getMasterComponentId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getContainerId() != data.getContainerId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartTime().get() != data.getStartTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateMasterComponentExecution.setInt(1,data.getMasterComponentExecId());

            updateMasterComponentExecution.setInt(2,data.getMasterComponentId());

            updateMasterComponentExecution.setInt(3,data.getConfigurationId());

            updateMasterComponentExecution.setInt(4,data.getContainerId());

	        updateMasterComponentExecution.setLong(5,data.getStartTime().get());

	        updateMasterComponentExecution.setLong(6,data.getEndTime().get());

	        updateMasterComponentExecution.setBoolean(7,data.getNormalStart());

	        updateMasterComponentExecution.setBoolean(8,data.getNormalTermination());

      		updateMasterComponentExecution.setInt(9, data.getMasterComponentExecId()); 
			updateMasterComponentExecution.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // ACS
    /////////////////////////////////////////

    public void assignACS(ACS x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setACSId(result.getInt(1));

        x.setACSVersion(result.getString(2));

        x.setConfigurationId(result.getInt(3));

        x.setComputerId(result.getInt(4));

        x.setVar1(result.getString(5));

        // if (result.wasNull())
        // 	x.setVar1Null();

        x.setVar2(result.getString(6));

        // if (result.wasNull())
        // 	x.setVar2Null();

        x.setVar3(result.getString(7));

        // if (result.wasNull())
        // 	x.setVar3Null();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public ACS getACS (int ACSId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getACSKey.setInt(1, ACSId);
            ResultSet result = getACSKey.executeQuery();
            ACS x = new ACS ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in ACS tables with key " + 
                    ACSId);

            assignACS(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for ACS table (key " + 
                    ACSId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public ACS getACS (String ACSVersion, int ConfigurationId, int ComputerId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getACSAlt.setString(1, ACSVersion);

            getACSAlt.setInt(2, ConfigurationId);

            getACSAlt.setInt(3, ComputerId);

            ResultSet result = getACSAlt.executeQuery();
            ACS x = new ACS ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in ACS tables with key " + 
                    ACSVersion + ", " + ConfigurationId + ", " + ComputerId);

            assignACS(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for ACS table (key " + 
                    ACSVersion + ", " + ConfigurationId + ", " + ComputerId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public ACS[] getACSWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<ACS> list = new ArrayList<ACS> ();
	    	ACS item = null;
	    	String s = "SELECT * FROM ACS";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new ACS ();
	    		assignACS(item,result);
	    		list.add(item);
	    	}
	    	ACS[] tmp = new ACS [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addACS(ACS data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addACS.setString(1,data.getACSVersion());

            addACS.setInt(2,data.getConfigurationId());

            addACS.setInt(3,data.getComputerId());

            addACS.setString(4,data.getVar1());

            addACS.setString(5,data.getVar2());

            addACS.setString(6,data.getVar3());

		    addACS.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			ACS addedRow = getACS (data.getACSVersion(), data.getConfigurationId(), data.getComputerId() );        
            return addedRow.getACSId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table ACS!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addACS(ACS data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			ACS x = getACS(data.getACSVersion(), data.getConfigurationId(), data.getComputerId() );
	    		return x.getACSId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addACS(data);

    }

    public void deleteACS (int ACSId) throws AcsJTmcdbSqlEx {
        try {
            deleteACSKey.setInt(1, ACSId);
			deleteACSKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteACS (String ACSVersion, int ConfigurationId, int ComputerId) throws AcsJTmcdbSqlEx {
        try {

            deleteACSAlt.setString(1, ACSVersion);

            deleteACSAlt.setInt(2, ConfigurationId);

            deleteACSAlt.setInt(3, ComputerId);

			deleteACSAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateACS(ACS data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        ACS x = null;

        x = getACS(data.getACSId());

        // You can't change the keys.
		if (x.getACSId() != data.getACSId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getACSVersion().equals(data.getACSVersion()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getComputerId() != data.getComputerId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateACS.setInt(1,data.getACSId());

            updateACS.setString(2,data.getACSVersion());

            updateACS.setInt(3,data.getConfigurationId());

            updateACS.setInt(4,data.getComputerId());

            updateACS.setString(5,data.getVar1());

            updateACS.setString(6,data.getVar2());

            updateACS.setString(7,data.getVar3());

      		updateACS.setInt(8, data.getACSId()); 
			updateACS.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // ACSExecution
    /////////////////////////////////////////

    public void assignACSExecution(ACSExecution x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setACSId(result.getInt(1));

        x.setConfigurationId(result.getInt(2));

	    x.setStartTime(new ArrayTime(result.getLong(3)));

	    x.setEndTime(new ArrayTime(result.getLong(4)));

        // if (result.wasNull())
        // 	x.setEndTimeNull();

	    x.setNormalStart(result.getBoolean(5));

	    x.setNormalTermination(result.getBoolean(6));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public ACSExecution getACSExecution (int ACSId, int ConfigurationId, ArrayTime StartTime) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getACSExecutionKey.setInt(1, ACSId);

          	getACSExecutionKey.setInt(2, ConfigurationId);

	      	getACSExecutionKey.setLong(3, StartTime.get());

            ResultSet result = getACSExecutionKey.executeQuery();
            ACSExecution x = new ACSExecution ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in ACSExecution tables with key " + 
                    ACSId + ", " + ConfigurationId + ", " + StartTime);
            assignACSExecution(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for ACSExecution table (key " + 
                    ACSId + ", " + ConfigurationId + ", " + StartTime + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public ACSExecution[] getACSExecutionWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<ACSExecution> list = new ArrayList<ACSExecution> ();
	    	ACSExecution item = null;
	    	String s = "SELECT * FROM ACSExecution";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new ACSExecution ();
	    		assignACSExecution(item,result);
	    		list.add(item);
	    	}
	    	ACSExecution[] tmp = new ACSExecution [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addACSExecution(ACSExecution data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    ACSExecution x = getACSExecution(data.getACSId(), data.getConfigurationId(), data.getStartTime());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addACSExecution.setInt(1,data.getACSId());

            addACSExecution.setInt(2,data.getConfigurationId());

	        addACSExecution.setLong(3,data.getStartTime().get());

	        addACSExecution.setLong(4,data.getEndTime().get());

	        addACSExecution.setBoolean(5,data.getNormalStart());

	        addACSExecution.setBoolean(6,data.getNormalTermination());

			addACSExecution.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addACSExecution(ACSExecution data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				ACSExecution x = getACSExecution(data.getACSId(), data.getConfigurationId(), data.getStartTime());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addACSExecution(data);

    }

    public void deleteACSExecution (int ACSId, int ConfigurationId, ArrayTime StartTime) throws AcsJTmcdbSqlEx {
        try {

          	deleteACSExecutionKey.setInt(1, ACSId);

          	deleteACSExecutionKey.setInt(2, ConfigurationId);

	      	deleteACSExecutionKey.setLong(3, StartTime.get());

			deleteACSExecutionKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateACSExecution(ACSExecution data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        ACSExecution x = null;
        try {
            x = getACSExecution(data.getACSId(), data.getConfigurationId(), data.getStartTime());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getACSId() != data.getACSId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartTime().get() != data.getStartTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateACSExecution.setInt(1,data.getACSId());

            updateACSExecution.setInt(2,data.getConfigurationId());

	        updateACSExecution.setLong(3,data.getStartTime().get());

	        updateACSExecution.setLong(4,data.getEndTime().get());

	        updateACSExecution.setBoolean(5,data.getNormalStart());

	        updateACSExecution.setBoolean(6,data.getNormalTermination());

          	updateACSExecution.setInt(6 + 1, data.getACSId());

          	updateACSExecution.setInt(6 + 2, data.getConfigurationId());

	      	updateACSExecution.setLong(6 + 3, data.getStartTime().get());

			updateACSExecution.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // NotificationChannel
    /////////////////////////////////////////

    public void assignNotificationChannel(NotificationChannel x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setNCId(result.getInt(1));

        x.setNCName(result.getString(2));

        x.setSubsystemName(result.getString(3));

        x.setConfigurationId(result.getInt(4));

        x.setQOS1(result.getString(5));

        // if (result.wasNull())
        // 	x.setQOS1Null();

        x.setQOS2(result.getString(6));

        // if (result.wasNull())
        // 	x.setQOS2Null();

        x.setQOS3(result.getString(7));

        // if (result.wasNull())
        // 	x.setQOS3Null();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public NotificationChannel getNotificationChannel (int NCId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getNotificationChannelKey.setInt(1, NCId);
            ResultSet result = getNotificationChannelKey.executeQuery();
            NotificationChannel x = new NotificationChannel ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in NotificationChannel tables with key " + 
                    NCId);

            assignNotificationChannel(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for NotificationChannel table (key " + 
                    NCId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public NotificationChannel getNotificationChannel (String NCName, int ConfigurationId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getNotificationChannelAlt.setString(1, NCName);

            getNotificationChannelAlt.setInt(2, ConfigurationId);

            ResultSet result = getNotificationChannelAlt.executeQuery();
            NotificationChannel x = new NotificationChannel ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in NotificationChannel tables with key " + 
                    NCName + ", " + ConfigurationId);

            assignNotificationChannel(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for NotificationChannel table (key " + 
                    NCName + ", " + ConfigurationId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public NotificationChannel[] getNotificationChannelWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<NotificationChannel> list = new ArrayList<NotificationChannel> ();
	    	NotificationChannel item = null;
	    	String s = "SELECT * FROM NotificationChannel";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new NotificationChannel ();
	    		assignNotificationChannel(item,result);
	    		list.add(item);
	    	}
	    	NotificationChannel[] tmp = new NotificationChannel [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addNotificationChannel(NotificationChannel data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addNotificationChannel.setString(1,data.getNCName());

            addNotificationChannel.setString(2,data.getSubsystemName());

            addNotificationChannel.setInt(3,data.getConfigurationId());

            addNotificationChannel.setString(4,data.getQOS1());

            addNotificationChannel.setString(5,data.getQOS2());

            addNotificationChannel.setString(6,data.getQOS3());

		    addNotificationChannel.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			NotificationChannel addedRow = getNotificationChannel (data.getNCName(), data.getConfigurationId() );        
            return addedRow.getNCId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table NotificationChannel!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addNotificationChannel(NotificationChannel data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			NotificationChannel x = getNotificationChannel(data.getNCName(), data.getConfigurationId() );
	    		return x.getNCId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addNotificationChannel(data);

    }

    public void deleteNotificationChannel (int NCId) throws AcsJTmcdbSqlEx {
        try {
            deleteNotificationChannelKey.setInt(1, NCId);
			deleteNotificationChannelKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteNotificationChannel (String NCName, int ConfigurationId) throws AcsJTmcdbSqlEx {
        try {

            deleteNotificationChannelAlt.setString(1, NCName);

            deleteNotificationChannelAlt.setInt(2, ConfigurationId);

			deleteNotificationChannelAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateNotificationChannel(NotificationChannel data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        NotificationChannel x = null;

        x = getNotificationChannel(data.getNCId());

        // You can't change the keys.
		if (x.getNCId() != data.getNCId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getNCName().equals(data.getNCName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateNotificationChannel.setInt(1,data.getNCId());

            updateNotificationChannel.setString(2,data.getNCName());

            updateNotificationChannel.setString(3,data.getSubsystemName());

            updateNotificationChannel.setInt(4,data.getConfigurationId());

            updateNotificationChannel.setString(5,data.getQOS1());

            updateNotificationChannel.setString(6,data.getQOS2());

            updateNotificationChannel.setString(7,data.getQOS3());

      		updateNotificationChannel.setInt(8, data.getNCId()); 
			updateNotificationChannel.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // NCExecution
    /////////////////////////////////////////

    public void assignNCExecution(NCExecution x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setNCId(result.getInt(1));

        x.setACSId(result.getInt(2));

        x.setConfigurationId(result.getInt(3));

	    x.setStartTime(new ArrayTime(result.getLong(4)));

	    x.setEndTime(new ArrayTime(result.getLong(5)));

        // if (result.wasNull())
        // 	x.setEndTimeNull();

	    x.setNormalStart(result.getBoolean(6));

	    x.setNormalTermination(result.getBoolean(7));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public NCExecution getNCExecution (int NCId, int ConfigurationId, ArrayTime StartTime) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getNCExecutionKey.setInt(1, NCId);

          	getNCExecutionKey.setInt(2, ConfigurationId);

	      	getNCExecutionKey.setLong(3, StartTime.get());

            ResultSet result = getNCExecutionKey.executeQuery();
            NCExecution x = new NCExecution ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in NCExecution tables with key " + 
                    NCId + ", " + ConfigurationId + ", " + StartTime);
            assignNCExecution(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for NCExecution table (key " + 
                    NCId + ", " + ConfigurationId + ", " + StartTime + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public NCExecution[] getNCExecutionWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<NCExecution> list = new ArrayList<NCExecution> ();
	    	NCExecution item = null;
	    	String s = "SELECT * FROM NCExecution";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new NCExecution ();
	    		assignNCExecution(item,result);
	    		list.add(item);
	    	}
	    	NCExecution[] tmp = new NCExecution [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addNCExecution(NCExecution data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    NCExecution x = getNCExecution(data.getNCId(), data.getConfigurationId(), data.getStartTime());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addNCExecution.setInt(1,data.getNCId());

            addNCExecution.setInt(2,data.getACSId());

            addNCExecution.setInt(3,data.getConfigurationId());

	        addNCExecution.setLong(4,data.getStartTime().get());

	        addNCExecution.setLong(5,data.getEndTime().get());

	        addNCExecution.setBoolean(6,data.getNormalStart());

	        addNCExecution.setBoolean(7,data.getNormalTermination());

			addNCExecution.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addNCExecution(NCExecution data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				NCExecution x = getNCExecution(data.getNCId(), data.getConfigurationId(), data.getStartTime());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addNCExecution(data);

    }

    public void deleteNCExecution (int NCId, int ConfigurationId, ArrayTime StartTime) throws AcsJTmcdbSqlEx {
        try {

          	deleteNCExecutionKey.setInt(1, NCId);

          	deleteNCExecutionKey.setInt(2, ConfigurationId);

	      	deleteNCExecutionKey.setLong(3, StartTime.get());

			deleteNCExecutionKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateNCExecution(NCExecution data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        NCExecution x = null;
        try {
            x = getNCExecution(data.getNCId(), data.getConfigurationId(), data.getStartTime());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getNCId() != data.getNCId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartTime().get() != data.getStartTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateNCExecution.setInt(1,data.getNCId());

            updateNCExecution.setInt(2,data.getACSId());

            updateNCExecution.setInt(3,data.getConfigurationId());

	        updateNCExecution.setLong(4,data.getStartTime().get());

	        updateNCExecution.setLong(5,data.getEndTime().get());

	        updateNCExecution.setBoolean(6,data.getNormalStart());

	        updateNCExecution.setBoolean(7,data.getNormalTermination());

          	updateNCExecution.setInt(7 + 1, data.getNCId());

          	updateNCExecution.setInt(7 + 2, data.getConfigurationId());

	      	updateNCExecution.setLong(7 + 3, data.getStartTime().get());

			updateNCExecution.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // Startup
    /////////////////////////////////////////

    public void assignStartup(Startup x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setStartupId(result.getInt(1));

        x.setConfigurationId(result.getInt(2));

        x.setStartupName(result.getString(3));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public Startup getStartup (int StartupId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getStartupKey.setInt(1, StartupId);
            ResultSet result = getStartupKey.executeQuery();
            Startup x = new Startup ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Startup tables with key " + 
                    StartupId);

            assignStartup(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Startup table (key " + 
                    StartupId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public Startup getStartup (String StartupName, int ConfigurationId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getStartupAlt.setString(1, StartupName);

            getStartupAlt.setInt(2, ConfigurationId);

            ResultSet result = getStartupAlt.executeQuery();
            Startup x = new Startup ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Startup tables with key " + 
                    StartupName + ", " + ConfigurationId);

            assignStartup(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Startup table (key " + 
                    StartupName + ", " + ConfigurationId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public Startup[] getStartupWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<Startup> list = new ArrayList<Startup> ();
	    	Startup item = null;
	    	String s = "SELECT * FROM Startup";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new Startup ();
	    		assignStartup(item,result);
	    		list.add(item);
	    	}
	    	Startup[] tmp = new Startup [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addStartup(Startup data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addStartup.setInt(1,data.getConfigurationId());

            addStartup.setString(2,data.getStartupName());

		    addStartup.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			Startup addedRow = getStartup (data.getStartupName(), data.getConfigurationId() );        
            return addedRow.getStartupId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table Startup!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addStartup(Startup data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			Startup x = getStartup(data.getStartupName(), data.getConfigurationId() );
	    		return x.getStartupId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addStartup(data);

    }

    public void deleteStartup (int StartupId) throws AcsJTmcdbSqlEx {
        try {
            deleteStartupKey.setInt(1, StartupId);
			deleteStartupKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteStartup (String StartupName, int ConfigurationId) throws AcsJTmcdbSqlEx {
        try {

            deleteStartupAlt.setString(1, StartupName);

            deleteStartupAlt.setInt(2, ConfigurationId);

			deleteStartupAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateStartup(Startup data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        Startup x = null;

        x = getStartup(data.getStartupId());

        // You can't change the keys.
		if (x.getStartupId() != data.getStartupId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getStartupName().equals(data.getStartupName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateStartup.setInt(1,data.getStartupId());

            updateStartup.setInt(2,data.getConfigurationId());

            updateStartup.setString(3,data.getStartupName());

      		updateStartup.setInt(4, data.getStartupId()); 
			updateStartup.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // SystemExecution
    /////////////////////////////////////////

    public void assignSystemExecution(SystemExecution x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setStartupId(result.getInt(1));

        x.setConfigurationId(result.getInt(2));

	    x.setStartTime(new ArrayTime(result.getLong(3)));

	    x.setEndTime(new ArrayTime(result.getLong(4)));

        // if (result.wasNull())
        // 	x.setEndTimeNull();

	    x.setNormalStart(result.getBoolean(5));

	    x.setNormalTermination(result.getBoolean(6));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public SystemExecution getSystemExecution (int StartupId, int ConfigurationId, ArrayTime StartTime) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getSystemExecutionKey.setInt(1, StartupId);

          	getSystemExecutionKey.setInt(2, ConfigurationId);

	      	getSystemExecutionKey.setLong(3, StartTime.get());

            ResultSet result = getSystemExecutionKey.executeQuery();
            SystemExecution x = new SystemExecution ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in SystemExecution tables with key " + 
                    StartupId + ", " + ConfigurationId + ", " + StartTime);
            assignSystemExecution(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for SystemExecution table (key " + 
                    StartupId + ", " + ConfigurationId + ", " + StartTime + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public SystemExecution[] getSystemExecutionWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<SystemExecution> list = new ArrayList<SystemExecution> ();
	    	SystemExecution item = null;
	    	String s = "SELECT * FROM SystemExecution";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new SystemExecution ();
	    		assignSystemExecution(item,result);
	    		list.add(item);
	    	}
	    	SystemExecution[] tmp = new SystemExecution [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addSystemExecution(SystemExecution data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    SystemExecution x = getSystemExecution(data.getStartupId(), data.getConfigurationId(), data.getStartTime());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addSystemExecution.setInt(1,data.getStartupId());

            addSystemExecution.setInt(2,data.getConfigurationId());

	        addSystemExecution.setLong(3,data.getStartTime().get());

	        addSystemExecution.setLong(4,data.getEndTime().get());

	        addSystemExecution.setBoolean(5,data.getNormalStart());

	        addSystemExecution.setBoolean(6,data.getNormalTermination());

			addSystemExecution.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addSystemExecution(SystemExecution data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				SystemExecution x = getSystemExecution(data.getStartupId(), data.getConfigurationId(), data.getStartTime());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addSystemExecution(data);

    }

    public void deleteSystemExecution (int StartupId, int ConfigurationId, ArrayTime StartTime) throws AcsJTmcdbSqlEx {
        try {

          	deleteSystemExecutionKey.setInt(1, StartupId);

          	deleteSystemExecutionKey.setInt(2, ConfigurationId);

	      	deleteSystemExecutionKey.setLong(3, StartTime.get());

			deleteSystemExecutionKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateSystemExecution(SystemExecution data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        SystemExecution x = null;
        try {
            x = getSystemExecution(data.getStartupId(), data.getConfigurationId(), data.getStartTime());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getStartupId() != data.getStartupId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartTime().get() != data.getStartTime().get())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateSystemExecution.setInt(1,data.getStartupId());

            updateSystemExecution.setInt(2,data.getConfigurationId());

	        updateSystemExecution.setLong(3,data.getStartTime().get());

	        updateSystemExecution.setLong(4,data.getEndTime().get());

	        updateSystemExecution.setBoolean(5,data.getNormalStart());

	        updateSystemExecution.setBoolean(6,data.getNormalTermination());

          	updateSystemExecution.setInt(6 + 1, data.getStartupId());

          	updateSystemExecution.setInt(6 + 2, data.getConfigurationId());

	      	updateSystemExecution.setLong(6 + 3, data.getStartTime().get());

			updateSystemExecution.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // DeploymentStartup
    /////////////////////////////////////////

    public void assignDeploymentStartup(DeploymentStartup x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setName(result.getString(1));

        x.setPath(result.getString(2));

        x.setStartupType(result.getString(3));

        x.setStartupId(result.getInt(4));

        x.setDependsOnName(result.getString(5));

        // if (result.wasNull())
        // 	x.setDependsOnNameNull();

        x.setDependsOnPath(result.getString(6));

        // if (result.wasNull())
        // 	x.setDependsOnPathNull();

        x.setDependsOnType(result.getString(7));

        // if (result.wasNull())
        // 	x.setDependsOnTypeNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public DeploymentStartup getDeploymentStartup (String Name, String Path, String StartupType, int StartupId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getDeploymentStartupKey.setString(1, Name);

          	getDeploymentStartupKey.setString(2, Path);

          	getDeploymentStartupKey.setString(3, StartupType);

          	getDeploymentStartupKey.setInt(4, StartupId);

            ResultSet result = getDeploymentStartupKey.executeQuery();
            DeploymentStartup x = new DeploymentStartup ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in DeploymentStartup tables with key " + 
                    Name + ", " + Path + ", " + StartupType + ", " + StartupId);
            assignDeploymentStartup(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for DeploymentStartup table (key " + 
                    Name + ", " + Path + ", " + StartupType + ", " + StartupId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public DeploymentStartup[] getDeploymentStartupWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<DeploymentStartup> list = new ArrayList<DeploymentStartup> ();
	    	DeploymentStartup item = null;
	    	String s = "SELECT * FROM DeploymentStartup";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new DeploymentStartup ();
	    		assignDeploymentStartup(item,result);
	    		list.add(item);
	    	}
	    	DeploymentStartup[] tmp = new DeploymentStartup [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addDeploymentStartup(DeploymentStartup data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    DeploymentStartup x = getDeploymentStartup(data.getName(), data.getPath(), data.getStartupType(), data.getStartupId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addDeploymentStartup.setString(1,data.getName());

            addDeploymentStartup.setString(2,data.getPath());

            addDeploymentStartup.setString(3,data.getStartupType());

            addDeploymentStartup.setInt(4,data.getStartupId());

            addDeploymentStartup.setString(5,data.getDependsOnName());

            addDeploymentStartup.setString(6,data.getDependsOnPath());

            addDeploymentStartup.setString(7,data.getDependsOnType());

			addDeploymentStartup.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addDeploymentStartup(DeploymentStartup data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				DeploymentStartup x = getDeploymentStartup(data.getName(), data.getPath(), data.getStartupType(), data.getStartupId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addDeploymentStartup(data);

    }

    public void deleteDeploymentStartup (String Name, String Path, String StartupType, int StartupId) throws AcsJTmcdbSqlEx {
        try {

          	deleteDeploymentStartupKey.setString(1, Name);

          	deleteDeploymentStartupKey.setString(2, Path);

          	deleteDeploymentStartupKey.setString(3, StartupType);

          	deleteDeploymentStartupKey.setInt(4, StartupId);

			deleteDeploymentStartupKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateDeploymentStartup(DeploymentStartup data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        DeploymentStartup x = null;
        try {
            x = getDeploymentStartup(data.getName(), data.getPath(), data.getStartupType(), data.getStartupId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (!x.getName().equals(data.getName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getPath().equals(data.getPath()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getStartupType().equals(data.getStartupType()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartupId() != data.getStartupId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateDeploymentStartup.setString(1,data.getName());

            updateDeploymentStartup.setString(2,data.getPath());

            updateDeploymentStartup.setString(3,data.getStartupType());

            updateDeploymentStartup.setInt(4,data.getStartupId());

            updateDeploymentStartup.setString(5,data.getDependsOnName());

            updateDeploymentStartup.setString(6,data.getDependsOnPath());

            updateDeploymentStartup.setString(7,data.getDependsOnType());

          	updateDeploymentStartup.setString(7 + 1, data.getName());

          	updateDeploymentStartup.setString(7 + 2, data.getPath());

          	updateDeploymentStartup.setString(7 + 3, data.getStartupType());

          	updateDeploymentStartup.setInt(7 + 4, data.getStartupId());

			updateDeploymentStartup.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // BaseElementStartup
    /////////////////////////////////////////

    public void assignBaseElementStartup(BaseElementStartup x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setBaseElementStartupId(result.getInt(1));

        x.setBaseElementId(result.getInt(2));

        // if (result.wasNull())
        // 	x.setBaseElementIdNull();

        x.setStartupId(result.getInt(3));

        // if (result.wasNull())
        // 	x.setStartupIdNull();

        x.setBaseElementType(result.getString(4));

        x.setParent(result.getInt(5));

        // if (result.wasNull())
        // 	x.setParentNull();

        x.setIsGeneric(result.getString(6));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public BaseElementStartup getBaseElementStartup (int BaseElementStartupId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getBaseElementStartupKey.setInt(1, BaseElementStartupId);
            ResultSet result = getBaseElementStartupKey.executeQuery();
            BaseElementStartup x = new BaseElementStartup ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in BaseElementStartup tables with key " + 
                    BaseElementStartupId);

            assignBaseElementStartup(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for BaseElementStartup table (key " + 
                    BaseElementStartupId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public BaseElementStartup getBaseElementStartup (Integer StartupId, Integer BaseElementId, Integer Parent, String BaseElementType) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getBaseElementStartupAlt.setInt(1, StartupId);

            getBaseElementStartupAlt.setInt(2, BaseElementId);

            getBaseElementStartupAlt.setInt(3, Parent);

            getBaseElementStartupAlt.setString(4, BaseElementType);

            ResultSet result = getBaseElementStartupAlt.executeQuery();
            BaseElementStartup x = new BaseElementStartup ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in BaseElementStartup tables with key " + 
                    StartupId + ", " + BaseElementId + ", " + Parent + ", " + BaseElementType);

            assignBaseElementStartup(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for BaseElementStartup table (key " + 
                    StartupId + ", " + BaseElementId + ", " + Parent + ", " + BaseElementType + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public BaseElementStartup[] getBaseElementStartupWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<BaseElementStartup> list = new ArrayList<BaseElementStartup> ();
	    	BaseElementStartup item = null;
	    	String s = "SELECT * FROM BaseElementStartup";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new BaseElementStartup ();
	    		assignBaseElementStartup(item,result);
	    		list.add(item);
	    	}
	    	BaseElementStartup[] tmp = new BaseElementStartup [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addBaseElementStartup(BaseElementStartup data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addBaseElementStartup.setInt(1,data.getBaseElementId());

            addBaseElementStartup.setInt(2,data.getStartupId());

            addBaseElementStartup.setString(3,data.getBaseElementType());

            addBaseElementStartup.setInt(4,data.getParent());

            addBaseElementStartup.setString(5,data.getIsGeneric());

		    addBaseElementStartup.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			BaseElementStartup addedRow = getBaseElementStartup (data.getStartupId(), data.getBaseElementId(), data.getParent(), data.getBaseElementType() );        
            return addedRow.getBaseElementStartupId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table BaseElementStartup!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addBaseElementStartup(BaseElementStartup data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			BaseElementStartup x = getBaseElementStartup(data.getStartupId(), data.getBaseElementId(), data.getParent(), data.getBaseElementType() );
	    		return x.getBaseElementStartupId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addBaseElementStartup(data);

    }

    public void deleteBaseElementStartup (int BaseElementStartupId) throws AcsJTmcdbSqlEx {
        try {
            deleteBaseElementStartupKey.setInt(1, BaseElementStartupId);
			deleteBaseElementStartupKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteBaseElementStartup (Integer StartupId, Integer BaseElementId, Integer Parent, String BaseElementType) throws AcsJTmcdbSqlEx {
        try {

            deleteBaseElementStartupAlt.setInt(1, StartupId);

            deleteBaseElementStartupAlt.setInt(2, BaseElementId);

            deleteBaseElementStartupAlt.setInt(3, Parent);

            deleteBaseElementStartupAlt.setString(4, BaseElementType);

			deleteBaseElementStartupAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateBaseElementStartup(BaseElementStartup data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        BaseElementStartup x = null;

        x = getBaseElementStartup(data.getBaseElementStartupId());

        // You can't change the keys.
		if (x.getBaseElementStartupId() != data.getBaseElementStartupId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartupId() != data.getStartupId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getBaseElementId() != data.getBaseElementId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getParent() != data.getParent())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getBaseElementType().equals(data.getBaseElementType()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateBaseElementStartup.setInt(1,data.getBaseElementStartupId());

            updateBaseElementStartup.setInt(2,data.getBaseElementId());

            updateBaseElementStartup.setInt(3,data.getStartupId());

            updateBaseElementStartup.setString(4,data.getBaseElementType());

            updateBaseElementStartup.setInt(5,data.getParent());

            updateBaseElementStartup.setString(6,data.getIsGeneric());

      		updateBaseElementStartup.setInt(7, data.getBaseElementStartupId()); 
			updateBaseElementStartup.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // AssociatedBaseElement
    /////////////////////////////////////////

    public void assignAssociatedBaseElement(AssociatedBaseElement x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setBaseElementId(result.getInt(1));

        x.setStartupId(result.getInt(2));

        x.setAssociatedId(result.getInt(3));

        x.setAssociationType(result.getString(4));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public AssociatedBaseElement getAssociatedBaseElement (int BaseElementId, int StartupId, int AssociatedId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getAssociatedBaseElementKey.setInt(1, BaseElementId);

          	getAssociatedBaseElementKey.setInt(2, StartupId);

          	getAssociatedBaseElementKey.setInt(3, AssociatedId);

            ResultSet result = getAssociatedBaseElementKey.executeQuery();
            AssociatedBaseElement x = new AssociatedBaseElement ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AssociatedBaseElement tables with key " + 
                    BaseElementId + ", " + StartupId + ", " + AssociatedId);
            assignAssociatedBaseElement(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for AssociatedBaseElement table (key " + 
                    BaseElementId + ", " + StartupId + ", " + AssociatedId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public AssociatedBaseElement[] getAssociatedBaseElementWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<AssociatedBaseElement> list = new ArrayList<AssociatedBaseElement> ();
	    	AssociatedBaseElement item = null;
	    	String s = "SELECT * FROM AssociatedBaseElement";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new AssociatedBaseElement ();
	    		assignAssociatedBaseElement(item,result);
	    		list.add(item);
	    	}
	    	AssociatedBaseElement[] tmp = new AssociatedBaseElement [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAssociatedBaseElement(AssociatedBaseElement data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    AssociatedBaseElement x = getAssociatedBaseElement(data.getBaseElementId(), data.getStartupId(), data.getAssociatedId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addAssociatedBaseElement.setInt(1,data.getBaseElementId());

            addAssociatedBaseElement.setInt(2,data.getStartupId());

            addAssociatedBaseElement.setInt(3,data.getAssociatedId());

            addAssociatedBaseElement.setString(4,data.getAssociationType());

			addAssociatedBaseElement.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addAssociatedBaseElement(AssociatedBaseElement data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				AssociatedBaseElement x = getAssociatedBaseElement(data.getBaseElementId(), data.getStartupId(), data.getAssociatedId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addAssociatedBaseElement(data);

    }

    public void deleteAssociatedBaseElement (int BaseElementId, int StartupId, int AssociatedId) throws AcsJTmcdbSqlEx {
        try {

          	deleteAssociatedBaseElementKey.setInt(1, BaseElementId);

          	deleteAssociatedBaseElementKey.setInt(2, StartupId);

          	deleteAssociatedBaseElementKey.setInt(3, AssociatedId);

			deleteAssociatedBaseElementKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAssociatedBaseElement(AssociatedBaseElement data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        AssociatedBaseElement x = null;
        try {
            x = getAssociatedBaseElement(data.getBaseElementId(), data.getStartupId(), data.getAssociatedId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getBaseElementId() != data.getBaseElementId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getStartupId() != data.getStartupId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getAssociatedId() != data.getAssociatedId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAssociatedBaseElement.setInt(1,data.getBaseElementId());

            updateAssociatedBaseElement.setInt(2,data.getStartupId());

            updateAssociatedBaseElement.setInt(3,data.getAssociatedId());

            updateAssociatedBaseElement.setString(4,data.getAssociationType());

          	updateAssociatedBaseElement.setInt(4 + 1, data.getBaseElementId());

          	updateAssociatedBaseElement.setInt(4 + 2, data.getStartupId());

          	updateAssociatedBaseElement.setInt(4 + 3, data.getAssociatedId());

			updateAssociatedBaseElement.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // AssemblyStartup
    /////////////////////////////////////////

    public void assignAssemblyStartup(AssemblyStartup x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setAssemblyStartupId(result.getInt(1));

        x.setRoleName(result.getString(2));

        x.setComponentId(result.getInt(3));

        x.setBaseElementStartupId(result.getInt(4));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public AssemblyStartup getAssemblyStartup (int AssemblyStartupId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getAssemblyStartupKey.setInt(1, AssemblyStartupId);
            ResultSet result = getAssemblyStartupKey.executeQuery();
            AssemblyStartup x = new AssemblyStartup ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AssemblyStartup tables with key " + 
                    AssemblyStartupId);

            assignAssemblyStartup(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for AssemblyStartup table (key " + 
                    AssemblyStartupId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public AssemblyStartup getAssemblyStartup (int BaseElementStartupId, String RoleName) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getAssemblyStartupAlt.setInt(1, BaseElementStartupId);

            getAssemblyStartupAlt.setString(2, RoleName);

            ResultSet result = getAssemblyStartupAlt.executeQuery();
            AssemblyStartup x = new AssemblyStartup ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AssemblyStartup tables with key " + 
                    BaseElementStartupId + ", " + RoleName);

            assignAssemblyStartup(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for AssemblyStartup table (key " + 
                    BaseElementStartupId + ", " + RoleName + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public AssemblyStartup[] getAssemblyStartupWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<AssemblyStartup> list = new ArrayList<AssemblyStartup> ();
	    	AssemblyStartup item = null;
	    	String s = "SELECT * FROM AssemblyStartup";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new AssemblyStartup ();
	    		assignAssemblyStartup(item,result);
	    		list.add(item);
	    	}
	    	AssemblyStartup[] tmp = new AssemblyStartup [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAssemblyStartup(AssemblyStartup data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addAssemblyStartup.setString(1,data.getRoleName());

            addAssemblyStartup.setInt(2,data.getComponentId());

            addAssemblyStartup.setInt(3,data.getBaseElementStartupId());

		    addAssemblyStartup.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			AssemblyStartup addedRow = getAssemblyStartup (data.getBaseElementStartupId(), data.getRoleName() );        
            return addedRow.getAssemblyStartupId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table AssemblyStartup!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addAssemblyStartup(AssemblyStartup data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			AssemblyStartup x = getAssemblyStartup(data.getBaseElementStartupId(), data.getRoleName() );
	    		return x.getAssemblyStartupId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addAssemblyStartup(data);

    }

    public void deleteAssemblyStartup (int AssemblyStartupId) throws AcsJTmcdbSqlEx {
        try {
            deleteAssemblyStartupKey.setInt(1, AssemblyStartupId);
			deleteAssemblyStartupKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteAssemblyStartup (int BaseElementStartupId, String RoleName) throws AcsJTmcdbSqlEx {
        try {

            deleteAssemblyStartupAlt.setInt(1, BaseElementStartupId);

            deleteAssemblyStartupAlt.setString(2, RoleName);

			deleteAssemblyStartupAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAssemblyStartup(AssemblyStartup data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        AssemblyStartup x = null;

        x = getAssemblyStartup(data.getAssemblyStartupId());

        // You can't change the keys.
		if (x.getAssemblyStartupId() != data.getAssemblyStartupId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getBaseElementStartupId() != data.getBaseElementStartupId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getRoleName().equals(data.getRoleName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAssemblyStartup.setInt(1,data.getAssemblyStartupId());

            updateAssemblyStartup.setString(2,data.getRoleName());

            updateAssemblyStartup.setInt(3,data.getComponentId());

            updateAssemblyStartup.setInt(4,data.getBaseElementStartupId());

      		updateAssemblyStartup.setInt(5, data.getAssemblyStartupId()); 
			updateAssemblyStartup.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // SystemCounters
    /////////////////////////////////////////

    public void assignSystemCounters(SystemCounters x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setConfigurationId(result.getInt(1));

	    x.setUpdateTime(new ArrayTime(result.getLong(2)));

        x.setAutoArrayCount(result.getInt(3));

        x.setManArrayCount(result.getInt(4));

        x.setDataCaptureCount(result.getInt(5));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public SystemCounters getSystemCounters (int ConfigurationId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getSystemCountersKey.setInt(1, ConfigurationId);

            ResultSet result = getSystemCountersKey.executeQuery();
            SystemCounters x = new SystemCounters ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in SystemCounters tables with key " + 
                    ConfigurationId);
            assignSystemCounters(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for SystemCounters table (key " + 
                    ConfigurationId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public SystemCounters[] getSystemCountersWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<SystemCounters> list = new ArrayList<SystemCounters> ();
	    	SystemCounters item = null;
	    	String s = "SELECT * FROM SystemCounters";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new SystemCounters ();
	    		assignSystemCounters(item,result);
	    		list.add(item);
	    	}
	    	SystemCounters[] tmp = new SystemCounters [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addSystemCounters(SystemCounters data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    SystemCounters x = getSystemCounters(data.getConfigurationId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addSystemCounters.setInt(1,data.getConfigurationId());

	        addSystemCounters.setLong(2,data.getUpdateTime().get());

            addSystemCounters.setInt(3,data.getAutoArrayCount());

            addSystemCounters.setInt(4,data.getManArrayCount());

            addSystemCounters.setInt(5,data.getDataCaptureCount());

			addSystemCounters.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addSystemCounters(SystemCounters data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				SystemCounters x = getSystemCounters(data.getConfigurationId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addSystemCounters(data);

    }

    public void deleteSystemCounters (int ConfigurationId) throws AcsJTmcdbSqlEx {
        try {

          	deleteSystemCountersKey.setInt(1, ConfigurationId);

			deleteSystemCountersKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateSystemCounters(SystemCounters data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        SystemCounters x = null;
        try {
            x = getSystemCounters(data.getConfigurationId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getConfigurationId() != data.getConfigurationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateSystemCounters.setInt(1,data.getConfigurationId());

	        updateSystemCounters.setLong(2,data.getUpdateTime().get());

            updateSystemCounters.setInt(3,data.getAutoArrayCount());

            updateSystemCounters.setInt(4,data.getManArrayCount());

            updateSystemCounters.setInt(5,data.getDataCaptureCount());

          	updateSystemCounters.setInt(5 + 1, data.getConfigurationId());

			updateSystemCounters.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // Location
    /////////////////////////////////////////

    public void assignLocation(Location x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setLocationId(result.getInt(1));

        x.setBuilding(result.getString(2));

        // if (result.wasNull())
        // 	x.setBuildingNull();

        x.setFloor(result.getString(3));

        // if (result.wasNull())
        // 	x.setFloorNull();

        x.setRoom(result.getString(4));

        // if (result.wasNull())
        // 	x.setRoomNull();

        x.setMnemonic(result.getString(5));

        // if (result.wasNull())
        // 	x.setMnemonicNull();

        x.setLocationPosition(result.getString(6));

        // if (result.wasNull())
        // 	x.setLocationPositionNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public Location getLocation (int LocationId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getLocationKey.setInt(1, LocationId);
            ResultSet result = getLocationKey.executeQuery();
            Location x = new Location ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Location tables with key " + 
                    LocationId);

            assignLocation(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Location table (key " + 
                    LocationId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public Location getLocation (String Building, String Floor, String Room, String Mnemonic, String LocationPosition) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getLocationAlt.setString(1, Building);

            getLocationAlt.setString(2, Floor);

            getLocationAlt.setString(3, Room);

            getLocationAlt.setString(4, Mnemonic);

            getLocationAlt.setString(5, LocationPosition);

            ResultSet result = getLocationAlt.executeQuery();
            Location x = new Location ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Location tables with key " + 
                    Building + ", " + Floor + ", " + Room + ", " + Mnemonic + ", " + LocationPosition);

            assignLocation(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Location table (key " + 
                    Building + ", " + Floor + ", " + Room + ", " + Mnemonic + ", " + LocationPosition + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public Location[] getLocationWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<Location> list = new ArrayList<Location> ();
	    	Location item = null;
	    	String s = "SELECT * FROM Location";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new Location ();
	    		assignLocation(item,result);
	    		list.add(item);
	    	}
	    	Location[] tmp = new Location [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addLocation(Location data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addLocation.setString(1,data.getBuilding());

            addLocation.setString(2,data.getFloor());

            addLocation.setString(3,data.getRoom());

            addLocation.setString(4,data.getMnemonic());

            addLocation.setString(5,data.getLocationPosition());

		    addLocation.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			Location addedRow = getLocation (data.getBuilding(), data.getFloor(), data.getRoom(), data.getMnemonic(), data.getLocationPosition() );        
            return addedRow.getLocationId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table Location!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addLocation(Location data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			Location x = getLocation(data.getBuilding(), data.getFloor(), data.getRoom(), data.getMnemonic(), data.getLocationPosition() );
	    		return x.getLocationId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addLocation(data);

    }

    public void deleteLocation (int LocationId) throws AcsJTmcdbSqlEx {
        try {
            deleteLocationKey.setInt(1, LocationId);
			deleteLocationKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteLocation (String Building, String Floor, String Room, String Mnemonic, String LocationPosition) throws AcsJTmcdbSqlEx {
        try {

            deleteLocationAlt.setString(1, Building);

            deleteLocationAlt.setString(2, Floor);

            deleteLocationAlt.setString(3, Room);

            deleteLocationAlt.setString(4, Mnemonic);

            deleteLocationAlt.setString(5, LocationPosition);

			deleteLocationAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateLocation(Location data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        Location x = null;

        x = getLocation(data.getLocationId());

        // You can't change the keys.
		if (x.getLocationId() != data.getLocationId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getBuilding().equals(data.getBuilding()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getFloor().equals(data.getFloor()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getRoom().equals(data.getRoom()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getMnemonic().equals(data.getMnemonic()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getLocationPosition().equals(data.getLocationPosition()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateLocation.setInt(1,data.getLocationId());

            updateLocation.setString(2,data.getBuilding());

            updateLocation.setString(3,data.getFloor());

            updateLocation.setString(4,data.getRoom());

            updateLocation.setString(5,data.getMnemonic());

            updateLocation.setString(6,data.getLocationPosition());

      		updateLocation.setInt(7, data.getLocationId()); 
			updateLocation.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // Contact
    /////////////////////////////////////////

    public void assignContact(Contact x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setContactId(result.getInt(1));

        x.setContactName(result.getString(2));

        x.setEmail(result.getString(3));

        // if (result.wasNull())
        // 	x.setEmailNull();

        x.setGsm(result.getString(4));

        // if (result.wasNull())
        // 	x.setGsmNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public Contact getContact (int ContactId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getContactKey.setInt(1, ContactId);
            ResultSet result = getContactKey.executeQuery();
            Contact x = new Contact ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Contact tables with key " + 
                    ContactId);

            assignContact(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Contact table (key " + 
                    ContactId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public Contact getContact (String ContactName) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getContactAlt.setString(1, ContactName);

            ResultSet result = getContactAlt.executeQuery();
            Contact x = new Contact ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in Contact tables with key " + 
                    ContactName);

            assignContact(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for Contact table (key " + 
                    ContactName + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public Contact[] getContactWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<Contact> list = new ArrayList<Contact> ();
	    	Contact item = null;
	    	String s = "SELECT * FROM Contact";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new Contact ();
	    		assignContact(item,result);
	    		list.add(item);
	    	}
	    	Contact[] tmp = new Contact [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addContact(Contact data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addContact.setString(1,data.getContactName());

            addContact.setString(2,data.getEmail());

            addContact.setString(3,data.getGsm());

		    addContact.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			Contact addedRow = getContact (data.getContactName() );        
            return addedRow.getContactId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table Contact!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addContact(Contact data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			Contact x = getContact(data.getContactName() );
	    		return x.getContactId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addContact(data);

    }

    public void deleteContact (int ContactId) throws AcsJTmcdbSqlEx {
        try {
            deleteContactKey.setInt(1, ContactId);
			deleteContactKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteContact (String ContactName) throws AcsJTmcdbSqlEx {
        try {

            deleteContactAlt.setString(1, ContactName);

			deleteContactAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateContact(Contact data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        Contact x = null;

        x = getContact(data.getContactId());

        // You can't change the keys.
		if (x.getContactId() != data.getContactId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getContactName().equals(data.getContactName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateContact.setInt(1,data.getContactId());

            updateContact.setString(2,data.getContactName());

            updateContact.setString(3,data.getEmail());

            updateContact.setString(4,data.getGsm());

      		updateContact.setInt(5, data.getContactId()); 
			updateContact.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // AlarmCategory
    /////////////////////////////////////////

    public void assignAlarmCategory(AlarmCategory x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setAlarmCategoryName(result.getString(1));

        x.setDescription(result.getString(2));

        x.setPath(result.getString(3));

	    x.setIsDefault(result.getBoolean(4));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public AlarmCategory getAlarmCategory (String AlarmCategoryName) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getAlarmCategoryKey.setString(1, AlarmCategoryName);

            ResultSet result = getAlarmCategoryKey.executeQuery();
            AlarmCategory x = new AlarmCategory ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in AlarmCategory tables with key " + 
                    AlarmCategoryName);
            assignAlarmCategory(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for AlarmCategory table (key " + 
                    AlarmCategoryName + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public AlarmCategory[] getAlarmCategoryWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<AlarmCategory> list = new ArrayList<AlarmCategory> ();
	    	AlarmCategory item = null;
	    	String s = "SELECT * FROM AlarmCategory";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new AlarmCategory ();
	    		assignAlarmCategory(item,result);
	    		list.add(item);
	    	}
	    	AlarmCategory[] tmp = new AlarmCategory [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addAlarmCategory(AlarmCategory data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    AlarmCategory x = getAlarmCategory(data.getAlarmCategoryName());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addAlarmCategory.setString(1,data.getAlarmCategoryName());

            addAlarmCategory.setString(2,data.getDescription());

            addAlarmCategory.setString(3,data.getPath());

	        addAlarmCategory.setBoolean(4,data.getIsDefault());

			addAlarmCategory.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addAlarmCategory(AlarmCategory data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				AlarmCategory x = getAlarmCategory(data.getAlarmCategoryName());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addAlarmCategory(data);

    }

    public void deleteAlarmCategory (String AlarmCategoryName) throws AcsJTmcdbSqlEx {
        try {

          	deleteAlarmCategoryKey.setString(1, AlarmCategoryName);

			deleteAlarmCategoryKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateAlarmCategory(AlarmCategory data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        AlarmCategory x = null;
        try {
            x = getAlarmCategory(data.getAlarmCategoryName());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (!x.getAlarmCategoryName().equals(data.getAlarmCategoryName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateAlarmCategory.setString(1,data.getAlarmCategoryName());

            updateAlarmCategory.setString(2,data.getDescription());

            updateAlarmCategory.setString(3,data.getPath());

	        updateAlarmCategory.setBoolean(4,data.getIsDefault());

          	updateAlarmCategory.setString(4 + 1, data.getAlarmCategoryName());

			updateAlarmCategory.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // FaultFamily
    /////////////////////////////////////////

    public void assignFaultFamily(FaultFamily x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setFaultFamilyId(result.getInt(1));

        x.setFamilyName(result.getString(2));

        x.setAlarmCategoryName(result.getString(3));

        // if (result.wasNull())
        // 	x.setAlarmCategoryNameNull();

        x.setAlarmSource(result.getString(4));

        x.setHelpURL(result.getString(5));

        // if (result.wasNull())
        // 	x.setHelpURLNull();

        x.setContactId(result.getInt(6));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public FaultFamily getFaultFamily (int FaultFamilyId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getFaultFamilyKey.setInt(1, FaultFamilyId);
            ResultSet result = getFaultFamilyKey.executeQuery();
            FaultFamily x = new FaultFamily ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in FaultFamily tables with key " + 
                    FaultFamilyId);

            assignFaultFamily(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for FaultFamily table (key " + 
                    FaultFamilyId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public FaultFamily getFaultFamily (String FamilyName) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getFaultFamilyAlt.setString(1, FamilyName);

            ResultSet result = getFaultFamilyAlt.executeQuery();
            FaultFamily x = new FaultFamily ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in FaultFamily tables with key " + 
                    FamilyName);

            assignFaultFamily(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for FaultFamily table (key " + 
                    FamilyName + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public FaultFamily[] getFaultFamilyWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<FaultFamily> list = new ArrayList<FaultFamily> ();
	    	FaultFamily item = null;
	    	String s = "SELECT * FROM FaultFamily";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new FaultFamily ();
	    		assignFaultFamily(item,result);
	    		list.add(item);
	    	}
	    	FaultFamily[] tmp = new FaultFamily [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addFaultFamily(FaultFamily data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addFaultFamily.setString(1,data.getFamilyName());

            addFaultFamily.setString(2,data.getAlarmCategoryName());

            addFaultFamily.setString(3,data.getAlarmSource());

            addFaultFamily.setString(4,data.getHelpURL());

            addFaultFamily.setInt(5,data.getContactId());

		    addFaultFamily.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			FaultFamily addedRow = getFaultFamily (data.getFamilyName() );        
            return addedRow.getFaultFamilyId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table FaultFamily!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addFaultFamily(FaultFamily data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			FaultFamily x = getFaultFamily(data.getFamilyName() );
	    		return x.getFaultFamilyId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addFaultFamily(data);

    }

    public void deleteFaultFamily (int FaultFamilyId) throws AcsJTmcdbSqlEx {
        try {
            deleteFaultFamilyKey.setInt(1, FaultFamilyId);
			deleteFaultFamilyKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteFaultFamily (String FamilyName) throws AcsJTmcdbSqlEx {
        try {

            deleteFaultFamilyAlt.setString(1, FamilyName);

			deleteFaultFamilyAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateFaultFamily(FaultFamily data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        FaultFamily x = null;

        x = getFaultFamily(data.getFaultFamilyId());

        // You can't change the keys.
		if (x.getFaultFamilyId() != data.getFaultFamilyId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (!x.getFamilyName().equals(data.getFamilyName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateFaultFamily.setInt(1,data.getFaultFamilyId());

            updateFaultFamily.setString(2,data.getFamilyName());

            updateFaultFamily.setString(3,data.getAlarmCategoryName());

            updateFaultFamily.setString(4,data.getAlarmSource());

            updateFaultFamily.setString(5,data.getHelpURL());

            updateFaultFamily.setInt(6,data.getContactId());

      		updateFaultFamily.setInt(7, data.getFaultFamilyId()); 
			updateFaultFamily.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // FaultMember
    /////////////////////////////////////////

    public void assignFaultMember(FaultMember x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setMemberName(result.getString(1));

        x.setFaultFamilyId(result.getInt(2));

        x.setLocationId(result.getInt(3));

        // if (result.wasNull())
        // 	x.setLocationIdNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public FaultMember getFaultMember (String MemberName) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getFaultMemberKey.setString(1, MemberName);

            ResultSet result = getFaultMemberKey.executeQuery();
            FaultMember x = new FaultMember ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in FaultMember tables with key " + 
                    MemberName);
            assignFaultMember(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for FaultMember table (key " + 
                    MemberName + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public FaultMember[] getFaultMemberWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<FaultMember> list = new ArrayList<FaultMember> ();
	    	FaultMember item = null;
	    	String s = "SELECT * FROM FaultMember";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new FaultMember ();
	    		assignFaultMember(item,result);
	    		list.add(item);
	    	}
	    	FaultMember[] tmp = new FaultMember [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addFaultMember(FaultMember data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    FaultMember x = getFaultMember(data.getMemberName());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addFaultMember.setString(1,data.getMemberName());

            addFaultMember.setInt(2,data.getFaultFamilyId());

            addFaultMember.setInt(3,data.getLocationId());

			addFaultMember.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addFaultMember(FaultMember data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				FaultMember x = getFaultMember(data.getMemberName());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addFaultMember(data);

    }

    public void deleteFaultMember (String MemberName) throws AcsJTmcdbSqlEx {
        try {

          	deleteFaultMemberKey.setString(1, MemberName);

			deleteFaultMemberKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateFaultMember(FaultMember data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        FaultMember x = null;
        try {
            x = getFaultMember(data.getMemberName());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (!x.getMemberName().equals(data.getMemberName()))
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateFaultMember.setString(1,data.getMemberName());

            updateFaultMember.setInt(2,data.getFaultFamilyId());

            updateFaultMember.setInt(3,data.getLocationId());

          	updateFaultMember.setString(3 + 1, data.getMemberName());

			updateFaultMember.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // DefaultMember
    /////////////////////////////////////////

    public void assignDefaultMember(DefaultMember x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setDefaultMemberId(result.getInt(1));

        x.setFaultFamilyId(result.getInt(2));

        x.setLocationID(result.getInt(3));

        // if (result.wasNull())
        // 	x.setLocationIDNull();

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public DefaultMember getDefaultMember (int DefaultMemberId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

          	getDefaultMemberKey.setInt(1, DefaultMemberId);

            ResultSet result = getDefaultMemberKey.executeQuery();
            DefaultMember x = new DefaultMember ();
            if (result.next() == false)
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in DefaultMember tables with key " + 
                    DefaultMemberId);
            assignDefaultMember(x,result);
            if (result.next())
                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: Duplicate keys for DefaultMember table (key " + 
                    DefaultMemberId + ")");
            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public DefaultMember[] getDefaultMemberWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<DefaultMember> list = new ArrayList<DefaultMember> ();
	    	DefaultMember item = null;
	    	String s = "SELECT * FROM DefaultMember";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new DefaultMember ();
	    		assignDefaultMember(item,result);
	    		list.add(item);
	    	}
	    	DefaultMember[] tmp = new DefaultMember [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addDefaultMember(DefaultMember data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx  {
        try {
            // Commented this out, as the insert will anyway fail. We can do it more efficient that way.
            // First, see if this row is already in the database.
            //try {
            //    DefaultMember x = getDefaultMember(data.getDefaultMemberId());
            //    throw new AcsJTmcdbRowAlreadyExistsEx();
            //} 
            //	catch (AcsJTmcdbNoSuchRowEx ex)
            //{
            //		;	// We're OK, there's no row with this key yet in the TMCDB
            //}          

            addDefaultMember.setInt(1,data.getDefaultMemberId());

            addDefaultMember.setInt(2,data.getFaultFamilyId());

            addDefaultMember.setInt(3,data.getLocationID());

			addDefaultMember.executeUpdate();	// INSERT doesn't return a result set
		return 0;
        } catch (SQLException err) {
            if(err.getErrorCode()==1){//ORA-00001: unique constraint (string.string) violated

                throw new AcsJTmcdbRowAlreadyExistsEx(err);

            }
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public int addDefaultMember(DefaultMember data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
				DefaultMember x = getDefaultMember(data.getDefaultMemberId());
	    		return 0;
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}
    	return addDefaultMember(data);

    }

    public void deleteDefaultMember (int DefaultMemberId) throws AcsJTmcdbSqlEx {
        try {

          	deleteDefaultMemberKey.setInt(1, DefaultMemberId);

			deleteDefaultMemberKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateDefaultMember(DefaultMember data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        DefaultMember x = null;
        try {
            x = getDefaultMember(data.getDefaultMemberId());
        } catch (AcsJTmcdbNoSuchRowEx err) {
            throw new AcsJTmcdbNoSuchRowEx(err);
        }
        // You can't change the keys.

		if (x.getDefaultMemberId() != data.getDefaultMemberId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateDefaultMember.setInt(1,data.getDefaultMemberId());

            updateDefaultMember.setInt(2,data.getFaultFamilyId());

            updateDefaultMember.setInt(3,data.getLocationID());

          	updateDefaultMember.setInt(3 + 1, data.getDefaultMemberId());

			updateDefaultMember.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    /////////////////////////////////////////
    // FaultCode
    /////////////////////////////////////////

    public void assignFaultCode(FaultCode x, ResultSet result) throws AcsJTmcdbSqlEx {
    try {

        x.setFaultCodeId(result.getInt(1));

        x.setFaultFamilyId(result.getInt(2));

        x.setCodeValue(result.getInt(3));

        x.setPriority(result.getInt(4));

        x.setCause(result.getString(5));

        // if (result.wasNull())
        // 	x.setCauseNull();

        x.setAction(result.getString(6));

        // if (result.wasNull())
        // 	x.setActionNull();

        x.setConsequence(result.getString(7));

        // if (result.wasNull())
        // 	x.setConsequenceNull();

        x.setProblemDescription(result.getString(8));

	    x.setIsInstant(result.getBoolean(9));

	} catch (SQLException err) {
		throw new AcsJTmcdbSqlEx(err);
	}
    }

    public FaultCode getFaultCode (int FaultCodeId) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx {
        try {
            getFaultCodeKey.setInt(1, FaultCodeId);
            ResultSet result = getFaultCodeKey.executeQuery();
            FaultCode x = new FaultCode ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in FaultCode tables with key " + 
                    FaultCodeId);

            assignFaultCode(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for FaultCode table (key " + 
                    FaultCodeId + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

	public FaultCode getFaultCode (int FaultFamilyId, int CodeValue) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbSqlEx  {
        try {

            getFaultCodeAlt.setInt(1, FaultFamilyId);

            getFaultCodeAlt.setInt(2, CodeValue);

            ResultSet result = getFaultCodeAlt.executeQuery();
            FaultCode x = new FaultCode ();
            if (result.next() == false)

                throw new AcsJTmcdbNoSuchRowEx("TMCDB: Database error: There are no rows in FaultCode tables with key " + 
                    FaultFamilyId + ", " + CodeValue);

            assignFaultCode(x,result);
            if (result.next())

                throw new AcsJTmcdbDuplicateKeyEx("TMCDB: Database error: Duplicate keys for FaultCode table (key " + 
                    FaultFamilyId + ", " + CodeValue + ")");

            return x;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public FaultCode[] getFaultCodeWhere (String whereClause) throws AcsJTmcdbSqlEx {
    	try { 
	    	ArrayList<FaultCode> list = new ArrayList<FaultCode> ();
	    	FaultCode item = null;
	    	String s = "SELECT * FROM FaultCode";
	    	if (whereClause != null)
	    		s += " WHERE " + whereClause;
	    	PreparedStatement query = conn.prepareStatement(s);	
	    	ResultSet result = query.executeQuery();
	    	while (result.next()) {
	    		item = new FaultCode ();
	    		assignFaultCode(item,result);
	    		list.add(item);
	    	}
	    	FaultCode[] tmp = new FaultCode [list.size()];
	    	tmp = list.toArray(tmp);
	    	return tmp;
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
	}

    public int addFaultCode(FaultCode data) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {
        try {

            addFaultCode.setInt(1,data.getFaultFamilyId());

            addFaultCode.setInt(2,data.getCodeValue());

            addFaultCode.setInt(3,data.getPriority());

            addFaultCode.setString(4,data.getCause());

            addFaultCode.setString(5,data.getAction());

            addFaultCode.setString(6,data.getConsequence());

            addFaultCode.setString(7,data.getProblemDescription());

	        addFaultCode.setBoolean(8,data.getIsInstant());

		    addFaultCode.executeUpdate();	// INSERT doesn't return a result set
		    // Get the generated primary key.
			FaultCode addedRow = getFaultCode (data.getFaultFamilyId(), data.getCodeValue() );        
            return addedRow.getFaultCodeId();

        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        } catch (AcsJTmcdbNoSuchRowEx e) {
        	e.setProperty("Problem", "Cam't retrieve the row we just inserted into table FaultCode!");
			throw e; // Something has gone very wrong here!
		}
    }

	public int addFaultCode(FaultCode data, Boolean okIfExists) throws AcsJTmcdbRowAlreadyExistsEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx, AcsJTmcdbNoSuchRowEx {

		if (okIfExists.booleanValue()) {
	    	try {
    			FaultCode x = getFaultCode(data.getFaultFamilyId(), data.getCodeValue() );
	    		return x.getFaultCodeId();
	    	} catch (AcsJTmcdbNoSuchRowEx e) {
	    	}
		}

    	return addFaultCode(data);

    }

    public void deleteFaultCode (int FaultCodeId) throws AcsJTmcdbSqlEx {
        try {
            deleteFaultCodeKey.setInt(1, FaultCodeId);
			deleteFaultCodeKey.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void deleteFaultCode (int FaultFamilyId, int CodeValue) throws AcsJTmcdbSqlEx {
        try {

            deleteFaultCodeAlt.setInt(1, FaultFamilyId);

            deleteFaultCodeAlt.setInt(2, CodeValue);

			deleteFaultCodeAlt.executeUpdate();	// DELETE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

    public void updateFaultCode(FaultCode data) throws AcsJTmcdbNoSuchRowEx, AcsJTmcdbKeyUpdateEx, AcsJTmcdbSqlEx, AcsJTmcdbDuplicateKeyEx {
        // First, see if this row is really in the database.
        FaultCode x = null;

        x = getFaultCode(data.getFaultCodeId());

        // You can't change the keys.
		if (x.getFaultCodeId() != data.getFaultCodeId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getFaultFamilyId() != data.getFaultFamilyId())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

		if (x.getCodeValue() != data.getCodeValue())
			throw new AcsJTmcdbKeyUpdateEx("TMCDB: Database error: Keys cannot be changed in an update method.");

        // Update the row.
        try {

            updateFaultCode.setInt(1,data.getFaultCodeId());

            updateFaultCode.setInt(2,data.getFaultFamilyId());

            updateFaultCode.setInt(3,data.getCodeValue());

            updateFaultCode.setInt(4,data.getPriority());

            updateFaultCode.setString(5,data.getCause());

            updateFaultCode.setString(6,data.getAction());

            updateFaultCode.setString(7,data.getConsequence());

            updateFaultCode.setString(8,data.getProblemDescription());

	        updateFaultCode.setBoolean(9,data.getIsInstant());

      		updateFaultCode.setInt(10, data.getFaultCodeId()); 
			updateFaultCode.executeUpdate();	// UPDATE doesn't return a result set
        } catch (SQLException err) {
            throw new AcsJTmcdbSqlEx(err);
        }
    }

}		
