/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File SystemCounters.java
 */
package alma.TMCDB.generated;

import alma.TMCDB.types.ArrayTime;

import alma.TMCDB_GEN_IDL.SystemCountersIDL;

/**

 * The SystemCounters table records keeps track of counters that are used by Control to generate names of arrays and Data Capture components.

 * The counters are initialized to 1 at the initial database load and increase to 9,999, at which point they role over to 1 again.

 * There is only one row per configuration in this table.

   * Key: ConfigurationId

 *
 */
public class SystemCounters implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int ConfigurationId;

    private ArrayTime UpdateTime;

    private int AutoArrayCount;

    private int ManArrayCount;

    private int DataCaptureCount;

    /**
     * Default Constructor for SystemCounters.  Setter methods must be used to insert data.
     */
    public SystemCounters () {

    }

    /**
     * Create a SystemCounters by specifiying all data values.
     */
    public SystemCounters (

        int ConfigurationId,

        ArrayTime UpdateTime,

        int AutoArrayCount,

        int ManArrayCount,

        int DataCaptureCount

    ) {

		setConfigurationId(ConfigurationId);

		setUpdateTime(UpdateTime);

		setAutoArrayCount(AutoArrayCount);

		setManArrayCount(ManArrayCount);

		setDataCaptureCount(DataCaptureCount);

    }

    /**
     * Create a SystemCounters by specifiying data values as an array of strings.
     */
    public SystemCounters (String[] data) {
    	if (data.length != 5)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 5)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.UpdateTime = new ArrayTime(data[i]);

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AutoArrayCount = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ManArrayCount = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DataCaptureCount = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "SystemCounters:" + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

        s += "\tUpdateTime: " + UpdateTime.toFITS() + newline;

        s += "\tAutoArrayCount: " + AutoArrayCount + newline;

        s += "\tManArrayCount: " + ManArrayCount + newline;

        s += "\tDataCaptureCount: " + DataCaptureCount + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "SystemCounters" + delimiter;  

        s += ConfigurationId + delimiter;

		s += new String(UpdateTime.toFITS()) + delimiter;

        s += AutoArrayCount + delimiter;

        s += ManArrayCount + delimiter;

        s += DataCaptureCount + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 5;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#SystemCounters" + delimiter  

        	+ "ConfigurationId" + delimiter

        	+ "UpdateTime" + delimiter

        	+ "AutoArrayCount" + delimiter

        	+ "ManArrayCount" + delimiter

        	+ "DataCaptureCount" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof SystemCounters)) return false;
    	SystemCounters arg = (SystemCounters) obj;

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		if (this.UpdateTime.get() != arg.UpdateTime.get())
			return false;

		if (this.AutoArrayCount != arg.AutoArrayCount)
			return false;

		if (this.ManArrayCount != arg.ManArrayCount)
			return false;

		if (this.DataCaptureCount != arg.DataCaptureCount)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public SystemCountersIDL toIDL() {
    	SystemCountersIDL x = new SystemCountersIDL ();

		x.ConfigurationId = this.ConfigurationId;

		x.UpdateTime = this.UpdateTime.toIDLArrayTime();

		x.AutoArrayCount = this.AutoArrayCount;

		x.ManArrayCount = this.ManArrayCount;

		x.DataCaptureCount = this.DataCaptureCount;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(SystemCountersIDL x) {

		this.ConfigurationId = x.ConfigurationId;

		this.UpdateTime = new ArrayTime(x.UpdateTime);

		this.AutoArrayCount = x.AutoArrayCount;

		this.ManArrayCount = x.ManArrayCount;

		this.DataCaptureCount = x.DataCaptureCount;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for SystemCounters.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

    /**
     * Get the value for UpdateTime.
     */
    public ArrayTime getUpdateTime () {
        return UpdateTime;
    }

    /**
     * Set UpdateTime to the specified value.
     */
    public void setUpdateTime(ArrayTime UpdateTime) {

        this.UpdateTime = UpdateTime;

    }

    /**
     * Get the value for AutoArrayCount.
     */
    public int getAutoArrayCount () {
        return AutoArrayCount;
    }

    /**
     * Set AutoArrayCount to the specified value.
     */
    public void setAutoArrayCount(int AutoArrayCount) {

        this.AutoArrayCount = AutoArrayCount;

    }

    /**
     * Get the value for ManArrayCount.
     */
    public int getManArrayCount () {
        return ManArrayCount;
    }

    /**
     * Set ManArrayCount to the specified value.
     */
    public void setManArrayCount(int ManArrayCount) {

        this.ManArrayCount = ManArrayCount;

    }

    /**
     * Get the value for DataCaptureCount.
     */
    public int getDataCaptureCount () {
        return DataCaptureCount;
    }

    /**
     * Set DataCaptureCount to the specified value.
     */
    public void setDataCaptureCount(int DataCaptureCount) {

        this.DataCaptureCount = DataCaptureCount;

    }

}
