/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File Startup.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.StartupIDL;

/**

 * The Startup table designates a startup configuration.

   * Key: StartupId is automatically generated from:  StartupName, ConfigurationId

 *
 */
public class Startup implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int StartupId;

    private int ConfigurationId;

    private String StartupName;

    /**
     * Default Constructor for Startup.  Setter methods must be used to insert data.
     */
    public Startup () {

    }

    /**
     * Create a Startup by specifiying all data values.
     */
    public Startup (

        int StartupId,

        int ConfigurationId,

        String StartupName

    ) {

		setStartupId(StartupId);

		setConfigurationId(ConfigurationId);

		setStartupName(StartupName);

    }

    /**
     * Create a Startup by specifiying data values as an array of strings.
     */
    public Startup (String[] data) {
    	if (data.length != 3)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 3)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StartupId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StartupName = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "Startup:" + newline;

        s += "\tStartupId: " + StartupId + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

        s += "\tStartupName: " + StartupName + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "Startup" + delimiter;  

        s += StartupId + delimiter;

        s += ConfigurationId + delimiter;

        s += StartupName + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 3;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#Startup" + delimiter  

        	+ "StartupId" + delimiter

        	+ "ConfigurationId" + delimiter

        	+ "StartupName" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof Startup)) return false;
    	Startup arg = (Startup) obj;

		if (this.StartupId != arg.StartupId)
			return false;

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		if (this.StartupName == null) {	// Two null strings are equal
			if (arg.StartupName == null)
				return true;
			else
				return false;
		}
		if (!this.StartupName.equals(arg.StartupName))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public StartupIDL toIDL() {
    	StartupIDL x = new StartupIDL ();

		x.StartupId = this.StartupId;

		x.ConfigurationId = this.ConfigurationId;

		x.StartupName = this.StartupName;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(StartupIDL x) {

		this.StartupId = x.StartupId;

		this.ConfigurationId = x.ConfigurationId;

		this.StartupName = x.StartupName;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return StartupId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for Startup.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for StartupId.
     */
    public int getStartupId () {
        return StartupId;
    }

    /**
     * Set StartupId to the specified value.
     */
    public void setStartupId(int StartupId) {

        this.StartupId = StartupId;

    }

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

    /**
     * Get the value for StartupName.
     */
    public String getStartupName () {
        return StartupName;
    }

    /**
     * Set StartupName to the specified value.
     */
    public void setStartupName(String StartupName) {

        this.StartupName = StartupName;

    }

}
