/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File Schemas.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.SchemasIDL;

/**

 * This table stores the system XML Schemas. The ComponentType table

 * references the URN column. This table also stores the XML Schemas

 * not directly associated with Component types.

   * Key: SchemaId is automatically generated from:  URN, ConfigurationId

 *
 */
public class Schemas implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int SchemaId;

    private String URN;

    private int ConfigurationId;

    private String Schema;

    // private boolean nullSchema;

    /**
     * Default Constructor for Schemas.  Setter methods must be used to insert data.
     */
    public Schemas () {

        // nullSchema = true;

    }

    /**
     * Create a Schemas by specifiying all data values.
     */
    public Schemas (

        int SchemaId,

        String URN,

        int ConfigurationId,

        String Schema

    ) {

		setSchemaId(SchemaId);

		setURN(URN);

		setConfigurationId(ConfigurationId);

		setSchema(Schema);

    }

    /**
     * Create a Schemas by specifiying data values as an array of strings.
     */
    public Schemas (String[] data) {
    	if (data.length != 4)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 4)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.SchemaId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.URN = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullSchema = true;
			// this.Schema = null;

		} else {

			// nullSchema = false;

			this.Schema = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "Schemas:" + newline;

        s += "\tSchemaId: " + SchemaId + newline;

        s += "\tURN: " + URN + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

    	// if (Schema == null)
    	//	s += "\tSchema: null" + newline;
    	// else

        s += "\tSchema: " + Schema + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "Schemas" + delimiter;  

        s += SchemaId + delimiter;

        s += URN + delimiter;

        s += ConfigurationId + delimiter;

        // if (nullSchema)
        // 	s += delimiter;
        // else

        	// s += Schema + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 4;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#Schemas" + delimiter  

        	+ "SchemaId" + delimiter

        	+ "URN" + delimiter

        	+ "ConfigurationId" + delimiter

        	+ "Schema" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof Schemas)) return false;
    	Schemas arg = (Schemas) obj;

		if (this.SchemaId != arg.SchemaId)
			return false;

		if (this.URN == null) {	// Two null strings are equal
			if (arg.URN == null)
				return true;
			else
				return false;
		}
		if (!this.URN.equals(arg.URN))
			return false; 

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		if (this.Schema != arg.Schema)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public SchemasIDL toIDL() {
    	SchemasIDL x = new SchemasIDL ();

		x.SchemaId = this.SchemaId;

		x.URN = this.URN;

		x.ConfigurationId = this.ConfigurationId;

		x.Schema = this.Schema;

        // x.nullSchema = this.nullSchema;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(SchemasIDL x) {

		this.SchemaId = x.SchemaId;

		this.URN = x.URN;

		this.ConfigurationId = x.ConfigurationId;

		this.Schema = x.Schema;

        // this.nullSchema = x.nullSchema;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return SchemaId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for Schemas.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for SchemaId.
     */
    public int getSchemaId () {
        return SchemaId;
    }

    /**
     * Set SchemaId to the specified value.
     */
    public void setSchemaId(int SchemaId) {

        this.SchemaId = SchemaId;

    }

    /**
     * Get the value for URN.
     */
    public String getURN () {
        return URN;
    }

    /**
     * Set URN to the specified value.
     */
    public void setURN(String URN) {

        this.URN = URN;

    }

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

    /**
     * Get the value for Schema.
     */
    public String getSchema () {
        return Schema;
    }

    /**
     * Set Schema to the specified value.
     */
    public void setSchema(String Schema) {

        // nullSchema = false;

        this.Schema = Schema;

    }

    /*
     * Is the Schema null?
     */
    // public boolean isSchemaNull() {
    //	return nullSchema;
    // }

    /*
     * Set the null indicator for Schema
     */       
    // public void setSchemaNull() {
    // 	nullSchema = true;
    // }

}
