/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File SBExecution.java
 */
package alma.TMCDB.generated;

import alma.TMCDB.types.ArrayTime;

import alma.TMCDB_GEN_IDL.SBExecutionIDL;

/**

 * The SBExecution table gives the UIDs of the scheduling blocks executed by the indicated array.

   * Key: ArrayId, SbUID, StartTime

 *
 */
public class SBExecution implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int ArrayId;

    private String SbUID;

    private ArrayTime StartTime;

    private ArrayTime EndTime;

    // private boolean nullEndTime;

    private boolean NormalTermination;

    /**
     * Default Constructor for SBExecution.  Setter methods must be used to insert data.
     */
    public SBExecution () {

        // nullEndTime = true;

    }

    /**
     * Create a SBExecution by specifiying all data values.
     */
    public SBExecution (

        int ArrayId,

        String SbUID,

        ArrayTime StartTime,

        ArrayTime EndTime,

        boolean NormalTermination

    ) {

		setArrayId(ArrayId);

		setSbUID(SbUID);

		setStartTime(StartTime);

		setEndTime(EndTime);

		setNormalTermination(NormalTermination);

    }

    /**
     * Create a SBExecution by specifiying data values as an array of strings.
     */
    public SBExecution (String[] data) {
    	if (data.length != 5)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 5)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ArrayId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.SbUID = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StartTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullEndTime = true;
			// this.EndTime = null;

		} else {

			// nullEndTime = false;

			this.EndTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NormalTermination = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "SBExecution:" + newline;

        s += "\tArrayId: " + ArrayId + newline;

        s += "\tSbUID: " + SbUID + newline;

        s += "\tStartTime: " + StartTime.toFITS() + newline;

    	// if (EndTime == null)
    	//	s += "\tEndTime: null" + newline;
    	// else

        s += "\tEndTime: " + EndTime.toFITS() + newline;

        s += "\tNormalTermination: " + NormalTermination + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "SBExecution" + delimiter;  

        s += ArrayId + delimiter;

        s += SbUID + delimiter;

		s += new String(StartTime.toFITS()) + delimiter;

        // if (nullEndTime)
        // 	s += delimiter;
        // else

		// s += new String(EndTime.toFITS()) + delimiter;

        s += NormalTermination + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 5;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#SBExecution" + delimiter  

        	+ "ArrayId" + delimiter

        	+ "SbUID" + delimiter

        	+ "StartTime" + delimiter

        	+ "EndTime" + delimiter

        	+ "NormalTermination" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof SBExecution)) return false;
    	SBExecution arg = (SBExecution) obj;

		if (this.ArrayId != arg.ArrayId)
			return false;

		if (this.SbUID == null) {	// Two null strings are equal
			if (arg.SbUID == null)
				return true;
			else
				return false;
		}
		if (!this.SbUID.equals(arg.SbUID))
			return false; 

		if (this.StartTime.get() != arg.StartTime.get())
			return false;

		if (this.EndTime.get() != arg.EndTime.get())
			return false;

		if (this.NormalTermination != arg.NormalTermination)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public SBExecutionIDL toIDL() {
    	SBExecutionIDL x = new SBExecutionIDL ();

		x.ArrayId = this.ArrayId;

		x.SbUID = this.SbUID;

		x.StartTime = this.StartTime.toIDLArrayTime();

		x.EndTime = this.EndTime.toIDLArrayTime();

        // x.nullEndTime = this.nullEndTime;

		x.NormalTermination = this.NormalTermination;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(SBExecutionIDL x) {

		this.ArrayId = x.ArrayId;

		this.SbUID = x.SbUID;

		this.StartTime = new ArrayTime(x.StartTime);

		this.EndTime = new ArrayTime(x.EndTime);

        // this.nullEndTime = x.nullEndTime;

		this.NormalTermination = x.NormalTermination;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for SBExecution.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for ArrayId.
     */
    public int getArrayId () {
        return ArrayId;
    }

    /**
     * Set ArrayId to the specified value.
     */
    public void setArrayId(int ArrayId) {

        this.ArrayId = ArrayId;

    }

    /**
     * Get the value for SbUID.
     */
    public String getSbUID () {
        return SbUID;
    }

    /**
     * Set SbUID to the specified value.
     */
    public void setSbUID(String SbUID) {

        this.SbUID = SbUID;

    }

    /**
     * Get the value for StartTime.
     */
    public ArrayTime getStartTime () {
        return StartTime;
    }

    /**
     * Set StartTime to the specified value.
     */
    public void setStartTime(ArrayTime StartTime) {

        this.StartTime = StartTime;

    }

    /**
     * Get the value for EndTime.
     */
    public ArrayTime getEndTime () {
        return EndTime;
    }

    /**
     * Set EndTime to the specified value.
     */
    public void setEndTime(ArrayTime EndTime) {

        // nullEndTime = false;

        this.EndTime = EndTime;

    }

    /*
     * Is the EndTime null?
     */
    // public boolean isEndTimeNull() {
    //	return nullEndTime;
    // }

    /*
     * Set the null indicator for EndTime
     */       
    // public void setEndTimeNull() {
    // 	nullEndTime = true;
    // }

    /**
     * Get the value for NormalTermination.
     */
    public boolean getNormalTermination () {
        return NormalTermination;
    }

    /**
     * Set NormalTermination to the specified value.
     */
    public void setNormalTermination(boolean NormalTermination) {

        this.NormalTermination = NormalTermination;

    }

}
