/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File NotificationChannel.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.NotificationChannelIDL;

/**

 * The NotificationChannel table records notification channels required by the system.

 * This table is obviously incomplete, but will be in the future.  The intention is to

 * specify quality of service parameters.

   * Key: NCId is automatically generated from:  NCName, ConfigurationId

 *
 */
public class NotificationChannel implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int NCId;

    private String NCName;

    private String SubsystemName;

    private int ConfigurationId;

    private String QOS1;

    // private boolean nullQOS1;

    private String QOS2;

    // private boolean nullQOS2;

    private String QOS3;

    // private boolean nullQOS3;

    /**
     * Default Constructor for NotificationChannel.  Setter methods must be used to insert data.
     */
    public NotificationChannel () {

        // nullQOS1 = true;

        // nullQOS2 = true;

        // nullQOS3 = true;

    }

    /**
     * Create a NotificationChannel by specifiying all data values.
     */
    public NotificationChannel (

        int NCId,

        String NCName,

        String SubsystemName,

        int ConfigurationId,

        String QOS1,

        String QOS2,

        String QOS3

    ) {

		setNCId(NCId);

		setNCName(NCName);

		setSubsystemName(SubsystemName);

		setConfigurationId(ConfigurationId);

		setQOS1(QOS1);

		setQOS2(QOS2);

		setQOS3(QOS3);

    }

    /**
     * Create a NotificationChannel by specifiying data values as an array of strings.
     */
    public NotificationChannel (String[] data) {
    	if (data.length != 7)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 7)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NCId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NCName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.SubsystemName = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullQOS1 = true;
			// this.QOS1 = null;

		} else {

			// nullQOS1 = false;

			this.QOS1 = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullQOS2 = true;
			// this.QOS2 = null;

		} else {

			// nullQOS2 = false;

			this.QOS2 = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullQOS3 = true;
			// this.QOS3 = null;

		} else {

			// nullQOS3 = false;

			this.QOS3 = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "NotificationChannel:" + newline;

        s += "\tNCId: " + NCId + newline;

        s += "\tNCName: " + NCName + newline;

        s += "\tSubsystemName: " + SubsystemName + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

    	// if (QOS1 == null)
    	//	s += "\tQOS1: null" + newline;
    	// else

        s += "\tQOS1: " + QOS1 + newline;

    	// if (QOS2 == null)
    	//	s += "\tQOS2: null" + newline;
    	// else

        s += "\tQOS2: " + QOS2 + newline;

    	// if (QOS3 == null)
    	//	s += "\tQOS3: null" + newline;
    	// else

        s += "\tQOS3: " + QOS3 + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "NotificationChannel" + delimiter;  

        s += NCId + delimiter;

        s += NCName + delimiter;

        s += SubsystemName + delimiter;

        s += ConfigurationId + delimiter;

        // if (nullQOS1)
        // 	s += delimiter;
        // else

        	// s += QOS1 + delimiter;

        // if (nullQOS2)
        // 	s += delimiter;
        // else

        	// s += QOS2 + delimiter;

        // if (nullQOS3)
        // 	s += delimiter;
        // else

        	// s += QOS3 + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 7;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#NotificationChannel" + delimiter  

        	+ "NCId" + delimiter

        	+ "NCName" + delimiter

        	+ "SubsystemName" + delimiter

        	+ "ConfigurationId" + delimiter

        	+ "QOS1" + delimiter

        	+ "QOS2" + delimiter

        	+ "QOS3" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof NotificationChannel)) return false;
    	NotificationChannel arg = (NotificationChannel) obj;

		if (this.NCId != arg.NCId)
			return false;

		if (this.NCName == null) {	// Two null strings are equal
			if (arg.NCName == null)
				return true;
			else
				return false;
		}
		if (!this.NCName.equals(arg.NCName))
			return false; 

		if (this.SubsystemName == null) {	// Two null strings are equal
			if (arg.SubsystemName == null)
				return true;
			else
				return false;
		}
		if (!this.SubsystemName.equals(arg.SubsystemName))
			return false; 

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		if (this.QOS1 == null) {	// Two null strings are equal
			if (arg.QOS1 == null)
				return true;
			else
				return false;
		}
		if (!this.QOS1.equals(arg.QOS1))
			return false; 

		if (this.QOS2 == null) {	// Two null strings are equal
			if (arg.QOS2 == null)
				return true;
			else
				return false;
		}
		if (!this.QOS2.equals(arg.QOS2))
			return false; 

		if (this.QOS3 == null) {	// Two null strings are equal
			if (arg.QOS3 == null)
				return true;
			else
				return false;
		}
		if (!this.QOS3.equals(arg.QOS3))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public NotificationChannelIDL toIDL() {
    	NotificationChannelIDL x = new NotificationChannelIDL ();

		x.NCId = this.NCId;

		x.NCName = this.NCName;

		x.SubsystemName = this.SubsystemName;

		x.ConfigurationId = this.ConfigurationId;

		x.QOS1 = this.QOS1;

        // x.nullQOS1 = this.nullQOS1;

		x.QOS2 = this.QOS2;

        // x.nullQOS2 = this.nullQOS2;

		x.QOS3 = this.QOS3;

        // x.nullQOS3 = this.nullQOS3;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(NotificationChannelIDL x) {

		this.NCId = x.NCId;

		this.NCName = x.NCName;

		this.SubsystemName = x.SubsystemName;

		this.ConfigurationId = x.ConfigurationId;

		this.QOS1 = x.QOS1;

        // this.nullQOS1 = x.nullQOS1;

		this.QOS2 = x.QOS2;

        // this.nullQOS2 = x.nullQOS2;

		this.QOS3 = x.QOS3;

        // this.nullQOS3 = x.nullQOS3;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return NCId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for NotificationChannel.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for NCId.
     */
    public int getNCId () {
        return NCId;
    }

    /**
     * Set NCId to the specified value.
     */
    public void setNCId(int NCId) {

        this.NCId = NCId;

    }

    /**
     * Get the value for NCName.
     */
    public String getNCName () {
        return NCName;
    }

    /**
     * Set NCName to the specified value.
     */
    public void setNCName(String NCName) {

        this.NCName = NCName;

    }

    /**
     * Get the value for SubsystemName.
     */
    public String getSubsystemName () {
        return SubsystemName;
    }

    /**
     * Set SubsystemName to the specified value.
     */
    public void setSubsystemName(String SubsystemName) {

        this.SubsystemName = SubsystemName;

    }

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

    /**
     * Get the value for QOS1.
     */
    public String getQOS1 () {
        return QOS1;
    }

    /**
     * Set QOS1 to the specified value.
     */
    public void setQOS1(String QOS1) {

        // nullQOS1 = false;

        this.QOS1 = QOS1;

    }

    /*
     * Is the QOS1 null?
     */
    // public boolean isQOS1Null() {
    //	return nullQOS1;
    // }

    /*
     * Set the null indicator for QOS1
     */       
    // public void setQOS1Null() {
    // 	nullQOS1 = true;
    // }

    /**
     * Get the value for QOS2.
     */
    public String getQOS2 () {
        return QOS2;
    }

    /**
     * Set QOS2 to the specified value.
     */
    public void setQOS2(String QOS2) {

        // nullQOS2 = false;

        this.QOS2 = QOS2;

    }

    /*
     * Is the QOS2 null?
     */
    // public boolean isQOS2Null() {
    //	return nullQOS2;
    // }

    /*
     * Set the null indicator for QOS2
     */       
    // public void setQOS2Null() {
    // 	nullQOS2 = true;
    // }

    /**
     * Get the value for QOS3.
     */
    public String getQOS3 () {
        return QOS3;
    }

    /**
     * Set QOS3 to the specified value.
     */
    public void setQOS3(String QOS3) {

        // nullQOS3 = false;

        this.QOS3 = QOS3;

    }

    /*
     * Is the QOS3 null?
     */
    // public boolean isQOS3Null() {
    //	return nullQOS3;
    // }

    /*
     * Set the null indicator for QOS3
     */       
    // public void setQOS3Null() {
    // 	nullQOS3 = true;
    // }

}
