/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File NamedLoggerConfig.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.NamedLoggerConfigIDL;

/**

 * An entry in the NamedLoggerConfig table specifies the configuration of a particular logger in the process / application

 * whose logging settings are configured in the referenced table LoggingConfig.

 * Given the name of a logger, its log levels can be tweaked, overriding LoggingConfig.MinLogLevelDefault and LoggingConfig.MinLogLevelLocalDefault.

 * The logger name can identify the logger used by the container, or the logger used by the ORB, or a logger used by a component that runs inside the container.

 * 

 * Attribute description:

 * TODO

 * Constraint description:

   * Key: NamedLoggerConfigId is automatically generated from:  LoggingConfigId, Name

 *
 */
public class NamedLoggerConfig implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int NamedLoggerConfigId;

    private int LoggingConfigId;

    private String Name;

    private int MinLogLevel;

    private int MinLogLevelLocal;

    /**
     * Default Constructor for NamedLoggerConfig.  Setter methods must be used to insert data.
     */
    public NamedLoggerConfig () {

    }

    /**
     * Create a NamedLoggerConfig by specifiying all data values.
     */
    public NamedLoggerConfig (

        int NamedLoggerConfigId,

        int LoggingConfigId,

        String Name,

        int MinLogLevel,

        int MinLogLevelLocal

    ) {

		setNamedLoggerConfigId(NamedLoggerConfigId);

		setLoggingConfigId(LoggingConfigId);

		setName(Name);

		setMinLogLevel(MinLogLevel);

		setMinLogLevelLocal(MinLogLevelLocal);

    }

    /**
     * Create a NamedLoggerConfig by specifiying data values as an array of strings.
     */
    public NamedLoggerConfig (String[] data) {
    	if (data.length != 5)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 5)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NamedLoggerConfigId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.LoggingConfigId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Name = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.MinLogLevel = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.MinLogLevelLocal = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "NamedLoggerConfig:" + newline;

        s += "\tNamedLoggerConfigId: " + NamedLoggerConfigId + newline;

        s += "\tLoggingConfigId: " + LoggingConfigId + newline;

        s += "\tName: " + Name + newline;

        s += "\tMinLogLevel: " + MinLogLevel + newline;

        s += "\tMinLogLevelLocal: " + MinLogLevelLocal + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "NamedLoggerConfig" + delimiter;  

        s += NamedLoggerConfigId + delimiter;

        s += LoggingConfigId + delimiter;

        s += Name + delimiter;

        s += MinLogLevel + delimiter;

        s += MinLogLevelLocal + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 5;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#NamedLoggerConfig" + delimiter  

        	+ "NamedLoggerConfigId" + delimiter

        	+ "LoggingConfigId" + delimiter

        	+ "Name" + delimiter

        	+ "MinLogLevel" + delimiter

        	+ "MinLogLevelLocal" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof NamedLoggerConfig)) return false;
    	NamedLoggerConfig arg = (NamedLoggerConfig) obj;

		if (this.NamedLoggerConfigId != arg.NamedLoggerConfigId)
			return false;

		if (this.LoggingConfigId != arg.LoggingConfigId)
			return false;

		if (this.Name == null) {	// Two null strings are equal
			if (arg.Name == null)
				return true;
			else
				return false;
		}
		if (!this.Name.equals(arg.Name))
			return false; 

		if (this.MinLogLevel != arg.MinLogLevel)
			return false;

		if (this.MinLogLevelLocal != arg.MinLogLevelLocal)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public NamedLoggerConfigIDL toIDL() {
    	NamedLoggerConfigIDL x = new NamedLoggerConfigIDL ();

		x.NamedLoggerConfigId = this.NamedLoggerConfigId;

		x.LoggingConfigId = this.LoggingConfigId;

		x.Name = this.Name;

		x.MinLogLevel = this.MinLogLevel;

		x.MinLogLevelLocal = this.MinLogLevelLocal;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(NamedLoggerConfigIDL x) {

		this.NamedLoggerConfigId = x.NamedLoggerConfigId;

		this.LoggingConfigId = x.LoggingConfigId;

		this.Name = x.Name;

		this.MinLogLevel = x.MinLogLevel;

		this.MinLogLevelLocal = x.MinLogLevelLocal;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return NamedLoggerConfigId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for NamedLoggerConfig.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for NamedLoggerConfigId.
     */
    public int getNamedLoggerConfigId () {
        return NamedLoggerConfigId;
    }

    /**
     * Set NamedLoggerConfigId to the specified value.
     */
    public void setNamedLoggerConfigId(int NamedLoggerConfigId) {

        this.NamedLoggerConfigId = NamedLoggerConfigId;

    }

    /**
     * Get the value for LoggingConfigId.
     */
    public int getLoggingConfigId () {
        return LoggingConfigId;
    }

    /**
     * Set LoggingConfigId to the specified value.
     */
    public void setLoggingConfigId(int LoggingConfigId) {

        this.LoggingConfigId = LoggingConfigId;

    }

    /**
     * Get the value for Name.
     */
    public String getName () {
        return Name;
    }

    /**
     * Set Name to the specified value.
     */
    public void setName(String Name) {

        this.Name = Name;

    }

    /**
     * Get the value for MinLogLevel.
     */
    public int getMinLogLevel () {
        return MinLogLevel;
    }

    /**
     * Set MinLogLevel to the specified value.
     */
    public void setMinLogLevel(int MinLogLevel) {

        this.MinLogLevel = MinLogLevel;

    }

    /**
     * Get the value for MinLogLevelLocal.
     */
    public int getMinLogLevelLocal () {
        return MinLogLevelLocal;
    }

    /**
     * Set MinLogLevelLocal to the specified value.
     */
    public void setMinLogLevelLocal(int MinLogLevelLocal) {

        this.MinLogLevelLocal = MinLogLevelLocal;

    }

}
