/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File MonitorData.java
 */
package alma.TMCDB.generated;

import alma.TMCDB.types.ArrayTime;

import alma.TMCDB_GEN_IDL.MonitorDataIDL;

/**

   * Key: MonitorPointId, MonitorTS

 *
 */
public class MonitorData implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int MonitorPointId;

    private ArrayTime StartTime;

    private ArrayTime EndTime;

    private String MonitorTS;

    private int SampleSize;

    private String MonitorClob;

    private Double MinStat;

    // private boolean nullMinStat;

    private Double MaxStat;

    // private boolean nullMaxStat;

    private Double MeanStat;

    // private boolean nullMeanStat;

    private Double StdDevStat;

    // private boolean nullStdDevStat;

    /**
     * Default Constructor for MonitorData.  Setter methods must be used to insert data.
     */
    public MonitorData () {

        // nullMinStat = true;

        // nullMaxStat = true;

        // nullMeanStat = true;

        // nullStdDevStat = true;

    }

    /**
     * Create a MonitorData by specifiying all data values.
     */
    public MonitorData (

        int MonitorPointId,

        ArrayTime StartTime,

        ArrayTime EndTime,

        String MonitorTS,

        int SampleSize,

        String MonitorClob,

        Double MinStat,

        Double MaxStat,

        Double MeanStat,

        Double StdDevStat

    ) {

		setMonitorPointId(MonitorPointId);

		setStartTime(StartTime);

		setEndTime(EndTime);

		setMonitorTS(MonitorTS);

		setSampleSize(SampleSize);

		setMonitorClob(MonitorClob);

		setMinStat(MinStat);

		setMaxStat(MaxStat);

		setMeanStat(MeanStat);

		setStdDevStat(StdDevStat);

    }

    /**
     * Create a MonitorData by specifiying data values as an array of strings.
     */
    public MonitorData (String[] data) {
    	if (data.length != 10)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 10)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.MonitorPointId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StartTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.EndTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.MonitorTS = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.SampleSize = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.MonitorClob = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullMinStat = true;
			// this.MinStat = null;

		} else {

			// nullMinStat = false;

			this.MinStat = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullMaxStat = true;
			// this.MaxStat = null;

		} else {

			// nullMaxStat = false;

			this.MaxStat = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullMeanStat = true;
			// this.MeanStat = null;

		} else {

			// nullMeanStat = false;

			this.MeanStat = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullStdDevStat = true;
			// this.StdDevStat = null;

		} else {

			// nullStdDevStat = false;

			this.StdDevStat = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "MonitorData:" + newline;

        s += "\tMonitorPointId: " + MonitorPointId + newline;

        s += "\tStartTime: " + StartTime.toFITS() + newline;

        s += "\tEndTime: " + EndTime.toFITS() + newline;

        s += "\tMonitorTS: " + MonitorTS + newline;

        s += "\tSampleSize: " + SampleSize + newline;

        s += "\tMonitorClob: " + MonitorClob + newline;

    	// if (MinStat == null)
    	//	s += "\tMinStat: null" + newline;
    	// else

        s += "\tMinStat: " + MinStat + newline;

    	// if (MaxStat == null)
    	//	s += "\tMaxStat: null" + newline;
    	// else

        s += "\tMaxStat: " + MaxStat + newline;

    	// if (MeanStat == null)
    	//	s += "\tMeanStat: null" + newline;
    	// else

        s += "\tMeanStat: " + MeanStat + newline;

    	// if (StdDevStat == null)
    	//	s += "\tStdDevStat: null" + newline;
    	// else

        s += "\tStdDevStat: " + StdDevStat + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "MonitorData" + delimiter;  

        s += MonitorPointId + delimiter;

		s += new String(StartTime.toFITS()) + delimiter;

		s += new String(EndTime.toFITS()) + delimiter;

        s += MonitorTS + delimiter;

        s += SampleSize + delimiter;

        s += MonitorClob + delimiter;

        // if (nullMinStat)
        // 	s += delimiter;
        // else

        	// s += MinStat + delimiter;

        // if (nullMaxStat)
        // 	s += delimiter;
        // else

        	// s += MaxStat + delimiter;

        // if (nullMeanStat)
        // 	s += delimiter;
        // else

        	// s += MeanStat + delimiter;

        // if (nullStdDevStat)
        // 	s += delimiter;
        // else

        	// s += StdDevStat + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 10;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#MonitorData" + delimiter  

        	+ "MonitorPointId" + delimiter

        	+ "StartTime" + delimiter

        	+ "EndTime" + delimiter

        	+ "MonitorTS" + delimiter

        	+ "SampleSize" + delimiter

        	+ "MonitorClob" + delimiter

        	+ "MinStat" + delimiter

        	+ "MaxStat" + delimiter

        	+ "MeanStat" + delimiter

        	+ "StdDevStat" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof MonitorData)) return false;
    	MonitorData arg = (MonitorData) obj;

		if (this.MonitorPointId != arg.MonitorPointId)
			return false;

		if (this.StartTime.get() != arg.StartTime.get())
			return false;

		if (this.EndTime.get() != arg.EndTime.get())
			return false;

		if (this.MonitorTS == null) {	// Two null strings are equal
			if (arg.MonitorTS == null)
				return true;
			else
				return false;
		}
		if (!this.MonitorTS.equals(arg.MonitorTS))
			return false; 

		if (this.SampleSize != arg.SampleSize)
			return false;

		if (this.MonitorClob != arg.MonitorClob)
			return false;

		if (this.MinStat != arg.MinStat)
			return false;

		if (this.MaxStat != arg.MaxStat)
			return false;

		if (this.MeanStat != arg.MeanStat)
			return false;

		if (this.StdDevStat != arg.StdDevStat)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public MonitorDataIDL toIDL() {
    	MonitorDataIDL x = new MonitorDataIDL ();

		x.MonitorPointId = this.MonitorPointId;

		x.StartTime = this.StartTime.toIDLArrayTime();

		x.EndTime = this.EndTime.toIDLArrayTime();

		x.MonitorTS = this.MonitorTS;

		x.SampleSize = this.SampleSize;

		x.MonitorClob = this.MonitorClob;

		x.MinStat = this.MinStat;

        // x.nullMinStat = this.nullMinStat;

		x.MaxStat = this.MaxStat;

        // x.nullMaxStat = this.nullMaxStat;

		x.MeanStat = this.MeanStat;

        // x.nullMeanStat = this.nullMeanStat;

		x.StdDevStat = this.StdDevStat;

        // x.nullStdDevStat = this.nullStdDevStat;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(MonitorDataIDL x) {

		this.MonitorPointId = x.MonitorPointId;

		this.StartTime = new ArrayTime(x.StartTime);

		this.EndTime = new ArrayTime(x.EndTime);

		this.MonitorTS = x.MonitorTS;

		this.SampleSize = x.SampleSize;

		this.MonitorClob = x.MonitorClob;

		this.MinStat = x.MinStat;

        // this.nullMinStat = x.nullMinStat;

		this.MaxStat = x.MaxStat;

        // this.nullMaxStat = x.nullMaxStat;

		this.MeanStat = x.MeanStat;

        // this.nullMeanStat = x.nullMeanStat;

		this.StdDevStat = x.StdDevStat;

        // this.nullStdDevStat = x.nullStdDevStat;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for MonitorData.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for MonitorPointId.
     */
    public int getMonitorPointId () {
        return MonitorPointId;
    }

    /**
     * Set MonitorPointId to the specified value.
     */
    public void setMonitorPointId(int MonitorPointId) {

        this.MonitorPointId = MonitorPointId;

    }

    /**
     * Get the value for StartTime.
     */
    public ArrayTime getStartTime () {
        return StartTime;
    }

    /**
     * Set StartTime to the specified value.
     */
    public void setStartTime(ArrayTime StartTime) {

        this.StartTime = StartTime;

    }

    /**
     * Get the value for EndTime.
     */
    public ArrayTime getEndTime () {
        return EndTime;
    }

    /**
     * Set EndTime to the specified value.
     */
    public void setEndTime(ArrayTime EndTime) {

        this.EndTime = EndTime;

    }

    /**
     * Get the value for MonitorTS.
     */
    public String getMonitorTS () {
        return MonitorTS;
    }

    /**
     * Set MonitorTS to the specified value.
     */
    public void setMonitorTS(String MonitorTS) {

        this.MonitorTS = MonitorTS;

    }

    /**
     * Get the value for SampleSize.
     */
    public int getSampleSize () {
        return SampleSize;
    }

    /**
     * Set SampleSize to the specified value.
     */
    public void setSampleSize(int SampleSize) {

        this.SampleSize = SampleSize;

    }

    /**
     * Get the value for MonitorClob.
     */
    public String getMonitorClob () {
        return MonitorClob;
    }

    /**
     * Set MonitorClob to the specified value.
     */
    public void setMonitorClob(String MonitorClob) {

        this.MonitorClob = MonitorClob;

    }

    /**
     * Get the value for MinStat.
     */
    public Double getMinStat () {
        return MinStat;
    }

    /**
     * Set MinStat to the specified value.
     */
    public void setMinStat(Double MinStat) {

        // nullMinStat = false;

        this.MinStat = MinStat;

    }

    /*
     * Is the MinStat null?
     */
    // public boolean isMinStatNull() {
    //	return nullMinStat;
    // }

    /*
     * Set the null indicator for MinStat
     */       
    // public void setMinStatNull() {
    // 	nullMinStat = true;
    // }

    /**
     * Get the value for MaxStat.
     */
    public Double getMaxStat () {
        return MaxStat;
    }

    /**
     * Set MaxStat to the specified value.
     */
    public void setMaxStat(Double MaxStat) {

        // nullMaxStat = false;

        this.MaxStat = MaxStat;

    }

    /*
     * Is the MaxStat null?
     */
    // public boolean isMaxStatNull() {
    //	return nullMaxStat;
    // }

    /*
     * Set the null indicator for MaxStat
     */       
    // public void setMaxStatNull() {
    // 	nullMaxStat = true;
    // }

    /**
     * Get the value for MeanStat.
     */
    public Double getMeanStat () {
        return MeanStat;
    }

    /**
     * Set MeanStat to the specified value.
     */
    public void setMeanStat(Double MeanStat) {

        // nullMeanStat = false;

        this.MeanStat = MeanStat;

    }

    /*
     * Is the MeanStat null?
     */
    // public boolean isMeanStatNull() {
    //	return nullMeanStat;
    // }

    /*
     * Set the null indicator for MeanStat
     */       
    // public void setMeanStatNull() {
    // 	nullMeanStat = true;
    // }

    /**
     * Get the value for StdDevStat.
     */
    public Double getStdDevStat () {
        return StdDevStat;
    }

    /**
     * Set StdDevStat to the specified value.
     */
    public void setStdDevStat(Double StdDevStat) {

        // nullStdDevStat = false;

        this.StdDevStat = StdDevStat;

    }

    /*
     * Is the StdDevStat null?
     */
    // public boolean isStdDevStatNull() {
    //	return nullStdDevStat;
    // }

    /*
     * Set the null indicator for StdDevStat
     */       
    // public void setStdDevStatNull() {
    // 	nullStdDevStat = true;
    // }

}
