/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File MasterComponent.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.MasterComponentIDL;

/**

 * Entries in the MasterComponent table are the software master components for a particular software subsystem.

   * Key: MasterComponentId is automatically generated from:  ComponentId, ConfigurationId

 *
 */
public class MasterComponent implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int MasterComponentId;

    private int ComponentId;

    private int ConfigurationId;

    private String SubsystemName;

    /**
     * Default Constructor for MasterComponent.  Setter methods must be used to insert data.
     */
    public MasterComponent () {

    }

    /**
     * Create a MasterComponent by specifiying all data values.
     */
    public MasterComponent (

        int MasterComponentId,

        int ComponentId,

        int ConfigurationId,

        String SubsystemName

    ) {

		setMasterComponentId(MasterComponentId);

		setComponentId(ComponentId);

		setConfigurationId(ConfigurationId);

		setSubsystemName(SubsystemName);

    }

    /**
     * Create a MasterComponent by specifiying data values as an array of strings.
     */
    public MasterComponent (String[] data) {
    	if (data.length != 4)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 4)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.MasterComponentId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComponentId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.SubsystemName = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "MasterComponent:" + newline;

        s += "\tMasterComponentId: " + MasterComponentId + newline;

        s += "\tComponentId: " + ComponentId + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

        s += "\tSubsystemName: " + SubsystemName + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "MasterComponent" + delimiter;  

        s += MasterComponentId + delimiter;

        s += ComponentId + delimiter;

        s += ConfigurationId + delimiter;

        s += SubsystemName + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 4;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#MasterComponent" + delimiter  

        	+ "MasterComponentId" + delimiter

        	+ "ComponentId" + delimiter

        	+ "ConfigurationId" + delimiter

        	+ "SubsystemName" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof MasterComponent)) return false;
    	MasterComponent arg = (MasterComponent) obj;

		if (this.MasterComponentId != arg.MasterComponentId)
			return false;

		if (this.ComponentId != arg.ComponentId)
			return false;

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		if (this.SubsystemName == null) {	// Two null strings are equal
			if (arg.SubsystemName == null)
				return true;
			else
				return false;
		}
		if (!this.SubsystemName.equals(arg.SubsystemName))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public MasterComponentIDL toIDL() {
    	MasterComponentIDL x = new MasterComponentIDL ();

		x.MasterComponentId = this.MasterComponentId;

		x.ComponentId = this.ComponentId;

		x.ConfigurationId = this.ConfigurationId;

		x.SubsystemName = this.SubsystemName;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(MasterComponentIDL x) {

		this.MasterComponentId = x.MasterComponentId;

		this.ComponentId = x.ComponentId;

		this.ConfigurationId = x.ConfigurationId;

		this.SubsystemName = x.SubsystemName;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return MasterComponentId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for MasterComponent.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for MasterComponentId.
     */
    public int getMasterComponentId () {
        return MasterComponentId;
    }

    /**
     * Set MasterComponentId to the specified value.
     */
    public void setMasterComponentId(int MasterComponentId) {

        this.MasterComponentId = MasterComponentId;

    }

    /**
     * Get the value for ComponentId.
     */
    public int getComponentId () {
        return ComponentId;
    }

    /**
     * Set ComponentId to the specified value.
     */
    public void setComponentId(int ComponentId) {

        this.ComponentId = ComponentId;

    }

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

    /**
     * Get the value for SubsystemName.
     */
    public String getSubsystemName () {
        return SubsystemName;
    }

    /**
     * Set SubsystemName to the specified value.
     */
    public void setSubsystemName(String SubsystemName) {

        this.SubsystemName = SubsystemName;

    }

}
