/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File MasterClock.java
 */
package alma.TMCDB.generated;

import alma.TMCDB.types.ArrayTime;

import alma.TMCDB_GEN_IDL.MasterClockIDL;

/**

 * This table is really only a place-holder to be filled in later with more interesting properties.

   * Key: BaseElementId

 *
 */
public class MasterClock implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int BaseElementId;

    private ArrayTime CommissionDate;

    private int ComponentId;

    /**
     * Default Constructor for MasterClock.  Setter methods must be used to insert data.
     */
    public MasterClock () {

    }

    /**
     * Create a MasterClock by specifiying all data values.
     */
    public MasterClock (

        int BaseElementId,

        ArrayTime CommissionDate,

        int ComponentId

    ) {

		setBaseElementId(BaseElementId);

		setCommissionDate(CommissionDate);

		setComponentId(ComponentId);

    }

    /**
     * Create a MasterClock by specifiying data values as an array of strings.
     */
    public MasterClock (String[] data) {
    	if (data.length != 3)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 3)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CommissionDate = new ArrayTime(data[i]);

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComponentId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "MasterClock:" + newline;

        s += "\tBaseElementId: " + BaseElementId + newline;

        s += "\tCommissionDate: " + CommissionDate.toFITS() + newline;

        s += "\tComponentId: " + ComponentId + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "MasterClock" + delimiter;  

        s += BaseElementId + delimiter;

		s += new String(CommissionDate.toFITS()) + delimiter;

        s += ComponentId + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 3;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#MasterClock" + delimiter  

        	+ "BaseElementId" + delimiter

        	+ "CommissionDate" + delimiter

        	+ "ComponentId" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof MasterClock)) return false;
    	MasterClock arg = (MasterClock) obj;

		if (this.BaseElementId != arg.BaseElementId)
			return false;

		if (this.CommissionDate.get() != arg.CommissionDate.get())
			return false;

		if (this.ComponentId != arg.ComponentId)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public MasterClockIDL toIDL() {
    	MasterClockIDL x = new MasterClockIDL ();

		x.BaseElementId = this.BaseElementId;

		x.CommissionDate = this.CommissionDate.toIDLArrayTime();

		x.ComponentId = this.ComponentId;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(MasterClockIDL x) {

		this.BaseElementId = x.BaseElementId;

		this.CommissionDate = new ArrayTime(x.CommissionDate);

		this.ComponentId = x.ComponentId;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for MasterClock.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for BaseElementId.
     */
    public int getBaseElementId () {
        return BaseElementId;
    }

    /**
     * Set BaseElementId to the specified value.
     */
    public void setBaseElementId(int BaseElementId) {

        this.BaseElementId = BaseElementId;

    }

    /**
     * Get the value for CommissionDate.
     */
    public ArrayTime getCommissionDate () {
        return CommissionDate;
    }

    /**
     * Set CommissionDate to the specified value.
     */
    public void setCommissionDate(ArrayTime CommissionDate) {

        this.CommissionDate = CommissionDate;

    }

    /**
     * Get the value for ComponentId.
     */
    public int getComponentId () {
        return ComponentId;
    }

    /**
     * Set ComponentId to the specified value.
     */
    public void setComponentId(int ComponentId) {

        this.ComponentId = ComponentId;

    }

}
