/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File Manager.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.ManagerIDL;

/**

 * The entries in this table are the managers that belong to the configuration.

 * LoggingConfigId  Link to the logging configuration for a container.

 * ServerThreads    The number of threads allocated to the CORBA infrastructure for the handling of concurrent invocations.

 * TODO attribute description

   * Key: ManagerId is automatically generated from:  ConfigurationId, LoggingConfigId, Startup, ServiceComponents, Timeout, ClientPingInterval, AdministratorPingInterval, ContainerPingInterval, ServerThreads, DeadlockTimeout

 *
 */
public class Manager implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int ManagerId;

    private int ConfigurationId;

    private int LoggingConfigId;

    private String Startup;

    // private boolean nullStartup;

    private String ServiceComponents;

    // private boolean nullServiceComponents;

    private int Timeout;

    private int ClientPingInterval;

    private int AdministratorPingInterval;

    private int ContainerPingInterval;

    private int ServerThreads;

    private int DeadlockTimeout;

    /**
     * Default Constructor for Manager.  Setter methods must be used to insert data.
     */
    public Manager () {

        // nullStartup = true;

        // nullServiceComponents = true;

    }

    /**
     * Create a Manager by specifiying all data values.
     */
    public Manager (

        int ManagerId,

        int ConfigurationId,

        int LoggingConfigId,

        String Startup,

        String ServiceComponents,

        int Timeout,

        int ClientPingInterval,

        int AdministratorPingInterval,

        int ContainerPingInterval,

        int ServerThreads,

        int DeadlockTimeout

    ) {

		setManagerId(ManagerId);

		setConfigurationId(ConfigurationId);

		setLoggingConfigId(LoggingConfigId);

		setStartup(Startup);

		setServiceComponents(ServiceComponents);

		setTimeout(Timeout);

		setClientPingInterval(ClientPingInterval);

		setAdministratorPingInterval(AdministratorPingInterval);

		setContainerPingInterval(ContainerPingInterval);

		setServerThreads(ServerThreads);

		setDeadlockTimeout(DeadlockTimeout);

    }

    /**
     * Create a Manager by specifiying data values as an array of strings.
     */
    public Manager (String[] data) {
    	if (data.length != 11)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 11)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ManagerId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.LoggingConfigId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullStartup = true;
			// this.Startup = null;

		} else {

			// nullStartup = false;

			this.Startup = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullServiceComponents = true;
			// this.ServiceComponents = null;

		} else {

			// nullServiceComponents = false;

			this.ServiceComponents = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Timeout = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ClientPingInterval = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AdministratorPingInterval = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ContainerPingInterval = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ServerThreads = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DeadlockTimeout = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "Manager:" + newline;

        s += "\tManagerId: " + ManagerId + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

        s += "\tLoggingConfigId: " + LoggingConfigId + newline;

    	// if (Startup == null)
    	//	s += "\tStartup: null" + newline;
    	// else

        s += "\tStartup: " + Startup + newline;

    	// if (ServiceComponents == null)
    	//	s += "\tServiceComponents: null" + newline;
    	// else

        s += "\tServiceComponents: " + ServiceComponents + newline;

        s += "\tTimeout: " + Timeout + newline;

        s += "\tClientPingInterval: " + ClientPingInterval + newline;

        s += "\tAdministratorPingInterval: " + AdministratorPingInterval + newline;

        s += "\tContainerPingInterval: " + ContainerPingInterval + newline;

        s += "\tServerThreads: " + ServerThreads + newline;

        s += "\tDeadlockTimeout: " + DeadlockTimeout + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "Manager" + delimiter;  

        s += ManagerId + delimiter;

        s += ConfigurationId + delimiter;

        s += LoggingConfigId + delimiter;

        // if (nullStartup)
        // 	s += delimiter;
        // else

        	// s += Startup + delimiter;

        // if (nullServiceComponents)
        // 	s += delimiter;
        // else

        	// s += ServiceComponents + delimiter;

        s += Timeout + delimiter;

        s += ClientPingInterval + delimiter;

        s += AdministratorPingInterval + delimiter;

        s += ContainerPingInterval + delimiter;

        s += ServerThreads + delimiter;

        s += DeadlockTimeout + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 11;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#Manager" + delimiter  

        	+ "ManagerId" + delimiter

        	+ "ConfigurationId" + delimiter

        	+ "LoggingConfigId" + delimiter

        	+ "Startup" + delimiter

        	+ "ServiceComponents" + delimiter

        	+ "Timeout" + delimiter

        	+ "ClientPingInterval" + delimiter

        	+ "AdministratorPingInterval" + delimiter

        	+ "ContainerPingInterval" + delimiter

        	+ "ServerThreads" + delimiter

        	+ "DeadlockTimeout" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof Manager)) return false;
    	Manager arg = (Manager) obj;

		if (this.ManagerId != arg.ManagerId)
			return false;

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		if (this.LoggingConfigId != arg.LoggingConfigId)
			return false;

		if (this.Startup == null) {	// Two null strings are equal
			if (arg.Startup == null)
				return true;
			else
				return false;
		}
		if (!this.Startup.equals(arg.Startup))
			return false; 

		if (this.ServiceComponents == null) {	// Two null strings are equal
			if (arg.ServiceComponents == null)
				return true;
			else
				return false;
		}
		if (!this.ServiceComponents.equals(arg.ServiceComponents))
			return false; 

		if (this.Timeout != arg.Timeout)
			return false;

		if (this.ClientPingInterval != arg.ClientPingInterval)
			return false;

		if (this.AdministratorPingInterval != arg.AdministratorPingInterval)
			return false;

		if (this.ContainerPingInterval != arg.ContainerPingInterval)
			return false;

		if (this.ServerThreads != arg.ServerThreads)
			return false;

		if (this.DeadlockTimeout != arg.DeadlockTimeout)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public ManagerIDL toIDL() {
    	ManagerIDL x = new ManagerIDL ();

		x.ManagerId = this.ManagerId;

		x.ConfigurationId = this.ConfigurationId;

		x.LoggingConfigId = this.LoggingConfigId;

		x.Startup = this.Startup;

        // x.nullStartup = this.nullStartup;

		x.ServiceComponents = this.ServiceComponents;

        // x.nullServiceComponents = this.nullServiceComponents;

		x.Timeout = this.Timeout;

		x.ClientPingInterval = this.ClientPingInterval;

		x.AdministratorPingInterval = this.AdministratorPingInterval;

		x.ContainerPingInterval = this.ContainerPingInterval;

		x.ServerThreads = this.ServerThreads;

		x.DeadlockTimeout = this.DeadlockTimeout;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(ManagerIDL x) {

		this.ManagerId = x.ManagerId;

		this.ConfigurationId = x.ConfigurationId;

		this.LoggingConfigId = x.LoggingConfigId;

		this.Startup = x.Startup;

        // this.nullStartup = x.nullStartup;

		this.ServiceComponents = x.ServiceComponents;

        // this.nullServiceComponents = x.nullServiceComponents;

		this.Timeout = x.Timeout;

		this.ClientPingInterval = x.ClientPingInterval;

		this.AdministratorPingInterval = x.AdministratorPingInterval;

		this.ContainerPingInterval = x.ContainerPingInterval;

		this.ServerThreads = x.ServerThreads;

		this.DeadlockTimeout = x.DeadlockTimeout;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return ManagerId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for Manager.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for ManagerId.
     */
    public int getManagerId () {
        return ManagerId;
    }

    /**
     * Set ManagerId to the specified value.
     */
    public void setManagerId(int ManagerId) {

        this.ManagerId = ManagerId;

    }

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

    /**
     * Get the value for LoggingConfigId.
     */
    public int getLoggingConfigId () {
        return LoggingConfigId;
    }

    /**
     * Set LoggingConfigId to the specified value.
     */
    public void setLoggingConfigId(int LoggingConfigId) {

        this.LoggingConfigId = LoggingConfigId;

    }

    /**
     * Get the value for Startup.
     */
    public String getStartup () {
        return Startup;
    }

    /**
     * Set Startup to the specified value.
     */
    public void setStartup(String Startup) {

        // nullStartup = false;

        this.Startup = Startup;

    }

    /*
     * Is the Startup null?
     */
    // public boolean isStartupNull() {
    //	return nullStartup;
    // }

    /*
     * Set the null indicator for Startup
     */       
    // public void setStartupNull() {
    // 	nullStartup = true;
    // }

    /**
     * Get the value for ServiceComponents.
     */
    public String getServiceComponents () {
        return ServiceComponents;
    }

    /**
     * Set ServiceComponents to the specified value.
     */
    public void setServiceComponents(String ServiceComponents) {

        // nullServiceComponents = false;

        this.ServiceComponents = ServiceComponents;

    }

    /*
     * Is the ServiceComponents null?
     */
    // public boolean isServiceComponentsNull() {
    //	return nullServiceComponents;
    // }

    /*
     * Set the null indicator for ServiceComponents
     */       
    // public void setServiceComponentsNull() {
    // 	nullServiceComponents = true;
    // }

    /**
     * Get the value for Timeout.
     */
    public int getTimeout () {
        return Timeout;
    }

    /**
     * Set Timeout to the specified value.
     */
    public void setTimeout(int Timeout) {

        this.Timeout = Timeout;

    }

    /**
     * Get the value for ClientPingInterval.
     */
    public int getClientPingInterval () {
        return ClientPingInterval;
    }

    /**
     * Set ClientPingInterval to the specified value.
     */
    public void setClientPingInterval(int ClientPingInterval) {

        this.ClientPingInterval = ClientPingInterval;

    }

    /**
     * Get the value for AdministratorPingInterval.
     */
    public int getAdministratorPingInterval () {
        return AdministratorPingInterval;
    }

    /**
     * Set AdministratorPingInterval to the specified value.
     */
    public void setAdministratorPingInterval(int AdministratorPingInterval) {

        this.AdministratorPingInterval = AdministratorPingInterval;

    }

    /**
     * Get the value for ContainerPingInterval.
     */
    public int getContainerPingInterval () {
        return ContainerPingInterval;
    }

    /**
     * Set ContainerPingInterval to the specified value.
     */
    public void setContainerPingInterval(int ContainerPingInterval) {

        this.ContainerPingInterval = ContainerPingInterval;

    }

    /**
     * Get the value for ServerThreads.
     */
    public int getServerThreads () {
        return ServerThreads;
    }

    /**
     * Set ServerThreads to the specified value.
     */
    public void setServerThreads(int ServerThreads) {

        this.ServerThreads = ServerThreads;

    }

    /**
     * Get the value for DeadlockTimeout.
     */
    public int getDeadlockTimeout () {
        return DeadlockTimeout;
    }

    /**
     * Set DeadlockTimeout to the specified value.
     */
    public void setDeadlockTimeout(int DeadlockTimeout) {

        this.DeadlockTimeout = DeadlockTimeout;

    }

}
