/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File LoggingConfig.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.LoggingConfigIDL;

/**

 * An entry in the LoggingConfig table describes the logging configuration for a process such as a container or the ACS manager

 * which sends log records to a central log service.

 * Log levels (thresholds) can be specified here as a default for all loggers that run inside this process,

 * or can be refined by entries in the NamedLoggerConfig table.

 * Attribute description:

 * MinLogLevelDefault         All logs with priority lower than this value will be discarded and never sent to the logging system.

 * On a normally running system, priority is kept to INFO level (4) or higher to avoid flooding the logging system.

 * While debugging, it might be useful to increase the verbosity of the system by setting the priority to 0 or 2.

 * MinLogLevelLocalDefault    Same as "minLogLevelDefault", but controlling the printing of the log to stdout independently of sending the log to the log service.

 * Note that printing logs on the command line degrades performance much more than sending them to the log service.

 * This value can be overridden by the env variable "ACS_LOG_STDOUT"

 * CentralizedLogger          Name of the service representing the logging service. This is the name used to query the Manager for the reference to the logging service.

 * In the current installations the default value is normally used. The value can be changed to distribute logs to different instances of the service

 * in order to improve performance and scalability of the system. In the future it will be possible to federate instances of the logging service,

 * but this is not implemented yet.

 * DispatchPacketSize         In order to improve performance and reduce network traffic, containers do not send immediately logs to the logging system.

 * This parameter specifies how many logs are packaged together and sent to the logging system in one call.

 * Note that the real package size may be smaller if sending off the records is also triggered by a timer and/or by the log level.

 * For debugging purposes it may be convenient to set the cache to 0, to avoid losing logs when a Container crashes.

 * ImmediateDispatchLevel     Normally a number of log records are sent together to the logging system, as described for "DispatchPacketSize".

 * The "ImmediateDispatchLevel" triggers sending all cached log records immediately once a record with the given (or higher) log level appears,

 * even before the specified packet size has been reached.

 * FlushPeriodSeconds         If log records are queued locally in order to send a bunch of them together to the remote log service, we still may want to send

 * packages with fewer records after a certain time. This makes sure that log receivers see the messages in time, even if very few records get produced.

 * This value sets the time period in seconds after which the log record queue should be flushed if it contains log records,

 * regardless of the resulting 'dispatchPacketSize'.  A value "0" turns off the time-triggered flushing.

 * MaxLogQueueSize            Log records are stored in a queue not only to send them in a packet over the wire (see dispatchPacketSize), but also to not lose any records

 * in times when the log service is not available (e.g. during container start, or any kind of network and service failure).

 * Thus they get stored in a queue, which gets drained once the log service becomes available. However, logging should not compete for memory with the functional parts of the software, so we limit this queue.

 * Values below "DispatchPacketSize"  will be ignored, as we first must queue the records that should be sent together.

 * Constraint description:

 * MaxLogQueueSize

   * Key: LoggingConfigId is automatically generated.

 *
 */
public class LoggingConfig implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int LoggingConfigId;

    private int ConfigurationId;

    private int MinLogLevelDefault;

    private int MinLogLevelLocalDefault;

    private String CentralizedLogger;

    private int DispatchPacketSize;

    private int ImmediateDispatchLevel;

    private int FlushPeriodSeconds;

    private int MaxLogQueueSize;

    /**
     * Default Constructor for LoggingConfig.  Setter methods must be used to insert data.
     */
    public LoggingConfig () {

    }

    /**
     * Create a LoggingConfig by specifiying all data values.
     */
    public LoggingConfig (

        int LoggingConfigId,

        int ConfigurationId,

        int MinLogLevelDefault,

        int MinLogLevelLocalDefault,

        String CentralizedLogger,

        int DispatchPacketSize,

        int ImmediateDispatchLevel,

        int FlushPeriodSeconds,

        int MaxLogQueueSize

    ) {

		setLoggingConfigId(LoggingConfigId);

		setConfigurationId(ConfigurationId);

		setMinLogLevelDefault(MinLogLevelDefault);

		setMinLogLevelLocalDefault(MinLogLevelLocalDefault);

		setCentralizedLogger(CentralizedLogger);

		setDispatchPacketSize(DispatchPacketSize);

		setImmediateDispatchLevel(ImmediateDispatchLevel);

		setFlushPeriodSeconds(FlushPeriodSeconds);

		setMaxLogQueueSize(MaxLogQueueSize);

    }

    /**
     * Create a LoggingConfig by specifiying data values as an array of strings.
     */
    public LoggingConfig (String[] data) {
    	if (data.length != 9)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 9)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.LoggingConfigId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.MinLogLevelDefault = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.MinLogLevelLocalDefault = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CentralizedLogger = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DispatchPacketSize = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ImmediateDispatchLevel = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.FlushPeriodSeconds = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.MaxLogQueueSize = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "LoggingConfig:" + newline;

        s += "\tLoggingConfigId: " + LoggingConfigId + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

        s += "\tMinLogLevelDefault: " + MinLogLevelDefault + newline;

        s += "\tMinLogLevelLocalDefault: " + MinLogLevelLocalDefault + newline;

        s += "\tCentralizedLogger: " + CentralizedLogger + newline;

        s += "\tDispatchPacketSize: " + DispatchPacketSize + newline;

        s += "\tImmediateDispatchLevel: " + ImmediateDispatchLevel + newline;

        s += "\tFlushPeriodSeconds: " + FlushPeriodSeconds + newline;

        s += "\tMaxLogQueueSize: " + MaxLogQueueSize + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "LoggingConfig" + delimiter;  

        s += LoggingConfigId + delimiter;

        s += ConfigurationId + delimiter;

        s += MinLogLevelDefault + delimiter;

        s += MinLogLevelLocalDefault + delimiter;

        s += CentralizedLogger + delimiter;

        s += DispatchPacketSize + delimiter;

        s += ImmediateDispatchLevel + delimiter;

        s += FlushPeriodSeconds + delimiter;

        s += MaxLogQueueSize + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 9;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#LoggingConfig" + delimiter  

        	+ "LoggingConfigId" + delimiter

        	+ "ConfigurationId" + delimiter

        	+ "MinLogLevelDefault" + delimiter

        	+ "MinLogLevelLocalDefault" + delimiter

        	+ "CentralizedLogger" + delimiter

        	+ "DispatchPacketSize" + delimiter

        	+ "ImmediateDispatchLevel" + delimiter

        	+ "FlushPeriodSeconds" + delimiter

        	+ "MaxLogQueueSize" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof LoggingConfig)) return false;
    	LoggingConfig arg = (LoggingConfig) obj;

		if (this.LoggingConfigId != arg.LoggingConfigId)
			return false;

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		if (this.MinLogLevelDefault != arg.MinLogLevelDefault)
			return false;

		if (this.MinLogLevelLocalDefault != arg.MinLogLevelLocalDefault)
			return false;

		if (this.CentralizedLogger == null) {	// Two null strings are equal
			if (arg.CentralizedLogger == null)
				return true;
			else
				return false;
		}
		if (!this.CentralizedLogger.equals(arg.CentralizedLogger))
			return false; 

		if (this.DispatchPacketSize != arg.DispatchPacketSize)
			return false;

		if (this.ImmediateDispatchLevel != arg.ImmediateDispatchLevel)
			return false;

		if (this.FlushPeriodSeconds != arg.FlushPeriodSeconds)
			return false;

		if (this.MaxLogQueueSize != arg.MaxLogQueueSize)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public LoggingConfigIDL toIDL() {
    	LoggingConfigIDL x = new LoggingConfigIDL ();

		x.LoggingConfigId = this.LoggingConfigId;

		x.ConfigurationId = this.ConfigurationId;

		x.MinLogLevelDefault = this.MinLogLevelDefault;

		x.MinLogLevelLocalDefault = this.MinLogLevelLocalDefault;

		x.CentralizedLogger = this.CentralizedLogger;

		x.DispatchPacketSize = this.DispatchPacketSize;

		x.ImmediateDispatchLevel = this.ImmediateDispatchLevel;

		x.FlushPeriodSeconds = this.FlushPeriodSeconds;

		x.MaxLogQueueSize = this.MaxLogQueueSize;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(LoggingConfigIDL x) {

		this.LoggingConfigId = x.LoggingConfigId;

		this.ConfigurationId = x.ConfigurationId;

		this.MinLogLevelDefault = x.MinLogLevelDefault;

		this.MinLogLevelLocalDefault = x.MinLogLevelLocalDefault;

		this.CentralizedLogger = x.CentralizedLogger;

		this.DispatchPacketSize = x.DispatchPacketSize;

		this.ImmediateDispatchLevel = x.ImmediateDispatchLevel;

		this.FlushPeriodSeconds = x.FlushPeriodSeconds;

		this.MaxLogQueueSize = x.MaxLogQueueSize;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return LoggingConfigId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for LoggingConfig.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for LoggingConfigId.
     */
    public int getLoggingConfigId () {
        return LoggingConfigId;
    }

    /**
     * Set LoggingConfigId to the specified value.
     */
    public void setLoggingConfigId(int LoggingConfigId) {

        this.LoggingConfigId = LoggingConfigId;

    }

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

    /**
     * Get the value for MinLogLevelDefault.
     */
    public int getMinLogLevelDefault () {
        return MinLogLevelDefault;
    }

    /**
     * Set MinLogLevelDefault to the specified value.
     */
    public void setMinLogLevelDefault(int MinLogLevelDefault) {

        this.MinLogLevelDefault = MinLogLevelDefault;

    }

    /**
     * Get the value for MinLogLevelLocalDefault.
     */
    public int getMinLogLevelLocalDefault () {
        return MinLogLevelLocalDefault;
    }

    /**
     * Set MinLogLevelLocalDefault to the specified value.
     */
    public void setMinLogLevelLocalDefault(int MinLogLevelLocalDefault) {

        this.MinLogLevelLocalDefault = MinLogLevelLocalDefault;

    }

    /**
     * Get the value for CentralizedLogger.
     */
    public String getCentralizedLogger () {
        return CentralizedLogger;
    }

    /**
     * Set CentralizedLogger to the specified value.
     */
    public void setCentralizedLogger(String CentralizedLogger) {

        this.CentralizedLogger = CentralizedLogger;

    }

    /**
     * Get the value for DispatchPacketSize.
     */
    public int getDispatchPacketSize () {
        return DispatchPacketSize;
    }

    /**
     * Set DispatchPacketSize to the specified value.
     */
    public void setDispatchPacketSize(int DispatchPacketSize) {

        this.DispatchPacketSize = DispatchPacketSize;

    }

    /**
     * Get the value for ImmediateDispatchLevel.
     */
    public int getImmediateDispatchLevel () {
        return ImmediateDispatchLevel;
    }

    /**
     * Set ImmediateDispatchLevel to the specified value.
     */
    public void setImmediateDispatchLevel(int ImmediateDispatchLevel) {

        this.ImmediateDispatchLevel = ImmediateDispatchLevel;

    }

    /**
     * Get the value for FlushPeriodSeconds.
     */
    public int getFlushPeriodSeconds () {
        return FlushPeriodSeconds;
    }

    /**
     * Set FlushPeriodSeconds to the specified value.
     */
    public void setFlushPeriodSeconds(int FlushPeriodSeconds) {

        this.FlushPeriodSeconds = FlushPeriodSeconds;

    }

    /**
     * Get the value for MaxLogQueueSize.
     */
    public int getMaxLogQueueSize () {
        return MaxLogQueueSize;
    }

    /**
     * Set MaxLogQueueSize to the specified value.
     */
    public void setMaxLogQueueSize(int MaxLogQueueSize) {

        this.MaxLogQueueSize = MaxLogQueueSize;

    }

}
