/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File Location.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.LocationIDL;

/**

 * The following tables contain the alarm definitions and configuration

   * Key: LocationId is automatically generated from:  Building, Floor, Room, Mnemonic, LocationPosition

 *
 */
public class Location implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int LocationId;

    private String Building;

    // private boolean nullBuilding;

    private String Floor;

    // private boolean nullFloor;

    private String Room;

    // private boolean nullRoom;

    private String Mnemonic;

    // private boolean nullMnemonic;

    private String LocationPosition;

    // private boolean nullLocationPosition;

    /**
     * Default Constructor for Location.  Setter methods must be used to insert data.
     */
    public Location () {

        // nullBuilding = true;

        // nullFloor = true;

        // nullRoom = true;

        // nullMnemonic = true;

        // nullLocationPosition = true;

    }

    /**
     * Create a Location by specifiying all data values.
     */
    public Location (

        int LocationId,

        String Building,

        String Floor,

        String Room,

        String Mnemonic,

        String LocationPosition

    ) {

		setLocationId(LocationId);

		setBuilding(Building);

		setFloor(Floor);

		setRoom(Room);

		setMnemonic(Mnemonic);

		setLocationPosition(LocationPosition);

    }

    /**
     * Create a Location by specifiying data values as an array of strings.
     */
    public Location (String[] data) {
    	if (data.length != 6)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 6)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.LocationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullBuilding = true;
			// this.Building = null;

		} else {

			// nullBuilding = false;

			this.Building = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullFloor = true;
			// this.Floor = null;

		} else {

			// nullFloor = false;

			this.Floor = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullRoom = true;
			// this.Room = null;

		} else {

			// nullRoom = false;

			this.Room = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullMnemonic = true;
			// this.Mnemonic = null;

		} else {

			// nullMnemonic = false;

			this.Mnemonic = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullLocationPosition = true;
			// this.LocationPosition = null;

		} else {

			// nullLocationPosition = false;

			this.LocationPosition = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "Location:" + newline;

        s += "\tLocationId: " + LocationId + newline;

    	// if (Building == null)
    	//	s += "\tBuilding: null" + newline;
    	// else

        s += "\tBuilding: " + Building + newline;

    	// if (Floor == null)
    	//	s += "\tFloor: null" + newline;
    	// else

        s += "\tFloor: " + Floor + newline;

    	// if (Room == null)
    	//	s += "\tRoom: null" + newline;
    	// else

        s += "\tRoom: " + Room + newline;

    	// if (Mnemonic == null)
    	//	s += "\tMnemonic: null" + newline;
    	// else

        s += "\tMnemonic: " + Mnemonic + newline;

    	// if (LocationPosition == null)
    	//	s += "\tLocationPosition: null" + newline;
    	// else

        s += "\tLocationPosition: " + LocationPosition + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "Location" + delimiter;  

        s += LocationId + delimiter;

        // if (nullBuilding)
        // 	s += delimiter;
        // else

        	// s += Building + delimiter;

        // if (nullFloor)
        // 	s += delimiter;
        // else

        	// s += Floor + delimiter;

        // if (nullRoom)
        // 	s += delimiter;
        // else

        	// s += Room + delimiter;

        // if (nullMnemonic)
        // 	s += delimiter;
        // else

        	// s += Mnemonic + delimiter;

        // if (nullLocationPosition)
        // 	s += delimiter;
        // else

        	// s += LocationPosition + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 6;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#Location" + delimiter  

        	+ "LocationId" + delimiter

        	+ "Building" + delimiter

        	+ "Floor" + delimiter

        	+ "Room" + delimiter

        	+ "Mnemonic" + delimiter

        	+ "LocationPosition" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof Location)) return false;
    	Location arg = (Location) obj;

		if (this.LocationId != arg.LocationId)
			return false;

		if (this.Building == null) {	// Two null strings are equal
			if (arg.Building == null)
				return true;
			else
				return false;
		}
		if (!this.Building.equals(arg.Building))
			return false; 

		if (this.Floor == null) {	// Two null strings are equal
			if (arg.Floor == null)
				return true;
			else
				return false;
		}
		if (!this.Floor.equals(arg.Floor))
			return false; 

		if (this.Room == null) {	// Two null strings are equal
			if (arg.Room == null)
				return true;
			else
				return false;
		}
		if (!this.Room.equals(arg.Room))
			return false; 

		if (this.Mnemonic == null) {	// Two null strings are equal
			if (arg.Mnemonic == null)
				return true;
			else
				return false;
		}
		if (!this.Mnemonic.equals(arg.Mnemonic))
			return false; 

		if (this.LocationPosition == null) {	// Two null strings are equal
			if (arg.LocationPosition == null)
				return true;
			else
				return false;
		}
		if (!this.LocationPosition.equals(arg.LocationPosition))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public LocationIDL toIDL() {
    	LocationIDL x = new LocationIDL ();

		x.LocationId = this.LocationId;

		x.Building = this.Building;

        // x.nullBuilding = this.nullBuilding;

		x.Floor = this.Floor;

        // x.nullFloor = this.nullFloor;

		x.Room = this.Room;

        // x.nullRoom = this.nullRoom;

		x.Mnemonic = this.Mnemonic;

        // x.nullMnemonic = this.nullMnemonic;

		x.LocationPosition = this.LocationPosition;

        // x.nullLocationPosition = this.nullLocationPosition;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(LocationIDL x) {

		this.LocationId = x.LocationId;

		this.Building = x.Building;

        // this.nullBuilding = x.nullBuilding;

		this.Floor = x.Floor;

        // this.nullFloor = x.nullFloor;

		this.Room = x.Room;

        // this.nullRoom = x.nullRoom;

		this.Mnemonic = x.Mnemonic;

        // this.nullMnemonic = x.nullMnemonic;

		this.LocationPosition = x.LocationPosition;

        // this.nullLocationPosition = x.nullLocationPosition;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return LocationId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for Location.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for LocationId.
     */
    public int getLocationId () {
        return LocationId;
    }

    /**
     * Set LocationId to the specified value.
     */
    public void setLocationId(int LocationId) {

        this.LocationId = LocationId;

    }

    /**
     * Get the value for Building.
     */
    public String getBuilding () {
        return Building;
    }

    /**
     * Set Building to the specified value.
     */
    public void setBuilding(String Building) {

        // nullBuilding = false;

        this.Building = Building;

    }

    /*
     * Is the Building null?
     */
    // public boolean isBuildingNull() {
    //	return nullBuilding;
    // }

    /*
     * Set the null indicator for Building
     */       
    // public void setBuildingNull() {
    // 	nullBuilding = true;
    // }

    /**
     * Get the value for Floor.
     */
    public String getFloor () {
        return Floor;
    }

    /**
     * Set Floor to the specified value.
     */
    public void setFloor(String Floor) {

        // nullFloor = false;

        this.Floor = Floor;

    }

    /*
     * Is the Floor null?
     */
    // public boolean isFloorNull() {
    //	return nullFloor;
    // }

    /*
     * Set the null indicator for Floor
     */       
    // public void setFloorNull() {
    // 	nullFloor = true;
    // }

    /**
     * Get the value for Room.
     */
    public String getRoom () {
        return Room;
    }

    /**
     * Set Room to the specified value.
     */
    public void setRoom(String Room) {

        // nullRoom = false;

        this.Room = Room;

    }

    /*
     * Is the Room null?
     */
    // public boolean isRoomNull() {
    //	return nullRoom;
    // }

    /*
     * Set the null indicator for Room
     */       
    // public void setRoomNull() {
    // 	nullRoom = true;
    // }

    /**
     * Get the value for Mnemonic.
     */
    public String getMnemonic () {
        return Mnemonic;
    }

    /**
     * Set Mnemonic to the specified value.
     */
    public void setMnemonic(String Mnemonic) {

        // nullMnemonic = false;

        this.Mnemonic = Mnemonic;

    }

    /*
     * Is the Mnemonic null?
     */
    // public boolean isMnemonicNull() {
    //	return nullMnemonic;
    // }

    /*
     * Set the null indicator for Mnemonic
     */       
    // public void setMnemonicNull() {
    // 	nullMnemonic = true;
    // }

    /**
     * Get the value for LocationPosition.
     */
    public String getLocationPosition () {
        return LocationPosition;
    }

    /**
     * Set LocationPosition to the specified value.
     */
    public void setLocationPosition(String LocationPosition) {

        // nullLocationPosition = false;

        this.LocationPosition = LocationPosition;

    }

    /*
     * Is the LocationPosition null?
     */
    // public boolean isLocationPositionNull() {
    //	return nullLocationPosition;
    // }

    /*
     * Set the null indicator for LocationPosition
     */       
    // public void setLocationPositionNull() {
    // 	nullLocationPosition = true;
    // }

}
