/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File LRUType.java
 */
package alma.TMCDB.generated;

import alma.TMCDB.types.ArrayTime;

import alma.TMCDB_GEN_IDL.LRUTypeIDL;

/**

 * LRUType represents the types of Line Replacable Units (LRU).  These are hardware units that are taken out of field, carried back to the lab, repaired or replaced and brought back to the field.

   * Key: LRUName

 *
 */
public class LRUType implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private String LRUName;

    private String FullName;

    private String ICD;

    private ArrayTime ICDDate;

    private String Description;

    private String Notes;

    // private boolean nullNotes;

    /**
     * Default Constructor for LRUType.  Setter methods must be used to insert data.
     */
    public LRUType () {

        // nullNotes = true;

    }

    /**
     * Create a LRUType by specifiying all data values.
     */
    public LRUType (

        String LRUName,

        String FullName,

        String ICD,

        ArrayTime ICDDate,

        String Description,

        String Notes

    ) {

		setLRUName(LRUName);

		setFullName(FullName);

		setICD(ICD);

		setICDDate(ICDDate);

		setDescription(Description);

		setNotes(Notes);

    }

    /**
     * Create a LRUType by specifiying data values as an array of strings.
     */
    public LRUType (String[] data) {
    	if (data.length != 6)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 6)");
    	int i = 0;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.LRUName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.FullName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ICD = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ICDDate = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Description = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullNotes = true;
			// this.Notes = null;

		} else {

			// nullNotes = false;

			this.Notes = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "LRUType:" + newline;

        s += "\tLRUName: " + LRUName + newline;

        s += "\tFullName: " + FullName + newline;

        s += "\tICD: " + ICD + newline;

        s += "\tICDDate: " + ICDDate.toFITS() + newline;

        s += "\tDescription: " + Description + newline;

    	// if (Notes == null)
    	//	s += "\tNotes: null" + newline;
    	// else

        s += "\tNotes: " + Notes + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "LRUType" + delimiter;  

        s += LRUName + delimiter;

        s += FullName + delimiter;

        s += ICD + delimiter;

		s += new String(ICDDate.toFITS()) + delimiter;

        s += Description + delimiter;

        // if (nullNotes)
        // 	s += delimiter;
        // else

        	// s += Notes + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 6;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#LRUType" + delimiter  

        	+ "LRUName" + delimiter

        	+ "FullName" + delimiter

        	+ "ICD" + delimiter

        	+ "ICDDate" + delimiter

        	+ "Description" + delimiter

        	+ "Notes" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof LRUType)) return false;
    	LRUType arg = (LRUType) obj;

		if (this.LRUName == null) {	// Two null strings are equal
			if (arg.LRUName == null)
				return true;
			else
				return false;
		}
		if (!this.LRUName.equals(arg.LRUName))
			return false; 

		if (this.FullName == null) {	// Two null strings are equal
			if (arg.FullName == null)
				return true;
			else
				return false;
		}
		if (!this.FullName.equals(arg.FullName))
			return false; 

		if (this.ICD == null) {	// Two null strings are equal
			if (arg.ICD == null)
				return true;
			else
				return false;
		}
		if (!this.ICD.equals(arg.ICD))
			return false; 

		if (this.ICDDate.get() != arg.ICDDate.get())
			return false;

		if (this.Description == null) {	// Two null strings are equal
			if (arg.Description == null)
				return true;
			else
				return false;
		}
		if (!this.Description.equals(arg.Description))
			return false; 

		if (this.Notes == null) {	// Two null strings are equal
			if (arg.Notes == null)
				return true;
			else
				return false;
		}
		if (!this.Notes.equals(arg.Notes))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public LRUTypeIDL toIDL() {
    	LRUTypeIDL x = new LRUTypeIDL ();

		x.LRUName = this.LRUName;

		x.FullName = this.FullName;

		x.ICD = this.ICD;

		x.ICDDate = this.ICDDate.toIDLArrayTime();

		x.Description = this.Description;

		x.Notes = this.Notes;

        // x.nullNotes = this.nullNotes;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(LRUTypeIDL x) {

		this.LRUName = x.LRUName;

		this.FullName = x.FullName;

		this.ICD = x.ICD;

		this.ICDDate = new ArrayTime(x.ICDDate);

		this.Description = x.Description;

		this.Notes = x.Notes;

        // this.nullNotes = x.nullNotes;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for LRUType.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for LRUName.
     */
    public String getLRUName () {
        return LRUName;
    }

    /**
     * Set LRUName to the specified value.
     */
    public void setLRUName(String LRUName) {

        this.LRUName = LRUName;

    }

    /**
     * Get the value for FullName.
     */
    public String getFullName () {
        return FullName;
    }

    /**
     * Set FullName to the specified value.
     */
    public void setFullName(String FullName) {

        this.FullName = FullName;

    }

    /**
     * Get the value for ICD.
     */
    public String getICD () {
        return ICD;
    }

    /**
     * Set ICD to the specified value.
     */
    public void setICD(String ICD) {

        this.ICD = ICD;

    }

    /**
     * Get the value for ICDDate.
     */
    public ArrayTime getICDDate () {
        return ICDDate;
    }

    /**
     * Set ICDDate to the specified value.
     */
    public void setICDDate(ArrayTime ICDDate) {

        this.ICDDate = ICDDate;

    }

    /**
     * Get the value for Description.
     */
    public String getDescription () {
        return Description;
    }

    /**
     * Set Description to the specified value.
     */
    public void setDescription(String Description) {

        this.Description = Description;

    }

    /**
     * Get the value for Notes.
     */
    public String getNotes () {
        return Notes;
    }

    /**
     * Set Notes to the specified value.
     */
    public void setNotes(String Notes) {

        // nullNotes = false;

        this.Notes = Notes;

    }

    /*
     * Is the Notes null?
     */
    // public boolean isNotesNull() {
    //	return nullNotes;
    // }

    /*
     * Set the null indicator for Notes
     */       
    // public void setNotesNull() {
    // 	nullNotes = true;
    // }

}
