/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File FaultMember.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.FaultMemberIDL;

/**

   * Key: MemberName

 *
 */
public class FaultMember implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private String MemberName;

    private int FaultFamilyId;

    private Integer LocationId;

    // private boolean nullLocationId;

    /**
     * Default Constructor for FaultMember.  Setter methods must be used to insert data.
     */
    public FaultMember () {

        // nullLocationId = true;

    }

    /**
     * Create a FaultMember by specifiying all data values.
     */
    public FaultMember (

        String MemberName,

        int FaultFamilyId,

        Integer LocationId

    ) {

		setMemberName(MemberName);

		setFaultFamilyId(FaultFamilyId);

		setLocationId(LocationId);

    }

    /**
     * Create a FaultMember by specifiying data values as an array of strings.
     */
    public FaultMember (String[] data) {
    	if (data.length != 3)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 3)");
    	int i = 0;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.MemberName = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.FaultFamilyId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullLocationId = true;
			// this.LocationId = null;

		} else {

			// nullLocationId = false;

			this.LocationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "FaultMember:" + newline;

        s += "\tMemberName: " + MemberName + newline;

        s += "\tFaultFamilyId: " + FaultFamilyId + newline;

    	// if (LocationId == null)
    	//	s += "\tLocationId: null" + newline;
    	// else

        s += "\tLocationId: " + LocationId + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "FaultMember" + delimiter;  

        s += MemberName + delimiter;

        s += FaultFamilyId + delimiter;

        // if (nullLocationId)
        // 	s += delimiter;
        // else

        	// s += LocationId + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 3;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#FaultMember" + delimiter  

        	+ "MemberName" + delimiter

        	+ "FaultFamilyId" + delimiter

        	+ "LocationId" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof FaultMember)) return false;
    	FaultMember arg = (FaultMember) obj;

		if (this.MemberName == null) {	// Two null strings are equal
			if (arg.MemberName == null)
				return true;
			else
				return false;
		}
		if (!this.MemberName.equals(arg.MemberName))
			return false; 

		if (this.FaultFamilyId != arg.FaultFamilyId)
			return false;

		if (this.LocationId != arg.LocationId)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public FaultMemberIDL toIDL() {
    	FaultMemberIDL x = new FaultMemberIDL ();

		x.MemberName = this.MemberName;

		x.FaultFamilyId = this.FaultFamilyId;

		x.LocationId = this.LocationId;

        // x.nullLocationId = this.nullLocationId;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(FaultMemberIDL x) {

		this.MemberName = x.MemberName;

		this.FaultFamilyId = x.FaultFamilyId;

		this.LocationId = x.LocationId;

        // this.nullLocationId = x.nullLocationId;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for FaultMember.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for MemberName.
     */
    public String getMemberName () {
        return MemberName;
    }

    /**
     * Set MemberName to the specified value.
     */
    public void setMemberName(String MemberName) {

        this.MemberName = MemberName;

    }

    /**
     * Get the value for FaultFamilyId.
     */
    public int getFaultFamilyId () {
        return FaultFamilyId;
    }

    /**
     * Set FaultFamilyId to the specified value.
     */
    public void setFaultFamilyId(int FaultFamilyId) {

        this.FaultFamilyId = FaultFamilyId;

    }

    /**
     * Get the value for LocationId.
     */
    public Integer getLocationId () {
        return LocationId;
    }

    /**
     * Set LocationId to the specified value.
     */
    public void setLocationId(Integer LocationId) {

        // nullLocationId = false;

        this.LocationId = LocationId;

    }

    /*
     * Is the LocationId null?
     */
    // public boolean isLocationIdNull() {
    //	return nullLocationId;
    // }

    /*
     * Set the null indicator for LocationId
     */       
    // public void setLocationIdNull() {
    // 	nullLocationId = true;
    // }

}
