/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File FaultFamily.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.FaultFamilyIDL;

/**

   * Key: FaultFamilyId is automatically generated from:  FamilyName

 *
 */
public class FaultFamily implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int FaultFamilyId;

    private String FamilyName;

    private String AlarmCategoryName;

    // private boolean nullAlarmCategoryName;

    private String AlarmSource;

    private String HelpURL;

    // private boolean nullHelpURL;

    private int ContactId;

    /**
     * Default Constructor for FaultFamily.  Setter methods must be used to insert data.
     */
    public FaultFamily () {

        // nullAlarmCategoryName = true;

        // nullHelpURL = true;

    }

    /**
     * Create a FaultFamily by specifiying all data values.
     */
    public FaultFamily (

        int FaultFamilyId,

        String FamilyName,

        String AlarmCategoryName,

        String AlarmSource,

        String HelpURL,

        int ContactId

    ) {

		setFaultFamilyId(FaultFamilyId);

		setFamilyName(FamilyName);

		setAlarmCategoryName(AlarmCategoryName);

		setAlarmSource(AlarmSource);

		setHelpURL(HelpURL);

		setContactId(ContactId);

    }

    /**
     * Create a FaultFamily by specifiying data values as an array of strings.
     */
    public FaultFamily (String[] data) {
    	if (data.length != 6)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 6)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.FaultFamilyId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.FamilyName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullAlarmCategoryName = true;
			// this.AlarmCategoryName = null;

		} else {

			// nullAlarmCategoryName = false;

			this.AlarmCategoryName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AlarmSource = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullHelpURL = true;
			// this.HelpURL = null;

		} else {

			// nullHelpURL = false;

			this.HelpURL = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ContactId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "FaultFamily:" + newline;

        s += "\tFaultFamilyId: " + FaultFamilyId + newline;

        s += "\tFamilyName: " + FamilyName + newline;

    	// if (AlarmCategoryName == null)
    	//	s += "\tAlarmCategoryName: null" + newline;
    	// else

        s += "\tAlarmCategoryName: " + AlarmCategoryName + newline;

        s += "\tAlarmSource: " + AlarmSource + newline;

    	// if (HelpURL == null)
    	//	s += "\tHelpURL: null" + newline;
    	// else

        s += "\tHelpURL: " + HelpURL + newline;

        s += "\tContactId: " + ContactId + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "FaultFamily" + delimiter;  

        s += FaultFamilyId + delimiter;

        s += FamilyName + delimiter;

        // if (nullAlarmCategoryName)
        // 	s += delimiter;
        // else

        	// s += AlarmCategoryName + delimiter;

        s += AlarmSource + delimiter;

        // if (nullHelpURL)
        // 	s += delimiter;
        // else

        	// s += HelpURL + delimiter;

        s += ContactId + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 6;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#FaultFamily" + delimiter  

        	+ "FaultFamilyId" + delimiter

        	+ "FamilyName" + delimiter

        	+ "AlarmCategoryName" + delimiter

        	+ "AlarmSource" + delimiter

        	+ "HelpURL" + delimiter

        	+ "ContactId" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof FaultFamily)) return false;
    	FaultFamily arg = (FaultFamily) obj;

		if (this.FaultFamilyId != arg.FaultFamilyId)
			return false;

		if (this.FamilyName == null) {	// Two null strings are equal
			if (arg.FamilyName == null)
				return true;
			else
				return false;
		}
		if (!this.FamilyName.equals(arg.FamilyName))
			return false; 

		if (this.AlarmCategoryName == null) {	// Two null strings are equal
			if (arg.AlarmCategoryName == null)
				return true;
			else
				return false;
		}
		if (!this.AlarmCategoryName.equals(arg.AlarmCategoryName))
			return false; 

		if (this.AlarmSource == null) {	// Two null strings are equal
			if (arg.AlarmSource == null)
				return true;
			else
				return false;
		}
		if (!this.AlarmSource.equals(arg.AlarmSource))
			return false; 

		if (this.HelpURL == null) {	// Two null strings are equal
			if (arg.HelpURL == null)
				return true;
			else
				return false;
		}
		if (!this.HelpURL.equals(arg.HelpURL))
			return false; 

		if (this.ContactId != arg.ContactId)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public FaultFamilyIDL toIDL() {
    	FaultFamilyIDL x = new FaultFamilyIDL ();

		x.FaultFamilyId = this.FaultFamilyId;

		x.FamilyName = this.FamilyName;

		x.AlarmCategoryName = this.AlarmCategoryName;

        // x.nullAlarmCategoryName = this.nullAlarmCategoryName;

		x.AlarmSource = this.AlarmSource;

		x.HelpURL = this.HelpURL;

        // x.nullHelpURL = this.nullHelpURL;

		x.ContactId = this.ContactId;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(FaultFamilyIDL x) {

		this.FaultFamilyId = x.FaultFamilyId;

		this.FamilyName = x.FamilyName;

		this.AlarmCategoryName = x.AlarmCategoryName;

        // this.nullAlarmCategoryName = x.nullAlarmCategoryName;

		this.AlarmSource = x.AlarmSource;

		this.HelpURL = x.HelpURL;

        // this.nullHelpURL = x.nullHelpURL;

		this.ContactId = x.ContactId;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return FaultFamilyId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for FaultFamily.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for FaultFamilyId.
     */
    public int getFaultFamilyId () {
        return FaultFamilyId;
    }

    /**
     * Set FaultFamilyId to the specified value.
     */
    public void setFaultFamilyId(int FaultFamilyId) {

        this.FaultFamilyId = FaultFamilyId;

    }

    /**
     * Get the value for FamilyName.
     */
    public String getFamilyName () {
        return FamilyName;
    }

    /**
     * Set FamilyName to the specified value.
     */
    public void setFamilyName(String FamilyName) {

        this.FamilyName = FamilyName;

    }

    /**
     * Get the value for AlarmCategoryName.
     */
    public String getAlarmCategoryName () {
        return AlarmCategoryName;
    }

    /**
     * Set AlarmCategoryName to the specified value.
     */
    public void setAlarmCategoryName(String AlarmCategoryName) {

        // nullAlarmCategoryName = false;

        this.AlarmCategoryName = AlarmCategoryName;

    }

    /*
     * Is the AlarmCategoryName null?
     */
    // public boolean isAlarmCategoryNameNull() {
    //	return nullAlarmCategoryName;
    // }

    /*
     * Set the null indicator for AlarmCategoryName
     */       
    // public void setAlarmCategoryNameNull() {
    // 	nullAlarmCategoryName = true;
    // }

    /**
     * Get the value for AlarmSource.
     */
    public String getAlarmSource () {
        return AlarmSource;
    }

    /**
     * Set AlarmSource to the specified value.
     */
    public void setAlarmSource(String AlarmSource) {

        this.AlarmSource = AlarmSource;

    }

    /**
     * Get the value for HelpURL.
     */
    public String getHelpURL () {
        return HelpURL;
    }

    /**
     * Set HelpURL to the specified value.
     */
    public void setHelpURL(String HelpURL) {

        // nullHelpURL = false;

        this.HelpURL = HelpURL;

    }

    /*
     * Is the HelpURL null?
     */
    // public boolean isHelpURLNull() {
    //	return nullHelpURL;
    // }

    /*
     * Set the null indicator for HelpURL
     */       
    // public void setHelpURLNull() {
    // 	nullHelpURL = true;
    // }

    /**
     * Get the value for ContactId.
     */
    public int getContactId () {
        return ContactId;
    }

    /**
     * Set ContactId to the specified value.
     */
    public void setContactId(int ContactId) {

        this.ContactId = ContactId;

    }

}
