/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File FaultCode.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.FaultCodeIDL;

/**

   * Key: FaultCodeId is automatically generated from:  FaultFamilyId, CodeValue

 *
 */
public class FaultCode implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int FaultCodeId;

    private int FaultFamilyId;

    private int CodeValue;

    private int Priority;

    private String Cause;

    // private boolean nullCause;

    private String Action;

    // private boolean nullAction;

    private String Consequence;

    // private boolean nullConsequence;

    private String ProblemDescription;

    private boolean IsInstant;

    /**
     * Default Constructor for FaultCode.  Setter methods must be used to insert data.
     */
    public FaultCode () {

        // nullCause = true;

        // nullAction = true;

        // nullConsequence = true;

    }

    /**
     * Create a FaultCode by specifiying all data values.
     */
    public FaultCode (

        int FaultCodeId,

        int FaultFamilyId,

        int CodeValue,

        int Priority,

        String Cause,

        String Action,

        String Consequence,

        String ProblemDescription,

        boolean IsInstant

    ) {

		setFaultCodeId(FaultCodeId);

		setFaultFamilyId(FaultFamilyId);

		setCodeValue(CodeValue);

		setPriority(Priority);

		setCause(Cause);

		setAction(Action);

		setConsequence(Consequence);

		setProblemDescription(ProblemDescription);

		setIsInstant(IsInstant);

    }

    /**
     * Create a FaultCode by specifiying data values as an array of strings.
     */
    public FaultCode (String[] data) {
    	if (data.length != 9)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 9)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.FaultCodeId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.FaultFamilyId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CodeValue = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Priority = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullCause = true;
			// this.Cause = null;

		} else {

			// nullCause = false;

			this.Cause = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullAction = true;
			// this.Action = null;

		} else {

			// nullAction = false;

			this.Action = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullConsequence = true;
			// this.Consequence = null;

		} else {

			// nullConsequence = false;

			this.Consequence = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ProblemDescription = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.IsInstant = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "FaultCode:" + newline;

        s += "\tFaultCodeId: " + FaultCodeId + newline;

        s += "\tFaultFamilyId: " + FaultFamilyId + newline;

        s += "\tCodeValue: " + CodeValue + newline;

        s += "\tPriority: " + Priority + newline;

    	// if (Cause == null)
    	//	s += "\tCause: null" + newline;
    	// else

        s += "\tCause: " + Cause + newline;

    	// if (Action == null)
    	//	s += "\tAction: null" + newline;
    	// else

        s += "\tAction: " + Action + newline;

    	// if (Consequence == null)
    	//	s += "\tConsequence: null" + newline;
    	// else

        s += "\tConsequence: " + Consequence + newline;

        s += "\tProblemDescription: " + ProblemDescription + newline;

        s += "\tIsInstant: " + IsInstant + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "FaultCode" + delimiter;  

        s += FaultCodeId + delimiter;

        s += FaultFamilyId + delimiter;

        s += CodeValue + delimiter;

        s += Priority + delimiter;

        // if (nullCause)
        // 	s += delimiter;
        // else

        	// s += Cause + delimiter;

        // if (nullAction)
        // 	s += delimiter;
        // else

        	// s += Action + delimiter;

        // if (nullConsequence)
        // 	s += delimiter;
        // else

        	// s += Consequence + delimiter;

        s += ProblemDescription + delimiter;

        s += IsInstant + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 9;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#FaultCode" + delimiter  

        	+ "FaultCodeId" + delimiter

        	+ "FaultFamilyId" + delimiter

        	+ "CodeValue" + delimiter

        	+ "Priority" + delimiter

        	+ "Cause" + delimiter

        	+ "Action" + delimiter

        	+ "Consequence" + delimiter

        	+ "ProblemDescription" + delimiter

        	+ "IsInstant" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof FaultCode)) return false;
    	FaultCode arg = (FaultCode) obj;

		if (this.FaultCodeId != arg.FaultCodeId)
			return false;

		if (this.FaultFamilyId != arg.FaultFamilyId)
			return false;

		if (this.CodeValue != arg.CodeValue)
			return false;

		if (this.Priority != arg.Priority)
			return false;

		if (this.Cause == null) {	// Two null strings are equal
			if (arg.Cause == null)
				return true;
			else
				return false;
		}
		if (!this.Cause.equals(arg.Cause))
			return false; 

		if (this.Action == null) {	// Two null strings are equal
			if (arg.Action == null)
				return true;
			else
				return false;
		}
		if (!this.Action.equals(arg.Action))
			return false; 

		if (this.Consequence == null) {	// Two null strings are equal
			if (arg.Consequence == null)
				return true;
			else
				return false;
		}
		if (!this.Consequence.equals(arg.Consequence))
			return false; 

		if (this.ProblemDescription == null) {	// Two null strings are equal
			if (arg.ProblemDescription == null)
				return true;
			else
				return false;
		}
		if (!this.ProblemDescription.equals(arg.ProblemDescription))
			return false; 

		if (this.IsInstant != arg.IsInstant)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public FaultCodeIDL toIDL() {
    	FaultCodeIDL x = new FaultCodeIDL ();

		x.FaultCodeId = this.FaultCodeId;

		x.FaultFamilyId = this.FaultFamilyId;

		x.CodeValue = this.CodeValue;

		x.Priority = this.Priority;

		x.Cause = this.Cause;

        // x.nullCause = this.nullCause;

		x.Action = this.Action;

        // x.nullAction = this.nullAction;

		x.Consequence = this.Consequence;

        // x.nullConsequence = this.nullConsequence;

		x.ProblemDescription = this.ProblemDescription;

		x.IsInstant = this.IsInstant;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(FaultCodeIDL x) {

		this.FaultCodeId = x.FaultCodeId;

		this.FaultFamilyId = x.FaultFamilyId;

		this.CodeValue = x.CodeValue;

		this.Priority = x.Priority;

		this.Cause = x.Cause;

        // this.nullCause = x.nullCause;

		this.Action = x.Action;

        // this.nullAction = x.nullAction;

		this.Consequence = x.Consequence;

        // this.nullConsequence = x.nullConsequence;

		this.ProblemDescription = x.ProblemDescription;

		this.IsInstant = x.IsInstant;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return FaultCodeId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for FaultCode.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for FaultCodeId.
     */
    public int getFaultCodeId () {
        return FaultCodeId;
    }

    /**
     * Set FaultCodeId to the specified value.
     */
    public void setFaultCodeId(int FaultCodeId) {

        this.FaultCodeId = FaultCodeId;

    }

    /**
     * Get the value for FaultFamilyId.
     */
    public int getFaultFamilyId () {
        return FaultFamilyId;
    }

    /**
     * Set FaultFamilyId to the specified value.
     */
    public void setFaultFamilyId(int FaultFamilyId) {

        this.FaultFamilyId = FaultFamilyId;

    }

    /**
     * Get the value for CodeValue.
     */
    public int getCodeValue () {
        return CodeValue;
    }

    /**
     * Set CodeValue to the specified value.
     */
    public void setCodeValue(int CodeValue) {

        this.CodeValue = CodeValue;

    }

    /**
     * Get the value for Priority.
     */
    public int getPriority () {
        return Priority;
    }

    /**
     * Set Priority to the specified value.
     */
    public void setPriority(int Priority) {

        this.Priority = Priority;

    }

    /**
     * Get the value for Cause.
     */
    public String getCause () {
        return Cause;
    }

    /**
     * Set Cause to the specified value.
     */
    public void setCause(String Cause) {

        // nullCause = false;

        this.Cause = Cause;

    }

    /*
     * Is the Cause null?
     */
    // public boolean isCauseNull() {
    //	return nullCause;
    // }

    /*
     * Set the null indicator for Cause
     */       
    // public void setCauseNull() {
    // 	nullCause = true;
    // }

    /**
     * Get the value for Action.
     */
    public String getAction () {
        return Action;
    }

    /**
     * Set Action to the specified value.
     */
    public void setAction(String Action) {

        // nullAction = false;

        this.Action = Action;

    }

    /*
     * Is the Action null?
     */
    // public boolean isActionNull() {
    //	return nullAction;
    // }

    /*
     * Set the null indicator for Action
     */       
    // public void setActionNull() {
    // 	nullAction = true;
    // }

    /**
     * Get the value for Consequence.
     */
    public String getConsequence () {
        return Consequence;
    }

    /**
     * Set Consequence to the specified value.
     */
    public void setConsequence(String Consequence) {

        // nullConsequence = false;

        this.Consequence = Consequence;

    }

    /*
     * Is the Consequence null?
     */
    // public boolean isConsequenceNull() {
    //	return nullConsequence;
    // }

    /*
     * Set the null indicator for Consequence
     */       
    // public void setConsequenceNull() {
    // 	nullConsequence = true;
    // }

    /**
     * Get the value for ProblemDescription.
     */
    public String getProblemDescription () {
        return ProblemDescription;
    }

    /**
     * Set ProblemDescription to the specified value.
     */
    public void setProblemDescription(String ProblemDescription) {

        this.ProblemDescription = ProblemDescription;

    }

    /**
     * Get the value for IsInstant.
     */
    public boolean getIsInstant () {
        return IsInstant;
    }

    /**
     * Set IsInstant to the specified value.
     */
    public void setIsInstant(boolean IsInstant) {

        this.IsInstant = IsInstant;

    }

}
