/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File DeploymentStartup.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.DeploymentStartupIDL;

/**

 * The DeploymentStartup table specifies a deployment element, either ACS or a computer, container

 * or component, to be started.

 * Name and Path are the name and path, if present, of the particular deployment item.

 * The DependsOnType and DependsOnId are used to indicate dependencies between these items.

   * Key: Name, Path, StartupType, StartupId

 *
 */
public class DeploymentStartup implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private String Name;

    private String Path;

    private String StartupType;

    private int StartupId;

    private String DependsOnName;

    // private boolean nullDependsOnName;

    private String DependsOnPath;

    // private boolean nullDependsOnPath;

    private String DependsOnType;

    // private boolean nullDependsOnType;

    /**
     * Default Constructor for DeploymentStartup.  Setter methods must be used to insert data.
     */
    public DeploymentStartup () {

        // nullDependsOnName = true;

        // nullDependsOnPath = true;

        // nullDependsOnType = true;

    }

    /**
     * Create a DeploymentStartup by specifiying all data values.
     */
    public DeploymentStartup (

        String Name,

        String Path,

        String StartupType,

        int StartupId,

        String DependsOnName,

        String DependsOnPath,

        String DependsOnType

    ) {

		setName(Name);

		setPath(Path);

		setStartupType(StartupType);

		setStartupId(StartupId);

		setDependsOnName(DependsOnName);

		setDependsOnPath(DependsOnPath);

		setDependsOnType(DependsOnType);

    }

    /**
     * Create a DeploymentStartup by specifiying data values as an array of strings.
     */
    public DeploymentStartup (String[] data) {
    	if (data.length != 7)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 7)");
    	int i = 0;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Name = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Path = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StartupType = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StartupId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullDependsOnName = true;
			// this.DependsOnName = null;

		} else {

			// nullDependsOnName = false;

			this.DependsOnName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullDependsOnPath = true;
			// this.DependsOnPath = null;

		} else {

			// nullDependsOnPath = false;

			this.DependsOnPath = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullDependsOnType = true;
			// this.DependsOnType = null;

		} else {

			// nullDependsOnType = false;

			this.DependsOnType = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "DeploymentStartup:" + newline;

        s += "\tName: " + Name + newline;

        s += "\tPath: " + Path + newline;

        s += "\tStartupType: " + StartupType + newline;

        s += "\tStartupId: " + StartupId + newline;

    	// if (DependsOnName == null)
    	//	s += "\tDependsOnName: null" + newline;
    	// else

        s += "\tDependsOnName: " + DependsOnName + newline;

    	// if (DependsOnPath == null)
    	//	s += "\tDependsOnPath: null" + newline;
    	// else

        s += "\tDependsOnPath: " + DependsOnPath + newline;

    	// if (DependsOnType == null)
    	//	s += "\tDependsOnType: null" + newline;
    	// else

        s += "\tDependsOnType: " + DependsOnType + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "DeploymentStartup" + delimiter;  

        s += Name + delimiter;

        s += Path + delimiter;

        s += StartupType + delimiter;

        s += StartupId + delimiter;

        // if (nullDependsOnName)
        // 	s += delimiter;
        // else

        	// s += DependsOnName + delimiter;

        // if (nullDependsOnPath)
        // 	s += delimiter;
        // else

        	// s += DependsOnPath + delimiter;

        // if (nullDependsOnType)
        // 	s += delimiter;
        // else

        	// s += DependsOnType + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 7;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#DeploymentStartup" + delimiter  

        	+ "Name" + delimiter

        	+ "Path" + delimiter

        	+ "StartupType" + delimiter

        	+ "StartupId" + delimiter

        	+ "DependsOnName" + delimiter

        	+ "DependsOnPath" + delimiter

        	+ "DependsOnType" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof DeploymentStartup)) return false;
    	DeploymentStartup arg = (DeploymentStartup) obj;

		if (this.Name == null) {	// Two null strings are equal
			if (arg.Name == null)
				return true;
			else
				return false;
		}
		if (!this.Name.equals(arg.Name))
			return false; 

		if (this.Path == null) {	// Two null strings are equal
			if (arg.Path == null)
				return true;
			else
				return false;
		}
		if (!this.Path.equals(arg.Path))
			return false; 

		if (this.StartupType == null) {	// Two null strings are equal
			if (arg.StartupType == null)
				return true;
			else
				return false;
		}
		if (!this.StartupType.equals(arg.StartupType))
			return false; 

		if (this.StartupId != arg.StartupId)
			return false;

		if (this.DependsOnName == null) {	// Two null strings are equal
			if (arg.DependsOnName == null)
				return true;
			else
				return false;
		}
		if (!this.DependsOnName.equals(arg.DependsOnName))
			return false; 

		if (this.DependsOnPath == null) {	// Two null strings are equal
			if (arg.DependsOnPath == null)
				return true;
			else
				return false;
		}
		if (!this.DependsOnPath.equals(arg.DependsOnPath))
			return false; 

		if (this.DependsOnType == null) {	// Two null strings are equal
			if (arg.DependsOnType == null)
				return true;
			else
				return false;
		}
		if (!this.DependsOnType.equals(arg.DependsOnType))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public DeploymentStartupIDL toIDL() {
    	DeploymentStartupIDL x = new DeploymentStartupIDL ();

		x.Name = this.Name;

		x.Path = this.Path;

		x.StartupType = this.StartupType;

		x.StartupId = this.StartupId;

		x.DependsOnName = this.DependsOnName;

        // x.nullDependsOnName = this.nullDependsOnName;

		x.DependsOnPath = this.DependsOnPath;

        // x.nullDependsOnPath = this.nullDependsOnPath;

		x.DependsOnType = this.DependsOnType;

        // x.nullDependsOnType = this.nullDependsOnType;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(DeploymentStartupIDL x) {

		this.Name = x.Name;

		this.Path = x.Path;

		this.StartupType = x.StartupType;

		this.StartupId = x.StartupId;

		this.DependsOnName = x.DependsOnName;

        // this.nullDependsOnName = x.nullDependsOnName;

		this.DependsOnPath = x.DependsOnPath;

        // this.nullDependsOnPath = x.nullDependsOnPath;

		this.DependsOnType = x.DependsOnType;

        // this.nullDependsOnType = x.nullDependsOnType;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for DeploymentStartup.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for Name.
     */
    public String getName () {
        return Name;
    }

    /**
     * Set Name to the specified value.
     */
    public void setName(String Name) {

        this.Name = Name;

    }

    /**
     * Get the value for Path.
     */
    public String getPath () {
        return Path;
    }

    /**
     * Set Path to the specified value.
     */
    public void setPath(String Path) {

        this.Path = Path;

    }

    /**
     * Get the value for StartupType.
     */
    public String getStartupType () {
        return StartupType;
    }

    /**
     * Set StartupType to the specified value.
     */
    public void setStartupType(String StartupType) {

        this.StartupType = StartupType;

    }

    /**
     * Get the value for StartupId.
     */
    public int getStartupId () {
        return StartupId;
    }

    /**
     * Set StartupId to the specified value.
     */
    public void setStartupId(int StartupId) {

        this.StartupId = StartupId;

    }

    /**
     * Get the value for DependsOnName.
     */
    public String getDependsOnName () {
        return DependsOnName;
    }

    /**
     * Set DependsOnName to the specified value.
     */
    public void setDependsOnName(String DependsOnName) {

        // nullDependsOnName = false;

        this.DependsOnName = DependsOnName;

    }

    /*
     * Is the DependsOnName null?
     */
    // public boolean isDependsOnNameNull() {
    //	return nullDependsOnName;
    // }

    /*
     * Set the null indicator for DependsOnName
     */       
    // public void setDependsOnNameNull() {
    // 	nullDependsOnName = true;
    // }

    /**
     * Get the value for DependsOnPath.
     */
    public String getDependsOnPath () {
        return DependsOnPath;
    }

    /**
     * Set DependsOnPath to the specified value.
     */
    public void setDependsOnPath(String DependsOnPath) {

        // nullDependsOnPath = false;

        this.DependsOnPath = DependsOnPath;

    }

    /*
     * Is the DependsOnPath null?
     */
    // public boolean isDependsOnPathNull() {
    //	return nullDependsOnPath;
    // }

    /*
     * Set the null indicator for DependsOnPath
     */       
    // public void setDependsOnPathNull() {
    // 	nullDependsOnPath = true;
    // }

    /**
     * Get the value for DependsOnType.
     */
    public String getDependsOnType () {
        return DependsOnType;
    }

    /**
     * Set DependsOnType to the specified value.
     */
    public void setDependsOnType(String DependsOnType) {

        // nullDependsOnType = false;

        this.DependsOnType = DependsOnType;

    }

    /*
     * Is the DependsOnType null?
     */
    // public boolean isDependsOnTypeNull() {
    //	return nullDependsOnType;
    // }

    /*
     * Set the null indicator for DependsOnType
     */       
    // public void setDependsOnTypeNull() {
    // 	nullDependsOnType = true;
    // }

}
