/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File DefaultMonitorPoint.java
 */
package alma.TMCDB.generated;

import alma.TMCDB.types.Length;

import alma.TMCDB_GEN_IDL.DefaultMonitorPointIDL;

/**

 * Next table allows for the feature Dynamic discovery of Device-SerialNumber

   * Key: DefaultMonitorPointId

 *
 */
public class DefaultMonitorPoint implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int DefaultMonitorPointId;

    private int DefaultBACIPropertyId;

    private String MonitorPointName;

    private int Indice;

    private String DataType;

    private String RCA;

    private boolean TeRelated;

    private String RawDataType;

    private String WorldDataType;

    private String Units;

    // private boolean nullUnits;

    private Double Scale;

    // private boolean nullScale;

    private Length Offset;

    // private boolean nullOffset;

    private String MinRange;

    // private boolean nullMinRange;

    private String MaxRange;

    // private boolean nullMaxRange;

    private String Description;

    /**
     * Default Constructor for DefaultMonitorPoint.  Setter methods must be used to insert data.
     */
    public DefaultMonitorPoint () {

        // nullUnits = true;

        // nullScale = true;

        // nullOffset = true;

        // nullMinRange = true;

        // nullMaxRange = true;

    }

    /**
     * Create a DefaultMonitorPoint by specifiying all data values.
     */
    public DefaultMonitorPoint (

        int DefaultMonitorPointId,

        int DefaultBACIPropertyId,

        String MonitorPointName,

        int Indice,

        String DataType,

        String RCA,

        boolean TeRelated,

        String RawDataType,

        String WorldDataType,

        String Units,

        Double Scale,

        Length Offset,

        String MinRange,

        String MaxRange,

        String Description

    ) {

		setDefaultMonitorPointId(DefaultMonitorPointId);

		setDefaultBACIPropertyId(DefaultBACIPropertyId);

		setMonitorPointName(MonitorPointName);

		setIndice(Indice);

		setDataType(DataType);

		setRCA(RCA);

		setTeRelated(TeRelated);

		setRawDataType(RawDataType);

		setWorldDataType(WorldDataType);

		setUnits(Units);

		setScale(Scale);

		setOffset(Offset);

		setMinRange(MinRange);

		setMaxRange(MaxRange);

		setDescription(Description);

    }

    /**
     * Create a DefaultMonitorPoint by specifiying data values as an array of strings.
     */
    public DefaultMonitorPoint (String[] data) {
    	if (data.length != 15)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 15)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DefaultMonitorPointId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DefaultBACIPropertyId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.MonitorPointName = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Indice = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DataType = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.RCA = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.TeRelated = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.RawDataType = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.WorldDataType = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullUnits = true;
			// this.Units = null;

		} else {

			// nullUnits = false;

			this.Units = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullScale = true;
			// this.Scale = null;

		} else {

			// nullScale = false;

			this.Scale = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullOffset = true;
			// this.Offset = null;

		} else {

			// nullOffset = false;

			this.Offset = new Length(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullMinRange = true;
			// this.MinRange = null;

		} else {

			// nullMinRange = false;

			this.MinRange = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullMaxRange = true;
			// this.MaxRange = null;

		} else {

			// nullMaxRange = false;

			this.MaxRange = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Description = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "DefaultMonitorPoint:" + newline;

        s += "\tDefaultMonitorPointId: " + DefaultMonitorPointId + newline;

        s += "\tDefaultBACIPropertyId: " + DefaultBACIPropertyId + newline;

        s += "\tMonitorPointName: " + MonitorPointName + newline;

        s += "\tIndice: " + Indice + newline;

        s += "\tDataType: " + DataType + newline;

        s += "\tRCA: " + RCA + newline;

        s += "\tTeRelated: " + TeRelated + newline;

        s += "\tRawDataType: " + RawDataType + newline;

        s += "\tWorldDataType: " + WorldDataType + newline;

    	// if (Units == null)
    	//	s += "\tUnits: null" + newline;
    	// else

        s += "\tUnits: " + Units + newline;

    	// if (Scale == null)
    	//	s += "\tScale: null" + newline;
    	// else

        s += "\tScale: " + Scale + newline;

    	// if (Offset == null)
    	//	s += "\tOffset: null" + newline;
    	// else

        s += "\tOffset: " + Offset + newline;

    	// if (MinRange == null)
    	//	s += "\tMinRange: null" + newline;
    	// else

        s += "\tMinRange: " + MinRange + newline;

    	// if (MaxRange == null)
    	//	s += "\tMaxRange: null" + newline;
    	// else

        s += "\tMaxRange: " + MaxRange + newline;

        s += "\tDescription: " + Description + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "DefaultMonitorPoint" + delimiter;  

        s += DefaultMonitorPointId + delimiter;

        s += DefaultBACIPropertyId + delimiter;

        s += MonitorPointName + delimiter;

        s += Indice + delimiter;

        s += DataType + delimiter;

        s += RCA + delimiter;

        s += TeRelated + delimiter;

        s += RawDataType + delimiter;

        s += WorldDataType + delimiter;

        // if (nullUnits)
        // 	s += delimiter;
        // else

        	// s += Units + delimiter;

        // if (nullScale)
        // 	s += delimiter;
        // else

        	// s += Scale + delimiter;

        // if (nullOffset)
        // 	s += delimiter;
        // else

        	// s += Offset + delimiter;

        // if (nullMinRange)
        // 	s += delimiter;
        // else

        	// s += MinRange + delimiter;

        // if (nullMaxRange)
        // 	s += delimiter;
        // else

        	// s += MaxRange + delimiter;

        s += Description + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 15;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#DefaultMonitorPoint" + delimiter  

        	+ "DefaultMonitorPointId" + delimiter

        	+ "DefaultBACIPropertyId" + delimiter

        	+ "MonitorPointName" + delimiter

        	+ "Indice" + delimiter

        	+ "DataType" + delimiter

        	+ "RCA" + delimiter

        	+ "TeRelated" + delimiter

        	+ "RawDataType" + delimiter

        	+ "WorldDataType" + delimiter

        	+ "Units" + delimiter

        	+ "Scale" + delimiter

        	+ "Offset" + delimiter

        	+ "MinRange" + delimiter

        	+ "MaxRange" + delimiter

        	+ "Description" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof DefaultMonitorPoint)) return false;
    	DefaultMonitorPoint arg = (DefaultMonitorPoint) obj;

		if (this.DefaultMonitorPointId != arg.DefaultMonitorPointId)
			return false;

		if (this.DefaultBACIPropertyId != arg.DefaultBACIPropertyId)
			return false;

		if (this.MonitorPointName == null) {	// Two null strings are equal
			if (arg.MonitorPointName == null)
				return true;
			else
				return false;
		}
		if (!this.MonitorPointName.equals(arg.MonitorPointName))
			return false; 

		if (this.Indice != arg.Indice)
			return false;

		if (this.DataType == null) {	// Two null strings are equal
			if (arg.DataType == null)
				return true;
			else
				return false;
		}
		if (!this.DataType.equals(arg.DataType))
			return false; 

		if (this.RCA == null) {	// Two null strings are equal
			if (arg.RCA == null)
				return true;
			else
				return false;
		}
		if (!this.RCA.equals(arg.RCA))
			return false; 

		if (this.TeRelated != arg.TeRelated)
			return false;

		if (this.RawDataType == null) {	// Two null strings are equal
			if (arg.RawDataType == null)
				return true;
			else
				return false;
		}
		if (!this.RawDataType.equals(arg.RawDataType))
			return false; 

		if (this.WorldDataType == null) {	// Two null strings are equal
			if (arg.WorldDataType == null)
				return true;
			else
				return false;
		}
		if (!this.WorldDataType.equals(arg.WorldDataType))
			return false; 

		if (this.Units == null) {	// Two null strings are equal
			if (arg.Units == null)
				return true;
			else
				return false;
		}
		if (!this.Units.equals(arg.Units))
			return false; 

		if (this.Scale != arg.Scale)
			return false;

		if (this.Offset.get() != arg.Offset.get())
			return false;

		if (this.MinRange == null) {	// Two null strings are equal
			if (arg.MinRange == null)
				return true;
			else
				return false;
		}
		if (!this.MinRange.equals(arg.MinRange))
			return false; 

		if (this.MaxRange == null) {	// Two null strings are equal
			if (arg.MaxRange == null)
				return true;
			else
				return false;
		}
		if (!this.MaxRange.equals(arg.MaxRange))
			return false; 

		if (this.Description == null) {	// Two null strings are equal
			if (arg.Description == null)
				return true;
			else
				return false;
		}
		if (!this.Description.equals(arg.Description))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public DefaultMonitorPointIDL toIDL() {
    	DefaultMonitorPointIDL x = new DefaultMonitorPointIDL ();

		x.DefaultMonitorPointId = this.DefaultMonitorPointId;

		x.DefaultBACIPropertyId = this.DefaultBACIPropertyId;

		x.MonitorPointName = this.MonitorPointName;

		x.Indice = this.Indice;

		x.DataType = this.DataType;

		x.RCA = this.RCA;

		x.TeRelated = this.TeRelated;

		x.RawDataType = this.RawDataType;

		x.WorldDataType = this.WorldDataType;

		x.Units = this.Units;

        // x.nullUnits = this.nullUnits;

		x.Scale = this.Scale;

        // x.nullScale = this.nullScale;

		x.Offset = this.Offset.toIDLLength();

        // x.nullOffset = this.nullOffset;

		x.MinRange = this.MinRange;

        // x.nullMinRange = this.nullMinRange;

		x.MaxRange = this.MaxRange;

        // x.nullMaxRange = this.nullMaxRange;

		x.Description = this.Description;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(DefaultMonitorPointIDL x) {

		this.DefaultMonitorPointId = x.DefaultMonitorPointId;

		this.DefaultBACIPropertyId = x.DefaultBACIPropertyId;

		this.MonitorPointName = x.MonitorPointName;

		this.Indice = x.Indice;

		this.DataType = x.DataType;

		this.RCA = x.RCA;

		this.TeRelated = x.TeRelated;

		this.RawDataType = x.RawDataType;

		this.WorldDataType = x.WorldDataType;

		this.Units = x.Units;

        // this.nullUnits = x.nullUnits;

		this.Scale = x.Scale;

        // this.nullScale = x.nullScale;

		this.Offset = new Length(x.Offset);

        // this.nullOffset = x.nullOffset;

		this.MinRange = x.MinRange;

        // this.nullMinRange = x.nullMinRange;

		this.MaxRange = x.MaxRange;

        // this.nullMaxRange = x.nullMaxRange;

		this.Description = x.Description;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for DefaultMonitorPoint.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for DefaultMonitorPointId.
     */
    public int getDefaultMonitorPointId () {
        return DefaultMonitorPointId;
    }

    /**
     * Set DefaultMonitorPointId to the specified value.
     */
    public void setDefaultMonitorPointId(int DefaultMonitorPointId) {

        this.DefaultMonitorPointId = DefaultMonitorPointId;

    }

    /**
     * Get the value for DefaultBACIPropertyId.
     */
    public int getDefaultBACIPropertyId () {
        return DefaultBACIPropertyId;
    }

    /**
     * Set DefaultBACIPropertyId to the specified value.
     */
    public void setDefaultBACIPropertyId(int DefaultBACIPropertyId) {

        this.DefaultBACIPropertyId = DefaultBACIPropertyId;

    }

    /**
     * Get the value for MonitorPointName.
     */
    public String getMonitorPointName () {
        return MonitorPointName;
    }

    /**
     * Set MonitorPointName to the specified value.
     */
    public void setMonitorPointName(String MonitorPointName) {

        this.MonitorPointName = MonitorPointName;

    }

    /**
     * Get the value for Indice.
     */
    public int getIndice () {
        return Indice;
    }

    /**
     * Set Indice to the specified value.
     */
    public void setIndice(int Indice) {

        this.Indice = Indice;

    }

    /**
     * Get the value for DataType.
     */
    public String getDataType () {
        return DataType;
    }

    /**
     * Set DataType to the specified value.
     */
    public void setDataType(String DataType) {

        this.DataType = DataType;

    }

    /**
     * Get the value for RCA.
     */
    public String getRCA () {
        return RCA;
    }

    /**
     * Set RCA to the specified value.
     */
    public void setRCA(String RCA) {

        this.RCA = RCA;

    }

    /**
     * Get the value for TeRelated.
     */
    public boolean getTeRelated () {
        return TeRelated;
    }

    /**
     * Set TeRelated to the specified value.
     */
    public void setTeRelated(boolean TeRelated) {

        this.TeRelated = TeRelated;

    }

    /**
     * Get the value for RawDataType.
     */
    public String getRawDataType () {
        return RawDataType;
    }

    /**
     * Set RawDataType to the specified value.
     */
    public void setRawDataType(String RawDataType) {

        this.RawDataType = RawDataType;

    }

    /**
     * Get the value for WorldDataType.
     */
    public String getWorldDataType () {
        return WorldDataType;
    }

    /**
     * Set WorldDataType to the specified value.
     */
    public void setWorldDataType(String WorldDataType) {

        this.WorldDataType = WorldDataType;

    }

    /**
     * Get the value for Units.
     */
    public String getUnits () {
        return Units;
    }

    /**
     * Set Units to the specified value.
     */
    public void setUnits(String Units) {

        // nullUnits = false;

        this.Units = Units;

    }

    /*
     * Is the Units null?
     */
    // public boolean isUnitsNull() {
    //	return nullUnits;
    // }

    /*
     * Set the null indicator for Units
     */       
    // public void setUnitsNull() {
    // 	nullUnits = true;
    // }

    /**
     * Get the value for Scale.
     */
    public Double getScale () {
        return Scale;
    }

    /**
     * Set Scale to the specified value.
     */
    public void setScale(Double Scale) {

        // nullScale = false;

        this.Scale = Scale;

    }

    /*
     * Is the Scale null?
     */
    // public boolean isScaleNull() {
    //	return nullScale;
    // }

    /*
     * Set the null indicator for Scale
     */       
    // public void setScaleNull() {
    // 	nullScale = true;
    // }

    /**
     * Get the value for Offset.
     */
    public Length getOffset () {
        return Offset;
    }

    /**
     * Set Offset to the specified value.
     */
    public void setOffset(Length Offset) {

        // nullOffset = false;

        this.Offset = Offset;

    }

    /*
     * Is the Offset null?
     */
    // public boolean isOffsetNull() {
    //	return nullOffset;
    // }

    /*
     * Set the null indicator for Offset
     */       
    // public void setOffsetNull() {
    // 	nullOffset = true;
    // }

    /**
     * Get the value for MinRange.
     */
    public String getMinRange () {
        return MinRange;
    }

    /**
     * Set MinRange to the specified value.
     */
    public void setMinRange(String MinRange) {

        // nullMinRange = false;

        this.MinRange = MinRange;

    }

    /*
     * Is the MinRange null?
     */
    // public boolean isMinRangeNull() {
    //	return nullMinRange;
    // }

    /*
     * Set the null indicator for MinRange
     */       
    // public void setMinRangeNull() {
    // 	nullMinRange = true;
    // }

    /**
     * Get the value for MaxRange.
     */
    public String getMaxRange () {
        return MaxRange;
    }

    /**
     * Set MaxRange to the specified value.
     */
    public void setMaxRange(String MaxRange) {

        // nullMaxRange = false;

        this.MaxRange = MaxRange;

    }

    /*
     * Is the MaxRange null?
     */
    // public boolean isMaxRangeNull() {
    //	return nullMaxRange;
    // }

    /*
     * Set the null indicator for MaxRange
     */       
    // public void setMaxRangeNull() {
    // 	nullMaxRange = true;
    // }

    /**
     * Get the value for Description.
     */
    public String getDescription () {
        return Description;
    }

    /**
     * Set Description to the specified value.
     */
    public void setDescription(String Description) {

        this.Description = Description;

    }

}
