/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File DefaultMember.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.DefaultMemberIDL;

/**

   * Key: DefaultMemberId

 *
 */
public class DefaultMember implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int DefaultMemberId;

    private int FaultFamilyId;

    private Integer LocationID;

    // private boolean nullLocationID;

    /**
     * Default Constructor for DefaultMember.  Setter methods must be used to insert data.
     */
    public DefaultMember () {

        // nullLocationID = true;

    }

    /**
     * Create a DefaultMember by specifiying all data values.
     */
    public DefaultMember (

        int DefaultMemberId,

        int FaultFamilyId,

        Integer LocationID

    ) {

		setDefaultMemberId(DefaultMemberId);

		setFaultFamilyId(FaultFamilyId);

		setLocationID(LocationID);

    }

    /**
     * Create a DefaultMember by specifiying data values as an array of strings.
     */
    public DefaultMember (String[] data) {
    	if (data.length != 3)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 3)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DefaultMemberId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.FaultFamilyId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullLocationID = true;
			// this.LocationID = null;

		} else {

			// nullLocationID = false;

			this.LocationID = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "DefaultMember:" + newline;

        s += "\tDefaultMemberId: " + DefaultMemberId + newline;

        s += "\tFaultFamilyId: " + FaultFamilyId + newline;

    	// if (LocationID == null)
    	//	s += "\tLocationID: null" + newline;
    	// else

        s += "\tLocationID: " + LocationID + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "DefaultMember" + delimiter;  

        s += DefaultMemberId + delimiter;

        s += FaultFamilyId + delimiter;

        // if (nullLocationID)
        // 	s += delimiter;
        // else

        	// s += LocationID + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 3;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#DefaultMember" + delimiter  

        	+ "DefaultMemberId" + delimiter

        	+ "FaultFamilyId" + delimiter

        	+ "LocationID" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof DefaultMember)) return false;
    	DefaultMember arg = (DefaultMember) obj;

		if (this.DefaultMemberId != arg.DefaultMemberId)
			return false;

		if (this.FaultFamilyId != arg.FaultFamilyId)
			return false;

		if (this.LocationID != arg.LocationID)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public DefaultMemberIDL toIDL() {
    	DefaultMemberIDL x = new DefaultMemberIDL ();

		x.DefaultMemberId = this.DefaultMemberId;

		x.FaultFamilyId = this.FaultFamilyId;

		x.LocationID = this.LocationID;

        // x.nullLocationID = this.nullLocationID;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(DefaultMemberIDL x) {

		this.DefaultMemberId = x.DefaultMemberId;

		this.FaultFamilyId = x.FaultFamilyId;

		this.LocationID = x.LocationID;

        // this.nullLocationID = x.nullLocationID;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for DefaultMember.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for DefaultMemberId.
     */
    public int getDefaultMemberId () {
        return DefaultMemberId;
    }

    /**
     * Set DefaultMemberId to the specified value.
     */
    public void setDefaultMemberId(int DefaultMemberId) {

        this.DefaultMemberId = DefaultMemberId;

    }

    /**
     * Get the value for FaultFamilyId.
     */
    public int getFaultFamilyId () {
        return FaultFamilyId;
    }

    /**
     * Set FaultFamilyId to the specified value.
     */
    public void setFaultFamilyId(int FaultFamilyId) {

        this.FaultFamilyId = FaultFamilyId;

    }

    /**
     * Get the value for LocationID.
     */
    public Integer getLocationID () {
        return LocationID;
    }

    /**
     * Set LocationID to the specified value.
     */
    public void setLocationID(Integer LocationID) {

        // nullLocationID = false;

        this.LocationID = LocationID;

    }

    /*
     * Is the LocationID null?
     */
    // public boolean isLocationIDNull() {
    //	return nullLocationID;
    // }

    /*
     * Set the null indicator for LocationID
     */       
    // public void setLocationIDNull() {
    // 	nullLocationID = true;
    // }

}
