/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File DefaultComponent.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.DefaultComponentIDL;

/**

 * The Default Component table have the static information coming from ALMA Components

   * Key: DefaultComponentId

 *
 */
public class DefaultComponent implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int DefaultComponentId;

    private int ComponentTypeId;

    private String AssemblyTypeName;

    private String ImplLang;

    private boolean RealTime;

    private String Code;

    private String Path;

    private boolean IsAutostart;

    private boolean IsDefault;

    private Boolean IsStandaloneDefined;

    // private boolean nullIsStandaloneDefined;

    private int KeepAliveTime;

    private int MinLogLevel;

    private int MinLogLevelLocal;

    private String XMLDoc;

    // private boolean nullXMLDoc;

    /**
     * Default Constructor for DefaultComponent.  Setter methods must be used to insert data.
     */
    public DefaultComponent () {

        // nullIsStandaloneDefined = true;

        // nullXMLDoc = true;

    }

    /**
     * Create a DefaultComponent by specifiying all data values.
     */
    public DefaultComponent (

        int DefaultComponentId,

        int ComponentTypeId,

        String AssemblyTypeName,

        String ImplLang,

        boolean RealTime,

        String Code,

        String Path,

        boolean IsAutostart,

        boolean IsDefault,

        Boolean IsStandaloneDefined,

        int KeepAliveTime,

        int MinLogLevel,

        int MinLogLevelLocal,

        String XMLDoc

    ) {

		setDefaultComponentId(DefaultComponentId);

		setComponentTypeId(ComponentTypeId);

		setAssemblyTypeName(AssemblyTypeName);

		setImplLang(ImplLang);

		setRealTime(RealTime);

		setCode(Code);

		setPath(Path);

		setIsAutostart(IsAutostart);

		setIsDefault(IsDefault);

		setIsStandaloneDefined(IsStandaloneDefined);

		setKeepAliveTime(KeepAliveTime);

		setMinLogLevel(MinLogLevel);

		setMinLogLevelLocal(MinLogLevelLocal);

		setXMLDoc(XMLDoc);

    }

    /**
     * Create a DefaultComponent by specifiying data values as an array of strings.
     */
    public DefaultComponent (String[] data) {
    	if (data.length != 14)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 14)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DefaultComponentId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComponentTypeId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AssemblyTypeName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ImplLang = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.RealTime = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Code = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Path = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.IsAutostart = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.IsDefault = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullIsStandaloneDefined = true;
			// this.IsStandaloneDefined = null;

		} else {

			// nullIsStandaloneDefined = false;

			this.IsStandaloneDefined = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.KeepAliveTime = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.MinLogLevel = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.MinLogLevelLocal = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullXMLDoc = true;
			// this.XMLDoc = null;

		} else {

			// nullXMLDoc = false;

			this.XMLDoc = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "DefaultComponent:" + newline;

        s += "\tDefaultComponentId: " + DefaultComponentId + newline;

        s += "\tComponentTypeId: " + ComponentTypeId + newline;

        s += "\tAssemblyTypeName: " + AssemblyTypeName + newline;

        s += "\tImplLang: " + ImplLang + newline;

        s += "\tRealTime: " + RealTime + newline;

        s += "\tCode: " + Code + newline;

        s += "\tPath: " + Path + newline;

        s += "\tIsAutostart: " + IsAutostart + newline;

        s += "\tIsDefault: " + IsDefault + newline;

    	// if (IsStandaloneDefined == null)
    	//	s += "\tIsStandaloneDefined: null" + newline;
    	// else

        s += "\tIsStandaloneDefined: " + IsStandaloneDefined + newline;

        s += "\tKeepAliveTime: " + KeepAliveTime + newline;

        s += "\tMinLogLevel: " + MinLogLevel + newline;

        s += "\tMinLogLevelLocal: " + MinLogLevelLocal + newline;

    	// if (XMLDoc == null)
    	//	s += "\tXMLDoc: null" + newline;
    	// else

        s += "\tXMLDoc: " + XMLDoc + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "DefaultComponent" + delimiter;  

        s += DefaultComponentId + delimiter;

        s += ComponentTypeId + delimiter;

        s += AssemblyTypeName + delimiter;

        s += ImplLang + delimiter;

        s += RealTime + delimiter;

        s += Code + delimiter;

        s += Path + delimiter;

        s += IsAutostart + delimiter;

        s += IsDefault + delimiter;

        // if (nullIsStandaloneDefined)
        // 	s += delimiter;
        // else

        	// s += IsStandaloneDefined + delimiter;

        s += KeepAliveTime + delimiter;

        s += MinLogLevel + delimiter;

        s += MinLogLevelLocal + delimiter;

        // if (nullXMLDoc)
        // 	s += delimiter;
        // else

        	// s += XMLDoc + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 14;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#DefaultComponent" + delimiter  

        	+ "DefaultComponentId" + delimiter

        	+ "ComponentTypeId" + delimiter

        	+ "AssemblyTypeName" + delimiter

        	+ "ImplLang" + delimiter

        	+ "RealTime" + delimiter

        	+ "Code" + delimiter

        	+ "Path" + delimiter

        	+ "IsAutostart" + delimiter

        	+ "IsDefault" + delimiter

        	+ "IsStandaloneDefined" + delimiter

        	+ "KeepAliveTime" + delimiter

        	+ "MinLogLevel" + delimiter

        	+ "MinLogLevelLocal" + delimiter

        	+ "XMLDoc" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof DefaultComponent)) return false;
    	DefaultComponent arg = (DefaultComponent) obj;

		if (this.DefaultComponentId != arg.DefaultComponentId)
			return false;

		if (this.ComponentTypeId != arg.ComponentTypeId)
			return false;

		if (this.AssemblyTypeName == null) {	// Two null strings are equal
			if (arg.AssemblyTypeName == null)
				return true;
			else
				return false;
		}
		if (!this.AssemblyTypeName.equals(arg.AssemblyTypeName))
			return false; 

		if (this.ImplLang == null) {	// Two null strings are equal
			if (arg.ImplLang == null)
				return true;
			else
				return false;
		}
		if (!this.ImplLang.equals(arg.ImplLang))
			return false; 

		if (this.RealTime != arg.RealTime)
			return false;

		if (this.Code == null) {	// Two null strings are equal
			if (arg.Code == null)
				return true;
			else
				return false;
		}
		if (!this.Code.equals(arg.Code))
			return false; 

		if (this.Path == null) {	// Two null strings are equal
			if (arg.Path == null)
				return true;
			else
				return false;
		}
		if (!this.Path.equals(arg.Path))
			return false; 

		if (this.IsAutostart != arg.IsAutostart)
			return false;

		if (this.IsDefault != arg.IsDefault)
			return false;

		if (this.IsStandaloneDefined != arg.IsStandaloneDefined)
			return false;

		if (this.KeepAliveTime != arg.KeepAliveTime)
			return false;

		if (this.MinLogLevel != arg.MinLogLevel)
			return false;

		if (this.MinLogLevelLocal != arg.MinLogLevelLocal)
			return false;

		if (this.XMLDoc != arg.XMLDoc)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public DefaultComponentIDL toIDL() {
    	DefaultComponentIDL x = new DefaultComponentIDL ();

		x.DefaultComponentId = this.DefaultComponentId;

		x.ComponentTypeId = this.ComponentTypeId;

		x.AssemblyTypeName = this.AssemblyTypeName;

		x.ImplLang = this.ImplLang;

		x.RealTime = this.RealTime;

		x.Code = this.Code;

		x.Path = this.Path;

		x.IsAutostart = this.IsAutostart;

		x.IsDefault = this.IsDefault;

		x.IsStandaloneDefined = this.IsStandaloneDefined;

        // x.nullIsStandaloneDefined = this.nullIsStandaloneDefined;

		x.KeepAliveTime = this.KeepAliveTime;

		x.MinLogLevel = this.MinLogLevel;

		x.MinLogLevelLocal = this.MinLogLevelLocal;

		x.XMLDoc = this.XMLDoc;

        // x.nullXMLDoc = this.nullXMLDoc;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(DefaultComponentIDL x) {

		this.DefaultComponentId = x.DefaultComponentId;

		this.ComponentTypeId = x.ComponentTypeId;

		this.AssemblyTypeName = x.AssemblyTypeName;

		this.ImplLang = x.ImplLang;

		this.RealTime = x.RealTime;

		this.Code = x.Code;

		this.Path = x.Path;

		this.IsAutostart = x.IsAutostart;

		this.IsDefault = x.IsDefault;

		this.IsStandaloneDefined = x.IsStandaloneDefined;

        // this.nullIsStandaloneDefined = x.nullIsStandaloneDefined;

		this.KeepAliveTime = x.KeepAliveTime;

		this.MinLogLevel = x.MinLogLevel;

		this.MinLogLevelLocal = x.MinLogLevelLocal;

		this.XMLDoc = x.XMLDoc;

        // this.nullXMLDoc = x.nullXMLDoc;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for DefaultComponent.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for DefaultComponentId.
     */
    public int getDefaultComponentId () {
        return DefaultComponentId;
    }

    /**
     * Set DefaultComponentId to the specified value.
     */
    public void setDefaultComponentId(int DefaultComponentId) {

        this.DefaultComponentId = DefaultComponentId;

    }

    /**
     * Get the value for ComponentTypeId.
     */
    public int getComponentTypeId () {
        return ComponentTypeId;
    }

    /**
     * Set ComponentTypeId to the specified value.
     */
    public void setComponentTypeId(int ComponentTypeId) {

        this.ComponentTypeId = ComponentTypeId;

    }

    /**
     * Get the value for AssemblyTypeName.
     */
    public String getAssemblyTypeName () {
        return AssemblyTypeName;
    }

    /**
     * Set AssemblyTypeName to the specified value.
     */
    public void setAssemblyTypeName(String AssemblyTypeName) {

        this.AssemblyTypeName = AssemblyTypeName;

    }

    /**
     * Get the value for ImplLang.
     */
    public String getImplLang () {
        return ImplLang;
    }

    /**
     * Set ImplLang to the specified value.
     */
    public void setImplLang(String ImplLang) {

        this.ImplLang = ImplLang;

    }

    /**
     * Get the value for RealTime.
     */
    public boolean getRealTime () {
        return RealTime;
    }

    /**
     * Set RealTime to the specified value.
     */
    public void setRealTime(boolean RealTime) {

        this.RealTime = RealTime;

    }

    /**
     * Get the value for Code.
     */
    public String getCode () {
        return Code;
    }

    /**
     * Set Code to the specified value.
     */
    public void setCode(String Code) {

        this.Code = Code;

    }

    /**
     * Get the value for Path.
     */
    public String getPath () {
        return Path;
    }

    /**
     * Set Path to the specified value.
     */
    public void setPath(String Path) {

        this.Path = Path;

    }

    /**
     * Get the value for IsAutostart.
     */
    public boolean getIsAutostart () {
        return IsAutostart;
    }

    /**
     * Set IsAutostart to the specified value.
     */
    public void setIsAutostart(boolean IsAutostart) {

        this.IsAutostart = IsAutostart;

    }

    /**
     * Get the value for IsDefault.
     */
    public boolean getIsDefault () {
        return IsDefault;
    }

    /**
     * Set IsDefault to the specified value.
     */
    public void setIsDefault(boolean IsDefault) {

        this.IsDefault = IsDefault;

    }

    /**
     * Get the value for IsStandaloneDefined.
     */
    public Boolean getIsStandaloneDefined () {
        return IsStandaloneDefined;
    }

    /**
     * Set IsStandaloneDefined to the specified value.
     */
    public void setIsStandaloneDefined(Boolean IsStandaloneDefined) {

        // nullIsStandaloneDefined = false;

        this.IsStandaloneDefined = IsStandaloneDefined;

    }

    /*
     * Is the IsStandaloneDefined null?
     */
    // public boolean isIsStandaloneDefinedNull() {
    //	return nullIsStandaloneDefined;
    // }

    /*
     * Set the null indicator for IsStandaloneDefined
     */       
    // public void setIsStandaloneDefinedNull() {
    // 	nullIsStandaloneDefined = true;
    // }

    /**
     * Get the value for KeepAliveTime.
     */
    public int getKeepAliveTime () {
        return KeepAliveTime;
    }

    /**
     * Set KeepAliveTime to the specified value.
     */
    public void setKeepAliveTime(int KeepAliveTime) {

        this.KeepAliveTime = KeepAliveTime;

    }

    /**
     * Get the value for MinLogLevel.
     */
    public int getMinLogLevel () {
        return MinLogLevel;
    }

    /**
     * Set MinLogLevel to the specified value.
     */
    public void setMinLogLevel(int MinLogLevel) {

        this.MinLogLevel = MinLogLevel;

    }

    /**
     * Get the value for MinLogLevelLocal.
     */
    public int getMinLogLevelLocal () {
        return MinLogLevelLocal;
    }

    /**
     * Set MinLogLevelLocal to the specified value.
     */
    public void setMinLogLevelLocal(int MinLogLevelLocal) {

        this.MinLogLevelLocal = MinLogLevelLocal;

    }

    /**
     * Get the value for XMLDoc.
     */
    public String getXMLDoc () {
        return XMLDoc;
    }

    /**
     * Set XMLDoc to the specified value.
     */
    public void setXMLDoc(String XMLDoc) {

        // nullXMLDoc = false;

        this.XMLDoc = XMLDoc;

    }

    /*
     * Is the XMLDoc null?
     */
    // public boolean isXMLDocNull() {
    //	return nullXMLDoc;
    // }

    /*
     * Set the null indicator for XMLDoc
     */       
    // public void setXMLDocNull() {
    // 	nullXMLDoc = true;
    // }

}
