/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File DefaultCanAddress.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.DefaultCanAddressIDL;

/**

 * THIS TABLE IS TEMPORARY. It will be removed when CONTROL modifies the way

 * its devices are getting the CAN address, which currently is exclusively

 * from DAL. This should be modified so the address is retrieved directly from

 * the TMCDB, falling back to DAL only if a TMCDB connection doesn't exist.

 * This table allows to decouple the TMCDB SW Configuration from the

 * HW Configuration, simplifying the interaction of the TMCDB DAL service with

 * CONTROL HW configuration tables (AssemblyStartup, AssemblyRole, etc.)

 * allowing the TMCDB DAL service to get the CAN parameters for CONTROL devices

 * without having to create dummy entries in these tables in order to fullfill

 * the round-trip requirement.

 * While this table exists, the TMCDB DAL service will populate this

 * table from the CDB if the LOAD_FROM_XML option is set; and will use the table

 * to form the alma/CONTROL/<component...>/Address nodes. This address is

 * overriden if a TMCDB_STARTUP_NAME has been set, in which case the Adress will

 * be taken from AssemblyRole. This is the only case where the logic in the

 * TMCDB DAL service needs to deal with the HW Configuration tables.

 * When CONTROL devices are changed as described in the beginning and this

 * table is removed, the TMCDB DAL service doesn't have to deal with the CAN

 * Address anymore.

   * Key: ComponentId

 *
 */
public class DefaultCanAddress implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int ComponentId;

    private String NodeAddress;

    private int ChannelNumber;

    private String BaseAddress;

    // private boolean nullBaseAddress;

    /**
     * Default Constructor for DefaultCanAddress.  Setter methods must be used to insert data.
     */
    public DefaultCanAddress () {

        // nullBaseAddress = true;

    }

    /**
     * Create a DefaultCanAddress by specifiying all data values.
     */
    public DefaultCanAddress (

        int ComponentId,

        String NodeAddress,

        int ChannelNumber,

        String BaseAddress

    ) {

		setComponentId(ComponentId);

		setNodeAddress(NodeAddress);

		setChannelNumber(ChannelNumber);

		setBaseAddress(BaseAddress);

    }

    /**
     * Create a DefaultCanAddress by specifiying data values as an array of strings.
     */
    public DefaultCanAddress (String[] data) {
    	if (data.length != 4)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 4)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComponentId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NodeAddress = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ChannelNumber = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullBaseAddress = true;
			// this.BaseAddress = null;

		} else {

			// nullBaseAddress = false;

			this.BaseAddress = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "DefaultCanAddress:" + newline;

        s += "\tComponentId: " + ComponentId + newline;

        s += "\tNodeAddress: " + NodeAddress + newline;

        s += "\tChannelNumber: " + ChannelNumber + newline;

    	// if (BaseAddress == null)
    	//	s += "\tBaseAddress: null" + newline;
    	// else

        s += "\tBaseAddress: " + BaseAddress + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "DefaultCanAddress" + delimiter;  

        s += ComponentId + delimiter;

        s += NodeAddress + delimiter;

        s += ChannelNumber + delimiter;

        // if (nullBaseAddress)
        // 	s += delimiter;
        // else

        	// s += BaseAddress + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 4;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#DefaultCanAddress" + delimiter  

        	+ "ComponentId" + delimiter

        	+ "NodeAddress" + delimiter

        	+ "ChannelNumber" + delimiter

        	+ "BaseAddress" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof DefaultCanAddress)) return false;
    	DefaultCanAddress arg = (DefaultCanAddress) obj;

		if (this.ComponentId != arg.ComponentId)
			return false;

		if (this.NodeAddress == null) {	// Two null strings are equal
			if (arg.NodeAddress == null)
				return true;
			else
				return false;
		}
		if (!this.NodeAddress.equals(arg.NodeAddress))
			return false; 

		if (this.ChannelNumber != arg.ChannelNumber)
			return false;

		if (this.BaseAddress == null) {	// Two null strings are equal
			if (arg.BaseAddress == null)
				return true;
			else
				return false;
		}
		if (!this.BaseAddress.equals(arg.BaseAddress))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public DefaultCanAddressIDL toIDL() {
    	DefaultCanAddressIDL x = new DefaultCanAddressIDL ();

		x.ComponentId = this.ComponentId;

		x.NodeAddress = this.NodeAddress;

		x.ChannelNumber = this.ChannelNumber;

		x.BaseAddress = this.BaseAddress;

        // x.nullBaseAddress = this.nullBaseAddress;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(DefaultCanAddressIDL x) {

		this.ComponentId = x.ComponentId;

		this.NodeAddress = x.NodeAddress;

		this.ChannelNumber = x.ChannelNumber;

		this.BaseAddress = x.BaseAddress;

        // this.nullBaseAddress = x.nullBaseAddress;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for DefaultCanAddress.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for ComponentId.
     */
    public int getComponentId () {
        return ComponentId;
    }

    /**
     * Set ComponentId to the specified value.
     */
    public void setComponentId(int ComponentId) {

        this.ComponentId = ComponentId;

    }

    /**
     * Get the value for NodeAddress.
     */
    public String getNodeAddress () {
        return NodeAddress;
    }

    /**
     * Set NodeAddress to the specified value.
     */
    public void setNodeAddress(String NodeAddress) {

        this.NodeAddress = NodeAddress;

    }

    /**
     * Get the value for ChannelNumber.
     */
    public int getChannelNumber () {
        return ChannelNumber;
    }

    /**
     * Set ChannelNumber to the specified value.
     */
    public void setChannelNumber(int ChannelNumber) {

        this.ChannelNumber = ChannelNumber;

    }

    /**
     * Get the value for BaseAddress.
     */
    public String getBaseAddress () {
        return BaseAddress;
    }

    /**
     * Set BaseAddress to the specified value.
     */
    public void setBaseAddress(String BaseAddress) {

        // nullBaseAddress = false;

        this.BaseAddress = BaseAddress;

    }

    /*
     * Is the BaseAddress null?
     */
    // public boolean isBaseAddressNull() {
    //	return nullBaseAddress;
    // }

    /*
     * Set the null indicator for BaseAddress
     */       
    // public void setBaseAddressNull() {
    // 	nullBaseAddress = true;
    // }

}
