/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File DefaultBaciProperty.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.DefaultBaciPropertyIDL;

/**

 * For supporting dynamic discovery of device-serial number, next two tables

 * with default information was added

   * Key: DefaultBaciPropId

 *
 */
public class DefaultBaciProperty implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int DefaultBaciPropId;

    private int DefaultComponentId;

    private String PropertyName;

    private String description;

    private String format;

    private String units;

    private String resolution;

    private int archive_priority;

    private double archive_min_int;

    private double archive_max_int;

    private double default_timer_trig;

    private double min_timer_trig;

    private boolean initialize_devio;

    private Double min_delta_trig;

    // private boolean nullmin_delta_trig;

    private String default_value;

    private Double graph_min;

    // private boolean nullgraph_min;

    private Double graph_max;

    // private boolean nullgraph_max;

    private Double min_step;

    // private boolean nullmin_step;

    private double archive_delta;

    private Double alarm_high_on;

    // private boolean nullalarm_high_on;

    private Double alarm_low_on;

    // private boolean nullalarm_low_on;

    private Double alarm_high_off;

    // private boolean nullalarm_high_off;

    private Double alarm_low_off;

    // private boolean nullalarm_low_off;

    private Double alarm_timer_trig;

    // private boolean nullalarm_timer_trig;

    private Double min_value;

    // private boolean nullmin_value;

    private Double max_value;

    // private boolean nullmax_value;

    private String bitDescription;

    // private boolean nullbitDescription;

    private String whenSet;

    // private boolean nullwhenSet;

    private String whenCleared;

    // private boolean nullwhenCleared;

    private String statesDescription;

    // private boolean nullstatesDescription;

    private String condition;

    // private boolean nullcondition;

    private String alarm_on;

    // private boolean nullalarm_on;

    private String alarm_off;

    // private boolean nullalarm_off;

    private String Data;

    // private boolean nullData;

    /**
     * Default Constructor for DefaultBaciProperty.  Setter methods must be used to insert data.
     */
    public DefaultBaciProperty () {

        // nullmin_delta_trig = true;

        // nullgraph_min = true;

        // nullgraph_max = true;

        // nullmin_step = true;

        // nullalarm_high_on = true;

        // nullalarm_low_on = true;

        // nullalarm_high_off = true;

        // nullalarm_low_off = true;

        // nullalarm_timer_trig = true;

        // nullmin_value = true;

        // nullmax_value = true;

        // nullbitDescription = true;

        // nullwhenSet = true;

        // nullwhenCleared = true;

        // nullstatesDescription = true;

        // nullcondition = true;

        // nullalarm_on = true;

        // nullalarm_off = true;

        // nullData = true;

    }

    /**
     * Create a DefaultBaciProperty by specifiying all data values.
     */
    public DefaultBaciProperty (

        int DefaultBaciPropId,

        int DefaultComponentId,

        String PropertyName,

        String description,

        String format,

        String units,

        String resolution,

        int archive_priority,

        double archive_min_int,

        double archive_max_int,

        double default_timer_trig,

        double min_timer_trig,

        boolean initialize_devio,

        Double min_delta_trig,

        String default_value,

        Double graph_min,

        Double graph_max,

        Double min_step,

        double archive_delta,

        Double alarm_high_on,

        Double alarm_low_on,

        Double alarm_high_off,

        Double alarm_low_off,

        Double alarm_timer_trig,

        Double min_value,

        Double max_value,

        String bitDescription,

        String whenSet,

        String whenCleared,

        String statesDescription,

        String condition,

        String alarm_on,

        String alarm_off,

        String Data

    ) {

		setDefaultBaciPropId(DefaultBaciPropId);

		setDefaultComponentId(DefaultComponentId);

		setPropertyName(PropertyName);

		setdescription(description);

		setformat(format);

		setunits(units);

		setresolution(resolution);

		setarchive_priority(archive_priority);

		setarchive_min_int(archive_min_int);

		setarchive_max_int(archive_max_int);

		setdefault_timer_trig(default_timer_trig);

		setmin_timer_trig(min_timer_trig);

		setinitialize_devio(initialize_devio);

		setmin_delta_trig(min_delta_trig);

		setdefault_value(default_value);

		setgraph_min(graph_min);

		setgraph_max(graph_max);

		setmin_step(min_step);

		setarchive_delta(archive_delta);

		setalarm_high_on(alarm_high_on);

		setalarm_low_on(alarm_low_on);

		setalarm_high_off(alarm_high_off);

		setalarm_low_off(alarm_low_off);

		setalarm_timer_trig(alarm_timer_trig);

		setmin_value(min_value);

		setmax_value(max_value);

		setbitDescription(bitDescription);

		setwhenSet(whenSet);

		setwhenCleared(whenCleared);

		setstatesDescription(statesDescription);

		setcondition(condition);

		setalarm_on(alarm_on);

		setalarm_off(alarm_off);

		setData(Data);

    }

    /**
     * Create a DefaultBaciProperty by specifiying data values as an array of strings.
     */
    public DefaultBaciProperty (String[] data) {
    	if (data.length != 34)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 34)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DefaultBaciPropId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DefaultComponentId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.PropertyName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.description = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.format = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.units = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.resolution = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.archive_priority = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.archive_min_int = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.archive_max_int = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.default_timer_trig = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.min_timer_trig = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.initialize_devio = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullmin_delta_trig = true;
			// this.min_delta_trig = null;

		} else {

			// nullmin_delta_trig = false;

			this.min_delta_trig = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.default_value = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullgraph_min = true;
			// this.graph_min = null;

		} else {

			// nullgraph_min = false;

			this.graph_min = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullgraph_max = true;
			// this.graph_max = null;

		} else {

			// nullgraph_max = false;

			this.graph_max = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullmin_step = true;
			// this.min_step = null;

		} else {

			// nullmin_step = false;

			this.min_step = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.archive_delta = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullalarm_high_on = true;
			// this.alarm_high_on = null;

		} else {

			// nullalarm_high_on = false;

			this.alarm_high_on = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullalarm_low_on = true;
			// this.alarm_low_on = null;

		} else {

			// nullalarm_low_on = false;

			this.alarm_low_on = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullalarm_high_off = true;
			// this.alarm_high_off = null;

		} else {

			// nullalarm_high_off = false;

			this.alarm_high_off = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullalarm_low_off = true;
			// this.alarm_low_off = null;

		} else {

			// nullalarm_low_off = false;

			this.alarm_low_off = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullalarm_timer_trig = true;
			// this.alarm_timer_trig = null;

		} else {

			// nullalarm_timer_trig = false;

			this.alarm_timer_trig = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullmin_value = true;
			// this.min_value = null;

		} else {

			// nullmin_value = false;

			this.min_value = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullmax_value = true;
			// this.max_value = null;

		} else {

			// nullmax_value = false;

			this.max_value = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullbitDescription = true;
			// this.bitDescription = null;

		} else {

			// nullbitDescription = false;

			this.bitDescription = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullwhenSet = true;
			// this.whenSet = null;

		} else {

			// nullwhenSet = false;

			this.whenSet = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullwhenCleared = true;
			// this.whenCleared = null;

		} else {

			// nullwhenCleared = false;

			this.whenCleared = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullstatesDescription = true;
			// this.statesDescription = null;

		} else {

			// nullstatesDescription = false;

			this.statesDescription = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullcondition = true;
			// this.condition = null;

		} else {

			// nullcondition = false;

			this.condition = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullalarm_on = true;
			// this.alarm_on = null;

		} else {

			// nullalarm_on = false;

			this.alarm_on = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullalarm_off = true;
			// this.alarm_off = null;

		} else {

			// nullalarm_off = false;

			this.alarm_off = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullData = true;
			// this.Data = null;

		} else {

			// nullData = false;

			this.Data = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "DefaultBaciProperty:" + newline;

        s += "\tDefaultBaciPropId: " + DefaultBaciPropId + newline;

        s += "\tDefaultComponentId: " + DefaultComponentId + newline;

        s += "\tPropertyName: " + PropertyName + newline;

        s += "\tdescription: " + description + newline;

        s += "\tformat: " + format + newline;

        s += "\tunits: " + units + newline;

        s += "\tresolution: " + resolution + newline;

        s += "\tarchive_priority: " + archive_priority + newline;

        s += "\tarchive_min_int: " + archive_min_int + newline;

        s += "\tarchive_max_int: " + archive_max_int + newline;

        s += "\tdefault_timer_trig: " + default_timer_trig + newline;

        s += "\tmin_timer_trig: " + min_timer_trig + newline;

        s += "\tinitialize_devio: " + initialize_devio + newline;

    	// if (min_delta_trig == null)
    	//	s += "\tmin_delta_trig: null" + newline;
    	// else

        s += "\tmin_delta_trig: " + min_delta_trig + newline;

        s += "\tdefault_value: " + default_value + newline;

    	// if (graph_min == null)
    	//	s += "\tgraph_min: null" + newline;
    	// else

        s += "\tgraph_min: " + graph_min + newline;

    	// if (graph_max == null)
    	//	s += "\tgraph_max: null" + newline;
    	// else

        s += "\tgraph_max: " + graph_max + newline;

    	// if (min_step == null)
    	//	s += "\tmin_step: null" + newline;
    	// else

        s += "\tmin_step: " + min_step + newline;

        s += "\tarchive_delta: " + archive_delta + newline;

    	// if (alarm_high_on == null)
    	//	s += "\talarm_high_on: null" + newline;
    	// else

        s += "\talarm_high_on: " + alarm_high_on + newline;

    	// if (alarm_low_on == null)
    	//	s += "\talarm_low_on: null" + newline;
    	// else

        s += "\talarm_low_on: " + alarm_low_on + newline;

    	// if (alarm_high_off == null)
    	//	s += "\talarm_high_off: null" + newline;
    	// else

        s += "\talarm_high_off: " + alarm_high_off + newline;

    	// if (alarm_low_off == null)
    	//	s += "\talarm_low_off: null" + newline;
    	// else

        s += "\talarm_low_off: " + alarm_low_off + newline;

    	// if (alarm_timer_trig == null)
    	//	s += "\talarm_timer_trig: null" + newline;
    	// else

        s += "\talarm_timer_trig: " + alarm_timer_trig + newline;

    	// if (min_value == null)
    	//	s += "\tmin_value: null" + newline;
    	// else

        s += "\tmin_value: " + min_value + newline;

    	// if (max_value == null)
    	//	s += "\tmax_value: null" + newline;
    	// else

        s += "\tmax_value: " + max_value + newline;

    	// if (bitDescription == null)
    	//	s += "\tbitDescription: null" + newline;
    	// else

        s += "\tbitDescription: " + bitDescription + newline;

    	// if (whenSet == null)
    	//	s += "\twhenSet: null" + newline;
    	// else

        s += "\twhenSet: " + whenSet + newline;

    	// if (whenCleared == null)
    	//	s += "\twhenCleared: null" + newline;
    	// else

        s += "\twhenCleared: " + whenCleared + newline;

    	// if (statesDescription == null)
    	//	s += "\tstatesDescription: null" + newline;
    	// else

        s += "\tstatesDescription: " + statesDescription + newline;

    	// if (condition == null)
    	//	s += "\tcondition: null" + newline;
    	// else

        s += "\tcondition: " + condition + newline;

    	// if (alarm_on == null)
    	//	s += "\talarm_on: null" + newline;
    	// else

        s += "\talarm_on: " + alarm_on + newline;

    	// if (alarm_off == null)
    	//	s += "\talarm_off: null" + newline;
    	// else

        s += "\talarm_off: " + alarm_off + newline;

    	// if (Data == null)
    	//	s += "\tData: null" + newline;
    	// else

        s += "\tData: " + Data + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "DefaultBaciProperty" + delimiter;  

        s += DefaultBaciPropId + delimiter;

        s += DefaultComponentId + delimiter;

        s += PropertyName + delimiter;

        s += description + delimiter;

        s += format + delimiter;

        s += units + delimiter;

        s += resolution + delimiter;

        s += archive_priority + delimiter;

        s += archive_min_int + delimiter;

        s += archive_max_int + delimiter;

        s += default_timer_trig + delimiter;

        s += min_timer_trig + delimiter;

        s += initialize_devio + delimiter;

        // if (nullmin_delta_trig)
        // 	s += delimiter;
        // else

        	// s += min_delta_trig + delimiter;

        s += default_value + delimiter;

        // if (nullgraph_min)
        // 	s += delimiter;
        // else

        	// s += graph_min + delimiter;

        // if (nullgraph_max)
        // 	s += delimiter;
        // else

        	// s += graph_max + delimiter;

        // if (nullmin_step)
        // 	s += delimiter;
        // else

        	// s += min_step + delimiter;

        s += archive_delta + delimiter;

        // if (nullalarm_high_on)
        // 	s += delimiter;
        // else

        	// s += alarm_high_on + delimiter;

        // if (nullalarm_low_on)
        // 	s += delimiter;
        // else

        	// s += alarm_low_on + delimiter;

        // if (nullalarm_high_off)
        // 	s += delimiter;
        // else

        	// s += alarm_high_off + delimiter;

        // if (nullalarm_low_off)
        // 	s += delimiter;
        // else

        	// s += alarm_low_off + delimiter;

        // if (nullalarm_timer_trig)
        // 	s += delimiter;
        // else

        	// s += alarm_timer_trig + delimiter;

        // if (nullmin_value)
        // 	s += delimiter;
        // else

        	// s += min_value + delimiter;

        // if (nullmax_value)
        // 	s += delimiter;
        // else

        	// s += max_value + delimiter;

        // if (nullbitDescription)
        // 	s += delimiter;
        // else

        	// s += bitDescription + delimiter;

        // if (nullwhenSet)
        // 	s += delimiter;
        // else

        	// s += whenSet + delimiter;

        // if (nullwhenCleared)
        // 	s += delimiter;
        // else

        	// s += whenCleared + delimiter;

        // if (nullstatesDescription)
        // 	s += delimiter;
        // else

        	// s += statesDescription + delimiter;

        // if (nullcondition)
        // 	s += delimiter;
        // else

        	// s += condition + delimiter;

        // if (nullalarm_on)
        // 	s += delimiter;
        // else

        	// s += alarm_on + delimiter;

        // if (nullalarm_off)
        // 	s += delimiter;
        // else

        	// s += alarm_off + delimiter;

        // if (nullData)
        // 	s += delimiter;
        // else

        	// s += Data + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 34;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#DefaultBaciProperty" + delimiter  

        	+ "DefaultBaciPropId" + delimiter

        	+ "DefaultComponentId" + delimiter

        	+ "PropertyName" + delimiter

        	+ "description" + delimiter

        	+ "format" + delimiter

        	+ "units" + delimiter

        	+ "resolution" + delimiter

        	+ "archive_priority" + delimiter

        	+ "archive_min_int" + delimiter

        	+ "archive_max_int" + delimiter

        	+ "default_timer_trig" + delimiter

        	+ "min_timer_trig" + delimiter

        	+ "initialize_devio" + delimiter

        	+ "min_delta_trig" + delimiter

        	+ "default_value" + delimiter

        	+ "graph_min" + delimiter

        	+ "graph_max" + delimiter

        	+ "min_step" + delimiter

        	+ "archive_delta" + delimiter

        	+ "alarm_high_on" + delimiter

        	+ "alarm_low_on" + delimiter

        	+ "alarm_high_off" + delimiter

        	+ "alarm_low_off" + delimiter

        	+ "alarm_timer_trig" + delimiter

        	+ "min_value" + delimiter

        	+ "max_value" + delimiter

        	+ "bitDescription" + delimiter

        	+ "whenSet" + delimiter

        	+ "whenCleared" + delimiter

        	+ "statesDescription" + delimiter

        	+ "condition" + delimiter

        	+ "alarm_on" + delimiter

        	+ "alarm_off" + delimiter

        	+ "Data" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof DefaultBaciProperty)) return false;
    	DefaultBaciProperty arg = (DefaultBaciProperty) obj;

		if (this.DefaultBaciPropId != arg.DefaultBaciPropId)
			return false;

		if (this.DefaultComponentId != arg.DefaultComponentId)
			return false;

		if (this.PropertyName == null) {	// Two null strings are equal
			if (arg.PropertyName == null)
				return true;
			else
				return false;
		}
		if (!this.PropertyName.equals(arg.PropertyName))
			return false; 

		if (this.description == null) {	// Two null strings are equal
			if (arg.description == null)
				return true;
			else
				return false;
		}
		if (!this.description.equals(arg.description))
			return false; 

		if (this.format == null) {	// Two null strings are equal
			if (arg.format == null)
				return true;
			else
				return false;
		}
		if (!this.format.equals(arg.format))
			return false; 

		if (this.units == null) {	// Two null strings are equal
			if (arg.units == null)
				return true;
			else
				return false;
		}
		if (!this.units.equals(arg.units))
			return false; 

		if (this.resolution == null) {	// Two null strings are equal
			if (arg.resolution == null)
				return true;
			else
				return false;
		}
		if (!this.resolution.equals(arg.resolution))
			return false; 

		if (this.archive_priority != arg.archive_priority)
			return false;

		if (this.archive_min_int != arg.archive_min_int)
			return false;

		if (this.archive_max_int != arg.archive_max_int)
			return false;

		if (this.default_timer_trig != arg.default_timer_trig)
			return false;

		if (this.min_timer_trig != arg.min_timer_trig)
			return false;

		if (this.initialize_devio != arg.initialize_devio)
			return false;

		if (this.min_delta_trig != arg.min_delta_trig)
			return false;

		if (this.default_value == null) {	// Two null strings are equal
			if (arg.default_value == null)
				return true;
			else
				return false;
		}
		if (!this.default_value.equals(arg.default_value))
			return false; 

		if (this.graph_min != arg.graph_min)
			return false;

		if (this.graph_max != arg.graph_max)
			return false;

		if (this.min_step != arg.min_step)
			return false;

		if (this.archive_delta != arg.archive_delta)
			return false;

		if (this.alarm_high_on != arg.alarm_high_on)
			return false;

		if (this.alarm_low_on != arg.alarm_low_on)
			return false;

		if (this.alarm_high_off != arg.alarm_high_off)
			return false;

		if (this.alarm_low_off != arg.alarm_low_off)
			return false;

		if (this.alarm_timer_trig != arg.alarm_timer_trig)
			return false;

		if (this.min_value != arg.min_value)
			return false;

		if (this.max_value != arg.max_value)
			return false;

		if (this.bitDescription == null) {	// Two null strings are equal
			if (arg.bitDescription == null)
				return true;
			else
				return false;
		}
		if (!this.bitDescription.equals(arg.bitDescription))
			return false; 

		if (this.whenSet == null) {	// Two null strings are equal
			if (arg.whenSet == null)
				return true;
			else
				return false;
		}
		if (!this.whenSet.equals(arg.whenSet))
			return false; 

		if (this.whenCleared == null) {	// Two null strings are equal
			if (arg.whenCleared == null)
				return true;
			else
				return false;
		}
		if (!this.whenCleared.equals(arg.whenCleared))
			return false; 

		if (this.statesDescription == null) {	// Two null strings are equal
			if (arg.statesDescription == null)
				return true;
			else
				return false;
		}
		if (!this.statesDescription.equals(arg.statesDescription))
			return false; 

		if (this.condition == null) {	// Two null strings are equal
			if (arg.condition == null)
				return true;
			else
				return false;
		}
		if (!this.condition.equals(arg.condition))
			return false; 

		if (this.alarm_on == null) {	// Two null strings are equal
			if (arg.alarm_on == null)
				return true;
			else
				return false;
		}
		if (!this.alarm_on.equals(arg.alarm_on))
			return false; 

		if (this.alarm_off == null) {	// Two null strings are equal
			if (arg.alarm_off == null)
				return true;
			else
				return false;
		}
		if (!this.alarm_off.equals(arg.alarm_off))
			return false; 

		if (this.Data == null) {	// Two null strings are equal
			if (arg.Data == null)
				return true;
			else
				return false;
		}
		if (!this.Data.equals(arg.Data))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public DefaultBaciPropertyIDL toIDL() {
    	DefaultBaciPropertyIDL x = new DefaultBaciPropertyIDL ();

		x.DefaultBaciPropId = this.DefaultBaciPropId;

		x.DefaultComponentId = this.DefaultComponentId;

		x.PropertyName = this.PropertyName;

		x.description = this.description;

		x.format = this.format;

		x.units = this.units;

		x.resolution = this.resolution;

		x.archive_priority = this.archive_priority;

		x.archive_min_int = this.archive_min_int;

		x.archive_max_int = this.archive_max_int;

		x.default_timer_trig = this.default_timer_trig;

		x.min_timer_trig = this.min_timer_trig;

		x.initialize_devio = this.initialize_devio;

		x.min_delta_trig = this.min_delta_trig;

        // x.nullmin_delta_trig = this.nullmin_delta_trig;

		x.default_value = this.default_value;

		x.graph_min = this.graph_min;

        // x.nullgraph_min = this.nullgraph_min;

		x.graph_max = this.graph_max;

        // x.nullgraph_max = this.nullgraph_max;

		x.min_step = this.min_step;

        // x.nullmin_step = this.nullmin_step;

		x.archive_delta = this.archive_delta;

		x.alarm_high_on = this.alarm_high_on;

        // x.nullalarm_high_on = this.nullalarm_high_on;

		x.alarm_low_on = this.alarm_low_on;

        // x.nullalarm_low_on = this.nullalarm_low_on;

		x.alarm_high_off = this.alarm_high_off;

        // x.nullalarm_high_off = this.nullalarm_high_off;

		x.alarm_low_off = this.alarm_low_off;

        // x.nullalarm_low_off = this.nullalarm_low_off;

		x.alarm_timer_trig = this.alarm_timer_trig;

        // x.nullalarm_timer_trig = this.nullalarm_timer_trig;

		x.min_value = this.min_value;

        // x.nullmin_value = this.nullmin_value;

		x.max_value = this.max_value;

        // x.nullmax_value = this.nullmax_value;

		x.bitDescription = this.bitDescription;

        // x.nullbitDescription = this.nullbitDescription;

		x.whenSet = this.whenSet;

        // x.nullwhenSet = this.nullwhenSet;

		x.whenCleared = this.whenCleared;

        // x.nullwhenCleared = this.nullwhenCleared;

		x.statesDescription = this.statesDescription;

        // x.nullstatesDescription = this.nullstatesDescription;

		x.condition = this.condition;

        // x.nullcondition = this.nullcondition;

		x.alarm_on = this.alarm_on;

        // x.nullalarm_on = this.nullalarm_on;

		x.alarm_off = this.alarm_off;

        // x.nullalarm_off = this.nullalarm_off;

		x.Data = this.Data;

        // x.nullData = this.nullData;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(DefaultBaciPropertyIDL x) {

		this.DefaultBaciPropId = x.DefaultBaciPropId;

		this.DefaultComponentId = x.DefaultComponentId;

		this.PropertyName = x.PropertyName;

		this.description = x.description;

		this.format = x.format;

		this.units = x.units;

		this.resolution = x.resolution;

		this.archive_priority = x.archive_priority;

		this.archive_min_int = x.archive_min_int;

		this.archive_max_int = x.archive_max_int;

		this.default_timer_trig = x.default_timer_trig;

		this.min_timer_trig = x.min_timer_trig;

		this.initialize_devio = x.initialize_devio;

		this.min_delta_trig = x.min_delta_trig;

        // this.nullmin_delta_trig = x.nullmin_delta_trig;

		this.default_value = x.default_value;

		this.graph_min = x.graph_min;

        // this.nullgraph_min = x.nullgraph_min;

		this.graph_max = x.graph_max;

        // this.nullgraph_max = x.nullgraph_max;

		this.min_step = x.min_step;

        // this.nullmin_step = x.nullmin_step;

		this.archive_delta = x.archive_delta;

		this.alarm_high_on = x.alarm_high_on;

        // this.nullalarm_high_on = x.nullalarm_high_on;

		this.alarm_low_on = x.alarm_low_on;

        // this.nullalarm_low_on = x.nullalarm_low_on;

		this.alarm_high_off = x.alarm_high_off;

        // this.nullalarm_high_off = x.nullalarm_high_off;

		this.alarm_low_off = x.alarm_low_off;

        // this.nullalarm_low_off = x.nullalarm_low_off;

		this.alarm_timer_trig = x.alarm_timer_trig;

        // this.nullalarm_timer_trig = x.nullalarm_timer_trig;

		this.min_value = x.min_value;

        // this.nullmin_value = x.nullmin_value;

		this.max_value = x.max_value;

        // this.nullmax_value = x.nullmax_value;

		this.bitDescription = x.bitDescription;

        // this.nullbitDescription = x.nullbitDescription;

		this.whenSet = x.whenSet;

        // this.nullwhenSet = x.nullwhenSet;

		this.whenCleared = x.whenCleared;

        // this.nullwhenCleared = x.nullwhenCleared;

		this.statesDescription = x.statesDescription;

        // this.nullstatesDescription = x.nullstatesDescription;

		this.condition = x.condition;

        // this.nullcondition = x.nullcondition;

		this.alarm_on = x.alarm_on;

        // this.nullalarm_on = x.nullalarm_on;

		this.alarm_off = x.alarm_off;

        // this.nullalarm_off = x.nullalarm_off;

		this.Data = x.Data;

        // this.nullData = x.nullData;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for DefaultBaciProperty.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for DefaultBaciPropId.
     */
    public int getDefaultBaciPropId () {
        return DefaultBaciPropId;
    }

    /**
     * Set DefaultBaciPropId to the specified value.
     */
    public void setDefaultBaciPropId(int DefaultBaciPropId) {

        this.DefaultBaciPropId = DefaultBaciPropId;

    }

    /**
     * Get the value for DefaultComponentId.
     */
    public int getDefaultComponentId () {
        return DefaultComponentId;
    }

    /**
     * Set DefaultComponentId to the specified value.
     */
    public void setDefaultComponentId(int DefaultComponentId) {

        this.DefaultComponentId = DefaultComponentId;

    }

    /**
     * Get the value for PropertyName.
     */
    public String getPropertyName () {
        return PropertyName;
    }

    /**
     * Set PropertyName to the specified value.
     */
    public void setPropertyName(String PropertyName) {

        this.PropertyName = PropertyName;

    }

    /**
     * Get the value for description.
     */
    public String getdescription () {
        return description;
    }

    /**
     * Set description to the specified value.
     */
    public void setdescription(String description) {

        this.description = description;

    }

    /**
     * Get the value for format.
     */
    public String getformat () {
        return format;
    }

    /**
     * Set format to the specified value.
     */
    public void setformat(String format) {

        this.format = format;

    }

    /**
     * Get the value for units.
     */
    public String getunits () {
        return units;
    }

    /**
     * Set units to the specified value.
     */
    public void setunits(String units) {

        this.units = units;

    }

    /**
     * Get the value for resolution.
     */
    public String getresolution () {
        return resolution;
    }

    /**
     * Set resolution to the specified value.
     */
    public void setresolution(String resolution) {

        this.resolution = resolution;

    }

    /**
     * Get the value for archive_priority.
     */
    public int getarchive_priority () {
        return archive_priority;
    }

    /**
     * Set archive_priority to the specified value.
     */
    public void setarchive_priority(int archive_priority) {

        this.archive_priority = archive_priority;

    }

    /**
     * Get the value for archive_min_int.
     */
    public double getarchive_min_int () {
        return archive_min_int;
    }

    /**
     * Set archive_min_int to the specified value.
     */
    public void setarchive_min_int(double archive_min_int) {

        this.archive_min_int = archive_min_int;

    }

    /**
     * Get the value for archive_max_int.
     */
    public double getarchive_max_int () {
        return archive_max_int;
    }

    /**
     * Set archive_max_int to the specified value.
     */
    public void setarchive_max_int(double archive_max_int) {

        this.archive_max_int = archive_max_int;

    }

    /**
     * Get the value for default_timer_trig.
     */
    public double getdefault_timer_trig () {
        return default_timer_trig;
    }

    /**
     * Set default_timer_trig to the specified value.
     */
    public void setdefault_timer_trig(double default_timer_trig) {

        this.default_timer_trig = default_timer_trig;

    }

    /**
     * Get the value for min_timer_trig.
     */
    public double getmin_timer_trig () {
        return min_timer_trig;
    }

    /**
     * Set min_timer_trig to the specified value.
     */
    public void setmin_timer_trig(double min_timer_trig) {

        this.min_timer_trig = min_timer_trig;

    }

    /**
     * Get the value for initialize_devio.
     */
    public boolean getinitialize_devio () {
        return initialize_devio;
    }

    /**
     * Set initialize_devio to the specified value.
     */
    public void setinitialize_devio(boolean initialize_devio) {

        this.initialize_devio = initialize_devio;

    }

    /**
     * Get the value for min_delta_trig.
     */
    public Double getmin_delta_trig () {
        return min_delta_trig;
    }

    /**
     * Set min_delta_trig to the specified value.
     */
    public void setmin_delta_trig(Double min_delta_trig) {

        // nullmin_delta_trig = false;

        this.min_delta_trig = min_delta_trig;

    }

    /*
     * Is the min_delta_trig null?
     */
    // public boolean ismin_delta_trigNull() {
    //	return nullmin_delta_trig;
    // }

    /*
     * Set the null indicator for min_delta_trig
     */       
    // public void setmin_delta_trigNull() {
    // 	nullmin_delta_trig = true;
    // }

    /**
     * Get the value for default_value.
     */
    public String getdefault_value () {
        return default_value;
    }

    /**
     * Set default_value to the specified value.
     */
    public void setdefault_value(String default_value) {

        this.default_value = default_value;

    }

    /**
     * Get the value for graph_min.
     */
    public Double getgraph_min () {
        return graph_min;
    }

    /**
     * Set graph_min to the specified value.
     */
    public void setgraph_min(Double graph_min) {

        // nullgraph_min = false;

        this.graph_min = graph_min;

    }

    /*
     * Is the graph_min null?
     */
    // public boolean isgraph_minNull() {
    //	return nullgraph_min;
    // }

    /*
     * Set the null indicator for graph_min
     */       
    // public void setgraph_minNull() {
    // 	nullgraph_min = true;
    // }

    /**
     * Get the value for graph_max.
     */
    public Double getgraph_max () {
        return graph_max;
    }

    /**
     * Set graph_max to the specified value.
     */
    public void setgraph_max(Double graph_max) {

        // nullgraph_max = false;

        this.graph_max = graph_max;

    }

    /*
     * Is the graph_max null?
     */
    // public boolean isgraph_maxNull() {
    //	return nullgraph_max;
    // }

    /*
     * Set the null indicator for graph_max
     */       
    // public void setgraph_maxNull() {
    // 	nullgraph_max = true;
    // }

    /**
     * Get the value for min_step.
     */
    public Double getmin_step () {
        return min_step;
    }

    /**
     * Set min_step to the specified value.
     */
    public void setmin_step(Double min_step) {

        // nullmin_step = false;

        this.min_step = min_step;

    }

    /*
     * Is the min_step null?
     */
    // public boolean ismin_stepNull() {
    //	return nullmin_step;
    // }

    /*
     * Set the null indicator for min_step
     */       
    // public void setmin_stepNull() {
    // 	nullmin_step = true;
    // }

    /**
     * Get the value for archive_delta.
     */
    public double getarchive_delta () {
        return archive_delta;
    }

    /**
     * Set archive_delta to the specified value.
     */
    public void setarchive_delta(double archive_delta) {

        this.archive_delta = archive_delta;

    }

    /**
     * Get the value for alarm_high_on.
     */
    public Double getalarm_high_on () {
        return alarm_high_on;
    }

    /**
     * Set alarm_high_on to the specified value.
     */
    public void setalarm_high_on(Double alarm_high_on) {

        // nullalarm_high_on = false;

        this.alarm_high_on = alarm_high_on;

    }

    /*
     * Is the alarm_high_on null?
     */
    // public boolean isalarm_high_onNull() {
    //	return nullalarm_high_on;
    // }

    /*
     * Set the null indicator for alarm_high_on
     */       
    // public void setalarm_high_onNull() {
    // 	nullalarm_high_on = true;
    // }

    /**
     * Get the value for alarm_low_on.
     */
    public Double getalarm_low_on () {
        return alarm_low_on;
    }

    /**
     * Set alarm_low_on to the specified value.
     */
    public void setalarm_low_on(Double alarm_low_on) {

        // nullalarm_low_on = false;

        this.alarm_low_on = alarm_low_on;

    }

    /*
     * Is the alarm_low_on null?
     */
    // public boolean isalarm_low_onNull() {
    //	return nullalarm_low_on;
    // }

    /*
     * Set the null indicator for alarm_low_on
     */       
    // public void setalarm_low_onNull() {
    // 	nullalarm_low_on = true;
    // }

    /**
     * Get the value for alarm_high_off.
     */
    public Double getalarm_high_off () {
        return alarm_high_off;
    }

    /**
     * Set alarm_high_off to the specified value.
     */
    public void setalarm_high_off(Double alarm_high_off) {

        // nullalarm_high_off = false;

        this.alarm_high_off = alarm_high_off;

    }

    /*
     * Is the alarm_high_off null?
     */
    // public boolean isalarm_high_offNull() {
    //	return nullalarm_high_off;
    // }

    /*
     * Set the null indicator for alarm_high_off
     */       
    // public void setalarm_high_offNull() {
    // 	nullalarm_high_off = true;
    // }

    /**
     * Get the value for alarm_low_off.
     */
    public Double getalarm_low_off () {
        return alarm_low_off;
    }

    /**
     * Set alarm_low_off to the specified value.
     */
    public void setalarm_low_off(Double alarm_low_off) {

        // nullalarm_low_off = false;

        this.alarm_low_off = alarm_low_off;

    }

    /*
     * Is the alarm_low_off null?
     */
    // public boolean isalarm_low_offNull() {
    //	return nullalarm_low_off;
    // }

    /*
     * Set the null indicator for alarm_low_off
     */       
    // public void setalarm_low_offNull() {
    // 	nullalarm_low_off = true;
    // }

    /**
     * Get the value for alarm_timer_trig.
     */
    public Double getalarm_timer_trig () {
        return alarm_timer_trig;
    }

    /**
     * Set alarm_timer_trig to the specified value.
     */
    public void setalarm_timer_trig(Double alarm_timer_trig) {

        // nullalarm_timer_trig = false;

        this.alarm_timer_trig = alarm_timer_trig;

    }

    /*
     * Is the alarm_timer_trig null?
     */
    // public boolean isalarm_timer_trigNull() {
    //	return nullalarm_timer_trig;
    // }

    /*
     * Set the null indicator for alarm_timer_trig
     */       
    // public void setalarm_timer_trigNull() {
    // 	nullalarm_timer_trig = true;
    // }

    /**
     * Get the value for min_value.
     */
    public Double getmin_value () {
        return min_value;
    }

    /**
     * Set min_value to the specified value.
     */
    public void setmin_value(Double min_value) {

        // nullmin_value = false;

        this.min_value = min_value;

    }

    /*
     * Is the min_value null?
     */
    // public boolean ismin_valueNull() {
    //	return nullmin_value;
    // }

    /*
     * Set the null indicator for min_value
     */       
    // public void setmin_valueNull() {
    // 	nullmin_value = true;
    // }

    /**
     * Get the value for max_value.
     */
    public Double getmax_value () {
        return max_value;
    }

    /**
     * Set max_value to the specified value.
     */
    public void setmax_value(Double max_value) {

        // nullmax_value = false;

        this.max_value = max_value;

    }

    /*
     * Is the max_value null?
     */
    // public boolean ismax_valueNull() {
    //	return nullmax_value;
    // }

    /*
     * Set the null indicator for max_value
     */       
    // public void setmax_valueNull() {
    // 	nullmax_value = true;
    // }

    /**
     * Get the value for bitDescription.
     */
    public String getbitDescription () {
        return bitDescription;
    }

    /**
     * Set bitDescription to the specified value.
     */
    public void setbitDescription(String bitDescription) {

        // nullbitDescription = false;

        this.bitDescription = bitDescription;

    }

    /*
     * Is the bitDescription null?
     */
    // public boolean isbitDescriptionNull() {
    //	return nullbitDescription;
    // }

    /*
     * Set the null indicator for bitDescription
     */       
    // public void setbitDescriptionNull() {
    // 	nullbitDescription = true;
    // }

    /**
     * Get the value for whenSet.
     */
    public String getwhenSet () {
        return whenSet;
    }

    /**
     * Set whenSet to the specified value.
     */
    public void setwhenSet(String whenSet) {

        // nullwhenSet = false;

        this.whenSet = whenSet;

    }

    /*
     * Is the whenSet null?
     */
    // public boolean iswhenSetNull() {
    //	return nullwhenSet;
    // }

    /*
     * Set the null indicator for whenSet
     */       
    // public void setwhenSetNull() {
    // 	nullwhenSet = true;
    // }

    /**
     * Get the value for whenCleared.
     */
    public String getwhenCleared () {
        return whenCleared;
    }

    /**
     * Set whenCleared to the specified value.
     */
    public void setwhenCleared(String whenCleared) {

        // nullwhenCleared = false;

        this.whenCleared = whenCleared;

    }

    /*
     * Is the whenCleared null?
     */
    // public boolean iswhenClearedNull() {
    //	return nullwhenCleared;
    // }

    /*
     * Set the null indicator for whenCleared
     */       
    // public void setwhenClearedNull() {
    // 	nullwhenCleared = true;
    // }

    /**
     * Get the value for statesDescription.
     */
    public String getstatesDescription () {
        return statesDescription;
    }

    /**
     * Set statesDescription to the specified value.
     */
    public void setstatesDescription(String statesDescription) {

        // nullstatesDescription = false;

        this.statesDescription = statesDescription;

    }

    /*
     * Is the statesDescription null?
     */
    // public boolean isstatesDescriptionNull() {
    //	return nullstatesDescription;
    // }

    /*
     * Set the null indicator for statesDescription
     */       
    // public void setstatesDescriptionNull() {
    // 	nullstatesDescription = true;
    // }

    /**
     * Get the value for condition.
     */
    public String getcondition () {
        return condition;
    }

    /**
     * Set condition to the specified value.
     */
    public void setcondition(String condition) {

        // nullcondition = false;

        this.condition = condition;

    }

    /*
     * Is the condition null?
     */
    // public boolean isconditionNull() {
    //	return nullcondition;
    // }

    /*
     * Set the null indicator for condition
     */       
    // public void setconditionNull() {
    // 	nullcondition = true;
    // }

    /**
     * Get the value for alarm_on.
     */
    public String getalarm_on () {
        return alarm_on;
    }

    /**
     * Set alarm_on to the specified value.
     */
    public void setalarm_on(String alarm_on) {

        // nullalarm_on = false;

        this.alarm_on = alarm_on;

    }

    /*
     * Is the alarm_on null?
     */
    // public boolean isalarm_onNull() {
    //	return nullalarm_on;
    // }

    /*
     * Set the null indicator for alarm_on
     */       
    // public void setalarm_onNull() {
    // 	nullalarm_on = true;
    // }

    /**
     * Get the value for alarm_off.
     */
    public String getalarm_off () {
        return alarm_off;
    }

    /**
     * Set alarm_off to the specified value.
     */
    public void setalarm_off(String alarm_off) {

        // nullalarm_off = false;

        this.alarm_off = alarm_off;

    }

    /*
     * Is the alarm_off null?
     */
    // public boolean isalarm_offNull() {
    //	return nullalarm_off;
    // }

    /*
     * Set the null indicator for alarm_off
     */       
    // public void setalarm_offNull() {
    // 	nullalarm_off = true;
    // }

    /**
     * Get the value for Data.
     */
    public String getData () {
        return Data;
    }

    /**
     * Set Data to the specified value.
     */
    public void setData(String Data) {

        // nullData = false;

        this.Data = Data;

    }

    /*
     * Is the Data null?
     */
    // public boolean isDataNull() {
    //	return nullData;
    // }

    /*
     * Set the null indicator for Data
     */       
    // public void setDataNull() {
    // 	nullData = true;
    // }

}
