/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File CorrelatorBin.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.CorrelatorBinIDL;

/**

 * CorrBin gives the bins that belong to a correlator rack.  A correlator bin must contain at least a

 * single LTA with a CAN node address.  Additionally, there are 3 types of other cards (not in the CAN bus)

 * with monitor points populating a correlator bin: correlator cards, correlator interface cards, and power supply cards

   * Key: CorrelatorBinId is automatically generated from:  CorrelatorBinName, CorrQuadrantRackId

 *
 */
public class CorrelatorBin implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int CorrelatorBinId;

    private int CorrQuadrantRackId;

    private String CorrelatorBinName;

    private int LTANodeAddr;

    private int NumberOfCorrelatorCards;

    private int NumberOfInterfaceCards;

    private int NumberOfPSCards;

    private boolean Active;

    /**
     * Default Constructor for CorrelatorBin.  Setter methods must be used to insert data.
     */
    public CorrelatorBin () {

    }

    /**
     * Create a CorrelatorBin by specifiying all data values.
     */
    public CorrelatorBin (

        int CorrelatorBinId,

        int CorrQuadrantRackId,

        String CorrelatorBinName,

        int LTANodeAddr,

        int NumberOfCorrelatorCards,

        int NumberOfInterfaceCards,

        int NumberOfPSCards,

        boolean Active

    ) {

		setCorrelatorBinId(CorrelatorBinId);

		setCorrQuadrantRackId(CorrQuadrantRackId);

		setCorrelatorBinName(CorrelatorBinName);

		setLTANodeAddr(LTANodeAddr);

		setNumberOfCorrelatorCards(NumberOfCorrelatorCards);

		setNumberOfInterfaceCards(NumberOfInterfaceCards);

		setNumberOfPSCards(NumberOfPSCards);

		setActive(Active);

    }

    /**
     * Create a CorrelatorBin by specifiying data values as an array of strings.
     */
    public CorrelatorBin (String[] data) {
    	if (data.length != 8)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 8)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CorrelatorBinId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CorrQuadrantRackId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CorrelatorBinName = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.LTANodeAddr = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NumberOfCorrelatorCards = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NumberOfInterfaceCards = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NumberOfPSCards = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Active = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "CorrelatorBin:" + newline;

        s += "\tCorrelatorBinId: " + CorrelatorBinId + newline;

        s += "\tCorrQuadrantRackId: " + CorrQuadrantRackId + newline;

        s += "\tCorrelatorBinName: " + CorrelatorBinName + newline;

        s += "\tLTANodeAddr: " + LTANodeAddr + newline;

        s += "\tNumberOfCorrelatorCards: " + NumberOfCorrelatorCards + newline;

        s += "\tNumberOfInterfaceCards: " + NumberOfInterfaceCards + newline;

        s += "\tNumberOfPSCards: " + NumberOfPSCards + newline;

        s += "\tActive: " + Active + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "CorrelatorBin" + delimiter;  

        s += CorrelatorBinId + delimiter;

        s += CorrQuadrantRackId + delimiter;

        s += CorrelatorBinName + delimiter;

        s += LTANodeAddr + delimiter;

        s += NumberOfCorrelatorCards + delimiter;

        s += NumberOfInterfaceCards + delimiter;

        s += NumberOfPSCards + delimiter;

        s += Active + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 8;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#CorrelatorBin" + delimiter  

        	+ "CorrelatorBinId" + delimiter

        	+ "CorrQuadrantRackId" + delimiter

        	+ "CorrelatorBinName" + delimiter

        	+ "LTANodeAddr" + delimiter

        	+ "NumberOfCorrelatorCards" + delimiter

        	+ "NumberOfInterfaceCards" + delimiter

        	+ "NumberOfPSCards" + delimiter

        	+ "Active" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof CorrelatorBin)) return false;
    	CorrelatorBin arg = (CorrelatorBin) obj;

		if (this.CorrelatorBinId != arg.CorrelatorBinId)
			return false;

		if (this.CorrQuadrantRackId != arg.CorrQuadrantRackId)
			return false;

		if (this.CorrelatorBinName == null) {	// Two null strings are equal
			if (arg.CorrelatorBinName == null)
				return true;
			else
				return false;
		}
		if (!this.CorrelatorBinName.equals(arg.CorrelatorBinName))
			return false; 

		if (this.LTANodeAddr != arg.LTANodeAddr)
			return false;

		if (this.NumberOfCorrelatorCards != arg.NumberOfCorrelatorCards)
			return false;

		if (this.NumberOfInterfaceCards != arg.NumberOfInterfaceCards)
			return false;

		if (this.NumberOfPSCards != arg.NumberOfPSCards)
			return false;

		if (this.Active != arg.Active)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public CorrelatorBinIDL toIDL() {
    	CorrelatorBinIDL x = new CorrelatorBinIDL ();

		x.CorrelatorBinId = this.CorrelatorBinId;

		x.CorrQuadrantRackId = this.CorrQuadrantRackId;

		x.CorrelatorBinName = this.CorrelatorBinName;

		x.LTANodeAddr = this.LTANodeAddr;

		x.NumberOfCorrelatorCards = this.NumberOfCorrelatorCards;

		x.NumberOfInterfaceCards = this.NumberOfInterfaceCards;

		x.NumberOfPSCards = this.NumberOfPSCards;

		x.Active = this.Active;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(CorrelatorBinIDL x) {

		this.CorrelatorBinId = x.CorrelatorBinId;

		this.CorrQuadrantRackId = x.CorrQuadrantRackId;

		this.CorrelatorBinName = x.CorrelatorBinName;

		this.LTANodeAddr = x.LTANodeAddr;

		this.NumberOfCorrelatorCards = x.NumberOfCorrelatorCards;

		this.NumberOfInterfaceCards = x.NumberOfInterfaceCards;

		this.NumberOfPSCards = x.NumberOfPSCards;

		this.Active = x.Active;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return CorrelatorBinId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for CorrelatorBin.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for CorrelatorBinId.
     */
    public int getCorrelatorBinId () {
        return CorrelatorBinId;
    }

    /**
     * Set CorrelatorBinId to the specified value.
     */
    public void setCorrelatorBinId(int CorrelatorBinId) {

        this.CorrelatorBinId = CorrelatorBinId;

    }

    /**
     * Get the value for CorrQuadrantRackId.
     */
    public int getCorrQuadrantRackId () {
        return CorrQuadrantRackId;
    }

    /**
     * Set CorrQuadrantRackId to the specified value.
     */
    public void setCorrQuadrantRackId(int CorrQuadrantRackId) {

        this.CorrQuadrantRackId = CorrQuadrantRackId;

    }

    /**
     * Get the value for CorrelatorBinName.
     */
    public String getCorrelatorBinName () {
        return CorrelatorBinName;
    }

    /**
     * Set CorrelatorBinName to the specified value.
     */
    public void setCorrelatorBinName(String CorrelatorBinName) {

        this.CorrelatorBinName = CorrelatorBinName;

    }

    /**
     * Get the value for LTANodeAddr.
     */
    public int getLTANodeAddr () {
        return LTANodeAddr;
    }

    /**
     * Set LTANodeAddr to the specified value.
     */
    public void setLTANodeAddr(int LTANodeAddr) {

        this.LTANodeAddr = LTANodeAddr;

    }

    /**
     * Get the value for NumberOfCorrelatorCards.
     */
    public int getNumberOfCorrelatorCards () {
        return NumberOfCorrelatorCards;
    }

    /**
     * Set NumberOfCorrelatorCards to the specified value.
     */
    public void setNumberOfCorrelatorCards(int NumberOfCorrelatorCards) {

        this.NumberOfCorrelatorCards = NumberOfCorrelatorCards;

    }

    /**
     * Get the value for NumberOfInterfaceCards.
     */
    public int getNumberOfInterfaceCards () {
        return NumberOfInterfaceCards;
    }

    /**
     * Set NumberOfInterfaceCards to the specified value.
     */
    public void setNumberOfInterfaceCards(int NumberOfInterfaceCards) {

        this.NumberOfInterfaceCards = NumberOfInterfaceCards;

    }

    /**
     * Get the value for NumberOfPSCards.
     */
    public int getNumberOfPSCards () {
        return NumberOfPSCards;
    }

    /**
     * Set NumberOfPSCards to the specified value.
     */
    public void setNumberOfPSCards(int NumberOfPSCards) {

        this.NumberOfPSCards = NumberOfPSCards;

    }

    /**
     * Get the value for Active.
     */
    public boolean getActive () {
        return Active;
    }

    /**
     * Set Active to the specified value.
     */
    public void setActive(boolean Active) {

        this.Active = Active;

    }

}
