/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File CorrStationBin.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.CorrStationBinIDL;

/**

 * CorrStationBin gives the station bins that belong to a correlator station rack.  A station bin must contain at least a

 * single station control card with a CAN node address.  Additionally, there are 5 types of other cards (not in the CAN bus)

 * with monitor points populating a station bin: station cards, TFB cards, DRX cards, station interface cards, and power supply cards.

   * Key: CorrStationBinId is automatically generated from:  StationBinName, CorrQuadrantRackId

 *
 */
public class CorrStationBin implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int CorrStationBinId;

    private int CorrQuadrantRackId;

    private String StationBinName;

    private int StationNodeAddr;

    private int NumberOfStationCards;

    private int NumberOfTFBCards;

    private int NumberOfDRXCards;

    private int NumberOfInterfaceCards;

    private int NumberOfPSCards;

    private boolean Active;

    /**
     * Default Constructor for CorrStationBin.  Setter methods must be used to insert data.
     */
    public CorrStationBin () {

    }

    /**
     * Create a CorrStationBin by specifiying all data values.
     */
    public CorrStationBin (

        int CorrStationBinId,

        int CorrQuadrantRackId,

        String StationBinName,

        int StationNodeAddr,

        int NumberOfStationCards,

        int NumberOfTFBCards,

        int NumberOfDRXCards,

        int NumberOfInterfaceCards,

        int NumberOfPSCards,

        boolean Active

    ) {

		setCorrStationBinId(CorrStationBinId);

		setCorrQuadrantRackId(CorrQuadrantRackId);

		setStationBinName(StationBinName);

		setStationNodeAddr(StationNodeAddr);

		setNumberOfStationCards(NumberOfStationCards);

		setNumberOfTFBCards(NumberOfTFBCards);

		setNumberOfDRXCards(NumberOfDRXCards);

		setNumberOfInterfaceCards(NumberOfInterfaceCards);

		setNumberOfPSCards(NumberOfPSCards);

		setActive(Active);

    }

    /**
     * Create a CorrStationBin by specifiying data values as an array of strings.
     */
    public CorrStationBin (String[] data) {
    	if (data.length != 10)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 10)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CorrStationBinId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CorrQuadrantRackId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StationBinName = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StationNodeAddr = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NumberOfStationCards = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NumberOfTFBCards = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NumberOfDRXCards = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NumberOfInterfaceCards = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NumberOfPSCards = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Active = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "CorrStationBin:" + newline;

        s += "\tCorrStationBinId: " + CorrStationBinId + newline;

        s += "\tCorrQuadrantRackId: " + CorrQuadrantRackId + newline;

        s += "\tStationBinName: " + StationBinName + newline;

        s += "\tStationNodeAddr: " + StationNodeAddr + newline;

        s += "\tNumberOfStationCards: " + NumberOfStationCards + newline;

        s += "\tNumberOfTFBCards: " + NumberOfTFBCards + newline;

        s += "\tNumberOfDRXCards: " + NumberOfDRXCards + newline;

        s += "\tNumberOfInterfaceCards: " + NumberOfInterfaceCards + newline;

        s += "\tNumberOfPSCards: " + NumberOfPSCards + newline;

        s += "\tActive: " + Active + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "CorrStationBin" + delimiter;  

        s += CorrStationBinId + delimiter;

        s += CorrQuadrantRackId + delimiter;

        s += StationBinName + delimiter;

        s += StationNodeAddr + delimiter;

        s += NumberOfStationCards + delimiter;

        s += NumberOfTFBCards + delimiter;

        s += NumberOfDRXCards + delimiter;

        s += NumberOfInterfaceCards + delimiter;

        s += NumberOfPSCards + delimiter;

        s += Active + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 10;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#CorrStationBin" + delimiter  

        	+ "CorrStationBinId" + delimiter

        	+ "CorrQuadrantRackId" + delimiter

        	+ "StationBinName" + delimiter

        	+ "StationNodeAddr" + delimiter

        	+ "NumberOfStationCards" + delimiter

        	+ "NumberOfTFBCards" + delimiter

        	+ "NumberOfDRXCards" + delimiter

        	+ "NumberOfInterfaceCards" + delimiter

        	+ "NumberOfPSCards" + delimiter

        	+ "Active" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof CorrStationBin)) return false;
    	CorrStationBin arg = (CorrStationBin) obj;

		if (this.CorrStationBinId != arg.CorrStationBinId)
			return false;

		if (this.CorrQuadrantRackId != arg.CorrQuadrantRackId)
			return false;

		if (this.StationBinName == null) {	// Two null strings are equal
			if (arg.StationBinName == null)
				return true;
			else
				return false;
		}
		if (!this.StationBinName.equals(arg.StationBinName))
			return false; 

		if (this.StationNodeAddr != arg.StationNodeAddr)
			return false;

		if (this.NumberOfStationCards != arg.NumberOfStationCards)
			return false;

		if (this.NumberOfTFBCards != arg.NumberOfTFBCards)
			return false;

		if (this.NumberOfDRXCards != arg.NumberOfDRXCards)
			return false;

		if (this.NumberOfInterfaceCards != arg.NumberOfInterfaceCards)
			return false;

		if (this.NumberOfPSCards != arg.NumberOfPSCards)
			return false;

		if (this.Active != arg.Active)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public CorrStationBinIDL toIDL() {
    	CorrStationBinIDL x = new CorrStationBinIDL ();

		x.CorrStationBinId = this.CorrStationBinId;

		x.CorrQuadrantRackId = this.CorrQuadrantRackId;

		x.StationBinName = this.StationBinName;

		x.StationNodeAddr = this.StationNodeAddr;

		x.NumberOfStationCards = this.NumberOfStationCards;

		x.NumberOfTFBCards = this.NumberOfTFBCards;

		x.NumberOfDRXCards = this.NumberOfDRXCards;

		x.NumberOfInterfaceCards = this.NumberOfInterfaceCards;

		x.NumberOfPSCards = this.NumberOfPSCards;

		x.Active = this.Active;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(CorrStationBinIDL x) {

		this.CorrStationBinId = x.CorrStationBinId;

		this.CorrQuadrantRackId = x.CorrQuadrantRackId;

		this.StationBinName = x.StationBinName;

		this.StationNodeAddr = x.StationNodeAddr;

		this.NumberOfStationCards = x.NumberOfStationCards;

		this.NumberOfTFBCards = x.NumberOfTFBCards;

		this.NumberOfDRXCards = x.NumberOfDRXCards;

		this.NumberOfInterfaceCards = x.NumberOfInterfaceCards;

		this.NumberOfPSCards = x.NumberOfPSCards;

		this.Active = x.Active;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return CorrStationBinId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for CorrStationBin.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for CorrStationBinId.
     */
    public int getCorrStationBinId () {
        return CorrStationBinId;
    }

    /**
     * Set CorrStationBinId to the specified value.
     */
    public void setCorrStationBinId(int CorrStationBinId) {

        this.CorrStationBinId = CorrStationBinId;

    }

    /**
     * Get the value for CorrQuadrantRackId.
     */
    public int getCorrQuadrantRackId () {
        return CorrQuadrantRackId;
    }

    /**
     * Set CorrQuadrantRackId to the specified value.
     */
    public void setCorrQuadrantRackId(int CorrQuadrantRackId) {

        this.CorrQuadrantRackId = CorrQuadrantRackId;

    }

    /**
     * Get the value for StationBinName.
     */
    public String getStationBinName () {
        return StationBinName;
    }

    /**
     * Set StationBinName to the specified value.
     */
    public void setStationBinName(String StationBinName) {

        this.StationBinName = StationBinName;

    }

    /**
     * Get the value for StationNodeAddr.
     */
    public int getStationNodeAddr () {
        return StationNodeAddr;
    }

    /**
     * Set StationNodeAddr to the specified value.
     */
    public void setStationNodeAddr(int StationNodeAddr) {

        this.StationNodeAddr = StationNodeAddr;

    }

    /**
     * Get the value for NumberOfStationCards.
     */
    public int getNumberOfStationCards () {
        return NumberOfStationCards;
    }

    /**
     * Set NumberOfStationCards to the specified value.
     */
    public void setNumberOfStationCards(int NumberOfStationCards) {

        this.NumberOfStationCards = NumberOfStationCards;

    }

    /**
     * Get the value for NumberOfTFBCards.
     */
    public int getNumberOfTFBCards () {
        return NumberOfTFBCards;
    }

    /**
     * Set NumberOfTFBCards to the specified value.
     */
    public void setNumberOfTFBCards(int NumberOfTFBCards) {

        this.NumberOfTFBCards = NumberOfTFBCards;

    }

    /**
     * Get the value for NumberOfDRXCards.
     */
    public int getNumberOfDRXCards () {
        return NumberOfDRXCards;
    }

    /**
     * Set NumberOfDRXCards to the specified value.
     */
    public void setNumberOfDRXCards(int NumberOfDRXCards) {

        this.NumberOfDRXCards = NumberOfDRXCards;

    }

    /**
     * Get the value for NumberOfInterfaceCards.
     */
    public int getNumberOfInterfaceCards () {
        return NumberOfInterfaceCards;
    }

    /**
     * Set NumberOfInterfaceCards to the specified value.
     */
    public void setNumberOfInterfaceCards(int NumberOfInterfaceCards) {

        this.NumberOfInterfaceCards = NumberOfInterfaceCards;

    }

    /**
     * Get the value for NumberOfPSCards.
     */
    public int getNumberOfPSCards () {
        return NumberOfPSCards;
    }

    /**
     * Set NumberOfPSCards to the specified value.
     */
    public void setNumberOfPSCards(int NumberOfPSCards) {

        this.NumberOfPSCards = NumberOfPSCards;

    }

    /**
     * Get the value for Active.
     */
    public boolean getActive () {
        return Active;
    }

    /**
     * Set Active to the specified value.
     */
    public void setActive(boolean Active) {

        this.Active = Active;

    }

}
