/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File CorrQuadrantRack.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.CorrQuadrantRackIDL;

/**

 * CorrQuadrantRack gives the racks that belong to a correlator quadrant.  There are two types of racks, those that contain

 * station cards and those that contain correlator cards.  Racks may be turned on/off independently within a quadrant

 * (e.g. during maintenance, testing, etc.).  The ON/OFF status of a given rack within a given quadrant is indicated by

 * the Active field.

   * Key: CorrQuadrantRackId is automatically generated from:  RackName, CorrQuadrantId

 *
 */
public class CorrQuadrantRack implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int CorrQuadrantRackId;

    private int CorrQuadrantId;

    private String RackName;

    private String RackType;

    private int NumberOfBins;

    private boolean Active;

    /**
     * Default Constructor for CorrQuadrantRack.  Setter methods must be used to insert data.
     */
    public CorrQuadrantRack () {

    }

    /**
     * Create a CorrQuadrantRack by specifiying all data values.
     */
    public CorrQuadrantRack (

        int CorrQuadrantRackId,

        int CorrQuadrantId,

        String RackName,

        String RackType,

        int NumberOfBins,

        boolean Active

    ) {

		setCorrQuadrantRackId(CorrQuadrantRackId);

		setCorrQuadrantId(CorrQuadrantId);

		setRackName(RackName);

		setRackType(RackType);

		setNumberOfBins(NumberOfBins);

		setActive(Active);

    }

    /**
     * Create a CorrQuadrantRack by specifiying data values as an array of strings.
     */
    public CorrQuadrantRack (String[] data) {
    	if (data.length != 6)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 6)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CorrQuadrantRackId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CorrQuadrantId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.RackName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.RackType = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NumberOfBins = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Active = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "CorrQuadrantRack:" + newline;

        s += "\tCorrQuadrantRackId: " + CorrQuadrantRackId + newline;

        s += "\tCorrQuadrantId: " + CorrQuadrantId + newline;

        s += "\tRackName: " + RackName + newline;

        s += "\tRackType: " + RackType + newline;

        s += "\tNumberOfBins: " + NumberOfBins + newline;

        s += "\tActive: " + Active + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "CorrQuadrantRack" + delimiter;  

        s += CorrQuadrantRackId + delimiter;

        s += CorrQuadrantId + delimiter;

        s += RackName + delimiter;

        s += RackType + delimiter;

        s += NumberOfBins + delimiter;

        s += Active + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 6;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#CorrQuadrantRack" + delimiter  

        	+ "CorrQuadrantRackId" + delimiter

        	+ "CorrQuadrantId" + delimiter

        	+ "RackName" + delimiter

        	+ "RackType" + delimiter

        	+ "NumberOfBins" + delimiter

        	+ "Active" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof CorrQuadrantRack)) return false;
    	CorrQuadrantRack arg = (CorrQuadrantRack) obj;

		if (this.CorrQuadrantRackId != arg.CorrQuadrantRackId)
			return false;

		if (this.CorrQuadrantId != arg.CorrQuadrantId)
			return false;

		if (this.RackName == null) {	// Two null strings are equal
			if (arg.RackName == null)
				return true;
			else
				return false;
		}
		if (!this.RackName.equals(arg.RackName))
			return false; 

		if (this.RackType == null) {	// Two null strings are equal
			if (arg.RackType == null)
				return true;
			else
				return false;
		}
		if (!this.RackType.equals(arg.RackType))
			return false; 

		if (this.NumberOfBins != arg.NumberOfBins)
			return false;

		if (this.Active != arg.Active)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public CorrQuadrantRackIDL toIDL() {
    	CorrQuadrantRackIDL x = new CorrQuadrantRackIDL ();

		x.CorrQuadrantRackId = this.CorrQuadrantRackId;

		x.CorrQuadrantId = this.CorrQuadrantId;

		x.RackName = this.RackName;

		x.RackType = this.RackType;

		x.NumberOfBins = this.NumberOfBins;

		x.Active = this.Active;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(CorrQuadrantRackIDL x) {

		this.CorrQuadrantRackId = x.CorrQuadrantRackId;

		this.CorrQuadrantId = x.CorrQuadrantId;

		this.RackName = x.RackName;

		this.RackType = x.RackType;

		this.NumberOfBins = x.NumberOfBins;

		this.Active = x.Active;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return CorrQuadrantRackId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for CorrQuadrantRack.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for CorrQuadrantRackId.
     */
    public int getCorrQuadrantRackId () {
        return CorrQuadrantRackId;
    }

    /**
     * Set CorrQuadrantRackId to the specified value.
     */
    public void setCorrQuadrantRackId(int CorrQuadrantRackId) {

        this.CorrQuadrantRackId = CorrQuadrantRackId;

    }

    /**
     * Get the value for CorrQuadrantId.
     */
    public int getCorrQuadrantId () {
        return CorrQuadrantId;
    }

    /**
     * Set CorrQuadrantId to the specified value.
     */
    public void setCorrQuadrantId(int CorrQuadrantId) {

        this.CorrQuadrantId = CorrQuadrantId;

    }

    /**
     * Get the value for RackName.
     */
    public String getRackName () {
        return RackName;
    }

    /**
     * Set RackName to the specified value.
     */
    public void setRackName(String RackName) {

        this.RackName = RackName;

    }

    /**
     * Get the value for RackType.
     */
    public String getRackType () {
        return RackType;
    }

    /**
     * Set RackType to the specified value.
     */
    public void setRackType(String RackType) {

        this.RackType = RackType;

    }

    /**
     * Get the value for NumberOfBins.
     */
    public int getNumberOfBins () {
        return NumberOfBins;
    }

    /**
     * Set NumberOfBins to the specified value.
     */
    public void setNumberOfBins(int NumberOfBins) {

        this.NumberOfBins = NumberOfBins;

    }

    /**
     * Get the value for Active.
     */
    public boolean getActive () {
        return Active;
    }

    /**
     * Set Active to the specified value.
     */
    public void setActive(boolean Active) {

        this.Active = Active;

    }

}
