/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File CorrQuadrant.java
 */
package alma.TMCDB.generated;

import alma.TMCDB.types.ArrayTime;

import alma.TMCDB_GEN_IDL.CorrQuadrantIDL;

/**

 * Correlator quadrant belongs here rather than Correlator because each quadrant can separately be on-line or off-line.

 * A correlator quadrant is composed of racks.  In addition, each correlator quadrant has a number, a CAN channel,

 * number of antennas, and bins associated with it.  Quadrants may be turned on/off independetly within a HW configuration

 * (e.g. during maintenance, testing, etc.).  The ON/OFF status of a given quadrant within a given correlator

 * hardware configuration is indicated by the Active field.

 * 

   * Key: CorrQuadrantId is automatically generated from:  CorrName, Quadrant, BaseElementId

 *
 */
public class CorrQuadrant implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int CorrQuadrantId;

    private int CorrHWConfigId;

    private int BaseElementId;

    private String CorrName;

    private int Quadrant;

    private int ChannelNumber;

    private int NumberOfAntennas;

    private ArrayTime CommissionDate;

    private int ComponentId;

    private int NumberOfRacks;

    private int NumberOfBins;

    private boolean Active;

    /**
     * Default Constructor for CorrQuadrant.  Setter methods must be used to insert data.
     */
    public CorrQuadrant () {

    }

    /**
     * Create a CorrQuadrant by specifiying all data values.
     */
    public CorrQuadrant (

        int CorrQuadrantId,

        int CorrHWConfigId,

        int BaseElementId,

        String CorrName,

        int Quadrant,

        int ChannelNumber,

        int NumberOfAntennas,

        ArrayTime CommissionDate,

        int ComponentId,

        int NumberOfRacks,

        int NumberOfBins,

        boolean Active

    ) {

		setCorrQuadrantId(CorrQuadrantId);

		setCorrHWConfigId(CorrHWConfigId);

		setBaseElementId(BaseElementId);

		setCorrName(CorrName);

		setQuadrant(Quadrant);

		setChannelNumber(ChannelNumber);

		setNumberOfAntennas(NumberOfAntennas);

		setCommissionDate(CommissionDate);

		setComponentId(ComponentId);

		setNumberOfRacks(NumberOfRacks);

		setNumberOfBins(NumberOfBins);

		setActive(Active);

    }

    /**
     * Create a CorrQuadrant by specifiying data values as an array of strings.
     */
    public CorrQuadrant (String[] data) {
    	if (data.length != 12)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 12)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CorrQuadrantId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CorrHWConfigId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CorrName = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Quadrant = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ChannelNumber = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NumberOfAntennas = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CommissionDate = new ArrayTime(data[i]);

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComponentId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NumberOfRacks = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NumberOfBins = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Active = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "CorrQuadrant:" + newline;

        s += "\tCorrQuadrantId: " + CorrQuadrantId + newline;

        s += "\tCorrHWConfigId: " + CorrHWConfigId + newline;

        s += "\tBaseElementId: " + BaseElementId + newline;

        s += "\tCorrName: " + CorrName + newline;

        s += "\tQuadrant: " + Quadrant + newline;

        s += "\tChannelNumber: " + ChannelNumber + newline;

        s += "\tNumberOfAntennas: " + NumberOfAntennas + newline;

        s += "\tCommissionDate: " + CommissionDate.toFITS() + newline;

        s += "\tComponentId: " + ComponentId + newline;

        s += "\tNumberOfRacks: " + NumberOfRacks + newline;

        s += "\tNumberOfBins: " + NumberOfBins + newline;

        s += "\tActive: " + Active + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "CorrQuadrant" + delimiter;  

        s += CorrQuadrantId + delimiter;

        s += CorrHWConfigId + delimiter;

        s += BaseElementId + delimiter;

        s += CorrName + delimiter;

        s += Quadrant + delimiter;

        s += ChannelNumber + delimiter;

        s += NumberOfAntennas + delimiter;

		s += new String(CommissionDate.toFITS()) + delimiter;

        s += ComponentId + delimiter;

        s += NumberOfRacks + delimiter;

        s += NumberOfBins + delimiter;

        s += Active + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 12;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#CorrQuadrant" + delimiter  

        	+ "CorrQuadrantId" + delimiter

        	+ "CorrHWConfigId" + delimiter

        	+ "BaseElementId" + delimiter

        	+ "CorrName" + delimiter

        	+ "Quadrant" + delimiter

        	+ "ChannelNumber" + delimiter

        	+ "NumberOfAntennas" + delimiter

        	+ "CommissionDate" + delimiter

        	+ "ComponentId" + delimiter

        	+ "NumberOfRacks" + delimiter

        	+ "NumberOfBins" + delimiter

        	+ "Active" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof CorrQuadrant)) return false;
    	CorrQuadrant arg = (CorrQuadrant) obj;

		if (this.CorrQuadrantId != arg.CorrQuadrantId)
			return false;

		if (this.CorrHWConfigId != arg.CorrHWConfigId)
			return false;

		if (this.BaseElementId != arg.BaseElementId)
			return false;

		if (this.CorrName == null) {	// Two null strings are equal
			if (arg.CorrName == null)
				return true;
			else
				return false;
		}
		if (!this.CorrName.equals(arg.CorrName))
			return false; 

		if (this.Quadrant != arg.Quadrant)
			return false;

		if (this.ChannelNumber != arg.ChannelNumber)
			return false;

		if (this.NumberOfAntennas != arg.NumberOfAntennas)
			return false;

		if (this.CommissionDate.get() != arg.CommissionDate.get())
			return false;

		if (this.ComponentId != arg.ComponentId)
			return false;

		if (this.NumberOfRacks != arg.NumberOfRacks)
			return false;

		if (this.NumberOfBins != arg.NumberOfBins)
			return false;

		if (this.Active != arg.Active)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public CorrQuadrantIDL toIDL() {
    	CorrQuadrantIDL x = new CorrQuadrantIDL ();

		x.CorrQuadrantId = this.CorrQuadrantId;

		x.CorrHWConfigId = this.CorrHWConfigId;

		x.BaseElementId = this.BaseElementId;

		x.CorrName = this.CorrName;

		x.Quadrant = this.Quadrant;

		x.ChannelNumber = this.ChannelNumber;

		x.NumberOfAntennas = this.NumberOfAntennas;

		x.CommissionDate = this.CommissionDate.toIDLArrayTime();

		x.ComponentId = this.ComponentId;

		x.NumberOfRacks = this.NumberOfRacks;

		x.NumberOfBins = this.NumberOfBins;

		x.Active = this.Active;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(CorrQuadrantIDL x) {

		this.CorrQuadrantId = x.CorrQuadrantId;

		this.CorrHWConfigId = x.CorrHWConfigId;

		this.BaseElementId = x.BaseElementId;

		this.CorrName = x.CorrName;

		this.Quadrant = x.Quadrant;

		this.ChannelNumber = x.ChannelNumber;

		this.NumberOfAntennas = x.NumberOfAntennas;

		this.CommissionDate = new ArrayTime(x.CommissionDate);

		this.ComponentId = x.ComponentId;

		this.NumberOfRacks = x.NumberOfRacks;

		this.NumberOfBins = x.NumberOfBins;

		this.Active = x.Active;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return CorrQuadrantId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for CorrQuadrant.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for CorrQuadrantId.
     */
    public int getCorrQuadrantId () {
        return CorrQuadrantId;
    }

    /**
     * Set CorrQuadrantId to the specified value.
     */
    public void setCorrQuadrantId(int CorrQuadrantId) {

        this.CorrQuadrantId = CorrQuadrantId;

    }

    /**
     * Get the value for CorrHWConfigId.
     */
    public int getCorrHWConfigId () {
        return CorrHWConfigId;
    }

    /**
     * Set CorrHWConfigId to the specified value.
     */
    public void setCorrHWConfigId(int CorrHWConfigId) {

        this.CorrHWConfigId = CorrHWConfigId;

    }

    /**
     * Get the value for BaseElementId.
     */
    public int getBaseElementId () {
        return BaseElementId;
    }

    /**
     * Set BaseElementId to the specified value.
     */
    public void setBaseElementId(int BaseElementId) {

        this.BaseElementId = BaseElementId;

    }

    /**
     * Get the value for CorrName.
     */
    public String getCorrName () {
        return CorrName;
    }

    /**
     * Set CorrName to the specified value.
     */
    public void setCorrName(String CorrName) {

        this.CorrName = CorrName;

    }

    /**
     * Get the value for Quadrant.
     */
    public int getQuadrant () {
        return Quadrant;
    }

    /**
     * Set Quadrant to the specified value.
     */
    public void setQuadrant(int Quadrant) {

        this.Quadrant = Quadrant;

    }

    /**
     * Get the value for ChannelNumber.
     */
    public int getChannelNumber () {
        return ChannelNumber;
    }

    /**
     * Set ChannelNumber to the specified value.
     */
    public void setChannelNumber(int ChannelNumber) {

        this.ChannelNumber = ChannelNumber;

    }

    /**
     * Get the value for NumberOfAntennas.
     */
    public int getNumberOfAntennas () {
        return NumberOfAntennas;
    }

    /**
     * Set NumberOfAntennas to the specified value.
     */
    public void setNumberOfAntennas(int NumberOfAntennas) {

        this.NumberOfAntennas = NumberOfAntennas;

    }

    /**
     * Get the value for CommissionDate.
     */
    public ArrayTime getCommissionDate () {
        return CommissionDate;
    }

    /**
     * Set CommissionDate to the specified value.
     */
    public void setCommissionDate(ArrayTime CommissionDate) {

        this.CommissionDate = CommissionDate;

    }

    /**
     * Get the value for ComponentId.
     */
    public int getComponentId () {
        return ComponentId;
    }

    /**
     * Set ComponentId to the specified value.
     */
    public void setComponentId(int ComponentId) {

        this.ComponentId = ComponentId;

    }

    /**
     * Get the value for NumberOfRacks.
     */
    public int getNumberOfRacks () {
        return NumberOfRacks;
    }

    /**
     * Set NumberOfRacks to the specified value.
     */
    public void setNumberOfRacks(int NumberOfRacks) {

        this.NumberOfRacks = NumberOfRacks;

    }

    /**
     * Get the value for NumberOfBins.
     */
    public int getNumberOfBins () {
        return NumberOfBins;
    }

    /**
     * Set NumberOfBins to the specified value.
     */
    public void setNumberOfBins(int NumberOfBins) {

        this.NumberOfBins = NumberOfBins;

    }

    /**
     * Get the value for Active.
     */
    public boolean getActive () {
        return Active;
    }

    /**
     * Set Active to the specified value.
     */
    public void setActive(boolean Active) {

        this.Active = Active;

    }

}
