/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File CorrHWConfiguration.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.CorrHWConfigurationIDL;

/**

 * CorrHWConfiguration determines the type of correlator in use.  A configuration may have up to 4 quadrants depending on its type.

   * Key: BaseElementId

 *
 */
public class CorrHWConfiguration implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int BaseElementId;

    private String CorrHWName;

    private String CorrHWType;

    /**
     * Default Constructor for CorrHWConfiguration.  Setter methods must be used to insert data.
     */
    public CorrHWConfiguration () {

    }

    /**
     * Create a CorrHWConfiguration by specifiying all data values.
     */
    public CorrHWConfiguration (

        int BaseElementId,

        String CorrHWName,

        String CorrHWType

    ) {

		setBaseElementId(BaseElementId);

		setCorrHWName(CorrHWName);

		setCorrHWType(CorrHWType);

    }

    /**
     * Create a CorrHWConfiguration by specifiying data values as an array of strings.
     */
    public CorrHWConfiguration (String[] data) {
    	if (data.length != 3)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 3)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CorrHWName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CorrHWType = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "CorrHWConfiguration:" + newline;

        s += "\tBaseElementId: " + BaseElementId + newline;

        s += "\tCorrHWName: " + CorrHWName + newline;

        s += "\tCorrHWType: " + CorrHWType + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "CorrHWConfiguration" + delimiter;  

        s += BaseElementId + delimiter;

        s += CorrHWName + delimiter;

        s += CorrHWType + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 3;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#CorrHWConfiguration" + delimiter  

        	+ "BaseElementId" + delimiter

        	+ "CorrHWName" + delimiter

        	+ "CorrHWType" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof CorrHWConfiguration)) return false;
    	CorrHWConfiguration arg = (CorrHWConfiguration) obj;

		if (this.BaseElementId != arg.BaseElementId)
			return false;

		if (this.CorrHWName == null) {	// Two null strings are equal
			if (arg.CorrHWName == null)
				return true;
			else
				return false;
		}
		if (!this.CorrHWName.equals(arg.CorrHWName))
			return false; 

		if (this.CorrHWType == null) {	// Two null strings are equal
			if (arg.CorrHWType == null)
				return true;
			else
				return false;
		}
		if (!this.CorrHWType.equals(arg.CorrHWType))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public CorrHWConfigurationIDL toIDL() {
    	CorrHWConfigurationIDL x = new CorrHWConfigurationIDL ();

		x.BaseElementId = this.BaseElementId;

		x.CorrHWName = this.CorrHWName;

		x.CorrHWType = this.CorrHWType;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(CorrHWConfigurationIDL x) {

		this.BaseElementId = x.BaseElementId;

		this.CorrHWName = x.CorrHWName;

		this.CorrHWType = x.CorrHWType;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for CorrHWConfiguration.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for BaseElementId.
     */
    public int getBaseElementId () {
        return BaseElementId;
    }

    /**
     * Set BaseElementId to the specified value.
     */
    public void setBaseElementId(int BaseElementId) {

        this.BaseElementId = BaseElementId;

    }

    /**
     * Get the value for CorrHWName.
     */
    public String getCorrHWName () {
        return CorrHWName;
    }

    /**
     * Set CorrHWName to the specified value.
     */
    public void setCorrHWName(String CorrHWName) {

        this.CorrHWName = CorrHWName;

    }

    /**
     * Get the value for CorrHWType.
     */
    public String getCorrHWType () {
        return CorrHWType;
    }

    /**
     * Set CorrHWType to the specified value.
     */
    public void setCorrHWType(String CorrHWType) {

        this.CorrHWType = CorrHWType;

    }

}
