/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File ContainerExecution.java
 */
package alma.TMCDB.generated;

import alma.TMCDB.types.ArrayTime;

import alma.TMCDB_GEN_IDL.ContainerExecutionIDL;

/**

 * Entries in the ContainerExecution table record when a container was executed on a particular computer.

 * There is an implied constraint here: real-time containers must run on real-time computers.

   * Key: ContainerExecutionId is automatically generated from:  ContainerId, ComputerId, StartTime, ConfigurationId

 *
 */
public class ContainerExecution implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int ContainerExecutionId;

    private int ContainerId;

    private int ConfigurationId;

    private int ComputerId;

    private ArrayTime StartTime;

    private ArrayTime EndTime;

    // private boolean nullEndTime;

    private boolean NormalStart;

    private boolean NormalTermination;

    /**
     * Default Constructor for ContainerExecution.  Setter methods must be used to insert data.
     */
    public ContainerExecution () {

        // nullEndTime = true;

    }

    /**
     * Create a ContainerExecution by specifiying all data values.
     */
    public ContainerExecution (

        int ContainerExecutionId,

        int ContainerId,

        int ConfigurationId,

        int ComputerId,

        ArrayTime StartTime,

        ArrayTime EndTime,

        boolean NormalStart,

        boolean NormalTermination

    ) {

		setContainerExecutionId(ContainerExecutionId);

		setContainerId(ContainerId);

		setConfigurationId(ConfigurationId);

		setComputerId(ComputerId);

		setStartTime(StartTime);

		setEndTime(EndTime);

		setNormalStart(NormalStart);

		setNormalTermination(NormalTermination);

    }

    /**
     * Create a ContainerExecution by specifiying data values as an array of strings.
     */
    public ContainerExecution (String[] data) {
    	if (data.length != 8)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 8)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ContainerExecutionId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ContainerId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComputerId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StartTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullEndTime = true;
			// this.EndTime = null;

		} else {

			// nullEndTime = false;

			this.EndTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NormalStart = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NormalTermination = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "ContainerExecution:" + newline;

        s += "\tContainerExecutionId: " + ContainerExecutionId + newline;

        s += "\tContainerId: " + ContainerId + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

        s += "\tComputerId: " + ComputerId + newline;

        s += "\tStartTime: " + StartTime.toFITS() + newline;

    	// if (EndTime == null)
    	//	s += "\tEndTime: null" + newline;
    	// else

        s += "\tEndTime: " + EndTime.toFITS() + newline;

        s += "\tNormalStart: " + NormalStart + newline;

        s += "\tNormalTermination: " + NormalTermination + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "ContainerExecution" + delimiter;  

        s += ContainerExecutionId + delimiter;

        s += ContainerId + delimiter;

        s += ConfigurationId + delimiter;

        s += ComputerId + delimiter;

		s += new String(StartTime.toFITS()) + delimiter;

        // if (nullEndTime)
        // 	s += delimiter;
        // else

		// s += new String(EndTime.toFITS()) + delimiter;

        s += NormalStart + delimiter;

        s += NormalTermination + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 8;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#ContainerExecution" + delimiter  

        	+ "ContainerExecutionId" + delimiter

        	+ "ContainerId" + delimiter

        	+ "ConfigurationId" + delimiter

        	+ "ComputerId" + delimiter

        	+ "StartTime" + delimiter

        	+ "EndTime" + delimiter

        	+ "NormalStart" + delimiter

        	+ "NormalTermination" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof ContainerExecution)) return false;
    	ContainerExecution arg = (ContainerExecution) obj;

		if (this.ContainerExecutionId != arg.ContainerExecutionId)
			return false;

		if (this.ContainerId != arg.ContainerId)
			return false;

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		if (this.ComputerId != arg.ComputerId)
			return false;

		if (this.StartTime.get() != arg.StartTime.get())
			return false;

		if (this.EndTime.get() != arg.EndTime.get())
			return false;

		if (this.NormalStart != arg.NormalStart)
			return false;

		if (this.NormalTermination != arg.NormalTermination)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public ContainerExecutionIDL toIDL() {
    	ContainerExecutionIDL x = new ContainerExecutionIDL ();

		x.ContainerExecutionId = this.ContainerExecutionId;

		x.ContainerId = this.ContainerId;

		x.ConfigurationId = this.ConfigurationId;

		x.ComputerId = this.ComputerId;

		x.StartTime = this.StartTime.toIDLArrayTime();

		x.EndTime = this.EndTime.toIDLArrayTime();

        // x.nullEndTime = this.nullEndTime;

		x.NormalStart = this.NormalStart;

		x.NormalTermination = this.NormalTermination;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(ContainerExecutionIDL x) {

		this.ContainerExecutionId = x.ContainerExecutionId;

		this.ContainerId = x.ContainerId;

		this.ConfigurationId = x.ConfigurationId;

		this.ComputerId = x.ComputerId;

		this.StartTime = new ArrayTime(x.StartTime);

		this.EndTime = new ArrayTime(x.EndTime);

        // this.nullEndTime = x.nullEndTime;

		this.NormalStart = x.NormalStart;

		this.NormalTermination = x.NormalTermination;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return ContainerExecutionId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for ContainerExecution.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for ContainerExecutionId.
     */
    public int getContainerExecutionId () {
        return ContainerExecutionId;
    }

    /**
     * Set ContainerExecutionId to the specified value.
     */
    public void setContainerExecutionId(int ContainerExecutionId) {

        this.ContainerExecutionId = ContainerExecutionId;

    }

    /**
     * Get the value for ContainerId.
     */
    public int getContainerId () {
        return ContainerId;
    }

    /**
     * Set ContainerId to the specified value.
     */
    public void setContainerId(int ContainerId) {

        this.ContainerId = ContainerId;

    }

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

    /**
     * Get the value for ComputerId.
     */
    public int getComputerId () {
        return ComputerId;
    }

    /**
     * Set ComputerId to the specified value.
     */
    public void setComputerId(int ComputerId) {

        this.ComputerId = ComputerId;

    }

    /**
     * Get the value for StartTime.
     */
    public ArrayTime getStartTime () {
        return StartTime;
    }

    /**
     * Set StartTime to the specified value.
     */
    public void setStartTime(ArrayTime StartTime) {

        this.StartTime = StartTime;

    }

    /**
     * Get the value for EndTime.
     */
    public ArrayTime getEndTime () {
        return EndTime;
    }

    /**
     * Set EndTime to the specified value.
     */
    public void setEndTime(ArrayTime EndTime) {

        // nullEndTime = false;

        this.EndTime = EndTime;

    }

    /*
     * Is the EndTime null?
     */
    // public boolean isEndTimeNull() {
    //	return nullEndTime;
    // }

    /*
     * Set the null indicator for EndTime
     */       
    // public void setEndTimeNull() {
    // 	nullEndTime = true;
    // }

    /**
     * Get the value for NormalStart.
     */
    public boolean getNormalStart () {
        return NormalStart;
    }

    /**
     * Set NormalStart to the specified value.
     */
    public void setNormalStart(boolean NormalStart) {

        this.NormalStart = NormalStart;

    }

    /**
     * Get the value for NormalTermination.
     */
    public boolean getNormalTermination () {
        return NormalTermination;
    }

    /**
     * Set NormalTermination to the specified value.
     */
    public void setNormalTermination(boolean NormalTermination) {

        this.NormalTermination = NormalTermination;

    }

}
