/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File Container.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.ContainerIDL;

/**

 * The entries in this table are the containers that belong to the configuration.

 * If this is a real-time container and kernel modules are to be loaded on startup, their directory location is specified in KernelModuleLocation.

 * LoggingConfigId  Link to the logging configuration for a container.

 * ComputerId       Links to the computer on which this container is supposed to run. Only applies when the container is started automatically by ACS.

 * ImplLang         the programming language (PL) this container is written in (see constraint ContainerImplLang below).

 * The container PL must match the component PL for all components configured to run in this container.

 * TypeModifiers    Optional space-separated list of type modifiers such as "debug pipeline-mode single-threaded".

 * KernelModule     Contains a comma-separated list of kernel module names to be loaded.

 * AcsInstance      The ACS instance to which this container should belong. Only applies when the container is started automatically by ACS

 * and should always be 0 in operational environments. (The ACS instance number is used to isolate instances of ACS running on one (group of) computer(s)).

 * CmdLineArgs      additional comman line arguments to be used when starting this container. Only applies when the container is started automatically by ACS.

 * KeepAliveTime    The time in seconds for which the container should not be shut down even when it no longer hosts any components. Negative values mean infinite time.

 * Only applies when the container is started automatically by ACS.

 * ServerThreads    The number of threads allocated to the CORBA infrastructure for the handling of concurrent invocations.

 * ManagerRetry     How many times the Container shall try to contact the Manager upon startup before bailing out. 0 means forever.

 * CallTimeout      Standard timeout in seconds for remote (CORBA) calls. Every call will timeout after this period of time, ensuring protection from deadlock.

 * Notice that ACS QoS features can be used to trim specific calls.

 * Recovery         By default when a Container that crashes is restarted, the system tries to reload all the same Components that were active at the time of the crash.

 * This can lead to problems, for example, trying to debug a component that causes the crash of the container just at activation time.

 * Therefore it is possible to set this options to prevent reloading the components and getting into a deadlock situation.

 * AutoloadSharedLibs Blank-separated list of shared libraries (C++ container only) that must be automatically loaded by the container.

 * It does not seem necessary to break down storage further, e.g. using tables "SharedLibs" and "ContainerToAutoloadedSharedLibs".

 * 

   * Key: ContainerId is automatically generated from:  ContainerName, Path, ConfigurationId

 *
 */
public class Container implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int ContainerId;

    private String ContainerName;

    private String Path;

    private int ConfigurationId;

    private int LoggingConfigId;

    private Integer ComputerId;

    // private boolean nullComputerId;

    private String ImplLang;

    private String TypeModifiers;

    // private boolean nullTypeModifiers;

    private boolean RealTime;

    private String RealTimeType;

    private String KernelModuleLocation;

    // private boolean nullKernelModuleLocation;

    private String KernelModule;

    // private boolean nullKernelModule;

    private int AcsInstance;

    private String CmdLineArgs;

    // private boolean nullCmdLineArgs;

    private int KeepAliveTime;

    private int ServerThreads;

    private int ManagerRetry;

    private int CallTimeout;

    private boolean Recovery;

    private String AutoloadSharedLibs;

    // private boolean nullAutoloadSharedLibs;

    /**
     * Default Constructor for Container.  Setter methods must be used to insert data.
     */
    public Container () {

        // nullComputerId = true;

        // nullTypeModifiers = true;

        // nullKernelModuleLocation = true;

        // nullKernelModule = true;

        // nullCmdLineArgs = true;

        // nullAutoloadSharedLibs = true;

    }

    /**
     * Create a Container by specifiying all data values.
     */
    public Container (

        int ContainerId,

        String ContainerName,

        String Path,

        int ConfigurationId,

        int LoggingConfigId,

        Integer ComputerId,

        String ImplLang,

        String TypeModifiers,

        boolean RealTime,

        String RealTimeType,

        String KernelModuleLocation,

        String KernelModule,

        int AcsInstance,

        String CmdLineArgs,

        int KeepAliveTime,

        int ServerThreads,

        int ManagerRetry,

        int CallTimeout,

        boolean Recovery,

        String AutoloadSharedLibs

    ) {

		setContainerId(ContainerId);

		setContainerName(ContainerName);

		setPath(Path);

		setConfigurationId(ConfigurationId);

		setLoggingConfigId(LoggingConfigId);

		setComputerId(ComputerId);

		setImplLang(ImplLang);

		setTypeModifiers(TypeModifiers);

		setRealTime(RealTime);

		setRealTimeType(RealTimeType);

		setKernelModuleLocation(KernelModuleLocation);

		setKernelModule(KernelModule);

		setAcsInstance(AcsInstance);

		setCmdLineArgs(CmdLineArgs);

		setKeepAliveTime(KeepAliveTime);

		setServerThreads(ServerThreads);

		setManagerRetry(ManagerRetry);

		setCallTimeout(CallTimeout);

		setRecovery(Recovery);

		setAutoloadSharedLibs(AutoloadSharedLibs);

    }

    /**
     * Create a Container by specifiying data values as an array of strings.
     */
    public Container (String[] data) {
    	if (data.length != 20)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 20)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ContainerId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ContainerName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Path = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.LoggingConfigId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullComputerId = true;
			// this.ComputerId = null;

		} else {

			// nullComputerId = false;

			this.ComputerId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ImplLang = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullTypeModifiers = true;
			// this.TypeModifiers = null;

		} else {

			// nullTypeModifiers = false;

			this.TypeModifiers = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.RealTime = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.RealTimeType = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullKernelModuleLocation = true;
			// this.KernelModuleLocation = null;

		} else {

			// nullKernelModuleLocation = false;

			this.KernelModuleLocation = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullKernelModule = true;
			// this.KernelModule = null;

		} else {

			// nullKernelModule = false;

			this.KernelModule = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AcsInstance = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullCmdLineArgs = true;
			// this.CmdLineArgs = null;

		} else {

			// nullCmdLineArgs = false;

			this.CmdLineArgs = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.KeepAliveTime = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ServerThreads = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ManagerRetry = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CallTimeout = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Recovery = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullAutoloadSharedLibs = true;
			// this.AutoloadSharedLibs = null;

		} else {

			// nullAutoloadSharedLibs = false;

			this.AutoloadSharedLibs = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "Container:" + newline;

        s += "\tContainerId: " + ContainerId + newline;

        s += "\tContainerName: " + ContainerName + newline;

        s += "\tPath: " + Path + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

        s += "\tLoggingConfigId: " + LoggingConfigId + newline;

    	// if (ComputerId == null)
    	//	s += "\tComputerId: null" + newline;
    	// else

        s += "\tComputerId: " + ComputerId + newline;

        s += "\tImplLang: " + ImplLang + newline;

    	// if (TypeModifiers == null)
    	//	s += "\tTypeModifiers: null" + newline;
    	// else

        s += "\tTypeModifiers: " + TypeModifiers + newline;

        s += "\tRealTime: " + RealTime + newline;

        s += "\tRealTimeType: " + RealTimeType + newline;

    	// if (KernelModuleLocation == null)
    	//	s += "\tKernelModuleLocation: null" + newline;
    	// else

        s += "\tKernelModuleLocation: " + KernelModuleLocation + newline;

    	// if (KernelModule == null)
    	//	s += "\tKernelModule: null" + newline;
    	// else

        s += "\tKernelModule: " + KernelModule + newline;

        s += "\tAcsInstance: " + AcsInstance + newline;

    	// if (CmdLineArgs == null)
    	//	s += "\tCmdLineArgs: null" + newline;
    	// else

        s += "\tCmdLineArgs: " + CmdLineArgs + newline;

        s += "\tKeepAliveTime: " + KeepAliveTime + newline;

        s += "\tServerThreads: " + ServerThreads + newline;

        s += "\tManagerRetry: " + ManagerRetry + newline;

        s += "\tCallTimeout: " + CallTimeout + newline;

        s += "\tRecovery: " + Recovery + newline;

    	// if (AutoloadSharedLibs == null)
    	//	s += "\tAutoloadSharedLibs: null" + newline;
    	// else

        s += "\tAutoloadSharedLibs: " + AutoloadSharedLibs + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "Container" + delimiter;  

        s += ContainerId + delimiter;

        s += ContainerName + delimiter;

        s += Path + delimiter;

        s += ConfigurationId + delimiter;

        s += LoggingConfigId + delimiter;

        // if (nullComputerId)
        // 	s += delimiter;
        // else

        	// s += ComputerId + delimiter;

        s += ImplLang + delimiter;

        // if (nullTypeModifiers)
        // 	s += delimiter;
        // else

        	// s += TypeModifiers + delimiter;

        s += RealTime + delimiter;

        s += RealTimeType + delimiter;

        // if (nullKernelModuleLocation)
        // 	s += delimiter;
        // else

        	// s += KernelModuleLocation + delimiter;

        // if (nullKernelModule)
        // 	s += delimiter;
        // else

        	// s += KernelModule + delimiter;

        s += AcsInstance + delimiter;

        // if (nullCmdLineArgs)
        // 	s += delimiter;
        // else

        	// s += CmdLineArgs + delimiter;

        s += KeepAliveTime + delimiter;

        s += ServerThreads + delimiter;

        s += ManagerRetry + delimiter;

        s += CallTimeout + delimiter;

        s += Recovery + delimiter;

        // if (nullAutoloadSharedLibs)
        // 	s += delimiter;
        // else

        	// s += AutoloadSharedLibs + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 20;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#Container" + delimiter  

        	+ "ContainerId" + delimiter

        	+ "ContainerName" + delimiter

        	+ "Path" + delimiter

        	+ "ConfigurationId" + delimiter

        	+ "LoggingConfigId" + delimiter

        	+ "ComputerId" + delimiter

        	+ "ImplLang" + delimiter

        	+ "TypeModifiers" + delimiter

        	+ "RealTime" + delimiter

        	+ "RealTimeType" + delimiter

        	+ "KernelModuleLocation" + delimiter

        	+ "KernelModule" + delimiter

        	+ "AcsInstance" + delimiter

        	+ "CmdLineArgs" + delimiter

        	+ "KeepAliveTime" + delimiter

        	+ "ServerThreads" + delimiter

        	+ "ManagerRetry" + delimiter

        	+ "CallTimeout" + delimiter

        	+ "Recovery" + delimiter

        	+ "AutoloadSharedLibs" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof Container)) return false;
    	Container arg = (Container) obj;

		if (this.ContainerId != arg.ContainerId)
			return false;

		if (this.ContainerName == null) {	// Two null strings are equal
			if (arg.ContainerName == null)
				return true;
			else
				return false;
		}
		if (!this.ContainerName.equals(arg.ContainerName))
			return false; 

		if (this.Path == null) {	// Two null strings are equal
			if (arg.Path == null)
				return true;
			else
				return false;
		}
		if (!this.Path.equals(arg.Path))
			return false; 

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		if (this.LoggingConfigId != arg.LoggingConfigId)
			return false;

		if (this.ComputerId != arg.ComputerId)
			return false;

		if (this.ImplLang == null) {	// Two null strings are equal
			if (arg.ImplLang == null)
				return true;
			else
				return false;
		}
		if (!this.ImplLang.equals(arg.ImplLang))
			return false; 

		if (this.TypeModifiers == null) {	// Two null strings are equal
			if (arg.TypeModifiers == null)
				return true;
			else
				return false;
		}
		if (!this.TypeModifiers.equals(arg.TypeModifiers))
			return false; 

		if (this.RealTime != arg.RealTime)
			return false;

		if (this.RealTimeType == null) {	// Two null strings are equal
			if (arg.RealTimeType == null)
				return true;
			else
				return false;
		}
		if (!this.RealTimeType.equals(arg.RealTimeType))
			return false; 

		if (this.KernelModuleLocation == null) {	// Two null strings are equal
			if (arg.KernelModuleLocation == null)
				return true;
			else
				return false;
		}
		if (!this.KernelModuleLocation.equals(arg.KernelModuleLocation))
			return false; 

		if (this.KernelModule == null) {	// Two null strings are equal
			if (arg.KernelModule == null)
				return true;
			else
				return false;
		}
		if (!this.KernelModule.equals(arg.KernelModule))
			return false; 

		if (this.AcsInstance != arg.AcsInstance)
			return false;

		if (this.CmdLineArgs == null) {	// Two null strings are equal
			if (arg.CmdLineArgs == null)
				return true;
			else
				return false;
		}
		if (!this.CmdLineArgs.equals(arg.CmdLineArgs))
			return false; 

		if (this.KeepAliveTime != arg.KeepAliveTime)
			return false;

		if (this.ServerThreads != arg.ServerThreads)
			return false;

		if (this.ManagerRetry != arg.ManagerRetry)
			return false;

		if (this.CallTimeout != arg.CallTimeout)
			return false;

		if (this.Recovery != arg.Recovery)
			return false;

		if (this.AutoloadSharedLibs == null) {	// Two null strings are equal
			if (arg.AutoloadSharedLibs == null)
				return true;
			else
				return false;
		}
		if (!this.AutoloadSharedLibs.equals(arg.AutoloadSharedLibs))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public ContainerIDL toIDL() {
    	ContainerIDL x = new ContainerIDL ();

		x.ContainerId = this.ContainerId;

		x.ContainerName = this.ContainerName;

		x.Path = this.Path;

		x.ConfigurationId = this.ConfigurationId;

		x.LoggingConfigId = this.LoggingConfigId;

		x.ComputerId = this.ComputerId;

        // x.nullComputerId = this.nullComputerId;

		x.ImplLang = this.ImplLang;

		x.TypeModifiers = this.TypeModifiers;

        // x.nullTypeModifiers = this.nullTypeModifiers;

		x.RealTime = this.RealTime;

		x.RealTimeType = this.RealTimeType;

		x.KernelModuleLocation = this.KernelModuleLocation;

        // x.nullKernelModuleLocation = this.nullKernelModuleLocation;

		x.KernelModule = this.KernelModule;

        // x.nullKernelModule = this.nullKernelModule;

		x.AcsInstance = this.AcsInstance;

		x.CmdLineArgs = this.CmdLineArgs;

        // x.nullCmdLineArgs = this.nullCmdLineArgs;

		x.KeepAliveTime = this.KeepAliveTime;

		x.ServerThreads = this.ServerThreads;

		x.ManagerRetry = this.ManagerRetry;

		x.CallTimeout = this.CallTimeout;

		x.Recovery = this.Recovery;

		x.AutoloadSharedLibs = this.AutoloadSharedLibs;

        // x.nullAutoloadSharedLibs = this.nullAutoloadSharedLibs;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(ContainerIDL x) {

		this.ContainerId = x.ContainerId;

		this.ContainerName = x.ContainerName;

		this.Path = x.Path;

		this.ConfigurationId = x.ConfigurationId;

		this.LoggingConfigId = x.LoggingConfigId;

		this.ComputerId = x.ComputerId;

        // this.nullComputerId = x.nullComputerId;

		this.ImplLang = x.ImplLang;

		this.TypeModifiers = x.TypeModifiers;

        // this.nullTypeModifiers = x.nullTypeModifiers;

		this.RealTime = x.RealTime;

		this.RealTimeType = x.RealTimeType;

		this.KernelModuleLocation = x.KernelModuleLocation;

        // this.nullKernelModuleLocation = x.nullKernelModuleLocation;

		this.KernelModule = x.KernelModule;

        // this.nullKernelModule = x.nullKernelModule;

		this.AcsInstance = x.AcsInstance;

		this.CmdLineArgs = x.CmdLineArgs;

        // this.nullCmdLineArgs = x.nullCmdLineArgs;

		this.KeepAliveTime = x.KeepAliveTime;

		this.ServerThreads = x.ServerThreads;

		this.ManagerRetry = x.ManagerRetry;

		this.CallTimeout = x.CallTimeout;

		this.Recovery = x.Recovery;

		this.AutoloadSharedLibs = x.AutoloadSharedLibs;

        // this.nullAutoloadSharedLibs = x.nullAutoloadSharedLibs;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return ContainerId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for Container.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for ContainerId.
     */
    public int getContainerId () {
        return ContainerId;
    }

    /**
     * Set ContainerId to the specified value.
     */
    public void setContainerId(int ContainerId) {

        this.ContainerId = ContainerId;

    }

    /**
     * Get the value for ContainerName.
     */
    public String getContainerName () {
        return ContainerName;
    }

    /**
     * Set ContainerName to the specified value.
     */
    public void setContainerName(String ContainerName) {

        this.ContainerName = ContainerName;

    }

    /**
     * Get the value for Path.
     */
    public String getPath () {
        return Path;
    }

    /**
     * Set Path to the specified value.
     */
    public void setPath(String Path) {

        this.Path = Path;

    }

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

    /**
     * Get the value for LoggingConfigId.
     */
    public int getLoggingConfigId () {
        return LoggingConfigId;
    }

    /**
     * Set LoggingConfigId to the specified value.
     */
    public void setLoggingConfigId(int LoggingConfigId) {

        this.LoggingConfigId = LoggingConfigId;

    }

    /**
     * Get the value for ComputerId.
     */
    public Integer getComputerId () {
        return ComputerId;
    }

    /**
     * Set ComputerId to the specified value.
     */
    public void setComputerId(Integer ComputerId) {

        // nullComputerId = false;

        this.ComputerId = ComputerId;

    }

    /*
     * Is the ComputerId null?
     */
    // public boolean isComputerIdNull() {
    //	return nullComputerId;
    // }

    /*
     * Set the null indicator for ComputerId
     */       
    // public void setComputerIdNull() {
    // 	nullComputerId = true;
    // }

    /**
     * Get the value for ImplLang.
     */
    public String getImplLang () {
        return ImplLang;
    }

    /**
     * Set ImplLang to the specified value.
     */
    public void setImplLang(String ImplLang) {

        this.ImplLang = ImplLang;

    }

    /**
     * Get the value for TypeModifiers.
     */
    public String getTypeModifiers () {
        return TypeModifiers;
    }

    /**
     * Set TypeModifiers to the specified value.
     */
    public void setTypeModifiers(String TypeModifiers) {

        // nullTypeModifiers = false;

        this.TypeModifiers = TypeModifiers;

    }

    /*
     * Is the TypeModifiers null?
     */
    // public boolean isTypeModifiersNull() {
    //	return nullTypeModifiers;
    // }

    /*
     * Set the null indicator for TypeModifiers
     */       
    // public void setTypeModifiersNull() {
    // 	nullTypeModifiers = true;
    // }

    /**
     * Get the value for RealTime.
     */
    public boolean getRealTime () {
        return RealTime;
    }

    /**
     * Set RealTime to the specified value.
     */
    public void setRealTime(boolean RealTime) {

        this.RealTime = RealTime;

    }

    /**
     * Get the value for RealTimeType.
     */
    public String getRealTimeType () {
        return RealTimeType;
    }

    /**
     * Set RealTimeType to the specified value.
     */
    public void setRealTimeType(String RealTimeType) {

        this.RealTimeType = RealTimeType;

    }

    /**
     * Get the value for KernelModuleLocation.
     */
    public String getKernelModuleLocation () {
        return KernelModuleLocation;
    }

    /**
     * Set KernelModuleLocation to the specified value.
     */
    public void setKernelModuleLocation(String KernelModuleLocation) {

        // nullKernelModuleLocation = false;

        this.KernelModuleLocation = KernelModuleLocation;

    }

    /*
     * Is the KernelModuleLocation null?
     */
    // public boolean isKernelModuleLocationNull() {
    //	return nullKernelModuleLocation;
    // }

    /*
     * Set the null indicator for KernelModuleLocation
     */       
    // public void setKernelModuleLocationNull() {
    // 	nullKernelModuleLocation = true;
    // }

    /**
     * Get the value for KernelModule.
     */
    public String getKernelModule () {
        return KernelModule;
    }

    /**
     * Set KernelModule to the specified value.
     */
    public void setKernelModule(String KernelModule) {

        // nullKernelModule = false;

        this.KernelModule = KernelModule;

    }

    /*
     * Is the KernelModule null?
     */
    // public boolean isKernelModuleNull() {
    //	return nullKernelModule;
    // }

    /*
     * Set the null indicator for KernelModule
     */       
    // public void setKernelModuleNull() {
    // 	nullKernelModule = true;
    // }

    /**
     * Get the value for AcsInstance.
     */
    public int getAcsInstance () {
        return AcsInstance;
    }

    /**
     * Set AcsInstance to the specified value.
     */
    public void setAcsInstance(int AcsInstance) {

        this.AcsInstance = AcsInstance;

    }

    /**
     * Get the value for CmdLineArgs.
     */
    public String getCmdLineArgs () {
        return CmdLineArgs;
    }

    /**
     * Set CmdLineArgs to the specified value.
     */
    public void setCmdLineArgs(String CmdLineArgs) {

        // nullCmdLineArgs = false;

        this.CmdLineArgs = CmdLineArgs;

    }

    /*
     * Is the CmdLineArgs null?
     */
    // public boolean isCmdLineArgsNull() {
    //	return nullCmdLineArgs;
    // }

    /*
     * Set the null indicator for CmdLineArgs
     */       
    // public void setCmdLineArgsNull() {
    // 	nullCmdLineArgs = true;
    // }

    /**
     * Get the value for KeepAliveTime.
     */
    public int getKeepAliveTime () {
        return KeepAliveTime;
    }

    /**
     * Set KeepAliveTime to the specified value.
     */
    public void setKeepAliveTime(int KeepAliveTime) {

        this.KeepAliveTime = KeepAliveTime;

    }

    /**
     * Get the value for ServerThreads.
     */
    public int getServerThreads () {
        return ServerThreads;
    }

    /**
     * Set ServerThreads to the specified value.
     */
    public void setServerThreads(int ServerThreads) {

        this.ServerThreads = ServerThreads;

    }

    /**
     * Get the value for ManagerRetry.
     */
    public int getManagerRetry () {
        return ManagerRetry;
    }

    /**
     * Set ManagerRetry to the specified value.
     */
    public void setManagerRetry(int ManagerRetry) {

        this.ManagerRetry = ManagerRetry;

    }

    /**
     * Get the value for CallTimeout.
     */
    public int getCallTimeout () {
        return CallTimeout;
    }

    /**
     * Set CallTimeout to the specified value.
     */
    public void setCallTimeout(int CallTimeout) {

        this.CallTimeout = CallTimeout;

    }

    /**
     * Get the value for Recovery.
     */
    public boolean getRecovery () {
        return Recovery;
    }

    /**
     * Set Recovery to the specified value.
     */
    public void setRecovery(boolean Recovery) {

        this.Recovery = Recovery;

    }

    /**
     * Get the value for AutoloadSharedLibs.
     */
    public String getAutoloadSharedLibs () {
        return AutoloadSharedLibs;
    }

    /**
     * Set AutoloadSharedLibs to the specified value.
     */
    public void setAutoloadSharedLibs(String AutoloadSharedLibs) {

        // nullAutoloadSharedLibs = false;

        this.AutoloadSharedLibs = AutoloadSharedLibs;

    }

    /*
     * Is the AutoloadSharedLibs null?
     */
    // public boolean isAutoloadSharedLibsNull() {
    //	return nullAutoloadSharedLibs;
    // }

    /*
     * Set the null indicator for AutoloadSharedLibs
     */       
    // public void setAutoloadSharedLibsNull() {
    // 	nullAutoloadSharedLibs = true;
    // }

}
