/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File Contact.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.ContactIDL;

/**

   * Key: ContactId is automatically generated from:  ContactName

 *
 */
public class Contact implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int ContactId;

    private String ContactName;

    private String Email;

    // private boolean nullEmail;

    private String Gsm;

    // private boolean nullGsm;

    /**
     * Default Constructor for Contact.  Setter methods must be used to insert data.
     */
    public Contact () {

        // nullEmail = true;

        // nullGsm = true;

    }

    /**
     * Create a Contact by specifiying all data values.
     */
    public Contact (

        int ContactId,

        String ContactName,

        String Email,

        String Gsm

    ) {

		setContactId(ContactId);

		setContactName(ContactName);

		setEmail(Email);

		setGsm(Gsm);

    }

    /**
     * Create a Contact by specifiying data values as an array of strings.
     */
    public Contact (String[] data) {
    	if (data.length != 4)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 4)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ContactId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ContactName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullEmail = true;
			// this.Email = null;

		} else {

			// nullEmail = false;

			this.Email = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullGsm = true;
			// this.Gsm = null;

		} else {

			// nullGsm = false;

			this.Gsm = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "Contact:" + newline;

        s += "\tContactId: " + ContactId + newline;

        s += "\tContactName: " + ContactName + newline;

    	// if (Email == null)
    	//	s += "\tEmail: null" + newline;
    	// else

        s += "\tEmail: " + Email + newline;

    	// if (Gsm == null)
    	//	s += "\tGsm: null" + newline;
    	// else

        s += "\tGsm: " + Gsm + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "Contact" + delimiter;  

        s += ContactId + delimiter;

        s += ContactName + delimiter;

        // if (nullEmail)
        // 	s += delimiter;
        // else

        	// s += Email + delimiter;

        // if (nullGsm)
        // 	s += delimiter;
        // else

        	// s += Gsm + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 4;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#Contact" + delimiter  

        	+ "ContactId" + delimiter

        	+ "ContactName" + delimiter

        	+ "Email" + delimiter

        	+ "Gsm" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof Contact)) return false;
    	Contact arg = (Contact) obj;

		if (this.ContactId != arg.ContactId)
			return false;

		if (this.ContactName == null) {	// Two null strings are equal
			if (arg.ContactName == null)
				return true;
			else
				return false;
		}
		if (!this.ContactName.equals(arg.ContactName))
			return false; 

		if (this.Email == null) {	// Two null strings are equal
			if (arg.Email == null)
				return true;
			else
				return false;
		}
		if (!this.Email.equals(arg.Email))
			return false; 

		if (this.Gsm == null) {	// Two null strings are equal
			if (arg.Gsm == null)
				return true;
			else
				return false;
		}
		if (!this.Gsm.equals(arg.Gsm))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public ContactIDL toIDL() {
    	ContactIDL x = new ContactIDL ();

		x.ContactId = this.ContactId;

		x.ContactName = this.ContactName;

		x.Email = this.Email;

        // x.nullEmail = this.nullEmail;

		x.Gsm = this.Gsm;

        // x.nullGsm = this.nullGsm;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(ContactIDL x) {

		this.ContactId = x.ContactId;

		this.ContactName = x.ContactName;

		this.Email = x.Email;

        // this.nullEmail = x.nullEmail;

		this.Gsm = x.Gsm;

        // this.nullGsm = x.nullGsm;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return ContactId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for Contact.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for ContactId.
     */
    public int getContactId () {
        return ContactId;
    }

    /**
     * Set ContactId to the specified value.
     */
    public void setContactId(int ContactId) {

        this.ContactId = ContactId;

    }

    /**
     * Get the value for ContactName.
     */
    public String getContactName () {
        return ContactName;
    }

    /**
     * Set ContactName to the specified value.
     */
    public void setContactName(String ContactName) {

        this.ContactName = ContactName;

    }

    /**
     * Get the value for Email.
     */
    public String getEmail () {
        return Email;
    }

    /**
     * Set Email to the specified value.
     */
    public void setEmail(String Email) {

        // nullEmail = false;

        this.Email = Email;

    }

    /*
     * Is the Email null?
     */
    // public boolean isEmailNull() {
    //	return nullEmail;
    // }

    /*
     * Set the null indicator for Email
     */       
    // public void setEmailNull() {
    // 	nullEmail = true;
    // }

    /**
     * Get the value for Gsm.
     */
    public String getGsm () {
        return Gsm;
    }

    /**
     * Set Gsm to the specified value.
     */
    public void setGsm(String Gsm) {

        // nullGsm = false;

        this.Gsm = Gsm;

    }

    /*
     * Is the Gsm null?
     */
    // public boolean isGsmNull() {
    //	return nullGsm;
    // }

    /*
     * Set the null indicator for Gsm
     */       
    // public void setGsmNull() {
    // 	nullGsm = true;
    // }

}
