/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File Configuration.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.ConfigurationIDL;

/**

 * The Configuration table is a major partitioning of the database.  The TMCDB is capable of supporting

 * multiple, independent configurations.  This is especially useful for simulations, for example; but it

 * also implies that TMCDB databases can be combined or split apart.

 * If a Configuration is kept in the database only for historical reasons, but it doesnt reflect

 * any hardware or simulation deployment, then its Active flag should be false.

   * Key: ConfigurationId is automatically generated from:  ConfigurationName

 *
 */
public class Configuration implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int ConfigurationId;

    private String ConfigurationName;

    private String FullName;

    private boolean Active;

    private String CreationTime;

    private String Description;

    /**
     * Default Constructor for Configuration.  Setter methods must be used to insert data.
     */
    public Configuration () {

    }

    /**
     * Create a Configuration by specifiying all data values.
     */
    public Configuration (

        int ConfigurationId,

        String ConfigurationName,

        String FullName,

        boolean Active,

        String CreationTime,

        String Description

    ) {

		setConfigurationId(ConfigurationId);

		setConfigurationName(ConfigurationName);

		setFullName(FullName);

		setActive(Active);

		setCreationTime(CreationTime);

		setDescription(Description);

    }

    /**
     * Create a Configuration by specifiying data values as an array of strings.
     */
    public Configuration (String[] data) {
    	if (data.length != 6)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 6)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.FullName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Active = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CreationTime = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Description = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "Configuration:" + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

        s += "\tConfigurationName: " + ConfigurationName + newline;

        s += "\tFullName: " + FullName + newline;

        s += "\tActive: " + Active + newline;

        s += "\tCreationTime: " + CreationTime + newline;

        s += "\tDescription: " + Description + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "Configuration" + delimiter;  

        s += ConfigurationId + delimiter;

        s += ConfigurationName + delimiter;

        s += FullName + delimiter;

        s += Active + delimiter;

        s += CreationTime + delimiter;

        s += Description + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 6;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#Configuration" + delimiter  

        	+ "ConfigurationId" + delimiter

        	+ "ConfigurationName" + delimiter

        	+ "FullName" + delimiter

        	+ "Active" + delimiter

        	+ "CreationTime" + delimiter

        	+ "Description" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof Configuration)) return false;
    	Configuration arg = (Configuration) obj;

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		if (this.ConfigurationName == null) {	// Two null strings are equal
			if (arg.ConfigurationName == null)
				return true;
			else
				return false;
		}
		if (!this.ConfigurationName.equals(arg.ConfigurationName))
			return false; 

		if (this.FullName == null) {	// Two null strings are equal
			if (arg.FullName == null)
				return true;
			else
				return false;
		}
		if (!this.FullName.equals(arg.FullName))
			return false; 

		if (this.Active != arg.Active)
			return false;

		if (this.CreationTime == null) {	// Two null strings are equal
			if (arg.CreationTime == null)
				return true;
			else
				return false;
		}
		if (!this.CreationTime.equals(arg.CreationTime))
			return false; 

		if (this.Description == null) {	// Two null strings are equal
			if (arg.Description == null)
				return true;
			else
				return false;
		}
		if (!this.Description.equals(arg.Description))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public ConfigurationIDL toIDL() {
    	ConfigurationIDL x = new ConfigurationIDL ();

		x.ConfigurationId = this.ConfigurationId;

		x.ConfigurationName = this.ConfigurationName;

		x.FullName = this.FullName;

		x.Active = this.Active;

		x.CreationTime = this.CreationTime;

		x.Description = this.Description;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(ConfigurationIDL x) {

		this.ConfigurationId = x.ConfigurationId;

		this.ConfigurationName = x.ConfigurationName;

		this.FullName = x.FullName;

		this.Active = x.Active;

		this.CreationTime = x.CreationTime;

		this.Description = x.Description;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return ConfigurationId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for Configuration.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

    /**
     * Get the value for ConfigurationName.
     */
    public String getConfigurationName () {
        return ConfigurationName;
    }

    /**
     * Set ConfigurationName to the specified value.
     */
    public void setConfigurationName(String ConfigurationName) {

        this.ConfigurationName = ConfigurationName;

    }

    /**
     * Get the value for FullName.
     */
    public String getFullName () {
        return FullName;
    }

    /**
     * Set FullName to the specified value.
     */
    public void setFullName(String FullName) {

        this.FullName = FullName;

    }

    /**
     * Get the value for Active.
     */
    public boolean getActive () {
        return Active;
    }

    /**
     * Set Active to the specified value.
     */
    public void setActive(boolean Active) {

        this.Active = Active;

    }

    /**
     * Get the value for CreationTime.
     */
    public String getCreationTime () {
        return CreationTime;
    }

    /**
     * Set CreationTime to the specified value.
     */
    public void setCreationTime(String CreationTime) {

        this.CreationTime = CreationTime;

    }

    /**
     * Get the value for Description.
     */
    public String getDescription () {
        return Description;
    }

    /**
     * Set Description to the specified value.
     */
    public void setDescription(String Description) {

        this.Description = Description;

    }

}
