/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File Computer.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.ComputerIDL;

/**

 * The entries in this table are the computers that belong to the configuration.

 * Included are the full host name, whether the computer is real-time or not, and whether it is a uni-processor or an SMP.

   * Key: ComputerId is automatically generated from:  ComputerName, ConfigurationId

 *
 */
public class Computer implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int ComputerId;

    private String ComputerName;

    private int ConfigurationId;

    private String HostName;

    private boolean RealTime;

    private String ProcessorType;

    private String PhysicalLocation;

    // private boolean nullPhysicalLocation;

    /**
     * Default Constructor for Computer.  Setter methods must be used to insert data.
     */
    public Computer () {

        // nullPhysicalLocation = true;

    }

    /**
     * Create a Computer by specifiying all data values.
     */
    public Computer (

        int ComputerId,

        String ComputerName,

        int ConfigurationId,

        String HostName,

        boolean RealTime,

        String ProcessorType,

        String PhysicalLocation

    ) {

		setComputerId(ComputerId);

		setComputerName(ComputerName);

		setConfigurationId(ConfigurationId);

		setHostName(HostName);

		setRealTime(RealTime);

		setProcessorType(ProcessorType);

		setPhysicalLocation(PhysicalLocation);

    }

    /**
     * Create a Computer by specifiying data values as an array of strings.
     */
    public Computer (String[] data) {
    	if (data.length != 7)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 7)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComputerId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComputerName = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.HostName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.RealTime = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ProcessorType = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullPhysicalLocation = true;
			// this.PhysicalLocation = null;

		} else {

			// nullPhysicalLocation = false;

			this.PhysicalLocation = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "Computer:" + newline;

        s += "\tComputerId: " + ComputerId + newline;

        s += "\tComputerName: " + ComputerName + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

        s += "\tHostName: " + HostName + newline;

        s += "\tRealTime: " + RealTime + newline;

        s += "\tProcessorType: " + ProcessorType + newline;

    	// if (PhysicalLocation == null)
    	//	s += "\tPhysicalLocation: null" + newline;
    	// else

        s += "\tPhysicalLocation: " + PhysicalLocation + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "Computer" + delimiter;  

        s += ComputerId + delimiter;

        s += ComputerName + delimiter;

        s += ConfigurationId + delimiter;

        s += HostName + delimiter;

        s += RealTime + delimiter;

        s += ProcessorType + delimiter;

        // if (nullPhysicalLocation)
        // 	s += delimiter;
        // else

        	// s += PhysicalLocation + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 7;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#Computer" + delimiter  

        	+ "ComputerId" + delimiter

        	+ "ComputerName" + delimiter

        	+ "ConfigurationId" + delimiter

        	+ "HostName" + delimiter

        	+ "RealTime" + delimiter

        	+ "ProcessorType" + delimiter

        	+ "PhysicalLocation" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof Computer)) return false;
    	Computer arg = (Computer) obj;

		if (this.ComputerId != arg.ComputerId)
			return false;

		if (this.ComputerName == null) {	// Two null strings are equal
			if (arg.ComputerName == null)
				return true;
			else
				return false;
		}
		if (!this.ComputerName.equals(arg.ComputerName))
			return false; 

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		if (this.HostName == null) {	// Two null strings are equal
			if (arg.HostName == null)
				return true;
			else
				return false;
		}
		if (!this.HostName.equals(arg.HostName))
			return false; 

		if (this.RealTime != arg.RealTime)
			return false;

		if (this.ProcessorType == null) {	// Two null strings are equal
			if (arg.ProcessorType == null)
				return true;
			else
				return false;
		}
		if (!this.ProcessorType.equals(arg.ProcessorType))
			return false; 

		if (this.PhysicalLocation == null) {	// Two null strings are equal
			if (arg.PhysicalLocation == null)
				return true;
			else
				return false;
		}
		if (!this.PhysicalLocation.equals(arg.PhysicalLocation))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public ComputerIDL toIDL() {
    	ComputerIDL x = new ComputerIDL ();

		x.ComputerId = this.ComputerId;

		x.ComputerName = this.ComputerName;

		x.ConfigurationId = this.ConfigurationId;

		x.HostName = this.HostName;

		x.RealTime = this.RealTime;

		x.ProcessorType = this.ProcessorType;

		x.PhysicalLocation = this.PhysicalLocation;

        // x.nullPhysicalLocation = this.nullPhysicalLocation;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(ComputerIDL x) {

		this.ComputerId = x.ComputerId;

		this.ComputerName = x.ComputerName;

		this.ConfigurationId = x.ConfigurationId;

		this.HostName = x.HostName;

		this.RealTime = x.RealTime;

		this.ProcessorType = x.ProcessorType;

		this.PhysicalLocation = x.PhysicalLocation;

        // this.nullPhysicalLocation = x.nullPhysicalLocation;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return ComputerId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for Computer.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for ComputerId.
     */
    public int getComputerId () {
        return ComputerId;
    }

    /**
     * Set ComputerId to the specified value.
     */
    public void setComputerId(int ComputerId) {

        this.ComputerId = ComputerId;

    }

    /**
     * Get the value for ComputerName.
     */
    public String getComputerName () {
        return ComputerName;
    }

    /**
     * Set ComputerName to the specified value.
     */
    public void setComputerName(String ComputerName) {

        this.ComputerName = ComputerName;

    }

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

    /**
     * Get the value for HostName.
     */
    public String getHostName () {
        return HostName;
    }

    /**
     * Set HostName to the specified value.
     */
    public void setHostName(String HostName) {

        this.HostName = HostName;

    }

    /**
     * Get the value for RealTime.
     */
    public boolean getRealTime () {
        return RealTime;
    }

    /**
     * Set RealTime to the specified value.
     */
    public void setRealTime(boolean RealTime) {

        this.RealTime = RealTime;

    }

    /**
     * Get the value for ProcessorType.
     */
    public String getProcessorType () {
        return ProcessorType;
    }

    /**
     * Set ProcessorType to the specified value.
     */
    public void setProcessorType(String ProcessorType) {

        this.ProcessorType = ProcessorType;

    }

    /**
     * Get the value for PhysicalLocation.
     */
    public String getPhysicalLocation () {
        return PhysicalLocation;
    }

    /**
     * Set PhysicalLocation to the specified value.
     */
    public void setPhysicalLocation(String PhysicalLocation) {

        // nullPhysicalLocation = false;

        this.PhysicalLocation = PhysicalLocation;

    }

    /*
     * Is the PhysicalLocation null?
     */
    // public boolean isPhysicalLocationNull() {
    //	return nullPhysicalLocation;
    // }

    /*
     * Set the null indicator for PhysicalLocation
     */       
    // public void setPhysicalLocationNull() {
    // 	nullPhysicalLocation = true;
    // }

}
