/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File ComponentType.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.ComponentTypeIDL;

/**

 * The ComponentType  characterizes a "type" of component.

 * For example, the DataCapture component is dynamically created by Control

 * whenever a scheduling blocks is executed.

 * The ComponentType table can be used to describe this kind of component.

   * Key: ComponentTypeId is automatically generated from:  IDL

 *
 */
public class ComponentType implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int ComponentTypeId;

    private String IDL;

    private String URN;

    // private boolean nullURN;

    /**
     * Default Constructor for ComponentType.  Setter methods must be used to insert data.
     */
    public ComponentType () {

        // nullURN = true;

    }

    /**
     * Create a ComponentType by specifiying all data values.
     */
    public ComponentType (

        int ComponentTypeId,

        String IDL,

        String URN

    ) {

		setComponentTypeId(ComponentTypeId);

		setIDL(IDL);

		setURN(URN);

    }

    /**
     * Create a ComponentType by specifiying data values as an array of strings.
     */
    public ComponentType (String[] data) {
    	if (data.length != 3)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 3)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComponentTypeId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.IDL = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullURN = true;
			// this.URN = null;

		} else {

			// nullURN = false;

			this.URN = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "ComponentType:" + newline;

        s += "\tComponentTypeId: " + ComponentTypeId + newline;

        s += "\tIDL: " + IDL + newline;

    	// if (URN == null)
    	//	s += "\tURN: null" + newline;
    	// else

        s += "\tURN: " + URN + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "ComponentType" + delimiter;  

        s += ComponentTypeId + delimiter;

        s += IDL + delimiter;

        // if (nullURN)
        // 	s += delimiter;
        // else

        	// s += URN + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 3;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#ComponentType" + delimiter  

        	+ "ComponentTypeId" + delimiter

        	+ "IDL" + delimiter

        	+ "URN" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof ComponentType)) return false;
    	ComponentType arg = (ComponentType) obj;

		if (this.ComponentTypeId != arg.ComponentTypeId)
			return false;

		if (this.IDL == null) {	// Two null strings are equal
			if (arg.IDL == null)
				return true;
			else
				return false;
		}
		if (!this.IDL.equals(arg.IDL))
			return false; 

		if (this.URN == null) {	// Two null strings are equal
			if (arg.URN == null)
				return true;
			else
				return false;
		}
		if (!this.URN.equals(arg.URN))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public ComponentTypeIDL toIDL() {
    	ComponentTypeIDL x = new ComponentTypeIDL ();

		x.ComponentTypeId = this.ComponentTypeId;

		x.IDL = this.IDL;

		x.URN = this.URN;

        // x.nullURN = this.nullURN;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(ComponentTypeIDL x) {

		this.ComponentTypeId = x.ComponentTypeId;

		this.IDL = x.IDL;

		this.URN = x.URN;

        // this.nullURN = x.nullURN;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return ComponentTypeId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for ComponentType.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for ComponentTypeId.
     */
    public int getComponentTypeId () {
        return ComponentTypeId;
    }

    /**
     * Set ComponentTypeId to the specified value.
     */
    public void setComponentTypeId(int ComponentTypeId) {

        this.ComponentTypeId = ComponentTypeId;

    }

    /**
     * Get the value for IDL.
     */
    public String getIDL () {
        return IDL;
    }

    /**
     * Set IDL to the specified value.
     */
    public void setIDL(String IDL) {

        this.IDL = IDL;

    }

    /**
     * Get the value for URN.
     */
    public String getURN () {
        return URN;
    }

    /**
     * Set URN to the specified value.
     */
    public void setURN(String URN) {

        // nullURN = false;

        this.URN = URN;

    }

    /*
     * Is the URN null?
     */
    // public boolean isURNNull() {
    //	return nullURN;
    // }

    /*
     * Set the null indicator for URN
     */       
    // public void setURNNull() {
    // 	nullURN = true;
    // }

}
