/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File ComponentExecution.java
 */
package alma.TMCDB.generated;

import alma.TMCDB.types.ArrayTime;

import alma.TMCDB_GEN_IDL.ComponentExecutionIDL;

/**

 * Entries in the ComponentExecution table record when a component was executed in a particular container.

 * There is an implied constraint here: components must run in containers that support their type and

 * real-time status.

   * Key: ComponentExecutionId is automatically generated from:  ComponentId, StartTime, ConfigurationId

 *
 */
public class ComponentExecution implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int ComponentExecutionId;

    private long ComponentExecutionAcsId;

    private int ComponentId;

    private int ConfigurationId;

    private int ContainerId;

    private ArrayTime StartTime;

    private ArrayTime EndTime;

    // private boolean nullEndTime;

    private boolean NormalStart;

    private boolean NormalTermination;

    private Integer BaseElementOnlineId;

    // private boolean nullBaseElementOnlineId;

    private Integer AssemblyId;

    // private boolean nullAssemblyId;

    /**
     * Default Constructor for ComponentExecution.  Setter methods must be used to insert data.
     */
    public ComponentExecution () {

        // nullEndTime = true;

        // nullBaseElementOnlineId = true;

        // nullAssemblyId = true;

    }

    /**
     * Create a ComponentExecution by specifiying all data values.
     */
    public ComponentExecution (

        int ComponentExecutionId,

        long ComponentExecutionAcsId,

        int ComponentId,

        int ConfigurationId,

        int ContainerId,

        ArrayTime StartTime,

        ArrayTime EndTime,

        boolean NormalStart,

        boolean NormalTermination,

        Integer BaseElementOnlineId,

        Integer AssemblyId

    ) {

		setComponentExecutionId(ComponentExecutionId);

		setComponentExecutionAcsId(ComponentExecutionAcsId);

		setComponentId(ComponentId);

		setConfigurationId(ConfigurationId);

		setContainerId(ContainerId);

		setStartTime(StartTime);

		setEndTime(EndTime);

		setNormalStart(NormalStart);

		setNormalTermination(NormalTermination);

		setBaseElementOnlineId(BaseElementOnlineId);

		setAssemblyId(AssemblyId);

    }

    /**
     * Create a ComponentExecution by specifiying data values as an array of strings.
     */
    public ComponentExecution (String[] data) {
    	if (data.length != 11)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 11)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComponentExecutionId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComponentExecutionAcsId = new Long(Long.parseLong(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComponentId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ContainerId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StartTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullEndTime = true;
			// this.EndTime = null;

		} else {

			// nullEndTime = false;

			this.EndTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NormalStart = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NormalTermination = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullBaseElementOnlineId = true;
			// this.BaseElementOnlineId = null;

		} else {

			// nullBaseElementOnlineId = false;

			this.BaseElementOnlineId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullAssemblyId = true;
			// this.AssemblyId = null;

		} else {

			// nullAssemblyId = false;

			this.AssemblyId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "ComponentExecution:" + newline;

        s += "\tComponentExecutionId: " + ComponentExecutionId + newline;

        s += "\tComponentExecutionAcsId: " + ComponentExecutionAcsId + newline;

        s += "\tComponentId: " + ComponentId + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

        s += "\tContainerId: " + ContainerId + newline;

        s += "\tStartTime: " + StartTime.toFITS() + newline;

    	// if (EndTime == null)
    	//	s += "\tEndTime: null" + newline;
    	// else

        s += "\tEndTime: " + EndTime.toFITS() + newline;

        s += "\tNormalStart: " + NormalStart + newline;

        s += "\tNormalTermination: " + NormalTermination + newline;

    	// if (BaseElementOnlineId == null)
    	//	s += "\tBaseElementOnlineId: null" + newline;
    	// else

        s += "\tBaseElementOnlineId: " + BaseElementOnlineId + newline;

    	// if (AssemblyId == null)
    	//	s += "\tAssemblyId: null" + newline;
    	// else

        s += "\tAssemblyId: " + AssemblyId + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "ComponentExecution" + delimiter;  

        s += ComponentExecutionId + delimiter;

        s += ComponentExecutionAcsId + delimiter;

        s += ComponentId + delimiter;

        s += ConfigurationId + delimiter;

        s += ContainerId + delimiter;

		s += new String(StartTime.toFITS()) + delimiter;

        // if (nullEndTime)
        // 	s += delimiter;
        // else

		// s += new String(EndTime.toFITS()) + delimiter;

        s += NormalStart + delimiter;

        s += NormalTermination + delimiter;

        // if (nullBaseElementOnlineId)
        // 	s += delimiter;
        // else

        	// s += BaseElementOnlineId + delimiter;

        // if (nullAssemblyId)
        // 	s += delimiter;
        // else

        	// s += AssemblyId + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 11;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#ComponentExecution" + delimiter  

        	+ "ComponentExecutionId" + delimiter

        	+ "ComponentExecutionAcsId" + delimiter

        	+ "ComponentId" + delimiter

        	+ "ConfigurationId" + delimiter

        	+ "ContainerId" + delimiter

        	+ "StartTime" + delimiter

        	+ "EndTime" + delimiter

        	+ "NormalStart" + delimiter

        	+ "NormalTermination" + delimiter

        	+ "BaseElementOnlineId" + delimiter

        	+ "AssemblyId" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof ComponentExecution)) return false;
    	ComponentExecution arg = (ComponentExecution) obj;

		if (this.ComponentExecutionId != arg.ComponentExecutionId)
			return false;

		if (this.ComponentExecutionAcsId != arg.ComponentExecutionAcsId)
			return false;

		if (this.ComponentId != arg.ComponentId)
			return false;

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		if (this.ContainerId != arg.ContainerId)
			return false;

		if (this.StartTime.get() != arg.StartTime.get())
			return false;

		if (this.EndTime.get() != arg.EndTime.get())
			return false;

		if (this.NormalStart != arg.NormalStart)
			return false;

		if (this.NormalTermination != arg.NormalTermination)
			return false;

		if (this.BaseElementOnlineId != arg.BaseElementOnlineId)
			return false;

		if (this.AssemblyId != arg.AssemblyId)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public ComponentExecutionIDL toIDL() {
    	ComponentExecutionIDL x = new ComponentExecutionIDL ();

		x.ComponentExecutionId = this.ComponentExecutionId;

		x.ComponentExecutionAcsId = this.ComponentExecutionAcsId;

		x.ComponentId = this.ComponentId;

		x.ConfigurationId = this.ConfigurationId;

		x.ContainerId = this.ContainerId;

		x.StartTime = this.StartTime.toIDLArrayTime();

		x.EndTime = this.EndTime.toIDLArrayTime();

        // x.nullEndTime = this.nullEndTime;

		x.NormalStart = this.NormalStart;

		x.NormalTermination = this.NormalTermination;

		x.BaseElementOnlineId = this.BaseElementOnlineId;

        // x.nullBaseElementOnlineId = this.nullBaseElementOnlineId;

		x.AssemblyId = this.AssemblyId;

        // x.nullAssemblyId = this.nullAssemblyId;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(ComponentExecutionIDL x) {

		this.ComponentExecutionId = x.ComponentExecutionId;

		this.ComponentExecutionAcsId = x.ComponentExecutionAcsId;

		this.ComponentId = x.ComponentId;

		this.ConfigurationId = x.ConfigurationId;

		this.ContainerId = x.ContainerId;

		this.StartTime = new ArrayTime(x.StartTime);

		this.EndTime = new ArrayTime(x.EndTime);

        // this.nullEndTime = x.nullEndTime;

		this.NormalStart = x.NormalStart;

		this.NormalTermination = x.NormalTermination;

		this.BaseElementOnlineId = x.BaseElementOnlineId;

        // this.nullBaseElementOnlineId = x.nullBaseElementOnlineId;

		this.AssemblyId = x.AssemblyId;

        // this.nullAssemblyId = x.nullAssemblyId;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return ComponentExecutionId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for ComponentExecution.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for ComponentExecutionId.
     */
    public int getComponentExecutionId () {
        return ComponentExecutionId;
    }

    /**
     * Set ComponentExecutionId to the specified value.
     */
    public void setComponentExecutionId(int ComponentExecutionId) {

        this.ComponentExecutionId = ComponentExecutionId;

    }

    /**
     * Get the value for ComponentExecutionAcsId.
     */
    public long getComponentExecutionAcsId () {
        return ComponentExecutionAcsId;
    }

    /**
     * Set ComponentExecutionAcsId to the specified value.
     */
    public void setComponentExecutionAcsId(long ComponentExecutionAcsId) {

        this.ComponentExecutionAcsId = ComponentExecutionAcsId;

    }

    /**
     * Get the value for ComponentId.
     */
    public int getComponentId () {
        return ComponentId;
    }

    /**
     * Set ComponentId to the specified value.
     */
    public void setComponentId(int ComponentId) {

        this.ComponentId = ComponentId;

    }

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

    /**
     * Get the value for ContainerId.
     */
    public int getContainerId () {
        return ContainerId;
    }

    /**
     * Set ContainerId to the specified value.
     */
    public void setContainerId(int ContainerId) {

        this.ContainerId = ContainerId;

    }

    /**
     * Get the value for StartTime.
     */
    public ArrayTime getStartTime () {
        return StartTime;
    }

    /**
     * Set StartTime to the specified value.
     */
    public void setStartTime(ArrayTime StartTime) {

        this.StartTime = StartTime;

    }

    /**
     * Get the value for EndTime.
     */
    public ArrayTime getEndTime () {
        return EndTime;
    }

    /**
     * Set EndTime to the specified value.
     */
    public void setEndTime(ArrayTime EndTime) {

        // nullEndTime = false;

        this.EndTime = EndTime;

    }

    /*
     * Is the EndTime null?
     */
    // public boolean isEndTimeNull() {
    //	return nullEndTime;
    // }

    /*
     * Set the null indicator for EndTime
     */       
    // public void setEndTimeNull() {
    // 	nullEndTime = true;
    // }

    /**
     * Get the value for NormalStart.
     */
    public boolean getNormalStart () {
        return NormalStart;
    }

    /**
     * Set NormalStart to the specified value.
     */
    public void setNormalStart(boolean NormalStart) {

        this.NormalStart = NormalStart;

    }

    /**
     * Get the value for NormalTermination.
     */
    public boolean getNormalTermination () {
        return NormalTermination;
    }

    /**
     * Set NormalTermination to the specified value.
     */
    public void setNormalTermination(boolean NormalTermination) {

        this.NormalTermination = NormalTermination;

    }

    /**
     * Get the value for BaseElementOnlineId.
     */
    public Integer getBaseElementOnlineId () {
        return BaseElementOnlineId;
    }

    /**
     * Set BaseElementOnlineId to the specified value.
     */
    public void setBaseElementOnlineId(Integer BaseElementOnlineId) {

        // nullBaseElementOnlineId = false;

        this.BaseElementOnlineId = BaseElementOnlineId;

    }

    /*
     * Is the BaseElementOnlineId null?
     */
    // public boolean isBaseElementOnlineIdNull() {
    //	return nullBaseElementOnlineId;
    // }

    /*
     * Set the null indicator for BaseElementOnlineId
     */       
    // public void setBaseElementOnlineIdNull() {
    // 	nullBaseElementOnlineId = true;
    // }

    /**
     * Get the value for AssemblyId.
     */
    public Integer getAssemblyId () {
        return AssemblyId;
    }

    /**
     * Set AssemblyId to the specified value.
     */
    public void setAssemblyId(Integer AssemblyId) {

        // nullAssemblyId = false;

        this.AssemblyId = AssemblyId;

    }

    /*
     * Is the AssemblyId null?
     */
    // public boolean isAssemblyIdNull() {
    //	return nullAssemblyId;
    // }

    /*
     * Set the null indicator for AssemblyId
     */       
    // public void setAssemblyIdNull() {
    // 	nullAssemblyId = true;
    // }

}
