/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File BaseElementStartup.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.BaseElementStartupIDL;

/**

 * The BaseElementStartup table specifies which base elements are to be started.

   * Key: BaseElementStartupId is automatically generated from:  StartupId, BaseElementId, Parent, BaseElementType

 *
 */
public class BaseElementStartup implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int BaseElementStartupId;

    private Integer BaseElementId;

    // private boolean nullBaseElementId;

    private Integer StartupId;

    // private boolean nullStartupId;

    private String BaseElementType;

    private Integer Parent;

    // private boolean nullParent;

    private String IsGeneric;

    /**
     * Default Constructor for BaseElementStartup.  Setter methods must be used to insert data.
     */
    public BaseElementStartup () {

        // nullBaseElementId = true;

        // nullStartupId = true;

        // nullParent = true;

    }

    /**
     * Create a BaseElementStartup by specifiying all data values.
     */
    public BaseElementStartup (

        int BaseElementStartupId,

        Integer BaseElementId,

        Integer StartupId,

        String BaseElementType,

        Integer Parent,

        String IsGeneric

    ) {

		setBaseElementStartupId(BaseElementStartupId);

		setBaseElementId(BaseElementId);

		setStartupId(StartupId);

		setBaseElementType(BaseElementType);

		setParent(Parent);

		setIsGeneric(IsGeneric);

    }

    /**
     * Create a BaseElementStartup by specifiying data values as an array of strings.
     */
    public BaseElementStartup (String[] data) {
    	if (data.length != 6)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 6)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementStartupId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullBaseElementId = true;
			// this.BaseElementId = null;

		} else {

			// nullBaseElementId = false;

			this.BaseElementId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullStartupId = true;
			// this.StartupId = null;

		} else {

			// nullStartupId = false;

			this.StartupId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementType = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullParent = true;
			// this.Parent = null;

		} else {

			// nullParent = false;

			this.Parent = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.IsGeneric = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "BaseElementStartup:" + newline;

        s += "\tBaseElementStartupId: " + BaseElementStartupId + newline;

    	// if (BaseElementId == null)
    	//	s += "\tBaseElementId: null" + newline;
    	// else

        s += "\tBaseElementId: " + BaseElementId + newline;

    	// if (StartupId == null)
    	//	s += "\tStartupId: null" + newline;
    	// else

        s += "\tStartupId: " + StartupId + newline;

        s += "\tBaseElementType: " + BaseElementType + newline;

    	// if (Parent == null)
    	//	s += "\tParent: null" + newline;
    	// else

        s += "\tParent: " + Parent + newline;

        s += "\tIsGeneric: " + IsGeneric + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "BaseElementStartup" + delimiter;  

        s += BaseElementStartupId + delimiter;

        // if (nullBaseElementId)
        // 	s += delimiter;
        // else

        	// s += BaseElementId + delimiter;

        // if (nullStartupId)
        // 	s += delimiter;
        // else

        	// s += StartupId + delimiter;

        s += BaseElementType + delimiter;

        // if (nullParent)
        // 	s += delimiter;
        // else

        	// s += Parent + delimiter;

        s += IsGeneric + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 6;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#BaseElementStartup" + delimiter  

        	+ "BaseElementStartupId" + delimiter

        	+ "BaseElementId" + delimiter

        	+ "StartupId" + delimiter

        	+ "BaseElementType" + delimiter

        	+ "Parent" + delimiter

        	+ "IsGeneric" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof BaseElementStartup)) return false;
    	BaseElementStartup arg = (BaseElementStartup) obj;

		if (this.BaseElementStartupId != arg.BaseElementStartupId)
			return false;

		if (this.BaseElementId != arg.BaseElementId)
			return false;

		if (this.StartupId != arg.StartupId)
			return false;

		if (this.BaseElementType == null) {	// Two null strings are equal
			if (arg.BaseElementType == null)
				return true;
			else
				return false;
		}
		if (!this.BaseElementType.equals(arg.BaseElementType))
			return false; 

		if (this.Parent != arg.Parent)
			return false;

		if (this.IsGeneric == null) {	// Two null strings are equal
			if (arg.IsGeneric == null)
				return true;
			else
				return false;
		}
		if (!this.IsGeneric.equals(arg.IsGeneric))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public BaseElementStartupIDL toIDL() {
    	BaseElementStartupIDL x = new BaseElementStartupIDL ();

		x.BaseElementStartupId = this.BaseElementStartupId;

		x.BaseElementId = this.BaseElementId;

        // x.nullBaseElementId = this.nullBaseElementId;

		x.StartupId = this.StartupId;

        // x.nullStartupId = this.nullStartupId;

		x.BaseElementType = this.BaseElementType;

		x.Parent = this.Parent;

        // x.nullParent = this.nullParent;

		x.IsGeneric = this.IsGeneric;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(BaseElementStartupIDL x) {

		this.BaseElementStartupId = x.BaseElementStartupId;

		this.BaseElementId = x.BaseElementId;

        // this.nullBaseElementId = x.nullBaseElementId;

		this.StartupId = x.StartupId;

        // this.nullStartupId = x.nullStartupId;

		this.BaseElementType = x.BaseElementType;

		this.Parent = x.Parent;

        // this.nullParent = x.nullParent;

		this.IsGeneric = x.IsGeneric;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return BaseElementStartupId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for BaseElementStartup.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for BaseElementStartupId.
     */
    public int getBaseElementStartupId () {
        return BaseElementStartupId;
    }

    /**
     * Set BaseElementStartupId to the specified value.
     */
    public void setBaseElementStartupId(int BaseElementStartupId) {

        this.BaseElementStartupId = BaseElementStartupId;

    }

    /**
     * Get the value for BaseElementId.
     */
    public Integer getBaseElementId () {
        return BaseElementId;
    }

    /**
     * Set BaseElementId to the specified value.
     */
    public void setBaseElementId(Integer BaseElementId) {

        // nullBaseElementId = false;

        this.BaseElementId = BaseElementId;

    }

    /*
     * Is the BaseElementId null?
     */
    // public boolean isBaseElementIdNull() {
    //	return nullBaseElementId;
    // }

    /*
     * Set the null indicator for BaseElementId
     */       
    // public void setBaseElementIdNull() {
    // 	nullBaseElementId = true;
    // }

    /**
     * Get the value for StartupId.
     */
    public Integer getStartupId () {
        return StartupId;
    }

    /**
     * Set StartupId to the specified value.
     */
    public void setStartupId(Integer StartupId) {

        // nullStartupId = false;

        this.StartupId = StartupId;

    }

    /*
     * Is the StartupId null?
     */
    // public boolean isStartupIdNull() {
    //	return nullStartupId;
    // }

    /*
     * Set the null indicator for StartupId
     */       
    // public void setStartupIdNull() {
    // 	nullStartupId = true;
    // }

    /**
     * Get the value for BaseElementType.
     */
    public String getBaseElementType () {
        return BaseElementType;
    }

    /**
     * Set BaseElementType to the specified value.
     */
    public void setBaseElementType(String BaseElementType) {

        this.BaseElementType = BaseElementType;

    }

    /**
     * Get the value for Parent.
     */
    public Integer getParent () {
        return Parent;
    }

    /**
     * Set Parent to the specified value.
     */
    public void setParent(Integer Parent) {

        // nullParent = false;

        this.Parent = Parent;

    }

    /*
     * Is the Parent null?
     */
    // public boolean isParentNull() {
    //	return nullParent;
    // }

    /*
     * Set the null indicator for Parent
     */       
    // public void setParentNull() {
    // 	nullParent = true;
    // }

    /**
     * Get the value for IsGeneric.
     */
    public String getIsGeneric () {
        return IsGeneric;
    }

    /**
     * Set IsGeneric to the specified value.
     */
    public void setIsGeneric(String IsGeneric) {

        this.IsGeneric = IsGeneric;

    }

}
