/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File BaseElementOnline.java
 */
package alma.TMCDB.generated;

import alma.TMCDB.types.ArrayTime;

import alma.TMCDB_GEN_IDL.BaseElementOnlineIDL;

/**

 * The BaseElementOnline table provides a list of the base elements that are online.

 * A base element is one of a set of high-level structures that make up the ALMA telescope.  This set includes: Antenna, Pad, Weather Station, Correlator, Master Clock, Central Rack, Holography Tower, and Array.

 * BaseElementOnlineId is the unique key.  It is auto-generated as entries are added to the table.  The real unique key is BaseElementId plus ConfigurationId plus StartTime.

 * Array is included here because arrays change how the antennas are commanded.  The array that is represented here are the arrays that Scheduling defines, for example, the baseline array and the ACA array, not the detailed sub-arrays that are created within an observing script.  Furthermore, this array concept keeps track of scheduling blocks executed on the array, thus tying the TMCDB to the project and science databases.

 * The data associated with these base elements are dependent on the configuration, but not on a system execution; i.e., they may be shared between system executions within the same configuration.  If anything changes in a base element, a new base element entry is created and it becomes a part of a new base element online instance.

   * Key: BaseElementOnlineId is automatically generated from:  BaseElementId, ConfigurationId, StartTime

 *
 */
public class BaseElementOnline implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int BaseElementOnlineId;

    private int BaseElementId;

    private int ConfigurationId;

    private ArrayTime StartTime;

    private ArrayTime EndTime;

    // private boolean nullEndTime;

    private boolean NormalTermination;

    /**
     * Default Constructor for BaseElementOnline.  Setter methods must be used to insert data.
     */
    public BaseElementOnline () {

        // nullEndTime = true;

    }

    /**
     * Create a BaseElementOnline by specifiying all data values.
     */
    public BaseElementOnline (

        int BaseElementOnlineId,

        int BaseElementId,

        int ConfigurationId,

        ArrayTime StartTime,

        ArrayTime EndTime,

        boolean NormalTermination

    ) {

		setBaseElementOnlineId(BaseElementOnlineId);

		setBaseElementId(BaseElementId);

		setConfigurationId(ConfigurationId);

		setStartTime(StartTime);

		setEndTime(EndTime);

		setNormalTermination(NormalTermination);

    }

    /**
     * Create a BaseElementOnline by specifiying data values as an array of strings.
     */
    public BaseElementOnline (String[] data) {
    	if (data.length != 6)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 6)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementOnlineId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StartTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullEndTime = true;
			// this.EndTime = null;

		} else {

			// nullEndTime = false;

			this.EndTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NormalTermination = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "BaseElementOnline:" + newline;

        s += "\tBaseElementOnlineId: " + BaseElementOnlineId + newline;

        s += "\tBaseElementId: " + BaseElementId + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

        s += "\tStartTime: " + StartTime.toFITS() + newline;

    	// if (EndTime == null)
    	//	s += "\tEndTime: null" + newline;
    	// else

        s += "\tEndTime: " + EndTime.toFITS() + newline;

        s += "\tNormalTermination: " + NormalTermination + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "BaseElementOnline" + delimiter;  

        s += BaseElementOnlineId + delimiter;

        s += BaseElementId + delimiter;

        s += ConfigurationId + delimiter;

		s += new String(StartTime.toFITS()) + delimiter;

        // if (nullEndTime)
        // 	s += delimiter;
        // else

		// s += new String(EndTime.toFITS()) + delimiter;

        s += NormalTermination + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 6;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#BaseElementOnline" + delimiter  

        	+ "BaseElementOnlineId" + delimiter

        	+ "BaseElementId" + delimiter

        	+ "ConfigurationId" + delimiter

        	+ "StartTime" + delimiter

        	+ "EndTime" + delimiter

        	+ "NormalTermination" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof BaseElementOnline)) return false;
    	BaseElementOnline arg = (BaseElementOnline) obj;

		if (this.BaseElementOnlineId != arg.BaseElementOnlineId)
			return false;

		if (this.BaseElementId != arg.BaseElementId)
			return false;

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		if (this.StartTime.get() != arg.StartTime.get())
			return false;

		if (this.EndTime.get() != arg.EndTime.get())
			return false;

		if (this.NormalTermination != arg.NormalTermination)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public BaseElementOnlineIDL toIDL() {
    	BaseElementOnlineIDL x = new BaseElementOnlineIDL ();

		x.BaseElementOnlineId = this.BaseElementOnlineId;

		x.BaseElementId = this.BaseElementId;

		x.ConfigurationId = this.ConfigurationId;

		x.StartTime = this.StartTime.toIDLArrayTime();

		x.EndTime = this.EndTime.toIDLArrayTime();

        // x.nullEndTime = this.nullEndTime;

		x.NormalTermination = this.NormalTermination;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(BaseElementOnlineIDL x) {

		this.BaseElementOnlineId = x.BaseElementOnlineId;

		this.BaseElementId = x.BaseElementId;

		this.ConfigurationId = x.ConfigurationId;

		this.StartTime = new ArrayTime(x.StartTime);

		this.EndTime = new ArrayTime(x.EndTime);

        // this.nullEndTime = x.nullEndTime;

		this.NormalTermination = x.NormalTermination;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return BaseElementOnlineId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for BaseElementOnline.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for BaseElementOnlineId.
     */
    public int getBaseElementOnlineId () {
        return BaseElementOnlineId;
    }

    /**
     * Set BaseElementOnlineId to the specified value.
     */
    public void setBaseElementOnlineId(int BaseElementOnlineId) {

        this.BaseElementOnlineId = BaseElementOnlineId;

    }

    /**
     * Get the value for BaseElementId.
     */
    public int getBaseElementId () {
        return BaseElementId;
    }

    /**
     * Set BaseElementId to the specified value.
     */
    public void setBaseElementId(int BaseElementId) {

        this.BaseElementId = BaseElementId;

    }

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

    /**
     * Get the value for StartTime.
     */
    public ArrayTime getStartTime () {
        return StartTime;
    }

    /**
     * Set StartTime to the specified value.
     */
    public void setStartTime(ArrayTime StartTime) {

        this.StartTime = StartTime;

    }

    /**
     * Get the value for EndTime.
     */
    public ArrayTime getEndTime () {
        return EndTime;
    }

    /**
     * Set EndTime to the specified value.
     */
    public void setEndTime(ArrayTime EndTime) {

        // nullEndTime = false;

        this.EndTime = EndTime;

    }

    /*
     * Is the EndTime null?
     */
    // public boolean isEndTimeNull() {
    //	return nullEndTime;
    // }

    /*
     * Set the null indicator for EndTime
     */       
    // public void setEndTimeNull() {
    // 	nullEndTime = true;
    // }

    /**
     * Get the value for NormalTermination.
     */
    public boolean getNormalTermination () {
        return NormalTermination;
    }

    /**
     * Set NormalTermination to the specified value.
     */
    public void setNormalTermination(boolean NormalTermination) {

        this.NormalTermination = NormalTermination;

    }

}
