/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File BaseElementAssemblyList.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.BaseElementAssemblyListIDL;

/**

 * The BaseElementAssemblyList gives the list of assemblies that belong to the assembly group of

 * the indicated base element.

 * The base element assemblies may be grouped with an associated name.  If GroupName is not NULL

 * then this assembly is a member of that group; otherwise, it is not part of a group.  The members

 * of the list may or may not be ordered. The ordering is relative to a group.

 * GroupName is used by the correlator in conjunction with racks and bins.  The GroupName is

 * "RackName.BinName" and the assemblies within such a group must be ordered.

   * Key: AssemblyId, BaseElementOnlineId

 *
 */
public class BaseElementAssemblyList implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int AssemblyId;

    private int BaseElementOnlineId;

    private String GroupName;

    // private boolean nullGroupName;

    private Integer OrderTag;

    // private boolean nullOrderTag;

    private int ComponentId;

    private String RoleName;

    // private boolean nullRoleName;

    private Integer ChannelNumber;

    // private boolean nullChannelNumber;

    private String NodeAddress;

    // private boolean nullNodeAddress;

    private String BaseAddress;

    // private boolean nullBaseAddress;

    /**
     * Default Constructor for BaseElementAssemblyList.  Setter methods must be used to insert data.
     */
    public BaseElementAssemblyList () {

        // nullGroupName = true;

        // nullOrderTag = true;

        // nullRoleName = true;

        // nullChannelNumber = true;

        // nullNodeAddress = true;

        // nullBaseAddress = true;

    }

    /**
     * Create a BaseElementAssemblyList by specifiying all data values.
     */
    public BaseElementAssemblyList (

        int AssemblyId,

        int BaseElementOnlineId,

        String GroupName,

        Integer OrderTag,

        int ComponentId,

        String RoleName,

        Integer ChannelNumber,

        String NodeAddress,

        String BaseAddress

    ) {

		setAssemblyId(AssemblyId);

		setBaseElementOnlineId(BaseElementOnlineId);

		setGroupName(GroupName);

		setOrderTag(OrderTag);

		setComponentId(ComponentId);

		setRoleName(RoleName);

		setChannelNumber(ChannelNumber);

		setNodeAddress(NodeAddress);

		setBaseAddress(BaseAddress);

    }

    /**
     * Create a BaseElementAssemblyList by specifiying data values as an array of strings.
     */
    public BaseElementAssemblyList (String[] data) {
    	if (data.length != 9)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 9)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AssemblyId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementOnlineId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullGroupName = true;
			// this.GroupName = null;

		} else {

			// nullGroupName = false;

			this.GroupName = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullOrderTag = true;
			// this.OrderTag = null;

		} else {

			// nullOrderTag = false;

			this.OrderTag = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComponentId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullRoleName = true;
			// this.RoleName = null;

		} else {

			// nullRoleName = false;

			this.RoleName = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullChannelNumber = true;
			// this.ChannelNumber = null;

		} else {

			// nullChannelNumber = false;

			this.ChannelNumber = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullNodeAddress = true;
			// this.NodeAddress = null;

		} else {

			// nullNodeAddress = false;

			this.NodeAddress = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullBaseAddress = true;
			// this.BaseAddress = null;

		} else {

			// nullBaseAddress = false;

			this.BaseAddress = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "BaseElementAssemblyList:" + newline;

        s += "\tAssemblyId: " + AssemblyId + newline;

        s += "\tBaseElementOnlineId: " + BaseElementOnlineId + newline;

    	// if (GroupName == null)
    	//	s += "\tGroupName: null" + newline;
    	// else

        s += "\tGroupName: " + GroupName + newline;

    	// if (OrderTag == null)
    	//	s += "\tOrderTag: null" + newline;
    	// else

        s += "\tOrderTag: " + OrderTag + newline;

        s += "\tComponentId: " + ComponentId + newline;

    	// if (RoleName == null)
    	//	s += "\tRoleName: null" + newline;
    	// else

        s += "\tRoleName: " + RoleName + newline;

    	// if (ChannelNumber == null)
    	//	s += "\tChannelNumber: null" + newline;
    	// else

        s += "\tChannelNumber: " + ChannelNumber + newline;

    	// if (NodeAddress == null)
    	//	s += "\tNodeAddress: null" + newline;
    	// else

        s += "\tNodeAddress: " + NodeAddress + newline;

    	// if (BaseAddress == null)
    	//	s += "\tBaseAddress: null" + newline;
    	// else

        s += "\tBaseAddress: " + BaseAddress + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "BaseElementAssemblyList" + delimiter;  

        s += AssemblyId + delimiter;

        s += BaseElementOnlineId + delimiter;

        // if (nullGroupName)
        // 	s += delimiter;
        // else

        	// s += GroupName + delimiter;

        // if (nullOrderTag)
        // 	s += delimiter;
        // else

        	// s += OrderTag + delimiter;

        s += ComponentId + delimiter;

        // if (nullRoleName)
        // 	s += delimiter;
        // else

        	// s += RoleName + delimiter;

        // if (nullChannelNumber)
        // 	s += delimiter;
        // else

        	// s += ChannelNumber + delimiter;

        // if (nullNodeAddress)
        // 	s += delimiter;
        // else

        	// s += NodeAddress + delimiter;

        // if (nullBaseAddress)
        // 	s += delimiter;
        // else

        	// s += BaseAddress + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 9;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#BaseElementAssemblyList" + delimiter  

        	+ "AssemblyId" + delimiter

        	+ "BaseElementOnlineId" + delimiter

        	+ "GroupName" + delimiter

        	+ "OrderTag" + delimiter

        	+ "ComponentId" + delimiter

        	+ "RoleName" + delimiter

        	+ "ChannelNumber" + delimiter

        	+ "NodeAddress" + delimiter

        	+ "BaseAddress" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof BaseElementAssemblyList)) return false;
    	BaseElementAssemblyList arg = (BaseElementAssemblyList) obj;

		if (this.AssemblyId != arg.AssemblyId)
			return false;

		if (this.BaseElementOnlineId != arg.BaseElementOnlineId)
			return false;

		if (this.GroupName == null) {	// Two null strings are equal
			if (arg.GroupName == null)
				return true;
			else
				return false;
		}
		if (!this.GroupName.equals(arg.GroupName))
			return false; 

		if (this.OrderTag != arg.OrderTag)
			return false;

		if (this.ComponentId != arg.ComponentId)
			return false;

		if (this.RoleName == null) {	// Two null strings are equal
			if (arg.RoleName == null)
				return true;
			else
				return false;
		}
		if (!this.RoleName.equals(arg.RoleName))
			return false; 

		if (this.ChannelNumber != arg.ChannelNumber)
			return false;

		if (this.NodeAddress == null) {	// Two null strings are equal
			if (arg.NodeAddress == null)
				return true;
			else
				return false;
		}
		if (!this.NodeAddress.equals(arg.NodeAddress))
			return false; 

		if (this.BaseAddress == null) {	// Two null strings are equal
			if (arg.BaseAddress == null)
				return true;
			else
				return false;
		}
		if (!this.BaseAddress.equals(arg.BaseAddress))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public BaseElementAssemblyListIDL toIDL() {
    	BaseElementAssemblyListIDL x = new BaseElementAssemblyListIDL ();

		x.AssemblyId = this.AssemblyId;

		x.BaseElementOnlineId = this.BaseElementOnlineId;

		x.GroupName = this.GroupName;

        // x.nullGroupName = this.nullGroupName;

		x.OrderTag = this.OrderTag;

        // x.nullOrderTag = this.nullOrderTag;

		x.ComponentId = this.ComponentId;

		x.RoleName = this.RoleName;

        // x.nullRoleName = this.nullRoleName;

		x.ChannelNumber = this.ChannelNumber;

        // x.nullChannelNumber = this.nullChannelNumber;

		x.NodeAddress = this.NodeAddress;

        // x.nullNodeAddress = this.nullNodeAddress;

		x.BaseAddress = this.BaseAddress;

        // x.nullBaseAddress = this.nullBaseAddress;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(BaseElementAssemblyListIDL x) {

		this.AssemblyId = x.AssemblyId;

		this.BaseElementOnlineId = x.BaseElementOnlineId;

		this.GroupName = x.GroupName;

        // this.nullGroupName = x.nullGroupName;

		this.OrderTag = x.OrderTag;

        // this.nullOrderTag = x.nullOrderTag;

		this.ComponentId = x.ComponentId;

		this.RoleName = x.RoleName;

        // this.nullRoleName = x.nullRoleName;

		this.ChannelNumber = x.ChannelNumber;

        // this.nullChannelNumber = x.nullChannelNumber;

		this.NodeAddress = x.NodeAddress;

        // this.nullNodeAddress = x.nullNodeAddress;

		this.BaseAddress = x.BaseAddress;

        // this.nullBaseAddress = x.nullBaseAddress;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for BaseElementAssemblyList.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for AssemblyId.
     */
    public int getAssemblyId () {
        return AssemblyId;
    }

    /**
     * Set AssemblyId to the specified value.
     */
    public void setAssemblyId(int AssemblyId) {

        this.AssemblyId = AssemblyId;

    }

    /**
     * Get the value for BaseElementOnlineId.
     */
    public int getBaseElementOnlineId () {
        return BaseElementOnlineId;
    }

    /**
     * Set BaseElementOnlineId to the specified value.
     */
    public void setBaseElementOnlineId(int BaseElementOnlineId) {

        this.BaseElementOnlineId = BaseElementOnlineId;

    }

    /**
     * Get the value for GroupName.
     */
    public String getGroupName () {
        return GroupName;
    }

    /**
     * Set GroupName to the specified value.
     */
    public void setGroupName(String GroupName) {

        // nullGroupName = false;

        this.GroupName = GroupName;

    }

    /*
     * Is the GroupName null?
     */
    // public boolean isGroupNameNull() {
    //	return nullGroupName;
    // }

    /*
     * Set the null indicator for GroupName
     */       
    // public void setGroupNameNull() {
    // 	nullGroupName = true;
    // }

    /**
     * Get the value for OrderTag.
     */
    public Integer getOrderTag () {
        return OrderTag;
    }

    /**
     * Set OrderTag to the specified value.
     */
    public void setOrderTag(Integer OrderTag) {

        // nullOrderTag = false;

        this.OrderTag = OrderTag;

    }

    /*
     * Is the OrderTag null?
     */
    // public boolean isOrderTagNull() {
    //	return nullOrderTag;
    // }

    /*
     * Set the null indicator for OrderTag
     */       
    // public void setOrderTagNull() {
    // 	nullOrderTag = true;
    // }

    /**
     * Get the value for ComponentId.
     */
    public int getComponentId () {
        return ComponentId;
    }

    /**
     * Set ComponentId to the specified value.
     */
    public void setComponentId(int ComponentId) {

        this.ComponentId = ComponentId;

    }

    /**
     * Get the value for RoleName.
     */
    public String getRoleName () {
        return RoleName;
    }

    /**
     * Set RoleName to the specified value.
     */
    public void setRoleName(String RoleName) {

        // nullRoleName = false;

        this.RoleName = RoleName;

    }

    /*
     * Is the RoleName null?
     */
    // public boolean isRoleNameNull() {
    //	return nullRoleName;
    // }

    /*
     * Set the null indicator for RoleName
     */       
    // public void setRoleNameNull() {
    // 	nullRoleName = true;
    // }

    /**
     * Get the value for ChannelNumber.
     */
    public Integer getChannelNumber () {
        return ChannelNumber;
    }

    /**
     * Set ChannelNumber to the specified value.
     */
    public void setChannelNumber(Integer ChannelNumber) {

        // nullChannelNumber = false;

        this.ChannelNumber = ChannelNumber;

    }

    /*
     * Is the ChannelNumber null?
     */
    // public boolean isChannelNumberNull() {
    //	return nullChannelNumber;
    // }

    /*
     * Set the null indicator for ChannelNumber
     */       
    // public void setChannelNumberNull() {
    // 	nullChannelNumber = true;
    // }

    /**
     * Get the value for NodeAddress.
     */
    public String getNodeAddress () {
        return NodeAddress;
    }

    /**
     * Set NodeAddress to the specified value.
     */
    public void setNodeAddress(String NodeAddress) {

        // nullNodeAddress = false;

        this.NodeAddress = NodeAddress;

    }

    /*
     * Is the NodeAddress null?
     */
    // public boolean isNodeAddressNull() {
    //	return nullNodeAddress;
    // }

    /*
     * Set the null indicator for NodeAddress
     */       
    // public void setNodeAddressNull() {
    // 	nullNodeAddress = true;
    // }

    /**
     * Get the value for BaseAddress.
     */
    public String getBaseAddress () {
        return BaseAddress;
    }

    /**
     * Set BaseAddress to the specified value.
     */
    public void setBaseAddress(String BaseAddress) {

        // nullBaseAddress = false;

        this.BaseAddress = BaseAddress;

    }

    /*
     * Is the BaseAddress null?
     */
    // public boolean isBaseAddressNull() {
    //	return nullBaseAddress;
    // }

    /*
     * Set the null indicator for BaseAddress
     */       
    // public void setBaseAddressNull() {
    // 	nullBaseAddress = true;
    // }

}
