/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File BaseElement.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.BaseElementIDL;

/**

 * The BaseElement table provides access to the various types of base elements.

 * BaseId refers to the BaseElementId of that particular type.

   * Key: BaseElementId is automatically generated from:  BaseElementName, ConfigurationId

 *
 */
public class BaseElement implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int BaseElementId;

    private String BaseType;

    private String BaseElementName;

    private int ConfigurationId;

    /**
     * Default Constructor for BaseElement.  Setter methods must be used to insert data.
     */
    public BaseElement () {

    }

    /**
     * Create a BaseElement by specifiying all data values.
     */
    public BaseElement (

        int BaseElementId,

        String BaseType,

        String BaseElementName,

        int ConfigurationId

    ) {

		setBaseElementId(BaseElementId);

		setBaseType(BaseType);

		setBaseElementName(BaseElementName);

		setConfigurationId(ConfigurationId);

    }

    /**
     * Create a BaseElement by specifiying data values as an array of strings.
     */
    public BaseElement (String[] data) {
    	if (data.length != 4)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 4)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseType = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementName = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "BaseElement:" + newline;

        s += "\tBaseElementId: " + BaseElementId + newline;

        s += "\tBaseType: " + BaseType + newline;

        s += "\tBaseElementName: " + BaseElementName + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "BaseElement" + delimiter;  

        s += BaseElementId + delimiter;

        s += BaseType + delimiter;

        s += BaseElementName + delimiter;

        s += ConfigurationId + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 4;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#BaseElement" + delimiter  

        	+ "BaseElementId" + delimiter

        	+ "BaseType" + delimiter

        	+ "BaseElementName" + delimiter

        	+ "ConfigurationId" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof BaseElement)) return false;
    	BaseElement arg = (BaseElement) obj;

		if (this.BaseElementId != arg.BaseElementId)
			return false;

		if (this.BaseType == null) {	// Two null strings are equal
			if (arg.BaseType == null)
				return true;
			else
				return false;
		}
		if (!this.BaseType.equals(arg.BaseType))
			return false; 

		if (this.BaseElementName == null) {	// Two null strings are equal
			if (arg.BaseElementName == null)
				return true;
			else
				return false;
		}
		if (!this.BaseElementName.equals(arg.BaseElementName))
			return false; 

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public BaseElementIDL toIDL() {
    	BaseElementIDL x = new BaseElementIDL ();

		x.BaseElementId = this.BaseElementId;

		x.BaseType = this.BaseType;

		x.BaseElementName = this.BaseElementName;

		x.ConfigurationId = this.ConfigurationId;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(BaseElementIDL x) {

		this.BaseElementId = x.BaseElementId;

		this.BaseType = x.BaseType;

		this.BaseElementName = x.BaseElementName;

		this.ConfigurationId = x.ConfigurationId;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return BaseElementId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for BaseElement.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for BaseElementId.
     */
    public int getBaseElementId () {
        return BaseElementId;
    }

    /**
     * Set BaseElementId to the specified value.
     */
    public void setBaseElementId(int BaseElementId) {

        this.BaseElementId = BaseElementId;

    }

    /**
     * Get the value for BaseType.
     */
    public String getBaseType () {
        return BaseType;
    }

    /**
     * Set BaseType to the specified value.
     */
    public void setBaseType(String BaseType) {

        this.BaseType = BaseType;

    }

    /**
     * Get the value for BaseElementName.
     */
    public String getBaseElementName () {
        return BaseElementName;
    }

    /**
     * Set BaseElementName to the specified value.
     */
    public void setBaseElementName(String BaseElementName) {

        this.BaseElementName = BaseElementName;

    }

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

}
