/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File AssociatedBaseElement.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.AssociatedBaseElementIDL;

/**

 * The AssociatedBaseElement table specifies which base elements are associated with a given

 * base element in the startup list.

 * (RHV) This table seems to be redundant.

   * Key: BaseElementId, StartupId, AssociatedId

 *
 */
public class AssociatedBaseElement implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int BaseElementId;

    private int StartupId;

    private int AssociatedId;

    private String AssociationType;

    /**
     * Default Constructor for AssociatedBaseElement.  Setter methods must be used to insert data.
     */
    public AssociatedBaseElement () {

    }

    /**
     * Create a AssociatedBaseElement by specifiying all data values.
     */
    public AssociatedBaseElement (

        int BaseElementId,

        int StartupId,

        int AssociatedId,

        String AssociationType

    ) {

		setBaseElementId(BaseElementId);

		setStartupId(StartupId);

		setAssociatedId(AssociatedId);

		setAssociationType(AssociationType);

    }

    /**
     * Create a AssociatedBaseElement by specifiying data values as an array of strings.
     */
    public AssociatedBaseElement (String[] data) {
    	if (data.length != 4)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 4)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StartupId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AssociatedId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AssociationType = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "AssociatedBaseElement:" + newline;

        s += "\tBaseElementId: " + BaseElementId + newline;

        s += "\tStartupId: " + StartupId + newline;

        s += "\tAssociatedId: " + AssociatedId + newline;

        s += "\tAssociationType: " + AssociationType + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "AssociatedBaseElement" + delimiter;  

        s += BaseElementId + delimiter;

        s += StartupId + delimiter;

        s += AssociatedId + delimiter;

        s += AssociationType + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 4;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#AssociatedBaseElement" + delimiter  

        	+ "BaseElementId" + delimiter

        	+ "StartupId" + delimiter

        	+ "AssociatedId" + delimiter

        	+ "AssociationType" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof AssociatedBaseElement)) return false;
    	AssociatedBaseElement arg = (AssociatedBaseElement) obj;

		if (this.BaseElementId != arg.BaseElementId)
			return false;

		if (this.StartupId != arg.StartupId)
			return false;

		if (this.AssociatedId != arg.AssociatedId)
			return false;

		if (this.AssociationType == null) {	// Two null strings are equal
			if (arg.AssociationType == null)
				return true;
			else
				return false;
		}
		if (!this.AssociationType.equals(arg.AssociationType))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public AssociatedBaseElementIDL toIDL() {
    	AssociatedBaseElementIDL x = new AssociatedBaseElementIDL ();

		x.BaseElementId = this.BaseElementId;

		x.StartupId = this.StartupId;

		x.AssociatedId = this.AssociatedId;

		x.AssociationType = this.AssociationType;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(AssociatedBaseElementIDL x) {

		this.BaseElementId = x.BaseElementId;

		this.StartupId = x.StartupId;

		this.AssociatedId = x.AssociatedId;

		this.AssociationType = x.AssociationType;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for AssociatedBaseElement.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for BaseElementId.
     */
    public int getBaseElementId () {
        return BaseElementId;
    }

    /**
     * Set BaseElementId to the specified value.
     */
    public void setBaseElementId(int BaseElementId) {

        this.BaseElementId = BaseElementId;

    }

    /**
     * Get the value for StartupId.
     */
    public int getStartupId () {
        return StartupId;
    }

    /**
     * Set StartupId to the specified value.
     */
    public void setStartupId(int StartupId) {

        this.StartupId = StartupId;

    }

    /**
     * Get the value for AssociatedId.
     */
    public int getAssociatedId () {
        return AssociatedId;
    }

    /**
     * Set AssociatedId to the specified value.
     */
    public void setAssociatedId(int AssociatedId) {

        this.AssociatedId = AssociatedId;

    }

    /**
     * Get the value for AssociationType.
     */
    public String getAssociationType () {
        return AssociationType;
    }

    /**
     * Set AssociationType to the specified value.
     */
    public void setAssociationType(String AssociationType) {

        this.AssociationType = AssociationType;

    }

}
