/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File AssemblyType.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.AssemblyTypeIDL;

/**

 * AssemblyType represents assemblies that are part of an LRU.  All LRUs are made up of one or more assemblies.

 * All monitored properties are tied to specific assemblies.

 * AssemblyName is the unique key.  This requires that names of assemblies be unique across all hardware

 * devices and the entire database.  We could relax this to require that the combination of LRU_Name and

 * Assembly_Name be unique.  However, this is easier to deal with and is almost always the case anyway.

   * Key: AssemblyTypeName

 *
 */
public class AssemblyType implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private String AssemblyTypeName;

    private String BaseElementType;

    private String LRUName;

    private String FullName;

    private String Description;

    private String Notes;

    // private boolean nullNotes;

    private Integer ComponentTypeId;

    // private boolean nullComponentTypeId;

    private String Data;

    // private boolean nullData;

    /**
     * Default Constructor for AssemblyType.  Setter methods must be used to insert data.
     */
    public AssemblyType () {

        // nullNotes = true;

        // nullComponentTypeId = true;

        // nullData = true;

    }

    /**
     * Create a AssemblyType by specifiying all data values.
     */
    public AssemblyType (

        String AssemblyTypeName,

        String BaseElementType,

        String LRUName,

        String FullName,

        String Description,

        String Notes,

        Integer ComponentTypeId,

        String Data

    ) {

		setAssemblyTypeName(AssemblyTypeName);

		setBaseElementType(BaseElementType);

		setLRUName(LRUName);

		setFullName(FullName);

		setDescription(Description);

		setNotes(Notes);

		setComponentTypeId(ComponentTypeId);

		setData(Data);

    }

    /**
     * Create a AssemblyType by specifiying data values as an array of strings.
     */
    public AssemblyType (String[] data) {
    	if (data.length != 8)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 8)");
    	int i = 0;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AssemblyTypeName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementType = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.LRUName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.FullName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Description = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullNotes = true;
			// this.Notes = null;

		} else {

			// nullNotes = false;

			this.Notes = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			// nullComponentTypeId = true;
			// this.ComponentTypeId = null;

		} else {

			// nullComponentTypeId = false;

			this.ComponentTypeId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullData = true;
			// this.Data = null;

		} else {

			// nullData = false;

			this.Data = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "AssemblyType:" + newline;

        s += "\tAssemblyTypeName: " + AssemblyTypeName + newline;

        s += "\tBaseElementType: " + BaseElementType + newline;

        s += "\tLRUName: " + LRUName + newline;

        s += "\tFullName: " + FullName + newline;

        s += "\tDescription: " + Description + newline;

    	// if (Notes == null)
    	//	s += "\tNotes: null" + newline;
    	// else

        s += "\tNotes: " + Notes + newline;

    	// if (ComponentTypeId == null)
    	//	s += "\tComponentTypeId: null" + newline;
    	// else

        s += "\tComponentTypeId: " + ComponentTypeId + newline;

    	// if (Data == null)
    	//	s += "\tData: null" + newline;
    	// else

        s += "\tData: " + Data + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "AssemblyType" + delimiter;  

        s += AssemblyTypeName + delimiter;

        s += BaseElementType + delimiter;

        s += LRUName + delimiter;

        s += FullName + delimiter;

        s += Description + delimiter;

        // if (nullNotes)
        // 	s += delimiter;
        // else

        	// s += Notes + delimiter;

        // if (nullComponentTypeId)
        // 	s += delimiter;
        // else

        	// s += ComponentTypeId + delimiter;

        // if (nullData)
        // 	s += delimiter;
        // else

        	// s += Data + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 8;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#AssemblyType" + delimiter  

        	+ "AssemblyTypeName" + delimiter

        	+ "BaseElementType" + delimiter

        	+ "LRUName" + delimiter

        	+ "FullName" + delimiter

        	+ "Description" + delimiter

        	+ "Notes" + delimiter

        	+ "ComponentTypeId" + delimiter

        	+ "Data" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof AssemblyType)) return false;
    	AssemblyType arg = (AssemblyType) obj;

		if (this.AssemblyTypeName == null) {	// Two null strings are equal
			if (arg.AssemblyTypeName == null)
				return true;
			else
				return false;
		}
		if (!this.AssemblyTypeName.equals(arg.AssemblyTypeName))
			return false; 

		if (this.BaseElementType == null) {	// Two null strings are equal
			if (arg.BaseElementType == null)
				return true;
			else
				return false;
		}
		if (!this.BaseElementType.equals(arg.BaseElementType))
			return false; 

		if (this.LRUName == null) {	// Two null strings are equal
			if (arg.LRUName == null)
				return true;
			else
				return false;
		}
		if (!this.LRUName.equals(arg.LRUName))
			return false; 

		if (this.FullName == null) {	// Two null strings are equal
			if (arg.FullName == null)
				return true;
			else
				return false;
		}
		if (!this.FullName.equals(arg.FullName))
			return false; 

		if (this.Description == null) {	// Two null strings are equal
			if (arg.Description == null)
				return true;
			else
				return false;
		}
		if (!this.Description.equals(arg.Description))
			return false; 

		if (this.Notes == null) {	// Two null strings are equal
			if (arg.Notes == null)
				return true;
			else
				return false;
		}
		if (!this.Notes.equals(arg.Notes))
			return false; 

		if (this.ComponentTypeId != arg.ComponentTypeId)
			return false;

		if (this.Data != arg.Data)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public AssemblyTypeIDL toIDL() {
    	AssemblyTypeIDL x = new AssemblyTypeIDL ();

		x.AssemblyTypeName = this.AssemblyTypeName;

		x.BaseElementType = this.BaseElementType;

		x.LRUName = this.LRUName;

		x.FullName = this.FullName;

		x.Description = this.Description;

		x.Notes = this.Notes;

        // x.nullNotes = this.nullNotes;

		x.ComponentTypeId = this.ComponentTypeId;

        // x.nullComponentTypeId = this.nullComponentTypeId;

		x.Data = this.Data;

        // x.nullData = this.nullData;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(AssemblyTypeIDL x) {

		this.AssemblyTypeName = x.AssemblyTypeName;

		this.BaseElementType = x.BaseElementType;

		this.LRUName = x.LRUName;

		this.FullName = x.FullName;

		this.Description = x.Description;

		this.Notes = x.Notes;

        // this.nullNotes = x.nullNotes;

		this.ComponentTypeId = x.ComponentTypeId;

        // this.nullComponentTypeId = x.nullComponentTypeId;

		this.Data = x.Data;

        // this.nullData = x.nullData;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for AssemblyType.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for AssemblyTypeName.
     */
    public String getAssemblyTypeName () {
        return AssemblyTypeName;
    }

    /**
     * Set AssemblyTypeName to the specified value.
     */
    public void setAssemblyTypeName(String AssemblyTypeName) {

        this.AssemblyTypeName = AssemblyTypeName;

    }

    /**
     * Get the value for BaseElementType.
     */
    public String getBaseElementType () {
        return BaseElementType;
    }

    /**
     * Set BaseElementType to the specified value.
     */
    public void setBaseElementType(String BaseElementType) {

        this.BaseElementType = BaseElementType;

    }

    /**
     * Get the value for LRUName.
     */
    public String getLRUName () {
        return LRUName;
    }

    /**
     * Set LRUName to the specified value.
     */
    public void setLRUName(String LRUName) {

        this.LRUName = LRUName;

    }

    /**
     * Get the value for FullName.
     */
    public String getFullName () {
        return FullName;
    }

    /**
     * Set FullName to the specified value.
     */
    public void setFullName(String FullName) {

        this.FullName = FullName;

    }

    /**
     * Get the value for Description.
     */
    public String getDescription () {
        return Description;
    }

    /**
     * Set Description to the specified value.
     */
    public void setDescription(String Description) {

        this.Description = Description;

    }

    /**
     * Get the value for Notes.
     */
    public String getNotes () {
        return Notes;
    }

    /**
     * Set Notes to the specified value.
     */
    public void setNotes(String Notes) {

        // nullNotes = false;

        this.Notes = Notes;

    }

    /*
     * Is the Notes null?
     */
    // public boolean isNotesNull() {
    //	return nullNotes;
    // }

    /*
     * Set the null indicator for Notes
     */       
    // public void setNotesNull() {
    // 	nullNotes = true;
    // }

    /**
     * Get the value for ComponentTypeId.
     */
    public Integer getComponentTypeId () {
        return ComponentTypeId;
    }

    /**
     * Set ComponentTypeId to the specified value.
     */
    public void setComponentTypeId(Integer ComponentTypeId) {

        // nullComponentTypeId = false;

        this.ComponentTypeId = ComponentTypeId;

    }

    /*
     * Is the ComponentTypeId null?
     */
    // public boolean isComponentTypeIdNull() {
    //	return nullComponentTypeId;
    // }

    /*
     * Set the null indicator for ComponentTypeId
     */       
    // public void setComponentTypeIdNull() {
    // 	nullComponentTypeId = true;
    // }

    /**
     * Get the value for Data.
     */
    public String getData () {
        return Data;
    }

    /**
     * Set Data to the specified value.
     */
    public void setData(String Data) {

        // nullData = false;

        this.Data = Data;

    }

    /*
     * Is the Data null?
     */
    // public boolean isDataNull() {
    //	return nullData;
    // }

    /*
     * Set the null indicator for Data
     */       
    // public void setDataNull() {
    // 	nullData = true;
    // }

}
