/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File AssemblyStartup.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.AssemblyStartupIDL;

/**

 * The AssemblyStartup table specifies which assemblies are to be started.

 * The component associated with the assembly and the container in which it is

 * to be executed must be supplied.

   * Key: AssemblyStartupId is automatically generated from:  BaseElementStartupId, RoleName

 *
 */
public class AssemblyStartup implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int AssemblyStartupId;

    private String RoleName;

    private int ComponentId;

    private int BaseElementStartupId;

    /**
     * Default Constructor for AssemblyStartup.  Setter methods must be used to insert data.
     */
    public AssemblyStartup () {

    }

    /**
     * Create a AssemblyStartup by specifiying all data values.
     */
    public AssemblyStartup (

        int AssemblyStartupId,

        String RoleName,

        int ComponentId,

        int BaseElementStartupId

    ) {

		setAssemblyStartupId(AssemblyStartupId);

		setRoleName(RoleName);

		setComponentId(ComponentId);

		setBaseElementStartupId(BaseElementStartupId);

    }

    /**
     * Create a AssemblyStartup by specifiying data values as an array of strings.
     */
    public AssemblyStartup (String[] data) {
    	if (data.length != 4)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 4)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AssemblyStartupId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.RoleName = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComponentId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementStartupId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "AssemblyStartup:" + newline;

        s += "\tAssemblyStartupId: " + AssemblyStartupId + newline;

        s += "\tRoleName: " + RoleName + newline;

        s += "\tComponentId: " + ComponentId + newline;

        s += "\tBaseElementStartupId: " + BaseElementStartupId + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "AssemblyStartup" + delimiter;  

        s += AssemblyStartupId + delimiter;

        s += RoleName + delimiter;

        s += ComponentId + delimiter;

        s += BaseElementStartupId + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 4;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#AssemblyStartup" + delimiter  

        	+ "AssemblyStartupId" + delimiter

        	+ "RoleName" + delimiter

        	+ "ComponentId" + delimiter

        	+ "BaseElementStartupId" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof AssemblyStartup)) return false;
    	AssemblyStartup arg = (AssemblyStartup) obj;

		if (this.AssemblyStartupId != arg.AssemblyStartupId)
			return false;

		if (this.RoleName == null) {	// Two null strings are equal
			if (arg.RoleName == null)
				return true;
			else
				return false;
		}
		if (!this.RoleName.equals(arg.RoleName))
			return false; 

		if (this.ComponentId != arg.ComponentId)
			return false;

		if (this.BaseElementStartupId != arg.BaseElementStartupId)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public AssemblyStartupIDL toIDL() {
    	AssemblyStartupIDL x = new AssemblyStartupIDL ();

		x.AssemblyStartupId = this.AssemblyStartupId;

		x.RoleName = this.RoleName;

		x.ComponentId = this.ComponentId;

		x.BaseElementStartupId = this.BaseElementStartupId;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(AssemblyStartupIDL x) {

		this.AssemblyStartupId = x.AssemblyStartupId;

		this.RoleName = x.RoleName;

		this.ComponentId = x.ComponentId;

		this.BaseElementStartupId = x.BaseElementStartupId;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return AssemblyStartupId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for AssemblyStartup.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for AssemblyStartupId.
     */
    public int getAssemblyStartupId () {
        return AssemblyStartupId;
    }

    /**
     * Set AssemblyStartupId to the specified value.
     */
    public void setAssemblyStartupId(int AssemblyStartupId) {

        this.AssemblyStartupId = AssemblyStartupId;

    }

    /**
     * Get the value for RoleName.
     */
    public String getRoleName () {
        return RoleName;
    }

    /**
     * Set RoleName to the specified value.
     */
    public void setRoleName(String RoleName) {

        this.RoleName = RoleName;

    }

    /**
     * Get the value for ComponentId.
     */
    public int getComponentId () {
        return ComponentId;
    }

    /**
     * Set ComponentId to the specified value.
     */
    public void setComponentId(int ComponentId) {

        this.ComponentId = ComponentId;

    }

    /**
     * Get the value for BaseElementStartupId.
     */
    public int getBaseElementStartupId () {
        return BaseElementStartupId;
    }

    /**
     * Set BaseElementStartupId to the specified value.
     */
    public void setBaseElementStartupId(int BaseElementStartupId) {

        this.BaseElementStartupId = BaseElementStartupId;

    }

}
