/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File AssemblyRole.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.AssemblyRoleIDL;

/**

 * Role played by an AssemblyType in the system. Some types of assemblies are installed

 * multiple times in the same BaseElement. For example, four SecondLOs can are installed

 * in an antenna. The role is used to differentiate them and define their CAN parameters.

   * Key: RoleName

 *
 */
public class AssemblyRole implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private String RoleName;

    private String NodeAddress;

    private int ChannelNumber;

    private String BaseAddress;

    // private boolean nullBaseAddress;

    private String AssemblyTypeName;

    /**
     * Default Constructor for AssemblyRole.  Setter methods must be used to insert data.
     */
    public AssemblyRole () {

        // nullBaseAddress = true;

    }

    /**
     * Create a AssemblyRole by specifiying all data values.
     */
    public AssemblyRole (

        String RoleName,

        String NodeAddress,

        int ChannelNumber,

        String BaseAddress,

        String AssemblyTypeName

    ) {

		setRoleName(RoleName);

		setNodeAddress(NodeAddress);

		setChannelNumber(ChannelNumber);

		setBaseAddress(BaseAddress);

		setAssemblyTypeName(AssemblyTypeName);

    }

    /**
     * Create a AssemblyRole by specifiying data values as an array of strings.
     */
    public AssemblyRole (String[] data) {
    	if (data.length != 5)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 5)");
    	int i = 0;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.RoleName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NodeAddress = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ChannelNumber = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullBaseAddress = true;
			// this.BaseAddress = null;

		} else {

			// nullBaseAddress = false;

			this.BaseAddress = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AssemblyTypeName = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "AssemblyRole:" + newline;

        s += "\tRoleName: " + RoleName + newline;

        s += "\tNodeAddress: " + NodeAddress + newline;

        s += "\tChannelNumber: " + ChannelNumber + newline;

    	// if (BaseAddress == null)
    	//	s += "\tBaseAddress: null" + newline;
    	// else

        s += "\tBaseAddress: " + BaseAddress + newline;

        s += "\tAssemblyTypeName: " + AssemblyTypeName + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "AssemblyRole" + delimiter;  

        s += RoleName + delimiter;

        s += NodeAddress + delimiter;

        s += ChannelNumber + delimiter;

        // if (nullBaseAddress)
        // 	s += delimiter;
        // else

        	// s += BaseAddress + delimiter;

        s += AssemblyTypeName + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 5;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#AssemblyRole" + delimiter  

        	+ "RoleName" + delimiter

        	+ "NodeAddress" + delimiter

        	+ "ChannelNumber" + delimiter

        	+ "BaseAddress" + delimiter

        	+ "AssemblyTypeName" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof AssemblyRole)) return false;
    	AssemblyRole arg = (AssemblyRole) obj;

		if (this.RoleName == null) {	// Two null strings are equal
			if (arg.RoleName == null)
				return true;
			else
				return false;
		}
		if (!this.RoleName.equals(arg.RoleName))
			return false; 

		if (this.NodeAddress == null) {	// Two null strings are equal
			if (arg.NodeAddress == null)
				return true;
			else
				return false;
		}
		if (!this.NodeAddress.equals(arg.NodeAddress))
			return false; 

		if (this.ChannelNumber != arg.ChannelNumber)
			return false;

		if (this.BaseAddress == null) {	// Two null strings are equal
			if (arg.BaseAddress == null)
				return true;
			else
				return false;
		}
		if (!this.BaseAddress.equals(arg.BaseAddress))
			return false; 

		if (this.AssemblyTypeName == null) {	// Two null strings are equal
			if (arg.AssemblyTypeName == null)
				return true;
			else
				return false;
		}
		if (!this.AssemblyTypeName.equals(arg.AssemblyTypeName))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public AssemblyRoleIDL toIDL() {
    	AssemblyRoleIDL x = new AssemblyRoleIDL ();

		x.RoleName = this.RoleName;

		x.NodeAddress = this.NodeAddress;

		x.ChannelNumber = this.ChannelNumber;

		x.BaseAddress = this.BaseAddress;

        // x.nullBaseAddress = this.nullBaseAddress;

		x.AssemblyTypeName = this.AssemblyTypeName;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(AssemblyRoleIDL x) {

		this.RoleName = x.RoleName;

		this.NodeAddress = x.NodeAddress;

		this.ChannelNumber = x.ChannelNumber;

		this.BaseAddress = x.BaseAddress;

        // this.nullBaseAddress = x.nullBaseAddress;

		this.AssemblyTypeName = x.AssemblyTypeName;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for AssemblyRole.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for RoleName.
     */
    public String getRoleName () {
        return RoleName;
    }

    /**
     * Set RoleName to the specified value.
     */
    public void setRoleName(String RoleName) {

        this.RoleName = RoleName;

    }

    /**
     * Get the value for NodeAddress.
     */
    public String getNodeAddress () {
        return NodeAddress;
    }

    /**
     * Set NodeAddress to the specified value.
     */
    public void setNodeAddress(String NodeAddress) {

        this.NodeAddress = NodeAddress;

    }

    /**
     * Get the value for ChannelNumber.
     */
    public int getChannelNumber () {
        return ChannelNumber;
    }

    /**
     * Set ChannelNumber to the specified value.
     */
    public void setChannelNumber(int ChannelNumber) {

        this.ChannelNumber = ChannelNumber;

    }

    /**
     * Get the value for BaseAddress.
     */
    public String getBaseAddress () {
        return BaseAddress;
    }

    /**
     * Set BaseAddress to the specified value.
     */
    public void setBaseAddress(String BaseAddress) {

        // nullBaseAddress = false;

        this.BaseAddress = BaseAddress;

    }

    /*
     * Is the BaseAddress null?
     */
    // public boolean isBaseAddressNull() {
    //	return nullBaseAddress;
    // }

    /*
     * Set the null indicator for BaseAddress
     */       
    // public void setBaseAddressNull() {
    // 	nullBaseAddress = true;
    // }

    /**
     * Get the value for AssemblyTypeName.
     */
    public String getAssemblyTypeName () {
        return AssemblyTypeName;
    }

    /**
     * Set AssemblyTypeName to the specified value.
     */
    public void setAssemblyTypeName(String AssemblyTypeName) {

        this.AssemblyTypeName = AssemblyTypeName;

    }

}
