/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File Assembly.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.AssemblyIDL;

/**

 * An Assembly is an instance of an assembly type.  All monitored property data are tied to an instance of an assembly.

 * <nop>AssemblyId is a generated unique key.  The real requirement is that combination of SerialNumber and ConfigurationId are unique.  This means that the same hardware device may appear in different configurations, thus enabling us to track the entire life history a device as it moves from lab to ATF to commissioning, while keeping the property data separate as well.

 * The reason for choosing a generated key is that this key is referenced in the property tables and we want these to be as small as possible because this is where the bulk of the data is located.

 * The number of assemblies in full ALMA operations will be between three and four thousand.  Allowing for a small number of possible configurations increases this number of entries in the table.  To be on the safe size we allow 6 digits for the <nop>AssemblyId.  (Four digits is probably too small.)

 * pburgos: Maybe add a date on this table in the future to keep track of SN

   * Key: AssemblyId is automatically generated from:  SerialNumber, ConfigurationId

 *
 */
public class Assembly implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int AssemblyId;

    private String AssemblyTypeName;

    private int ConfigurationId;

    private String SerialNumber;

    private String Data;

    // private boolean nullData;

    /**
     * Default Constructor for Assembly.  Setter methods must be used to insert data.
     */
    public Assembly () {

        // nullData = true;

    }

    /**
     * Create a Assembly by specifiying all data values.
     */
    public Assembly (

        int AssemblyId,

        String AssemblyTypeName,

        int ConfigurationId,

        String SerialNumber,

        String Data

    ) {

		setAssemblyId(AssemblyId);

		setAssemblyTypeName(AssemblyTypeName);

		setConfigurationId(ConfigurationId);

		setSerialNumber(SerialNumber);

		setData(Data);

    }

    /**
     * Create a Assembly by specifiying data values as an array of strings.
     */
    public Assembly (String[] data) {
    	if (data.length != 5)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 5)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AssemblyId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AssemblyTypeName = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.SerialNumber = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullData = true;
			// this.Data = null;

		} else {

			// nullData = false;

			this.Data = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "Assembly:" + newline;

        s += "\tAssemblyId: " + AssemblyId + newline;

        s += "\tAssemblyTypeName: " + AssemblyTypeName + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

        s += "\tSerialNumber: " + SerialNumber + newline;

    	// if (Data == null)
    	//	s += "\tData: null" + newline;
    	// else

        s += "\tData: " + Data + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "Assembly" + delimiter;  

        s += AssemblyId + delimiter;

        s += AssemblyTypeName + delimiter;

        s += ConfigurationId + delimiter;

        s += SerialNumber + delimiter;

        // if (nullData)
        // 	s += delimiter;
        // else

        	// s += Data + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 5;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#Assembly" + delimiter  

        	+ "AssemblyId" + delimiter

        	+ "AssemblyTypeName" + delimiter

        	+ "ConfigurationId" + delimiter

        	+ "SerialNumber" + delimiter

        	+ "Data" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof Assembly)) return false;
    	Assembly arg = (Assembly) obj;

		if (this.AssemblyId != arg.AssemblyId)
			return false;

		if (this.AssemblyTypeName == null) {	// Two null strings are equal
			if (arg.AssemblyTypeName == null)
				return true;
			else
				return false;
		}
		if (!this.AssemblyTypeName.equals(arg.AssemblyTypeName))
			return false; 

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		if (this.SerialNumber == null) {	// Two null strings are equal
			if (arg.SerialNumber == null)
				return true;
			else
				return false;
		}
		if (!this.SerialNumber.equals(arg.SerialNumber))
			return false; 

		if (this.Data != arg.Data)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public AssemblyIDL toIDL() {
    	AssemblyIDL x = new AssemblyIDL ();

		x.AssemblyId = this.AssemblyId;

		x.AssemblyTypeName = this.AssemblyTypeName;

		x.ConfigurationId = this.ConfigurationId;

		x.SerialNumber = this.SerialNumber;

		x.Data = this.Data;

        // x.nullData = this.nullData;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(AssemblyIDL x) {

		this.AssemblyId = x.AssemblyId;

		this.AssemblyTypeName = x.AssemblyTypeName;

		this.ConfigurationId = x.ConfigurationId;

		this.SerialNumber = x.SerialNumber;

		this.Data = x.Data;

        // this.nullData = x.nullData;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return AssemblyId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for Assembly.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for AssemblyId.
     */
    public int getAssemblyId () {
        return AssemblyId;
    }

    /**
     * Set AssemblyId to the specified value.
     */
    public void setAssemblyId(int AssemblyId) {

        this.AssemblyId = AssemblyId;

    }

    /**
     * Get the value for AssemblyTypeName.
     */
    public String getAssemblyTypeName () {
        return AssemblyTypeName;
    }

    /**
     * Set AssemblyTypeName to the specified value.
     */
    public void setAssemblyTypeName(String AssemblyTypeName) {

        this.AssemblyTypeName = AssemblyTypeName;

    }

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

    /**
     * Get the value for SerialNumber.
     */
    public String getSerialNumber () {
        return SerialNumber;
    }

    /**
     * Set SerialNumber to the specified value.
     */
    public void setSerialNumber(String SerialNumber) {

        this.SerialNumber = SerialNumber;

    }

    /**
     * Get the value for Data.
     */
    public String getData () {
        return Data;
    }

    /**
     * Set Data to the specified value.
     */
    public void setData(String Data) {

        // nullData = false;

        this.Data = Data;

    }

    /*
     * Is the Data null?
     */
    // public boolean isDataNull() {
    //	return nullData;
    // }

    /*
     * Set the null indicator for Data
     */       
    // public void setDataNull() {
    // 	nullData = true;
    // }

}
